;-----------------------------------------------
;
; LOAD CONTIGUOUS BINARY FILE FROM DISK
;
;-----------------------------------------------
;
; VERSION 0.1 - 08 SEP 77
; JEFFREY W. SHOOK
;
	ORG	100H	; CP/M ENTRY POINT

LOADB:	LXI	H,0	; SAVE CP/M STACK
	DAD	SP
	SHLD	SAVSP
	LXI	SP,STACK; SET STACK POINTER

; INPUT INITIAL VALUES

	MVI	C,WCONB	; PRINT PROGRAM NAME
	LXI	D,MSG1
	CALL	BDOS
	JMP	NEXT1

MSG1:	DB CR,LF,0,'CONTIGUOUS FILE LOADER',CR,LF,0
	DB 'ENTER ALL VALUES IN HEXIDECIMAL',CR,LF,0,'$'

NEXT1:	MVI	C,WCONB	; REQUEST DISK #
	LXI	D,MSG0
	CALL	BDOS
	JMP	NEXT0

MSG0:	DB CR,LF,0,'WHICH DISK (A OR B)? ','$'

NEXT0:	MVI	C,RCON	; GET DISK
	CALL	BDOS
	CMA
	ANI	1
	STA	DISK
	MVI	A,SELDSK; SELECT DRIVE
	LXI	H,DISK
	MOV	C,M
	CALL	FBIOS
	MVI	C,WCONB	; REQUEST STARTING TRACK
	LXI	D,MSG2
	CALL	BDOS
	JMP	NEXT2

MSG2:	DB CR,LF,0,'STARTING POINT',CR,LF,0
	DB 'TRACK (XX) ? ','$'

NEXT2:	CALL	INBYTE	; GET TRACK #
	STA	TRACK
	MVI	C,WCONB	; REQUEST SECTOR #
	LXI	D,MSG3
	CALL	BDOS
	JMP	NEXT3

MSG3:	DB CR,LF,0,'SECTOR (XX) ? ','$'

NEXT3:	CALL	INBYTE	; GET SECTOR #
	STA	RECORD

	MVI	C,WCONB	; REQUEST SECTOR COUNT
	LXI	D,MSG4
	CALL	BDOS
	JMP	NEXT4

MSG4:	DB CR,LF,0,'FILE SIZE, SECTORS (XXXX)? ','$'

NEXT4:	CALL	INADDR	; INPUT # SECTORS TO READ
	SHLD	RCOUNT

	MVI	C,WCONB	; REQUEST STARTING ADDRESS
	LXI	D,MSG5
	CALL	BDOS
	JMP	NEXT5

MSG5:	DB CR,LF,0,'STARTING ADDRESS (XXXX)? ','$'

NEXT5:	CALL	INADDR	; INPUT STARTING ADDRESS
	SHLD	DMAADR

ALLOK:	MVI	C,WCONB	; CHECK IF ALL OK
	LXI	D,MSG51
	CALL	BDOS
	JMP	NEXT51

MSG51:	DB CR,LF,0,'LOAD FILE? (Y,N,Q) ','$'

NEXT51:	MVI	C,RCON	; GET CHAR
	CALL	BDOS
	CPI	'Q'	; QUIT?
	JZ	GOCPM
	CPI	'N'	; TRY AGAIN?
	JZ	LOADB
	CPI	'Y'
	JNZ	ALLOK

	MVI	C,WCONB	; PRINT BUSY MESSAGE
	LXI	D,MSG6
	CALL	BDOS
	JMP	NEXT6

MSG6:	DB CR,LF,0,'NOW LOADING FILE',CR,LF,0,'$'

NEXT6:
LOOP1:	CALL	READR	; READ ONE RECORD
	JC	DONE
	LHLD	DMAADR	; MOVE DMA POINTER
	LXI	D,128	; TO NEXT SECTOR
	DAD	D
	SHLD	DMAADR

	LHLD	RCOUNT	; DECREMENT RECORD COUNT
	DCX	H
	SHLD	RCOUNT
	MOV	A,L	; CHECK IF DONE
	ORA	H
	JNZ	LOOP1

DONE:	MVI	C,WCONB	; PRINT DONE MESSAGE
	LXI	D,MSG7
	CALL	BDOS
	JMP	NEXT7

MSG7:	DB CR,LF,0,'LOAD COMPLETE',CR,LF,0,'$'

NEXT7:

GOCPM:	LHLD	SAVSP
	SPHL
	JMP	BDOS

; READ RECORDS FROM DISK IN ORDER
;
; RETURN WITH CARRY SET WHEN END
; OF DISK IS REACHED.
;
; SET TRACK AND RECORD TO POINT
; TO NEXT RECORD TO BE READ.

; COUNT = 0

READR:	MVI	A,SETDMA; SET DMA ADDRESS
	LXI	H,DMAADR
	MOV	C,M
	INX	H
	MOV	B,M
	CALL	FBIOS

	MVI	A,SETTRK; SET TRACK
	LXI	H,TRACK
	MOV	C,M
	CALL	FBIOS

	LXI	H,RECORD; SET SECTOR
	MOV	C,M
	CALL	RECSEC	; CONVERT RECORD TO SECTOR
	MVI	A,SETSEC
	CALL	FBIOS

	MVI	A,READS	; READ SECTOR
	CALL	FBIOS
	CPI	0
	JNZ	READR2

; COMPUTE NEXT RECORD AND TRACK

	LXI	H,RECORD; INCREMENT RECORD #
	INR	M
	MOV	A,M	; CHECK FOR END OF TRACK
	CPI	27
	JM	READR1
	MVI	M,1	; SET TO FIRST RECORD

	LXI	H,TRACK	; INCREMENT TRACK #
	INR	M
	MOV	A,M
	CPI	78	; LAST TRACK?
	JP	READR2
READR1:	ORA	A	; CLEAR CARRY
	RET

READR2:	STC
	RET
	
RECSEC:	RET

;******************************************
;* BIOS FUNCTION CALLING PROCEDURE        *
;******************************************
;
; THIS PROCEDURE ALLOWS CALLING BIOS
; FUNCTIONS WITHOUT PRIOR KNOWLEDGE OF THE
; SIZE OF THE CP/M SYSTEM.
;
; CALL FBIOS WITH THE FUNCTION IN A
; AND THE PARAMETER IN BC.
;
FBIOS:	MOV	E,A	; GET ENTRY OFFSET
	MVI	D,0	; IN DE
	LHLD	1	; GET BIOS ENTRY + 3
	DAD	D	; ADD ENTRY TO OFFSET
	PCHL		; JUMP TO BIOS
;
; BIOS ENTRY CODE NAMES
;
WBOOT:	EQU	0	; WARM BOOT
CONST:	EQU	3	; TEST CONSOLE STATUS
CONIN:	EQU	6	; CONSOLE INPUT
CONOUT:	EQU	9	; CONSOLE OUTPUT
LIST:	EQU	12	; LIST OUTPUT
PUNCH:	EQU	15	; PUNCH OUTPUT
READER:	EQU	18	; READER INPUT
HOME:	EQU	21	; HEAD TO TRACK 0
SELDSK:	EQU	24	; SELECT DRIVE
SETTRK:	EQU	27	; SET NEXT TRACK
SETSEC:	EQU	30	; SET NEXT SECTOR
SETDMA:	EQU	33	; SET DMA ADDRESS
READS:	EQU	36	; READ SECTOR
WRITES:	EQU	39	; WRITE SECTOR
;
;
;**********************************************
; HEXIDECIMAL INPUT ROUTINES FOR CP/M
;
; VERSION 0.1 - 8 SEP 77 - J.W. SHOOK
;**********************************************

INHEX:	PUSH B ! PUSH D ! PUSH H
	MVI	C,RCON	; INPUT CHARACTER
	CALL	BDOS
	POP H  ! POP D  ! POP B
	SBI	'0'	; REMOVE ASCII OFFSET
	JC	INHEX2
	CPI	10	; DECIMAL DIGIT?
	JC	INHEX1
	SBI	'@'-'9'	; REMOVE ALPHA BIAS
INHEX1:	CPI	16	; TOO LARGE?
	JNC	INHEX2
	ORA	A	; CLEAR CARRY
	RET

INHEX2:	XRA	A	; CLEAR A ON ERROR
	STC	; MARK ERROR WITH CARRY
	RET

INBYTE:	CALL	INHEX	; INPUT HIGH HEX DIGIT
	RC		; ERROR
	ADD	A	; SHIFT TO LEFT HALF
	ADD	A
	ADD	A
	ADD	A
	MOV	B,A	; SAVE BYTE
	CALL	INHEX	; GET LOW HEX DIGIT
	RC		; ERROR
	ORA	B
	RET


INADDR:	CALL	INBYTE	; INPUT 4 DIGIT HEX NUMBER
	MOV	H,A
	PUSH	H
	CALL	INBYTE
	POP	H
	MOV	L,A
	RET


; VARIABLE DECLARATIONS

DISK:	DS	1
DMAADR:	DS	2
TRACK:	DS	2
SECTOR:	DS	1
RECORD:	DS	1
RCOUNT:	DS	2
SAVSP:	DS	2
	DS	100H
STACK:	DS	2

; SYMBOL DEFINITIONS

CR	EQU	0DH
LF	EQU	0AH

;***********************************;
;         CP/M STANDARD EQUATES     ;
;***********************************;

BOOT	EQU	0000H	;WARM START ADDRESS
TFCB	EQU	005CH	;DEFAULT FCB ADDRESS
TBUF	EQU	0080H	;DEFAULT BUFFER ADDRESS
TBASE	EQU	0100H	;TRANSIENT PROGRAM BASE
CBASE	EQU	2900H	;CCP BASE ADDRESS
BDOS	EQU	0005H	;CPM ENTRY POINT

;***********************************;
;       CP/M FUNCTION CODES         ;
;***********************************;
 
SRSET	EQU	00	;SYSTEM RESET
RCON	EQU	01	;READ CONSOLE
WCON	EQU	02	;WRITE CONSOLE
RRDR	EQU	03	;READ READER
WPUN	EQU	04	;WRITE PUNCH
WLST	EQU	05	;WRITE LIST
ISTAT	EQU	07	;GET IOSTATUS
SSTAT	EQU	08	;SET IOSTATUS
WCONB	EQU	09	;WRITE CONSOLE BUFFER
RCONB	EQU	10	;READ CONSOLE BUFFER
CSTAT	EQU	11	;CHECK CONSOLE STATUS
LHEAD	EQU	12	;LIFT DISK HEAD
RSDSK	EQU	13	;RESET DISK SYSTEM
SDISK	EQU	14	;SELECT DISK
OPEN	EQU	15	;OPEN FILE
CLOSE	EQU	16	;CLOSE FILE
SFRST	EQU	17	;SEARCH FIRST
SNEXT	EQU	18	;SEARCH NEXT
FDELT	EQU	19	;DELETE FILE
READ	EQU	20	;READ RECORD
WRITE	EQU	21	;WRITE RECORD
CREATE	EQU	22	;CREATE FILE
RENAM	EQU	23	;RENAME FILE
LOGIN	EQU	24	;GET LOGIN
IDISK	EQU	25	;GET DISK NUMBER
SDMA	EQU	26	;SET DMA VECTOR
IALLOC	EQU	27	;GET ALLOCATION VECTOR
	END

