*This program is used in conjuntion with dmatst.com.  When dmatst
*is called, it sets the MPX to doing dma in the second page of
*memory.  When this is called, it stops the nonsense and prints
*out whether the MPX has encountered any problems with its memory
*accessing.  It does this by simply placing a 0F0h at result byte
*2, or 'linkad+0fh'. It then monitors result byte 1 ('linkad+0eh')
*to see what the MPX says.  If it returns a 0aah then there has been
*an error.  If it returns a 0ffh then memory and DMA'ing is good.

good	equ	0ffh	;what MPX returns is one of these two
bad	equ	0aah

reboot	equ	00h
fdos	equ	reboot+05h
linkad	equ	41h	;where to find relevant information
*--------------------------------------
	
	org	100h		

howru:	xra	a		;clear response byte from MPX
	sta	linkad+0eh

	mvi	a,0f0h		;tell mpx to finish and respond
	sta	linkad+0fh

loop1:	lda	linkad+0eh
	ora	a	;wait until MPX responds with something
	jz	loop1

	cpi	good
	jz	gdnews

	cpi	bad
	jz 	bdnews

	lxi	h,weird		;the premise is that the MPX can only
	call	write		;respond with a 'good' or 'bad'. If any
	jmp	reboot		;other comes up, issue a message.

gdnews:	lxi	h,gd
	call	write
	jmp	reboot

bdnews:	lxi	h,bd
	call	write
	jmp	reboot
*-------------------------

write:	mov	a,m		;general purpose write routine.
	ora	a		;Initial address of output is
	rz			;contained in HL.  Terminates when
				;@HL contains 0h.
	mvi	c,02h
	mov	e,a

	push	h
	call	fdos
	pop	h

	inx	h
	jmp	write
*---------------------------

gd:	db	0dh,0ah,'CPU: Proper Termination of Process.',0dh,0ah,0h
bd:	db	0dh,0ah,'CPU: Proper Termination But MPX Error.',07h,0dh,0ah,0h
weird:	db	0dh,0ah,'CPU: Error, Illegal response from MPX.',07h,0dh,0ah,0h

	end
