acr	equ	0dh	;carriage return
alf	equ	0ah	;line feed
bdos	equ	5
conin	equ	1
pstring	equ	9
;
base	equ	50h	;mult/io i/o base
mpic0	equ	base	;master pic port a=0 
mpic1	equ	base+1	;master pic port a=1
spic0	equ	base+2	;slave pic port a=0 
spic1	equ	base+3	;slave pic port a=1
;
ic4	equ	1	;flag to require icw4
d4	equ	10h	;bit to signify pic init command
ltim	equ	8	;level trigger interrupt mode
addi	equ	4	;call address interval is 4
sngl	equ	0	;only one pic in system
imask	equ	00h	;interrupt mask-- enable all interrupts
eoi	equ	20h	;end of interrupt command to pic
;
timer0	equ	base+4
timer1	equ	base+5
timer2	equ	base+6	
tcntrl	equ	base+7	;timer control register
md0t0	equ	20h	;mode 0 for timer 0
md0t1	equ	60h	;mode 0 for timer 1
md0t2	equ	0a0h	;mode 0 for timer 2
;
	org	100h
;print copyright mesg
        lxi	d,cpymsg	;copyright message
        call    pmsg
;
start:	di		;disable interrupts
	lxi	sp,stack
	mvi	a,0ffh	;CPU-Z board interrupt mask
	out	0feh	;disable VI lines to CPU-Z
	lxi	d,dirmsg	;directions
	call	pmsg
;
;bring all timers low
	mvi	a,md0t0
	out	tcntrl
	mvi	a,md0t1
	out	tcntrl
	mvi	a,md0t2
	out	tcntrl
;
;initialize master pic
;
minit:	mvi	a,d4+ltim+addi+sngl+ic4
	out	mpic0	;icw1
	mvi	a,2	;address table starts at 200h
	out	mpic1	;icw2
	mvi	a,80h	;slave owner identifier
	out	mpic1	;icw3
	mvi	a,10h	;special fully nested mode
	out	mpic1	;icw4
	xra	a	;enable all interrupts
	out	mpic1	;ocw1
	mvi	a,8h	;non-polled mode
	out	mpic0	;ocw3
;
sinit:	mvi	a,d4+ltim+addi+sngl+ic4+20h
	out	spic0	;icw1
	mvi	a,2	;address table starts at 200h
	out	spic1	;icw2
	mvi	a,7h	;slave 
	out	spic1	;icw3
	mvi	a,10h	;special fully nested mode
	out	spic1	;icw4
	xra	a	;enable all interrupts
	out	spic1	;ocw1
	mvi	a,8h	;non-polled mode
	out	spic0	;ocw3
;
;set timer 2 high and mask out higher priority timer 2 interrupts
;should only allow s-irq7
;
begin:	mvi	a,24h	;master interrupt mask (kills irq's 2 and 5)
	out	mpic1	;for first pass
	mvi	a,12h	;slave interrupt mask (kills irq's 1 and 4)
	out	spic1	;for first pass
	xra	a	;count byte for timer
	out	timer2

;wait for consle input 
;
main:	di	;disable interrupts
	mvi	c,conin
	call	bdos	;get any character
	ei	;enable	interrupts
	halt
	jmp	main
;
;
	org	200h
;
table:	jmp	mirq0
	db	0
	jmp	mirq1
	db	0
	jmp	mirq2
	db	0
	jmp	mirq3
	db	0
	jmp	mirq4
	db	0
	jmp	mirq5
	db	0
	jmp	mirq6
	db	0
	jmp	mirq7
	db	0
	jmp	sirq0
	db	0
	jmp	sirq1
	db	0
	jmp	sirq2
	db	0
	jmp	sirq3
	db	0
	jmp	sirq4
	db	0
	jmp	sirq5
	db	0
	jmp	sirq6
	db	0
	jmp	sirq7
	db	0
;
mirq0:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t0
	out	tcntrl
;set up next timer
	xra	a
	out	timer2
;print message
	lxi	d,m0msg
	call	pmsg
;set up next pic masks
	mvi	a,24h
	out	mpic1	;master pic interrupt mask
	mvi	a,12h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq1:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t1
	out	tcntrl
;set up next timer
	xra	a
	out	timer0
;print message
	lxi	d,m1msg
	call	pmsg
;set up next pic masks
	mvi	a,0h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq2:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t2
	out	tcntrl
;set up next timer
	xra	a
	out	timer1
;print message
	lxi	d,m2msg
	call	pmsg
;set up next pic masks
	mvi	a,0h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq3:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t0
	out	tcntrl
;set up next timer
	xra	a
	out	timer2
;print message
	lxi	d,m3msg
	call	pmsg
;set up next pic masks
	mvi	a,0h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq4:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t1
	out	tcntrl
;set up next timer
	xra	a
	out	timer0
;print message
	lxi	d,m4msg
	call	pmsg
;set up next pic masks
	mvi	a,1h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq5:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t2
	out	tcntrl
;set up next timer
	xra	a
	out	timer1
;print message
	lxi	d,m5msg
	call	pmsg
;set up next pic masks
	mvi	a,2h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq6:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t0
	out	tcntrl
;set up next timer
	xra	a
	out	timer2
;print message
	lxi	d,m6msg
	call	pmsg
;set up next pic masks
	mvi	a,4h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
mirq7:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t2
	out	tcntrl
;set up next timer
	xra	a
	out	timer1
;print message
	lxi	d,m7msg
	call	pmsg
;set up next pic masks
	mvi	a,0h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq0:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t1
	out	tcntrl
;set up next timer
	xra	a
	out	timer0
;print message
	lxi	d,s0msg
	call	pmsg
;set up next pic masks
	mvi	a,9h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq1:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t2
	out	tcntrl
;set up next timer
	xra	a
	out	timer1
;print message
	lxi	d,s1msg
	call	pmsg
;set up next pic masks
	mvi	a,12h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq2:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t0
	out	tcntrl
;set up next timer
	xra	a
	out	timer2
;print message
	lxi	d,s2msg
	call	pmsg
;set up next pic masks
	mvi	a,24h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq3:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t1
	out	tcntrl
;set up next timer
	xra	a
	out	timer0
;print message
	lxi	d,s3msg
	call	pmsg
;set up next pic masks
	mvi	a,49h
	out	mpic1	;master pic interrupt mask
	mvi	a,0h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq4:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t2
	out	tcntrl
;set up next timer
	xra	a
	out	timer1
;print message
	lxi	d,s4msg
	call	pmsg
;set up next pic masks
	mvi	a,12h
	out	mpic1	;master pic interrupt mask
	mvi	a,1h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq5:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t0
	out	tcntrl
;set up next timer
	xra	a
	out	timer2
;print message
	lxi	d,s5msg
	call	pmsg
;set up next pic masks
	mvi	a,24h
	out	mpic1	;master pic interrupt mask
	mvi	a,2h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq6:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t1
	out	tcntrl
;set up next timer
	xra	a
	out	timer0
;print message
	lxi	d,s6msg
	call	pmsg
;set up next pic masks
	mvi	a,49h
	out	mpic1	;master pic interrupt mask
	mvi	a,4h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
sirq7:	push	h
	push	d
	push	b
	push	psw
;eliminate cause of interrupt
	mvi	a,md0t2
	out	tcntrl
;set up next timer
	xra	a
	out	timer1
;print message
	lxi	d,s7msg
	call	pmsg
;set up next pic masks
	mvi	a,12h
	out	mpic1	;master pic interrupt mask
	mvi	a,9h
	out	spic1	;slave pic interrupt mask
;
	jmp	intret	;return from interrupt
;
;
;routine below is a good general purpose exit routine
;
intret:	
	mvi	a,eoi	;signal end of interrupt to pic
	out	mpic0
	out	spic0
	pop	psw
	pop	b
	pop	d
	pop	h
	ret		;back to main program or next interrupt
;
pmsg:	mvi	c,pstring	;print string pointed to by de
	jmp	bdos		;and ending with $
;
m0msg:	db	acr,alf,'Number 15 of 15',acr,alf,'$'
m1msg:	db	acr,alf,'Number 14 of 15',acr,alf,'$'
m2msg:	db	acr,alf,'Number 13 of 15',acr,alf,'$'
m3msg:	db	acr,alf,'Number 12 of 15',acr,alf,'$'
m4msg:	db	acr,alf,'Number 11 of 15',acr,alf,'$'
m5msg:	db	acr,alf,'Number 10 of 15',acr,alf,'$'
m6msg:	db	acr,alf,'Number 9 of 15',acr,alf,'$'
m7msg:	db	acr,alf,'Illegal Interrupt!',acr,alf,'$'
s0msg:	db	acr,alf,'Number 8 of 15',acr,alf,'$'
s1msg:	db	acr,alf,'Number 7 of 15',acr,alf,'$'
s2msg:	db	acr,alf,'Number 6 of 15',acr,alf,'$'
s3msg:	db	acr,alf,'Number 5 of 15',acr,alf,'$'
s4msg:	db	acr,alf,'Number 4 of 15',acr,alf,'$'
s5msg:	db	acr,alf,'Number 3 of 15',acr,alf,'$'
s6msg:	db	acr,alf,'Number 2 of 15',acr,alf,'$'
s7msg:	db	acr,alf,'Number 1 of 15',acr,alf,'$'
;
dirmsg:	db	acr,alf,'Hit any key-- board should '
	db	'count from 1 to 15.',acr,alf,'$'
cpymsg: db      acr,alf,'COPYRIGHT COMPUPRO 1983'
        db      acr,alf,acr,alf,'$'
;
	ds	100h	;room for stack
stack	equ	$	;top of stack goes here
