/****************************************************************************

	Intel (tm) Hex format file saver library module

	This module supports the saving of Intel-Hex files from a buffer
location.

*****************************************************************************

	Known bugs:



*****************************************************************************

	Revisions:

1.00 -	11-20-92   grh
	1st cut.
	11-24-92   grh
	Correct printf() not returning anything, which caused premature abort.
	Correct checksum & buffer ptr increment bugs.
	11-25-92   grh
	Correct ld_addr increment bug.



****************************************************************************/

#include stdio.h
#include ctype.h
#include errno.h
#include mydefs.h

char
	htoa();

static BYTE
	chksum;		/* Accumulated checksum for record */

static int
	x_err;		/* Local error accumulator */


/****************************************************************************

	Save Hex file function
This function assumes the file is 'fopen'ed without error by the caller.
	entry -	outfile= stream
		bptr= ptr to start of buffer to xfer
		count= number of bytes to xfer
	exit -	0= ok
		-1= Error

****************************************************************************/
int 
writhex( outfile, bptr, count )   
	FILE 
		*outfile;   
	BYTE 
		*bptr;
	LWORD 
		count;
{

   static BYTE
	rec_len;	/* Hex record length */
   static WORD
	ld_addr;	/* Hex record load address */

/* Initialize data */
   ld_addr = 0;		/* start load address at 0 */
   x_err = FALSE;

/* Top of record loop */
   while( x_err == FALSE ) {
      chksum = 0;	/* init record checksum */
      fprintf( outfile, "\n:" );
      x_err |= errno;	/* sense fprintf error status */
      x_err = fputhxb( outfile, rec_len = ( count < 16 ) ? count : 16 ); /* byte cnt */
      x_err = fputhxw( outfile, ld_addr );	/* record's load address */
      x_err = fputhxb( outfile, 0 );		/* data record type */
      for( ; rec_len > 0; rec_len-- )   x_err = fputhxb( outfile, *bptr++ );
      x_err = fputhxb( outfile, -chksum );
      if( count <= 16 )   break;	/* if short record then done */
      else count -= 16;			/* else do next record */
      ld_addr += 16;
      }

/* Write end-of-file record */
   chksum = 0;	/* init record checksum */
   fprintf( outfile, "\n:" );
   x_err |= errno;	/* sense fprintf error status */
   x_err = fputhxb( outfile, 0 ); /* byte cnt */
   x_err = fputhxw( outfile, 0 );	/* record load address */
   x_err = fputhxb( outfile, 1 );		/* record type = data */
   x_err = fputhxb( outfile, -chksum );

/* Done */
   return x_err;
   }


/****************************************************************************

	Output hex byte to stream function
Function tests for previous error 1st. If true then returns.
	entry-	str= stream
		byte= byte to output
	exit -	0: ok
		/0: error

****************************************************************************/
static int 
fputhxb( str, byte )
	FILE
		*str;
	BYTE
		byte; 
{

   int
	xe;	/* local error status */

/* If previous error then abort */
   if( x_err )   return x_err;

/* Else convert high nibble */
   xe = putc( htoa( byte >> 4 ), str );

/* Now low nibble */
   xe = putc( htoa( byte ), str );

/* Update checksum */
   chksum += byte;

/* Done, return status */
   return ( xe == -1 ) ? -1 : 0;
   }


/****************************************************************************

	Output hex word to stream function
Function tests for previous error 1st. If true then returns.
	entry-	str= stream
		word= word to output
	exit -	0: ok
		/0: error

****************************************************************************/
static int 
fputhxw( str, word )
	FILE
		*str;
	WORD
		word; 
{

   int
	xe;	/* local error status */

/* If previous error then abort */
   if( x_err )   return x_err;

/* Else convert highest byte */
   xe = fputhxb( str, word >> 8 );

/* Now low byte */
   xe = fputhxb( str, word );

/* Done, return status */
   return ( xe == -1 ) ? -1 : 0;
   }


/****************************************************************************

	return ascii-hex character of binary nibble function
	entry-	nib=	data
	exit -	ascii-hex character of nib

****************************************************************************/
static char 
htoa( nib )
	BYTE
		nib;
{

/* Mask unused bits */
   nib &= 0x0f;

/* Convert to ascii-hex and return it */
   return ( nib <= 9 ) ? '0' + nib : '7' + nib;
   }
