/*  dos.h
****************************************************************************
/
/	DOS definitions header file
/
****************************************************************************
/
/ Revision History:
/
/ 1.0	2-22-95   grh
/	Extracted from io.h.
/	4-30-95   grh
/	Change conditional definitions to conditional #include myheader.h.
/	5-3-95   grh
/	Change myheader detection to MYFLAG.
/
****************************************************************************/

/*
/	Predefinitions
*/
#ifndef	MYFLAG
#include b:myheader.h
#endif

/*
/	Definitions
*/
#define	FNAMECHARS	8
#define	FTYPECHARS	3
#define	FNAMESIZE	11
#define	SECTSIZE	128

/*
/	File Control Block structure
*/
struct Fcb {
   BYTE
	F_Drive,		/* Drive number */
	F_Name [FNAMECHARS],	/* File name */
	F_Type [FTYPECHARS],	/* File type */
	F_Ext,			/* File current extent number */
	F_Resv [2],		/* Reserved */
	F_Rc,			/* Record count in extent */
	F_Sydx [16],		/* cluster allocation for extent */
	F_Cr;			/* Current record for read/write */
   WORD
	F_Record;		/* Random record number for read/write */
   BYTE
	F_Overfl;
   };
#define	FCBSIZE		(sizeof) struct fcb

/*
/	DOS Functions
*/
#define	SYSRESET	0
#define	READCNSL	1
#define	WRITCNSL	2
#define	WRITLIST	5
#define	CNSLIO		6
#define	PRNSTRNG	9
#define	RDCNSLBUF	10
#define	GETCNSLS	11
#define	GETVERS		12
#define	RESETDSK	13
#define	SELECTDSK	14
#define	OPENFILE	15
#define CLOSFILE	16
#define	SRCHFILE	17
#define	SRCHNEXT	18
#define DELFILE		19
#define READSEQ		20
#define WRITSEQ		21
#define MAKEFILE	22
#define	RENAMEFIL	23
#define	GETLOGIN	24
#define	GETDISKNO	25
#define SETDMA		26
#define	GETALLOCV	27
#define	WRTPROT		28
#define	GETROV		29
#define	SETFATT		30
#define	GETDPBA		31
#define GETUSR		32
#define READRAN		33
#define WRITRAN		34
#define FILESIZE	35
#define SETRANREC	36
#define	RESETDRV	37
#define	WRITERAN	40

/*
/	addresses
*/
#define	CURDRIVE	((BYTE *) 0x0004)
#define	BDOSENT		(( () *) 0x0005)
#define	DEFFCB		((BYTE *) 0x005c)
#define WRKBUF		((BYTE *) 0x0080)
