/****************************************************************************

	Buffer operations procedure
	Entry-	bufstrt= start address of the buffer for offsetting I/O
		bufend= last byte of buffer to prevent data corruption
		bufoff= offset added to user address input and subtracted 
			from address displays.
	Exit -	void

	The buffer access routines assume an offset of 'bufstrt' for user 
input. That is, all location arguments by the user have 'bufstrt' added to 
them and displayed addresses have 'bufstrt' subtracted from them.

*****************************************************************************
Known Bugs:




*****************************************************************************
Revision History:

	11-25-92   grh
	Add static invargs() function & display diagnostic '^' at error.





****************************************************************************/
#include stdio.h
#include errno.h
#include mylib.h

static char
	*cp,		/* character ptr */
	*tp;		/* input buffer ptr */

void
	invargs();


void 
buff_ops( bufstrt, bufend, bufoff )
	BYTE
		*bufstrt,	/* start address of buffer */
		*bufend;	/* last address of buffer */
	WORD
		bufoff;		/* offset to add to user input and display */
{

   unsigned int
	i;		/* counter */
   char
	tbuf[80];	/* input buffer */
   BYTE
	*bytptr;	/* buffer ptr */
   WORD
	arg[4],		/* command arguments */
	bufsize,	/* byte count of buffer */
	temp;		/* temporary storage */
   FILE
	*fp;		/* file ptr */
   static struct cmd
	buf_ops[] = {	"CO", 1,	/* Compare */
			"CH", 2,	/* Checksum */
			"D" , 3,	/* Display */
			"F",  4,	/* Fill */
			"LH", 5,	/* Load HEX file */
			"L",  6,	/* Load binary file */
			"M",  7,	/* Move */
			"SA", 8,	/* Save binary */
			"SH", 9,	/* Save HEX */
			"SE", 10,	/* Search */
			"S",  11,	/* Substitute */
			"XO", 12,	/* Exclusive or data */
			"X",  99,	/* Return to caller */
			"", 0
			};
   static char
	*bop1 = "\n\
********************* Buffer Operations Menu ***********************\n\
\n\
CO 1st last 2nd_1st	- Compare\n\
CH 1st last		- Checksum\n\
D  1st <last>		- Display\n\
F  1st last value	- Fill\n\
LH 1st filename		- Load HEX file\n\
L  1st filename		- Load binary file\n\
M  1st last new_1st	- Move\n\
SA 1st last filename	- Save binary\n\
SH 1st last filename	- Save HEX\n\
SE 1st last list	- Search for list bytes\n\
S  addr			- Substitute\n\
XO 1st last value	- Exclusive or data\n\
X			- Return to previous menu\n";

/* Print prompt on 1st entry */
   printf( bop1 );

/* Initialize */
   bufsize = bufend + 1 - bufstrt;

/* Loop until exit requested */
   while( TRUE ) {

/**** Fetch user command token */
      tp = cp = tbuf;
      temp = get_cmd( buf_ops, "Buf", &cp );

/**** Execute option */
      switch( temp ) {

	 case 1:	/**** Compare buffer ****/
	 if( get_n_args( &cp, 3, arg ) < 3 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] ) {
	    invargs();
	    break;
	    }
	 for( temp = TRUE;
		arg[0] <= arg[1] && bdos( 11, 0 ) == 0;
		arg[0]++, arg[2]++ ) {
	    if( bufstrt[ arg[0] ] != bufstrt[ arg[2] ] ) {
	       printf( "\n%04x = %02x : %04x = %02x ",
			arg[0], bufstrt[ arg[0] ],
			arg[2], bufstrt[ arg[2] ] );
	       temp = FALSE;
	       }
	    }
	 if( bdos( 11, 0 ) )   bdos( 1, 0 );	/* Dump possible abort char */
	 printf( ( temp ) ? "\nOK!\n" : "\n" );
         break;


         case 2:	/**** Checksum buffer ****/
	 if( get_n_args( &cp, 3, arg ) < 2 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] ) {
	    invargs();
	    break;
	    }
	 for( temp = 0; arg[0] <= arg[1]; arg[0]++ )
		 temp += bufstrt[ arg[0] ];
	 printf( "\n%4x -%4x\n", temp, -temp );
         break;


         case 3:	/**** Display buffer ****/
	 if( ( temp = get_n_args( &cp, 2, arg ) ) < 1 )  arg[0] = arg[1];
	 if( temp < 2 )   arg[1] = arg[0] + 128;
	 if( arg[0] > arg[1] ) {
	    invargs();
	    break;
	    }
	 for(  ; arg[0] <= arg[1] && bdos( 11, 0 ) == 0; arg[0] += 16 ) {
	    temp = ( ( arg[1] - arg[0] ) >= 16 ) ? 16 : ( arg[1] - arg[0] + 1 );
	    printf( "\n%4x  ", arg[0] );
	    for( i = 0; i < temp; i++ )
		printf( "%02x ", bufstrt[ arg[0] + i ] );
	    printf( "  " );
	    for( i = 0; i < temp; i++ )   
			printf( "%c",
				( ( bufstrt[ arg[0] + i ] < ' ' ) ||
		 		  ( bufstrt[ arg[0] + i ] > 0x7e ) ) 
		 		   ? '.' : bufstrt[ arg[0] + i ] );
	    }
	 if( bdos( 11, 0 ) )   bdos( 1, 0 );	/* Dump possible abort char */
	 break;


         case 4:	/**** Fill buffer ****/
	 if( get_n_args( &cp, 3, arg ) < 3 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] || arg[1] > bufsize ) {
	    invargs();
	    break;
	    }
	 while( arg[0] <= arg[1] )   bufstrt[ arg[0]++ ] = arg[2];
         break;


         case 5:	/**** Load Hex file ****/
	 if( get_n_args( &cp, 1, arg ) < 1 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > bufsize ) {
	    invargs();
	    break;
	    }
	 if( *cp == '\0' ) {
	    invargs();
	    break;
	    }
	 fp = fopen( cp, "r" );
	 if( fp == NULL ) {
	    printf( "\nFile Open Error: %d", errno );
	    break;
	    }
	 if( readhex( fp, &bufstrt[ arg[0] ], bufend ) != NULL )
		printf( "\nFile Read Error: %d", errno );
	 if( fclose( fp ) == -1 )   
		printf( "\nFile Close Error: %d", errno );	 
         break;


         case 6:	/**** Load binary file ****/
	 if( get_n_args( &cp, 1, arg ) < 1 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] || arg[0] > bufsize ) {
	    invargs();
	    break;
	    }
	 if( *cp == '\0' ) {
	    invargs();
	    break;
	    }
	 fp = fopen( cp, "r" );
	 if( fp == NULL ) {
	    printf( "\nFile Open Error: %d", errno );
	    break;
	    }
	 fread( &bufstrt[ arg[0] ], bufend - &bufstrt[ arg[0] ], 1, fp );
	 if( ferror( fp ) )
		printf( "\nFile Read Error: %d", errno );
	 if( fclose( fp ) == -1 )   
		printf( "\nFile Close Error: %d", errno );	 
         break;


         case 7:	/**** Move memory ****/
	 if( get_n_args( &cp, 3, arg ) < 3 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] ||
	     arg[1] > bufsize ||
	     ( arg[2] + ( arg[1] - arg[0] ) ) > bufsize ) {
	    invargs();
	    break;
	    }
	 if( arg[2] > arg[0] && arg[2] <= arg[1] ) {
	    arg[2] += arg[1] - arg[0] + 1;
	    for( ; arg[0] <= arg[1]; arg[1]--, arg[2]-- )
		bufstrt[ arg[2] ] = bufstrt[ arg[1] ];
	    }
	 else {
	    for( ; arg[0] <= arg[1]; arg[0]++, arg[2]++ )
		bufstrt[ arg[2] ] = bufstrt[ arg[0] ];
	    }
         break;


         case 8:	/**** Save binary file ****/
	 if( get_n_args( &cp, 2, arg ) < 2 ) {
	    invargs();
	    break;
	    }
	 if( arg[1] == arg[0] ||
		arg[0] > bufsize ||
		arg[1] > bufsize ) {
	    invargs();
	    break;
	    }
	 if( *cp == '\0' ) {
	    invargs();
	    break;
	    }
	 fp = fopen( cp, "w" );
	 if( fp == NULL ) {
	    printf( "\nFile Open Error: %d. Disk Full?", errno );
	    break;
	    }
	 fwrite( &bufstrt[ arg[0] ], arg[1] - arg[0], fp );
	 if( fclose( fp ) == -1 )   
		printf( "\nFile Close Error: %d", errno );	 
         break;


         case 9:	/**** Save Hex file ****/
	 if( get_n_args( &cp, 2, arg ) < 2 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] == arg[1] || 
		arg[0] > bufsize ||
		arg[1] > bufsize ) {
	    invargs();
	    break;
	    }
	 if( *cp == '\0' ) {
	    invargs();
	    break;
	    }
	 fp = fopen( cp, "w" );
	 if( fp == NULL ) {
	    printf( "\nFile Open Error: %d. Disk Full?", errno );
	    break;
	    }
	 writhex( fp, &bufstrt[ arg[0] ], (LWORD) ( arg[1] - arg[0] ) );
	 if( fclose( fp ) == -1 )
		printf( "\nFile Close Error: %d", errno );	 
         break;


         case 10:	/**** Search for list ****/
	 if( get_n_args( &cp, 2, arg ) < 2 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] ) {
	    invargs();
	    break;
	    }
	 bytptr = cp = tbuf;
	 while( get_n_args( &cp, 1, &arg[3] ) == 1 ) {
            *bytptr++ = (BYTE) arg[0];
            }
	 temp = bytptr - tbuf;
	 for( ; arg[1] <= arg[2] && bdos( 11, 0 ) == 0; arg[1]++ ) {
	    for( i = 0; i < temp; i++ )
		if( bufstrt[ arg[1] + i ] != tbuf[i] )   break;
	    if( i == temp )   printf( "\n%04x", arg[1] );
	    }
	 if( bdos( 11, 0 ) )   bdos( 1, 0 );	/* Dump possible abort char */
         break;


         case 11:	/**** Substitute data ****/
	 if( get_n_args( &cp, 1, arg ) < 1 ) {
	    invargs();
	    break;
	    }
	 for( ; arg[0] < bufsize; arg[0] += 1 ) {
	    printf( "\n%04x: %02x > ", arg[0], bufstrt[ arg[0] ] );
	    gets( tbuf );
	    cp = tbuf;
	    if( tbuf[0] == '.' )   break;
	    else if( tbuf[0] == '-' && arg[0] > 2 )   arg[0] -= 2;
	    else if( get_n_args( &cp, 1, &arg[1] ) == 1 )
		   bufstrt[ arg[0] ] = (BYTE) arg[1];
	    }
         break;


         case 12:	/**** Exclusive or data ****/
	 if( get_n_args( &cp, 3, arg ) < 3 ) {
	    invargs();
	    break;
	    }
	 if( arg[0] > arg[1] || arg[1] > bufsize ) {
	    invargs();
	    break;
	    }
	 while( arg[0] <= arg[1] )   
		bufstrt[ arg[0]++ ] ^= (BYTE) arg[2];
         break;

         case 99:	/**** Return to previous menu ****/
         return;
         break;

         default:	/**** ??? ****/
   	 printf( bop1 );
	 break;
	 }
      }
   }


/****************************************************************************

	Display invalid argument message & diagnostics
	Assumes: tp= ptr to command line
		 cp= ptr to command line error

****************************************************************************/
static void
invargs()

{
   WORD
	d;

/* Display command line */
   printf( "\n%s\n", tp );

/* Space over to error */
   for( d = cp - tp; d-- > 0; )   printf( " " );

/* Point to error */
   printf( "^" );

/* Print message */
   printf( "\nArgument(s) Error!\n" );
   }