;	CBIOS FOR MICROMATION 16K VERSION OF CP/M VERSION 1.3
;
;	COPYRIGHT (C) 1977, MICROMATION AND DIGITAL RESEARCH
;
;
;   OCTOBER 16, 1977
;
MSIZE		EQU	16	;SIZE OF OPERATING SYSTEM IN KILOBYTES
				;(CURRENTLY 16K).  THIS NUMBER MUST BE
				;CHANGED FOR LARGER SYSTEMS.
LOCATION	EQU	MSIZE*1024-512	;ORG LOCATION FOR THE CBIOS
;
	ORG	LOCATION	;BASE OF BIOS IN 16K SYSTEM
;
;
;	MAP OF SCRATCH AREA
;
SCRATCH		EQU	0FA00H		;BASE ADDR OF RAM SCRATCH AREA
;
BOOTSTACK	EQU	SCRATCH+6FH
CONTROLBYTE	EQU	SCRATCH+70H
RETRYCOUNT	EQU	SCRATCH+73H
DMAADDR		EQU	SCRATCH+74H
ADDRPTR		EQU	SCRATCH+76H
TRACK		EQU	SCRATCH+77H
SECTOR		EQU	SCRATCH+79H
;
;	PSEUDO PORTS IN ROM
;
DATAPORT	EQU	SCRATCH+100H
MARKPORT	EQU	SCRATCH+101H
DISKFUNCTION	EQU	SCRATCH+102H
LOADPORT	EQU	SCRATCH+103H
SERIALOUTPORT	EQU	SCRATCH+103H
;
;
;
HOME	EQU	0F822H
SELDSK	EQU	0F87FH
SETTRK	EQU	0F83FH
SETSEC	EQU	0F94CH	;SET SECTOR NUMBER
SETDMA	EQU	0F95AH
;
;
DISKWRITE	EQU	0F8D8H
DISKREAD	EQU	0F8B6H
DATAXFER	EQU	0F8C7H
;
;
SPEED		EQU	SCRATCH+71H
SERIALOUT	EQU	0F9C7H
SERIALIN	EQU	0F996H
;
;
CBASE	EQU	(MSIZE-16)*1024	;BIAS FOR SYSTEMS GREATER THAN 16K
CPMB	EQU	CBASE+2900H
BDOS	EQU	CBASE+3206H
CCPM	EQU	CPMB-128
CPML	EQU	$-CPMB
NSECTS	EQU	2AH	;CHANGE FOR LARGER MEMORY
;
	JMP	BOOT
EBOOT:	JMP	WBOOT
	JMP	CONST
	JMP	CONIN
	JMP	CONOUT
	JMP	LIST
	JMP	PUNCH
	JMP	READER
	JMP	TRACKZERO		;HOME
	JMP	SELDSK		;SELDSK		
	JMP	SETTRK		;SETTRK
	JMP	SETSEC		;SETSEC
	JMP	SETDMA		;SETDMA
	JMP	READ		;DISKREAD
	JMP	WRITE		;DISKWRITE
ERRORV:	RET			;NOT CURRENTLY USED
	NOP			;RESERVED FOR FUTURE ERROR
	NOP			;REPORTING
;
WBOOT:	LXI	SP,80H
	LDA	CONTROLBYTE
	ANI	08H		;IS IT DRIVE B?
	JZ	ADRIVE		;NO MUST BE A
	MVI	A,01H
ADRIVE:
	STA	CURRDRIVE
	MVI	C,0
	CALL	SELDSK		;SELECT DRIVE A TO REBOOT
	CALL	TRACKZERO
;
;	READ DISKETTE FOR TWO TRACKS, STARTING AT BOOT LOADER POSITION
		LXI	B,CCPM	;ONE SECTOR BOOT
		CALL	SETDMA
RDTRK:	;READ THE FIRST/NEXT TRACK
		LXI	D,0	;SECTOR NUMBER = 0000
RDSEC:	;READ THE FIRST/NEXT SECTOR
		MOV	A,E	;E IS SECTOR NUMBER
		CPI	26	;
		JZ	NXTTRK 	;0...25 COUNTS SECTORS
;	GET SKEWED SECTOR NUMBER
		LXI	H,TRAN
		DAD	D	;HL IS ADDRESS OF SKEWED SECTOR NUMBER
		MOV	A,M	;1...26 IN REG A
		INX	D	;TO NEXT SECTOR
		PUSH	D	;SAVE SECTOR NUMBER
		PUSH	B	;SAVE DMA ADDRESS
		MOV	C,A	;READY FOR SECTOR SET
		PUSH	PSW	;SAVE SKEWED SECTOR NUMBER
		CALL	SETSEC
		POP	PSW	;COUNT TO DMA POSITION
		POP	H	;COPY OF DMA BASE ADDRESS
		PUSH	H	;BACK TO STACK
		LXI	D,128	;SECTOR SIZE
MUL:
		DCR	A	;REGA*128
		JZ	MUL1
		DAD	D	;+128
		JMP	MUL
MUL1:	;HL IS DMA ADDRESS FOR THIS SECTOR
		SHLD	DMAADDR	;STORE IT DIRECTLY
		LDA	TRACK
		ORA	A
		JZ	RELP	;IF TRACK 0, THEN CONTINUE
		LDA	SECTOR	;IF TRACK 1 AND SECTOR > 18
		SUI	18	;THEN SKIP THE READ
		JP	SKIPREAD
RELP:
		CALL	READ	;READ THE DATA
		JNZ	WBOOT	;STAY HERE WHILE ERRORS OCCUR
SKIPREAD:
		POP	B	;RECALL BASE DMA ADDRESS
		POP	D 	;RECALL SECTOR NUMBER
		JMP	RDSEC	;FOR ANOTHER SECTOR
NXTTRK:
		LDA	TRACK	;0,1?
		ORA	A
		JNZ	BOOT	;STOP AT TRACK 1
		MVI	C,1	;SEEK 1 IF NOT
		CALL	SETTRK
		LXI	B,CCPM+26*128	;MOVE TO NEXT TRACK POSITION
		JMP	RDTRK	;TO READ THE ENTIRE TRACK
;
;
; GOING TO TRACK 0 IS FASTER THAN A HOME.  HOME SHOULD BE USED ONLY WHEN
;   AN ERROR HAS OCCURED.
TRACKZERO:
	MVI	C,0
	CALL	SETTRK		;ROUTINE TO HOME DISK (IE GO TO TRACK 0)
	RET
;
;
TRAN:		;TRANSLATION TABLE FOR SKEW FACTOR
;
		DB	01H
		DB	05H
		DB	09H
		DB	0DH
		DB	11H
		DB	15H
		DB	19H
		DB	03H
		DB	07H
		DB	0BH
		DB	0FH
		DB	13H
		DB	17H
		DB	02H
		DB	06H
		DB	0AH
		DB	0EH
		DB	12H
		DB	16H
		DB	1AH
		DB	04H
		DB	08H
		DB	0CH
		DB	10H
		DB	14H
		DB	18H
;
CURRDRIVE	DB	0
;
BOOT:
;
; SET THE SOFTWARE UART SPEED
; IF THE CBIOS IS MODIFIED FOR AN I/O BOARD THE 
;  CODE TO PROGRAM THE UART SHOULD BE 
;  PUT HERE AND THE INSTRUCTION TO SET THE SOFTWARE
;  UART SPEED REMOVED.
	LXI	H,0007H
	SHLD	SPEED
;
;
	MVI	A,0C3H
	STA	0
	LXI	H,EBOOT
	SHLD	1
	STA	5
	LXI	H,BDOS
	SHLD	6
	LXI	B,80H
	CALL	SETDMA
	EI
	LDA	CURRDRIVE	;ACTIVE DISK
	MOV	C,A
	JMP	CPMB
	;SOFTWARE UART CONSOLE ROUTINES
CONST:
	IN	0FAH	;POLL STATUS
	CMA
	ANI	01	;CHECK STATUS BIT
	RZ
	MVI	A,0FFH	;SET UP FOR CHAR RDY
	RET
;
CONIN:
	CALL	0C01FH	;SOL INP
	JZ	CONIN	;LOOP UNTIL CHARACTER RCVD
	ANI	7FH	;SET MSB
	RET
;
CONOUT:
	PUSH	B
	MOV	B,C
	MOV	A,B	;LOAD ACC WITH ASCII
	CPI	0DH	;IS IT A CR
	JNZ	LFCK	;IF NOT JUMP AROUND
	MVI	B,0AH	;LOAD A WITH LF
LFCK:	CPI	0AH	;IS IT A LF?
	JNZ	NCHG	;GO AROUND IF NOT
	MVI	B,0DH	; LOAD B WITH CR
NCHG:
	CALL	0C019H	;SOLSOUT
	POP	B
	RET
	DS	20
LIST:
	JMP	RETV	;JUMP TO RETURN,LEAVE ROOM FOR PATCH
PUNCH:	
	JMP	RETV	;JUMP TO RETURN,LEAVE ROOM FOR PATCH
READER:
	JMP	RETV	;JUMP TO RETURN,LEAVE ROOM FOR PATCH
	JMP	RETV	;JUMP TO RETURN,LEAVE ROOM FOR PATCH
;
;
;
;	ERROR CHECKING READ AND WRITE RTNS FOR
;	MICROMATION CBIOS
;
;		AUGUST 24, 1977
;
;
RETRYLIMIT		EQU	20	;NUMBER OF RETRIES
READ:
		XRA	A	;GET A ZERO
		STA	RETRYCOUNT
RETRYREAD:
		CALL	DISKREAD	;CALL PROM RTN
		MVI	A,0		;ZERO ACCUM, LEAVE FLAGS SET
		RZ			;IF NO ERROR THEN RETURN
		CALL	ERRORV
		CALL	ERRORCHECK
		JNZ	RETRYREAD	;IF ERROR RETRY
		CALL	DATAXFER	;TRANSFERS DATE
		MVI	A,0FH		;ERROR CODE
		RET			;EITHER RETRY SUCCESSFUL OR MORE THAN RETRYLIMIT
;
;
WRITE:
		XRA	A		;GET A ZERO
		STA	RETRYCOUNT
RETRYWRITE:
		CALL	DISKWRITE	;CALL PROM RTN
		MVI	A,0		;ZERO ACCUM, LEAVE FLAGS SET
		RZ			;IF NO ERROR THEN RETURN
		CALL 	ERRORV
		CALL	ERRORCHECK	;
		JNZ	RETRYWRITE	;IF ERROR, RETRY
		MVI	A,0FH		;RETURN ERROR CODE
		RET			; MORE THAN RETRYLIMIT
;
;
ERRORCHECK:
		LDA	RETRYCOUNT	;GET NUMBER OF RETRIES
		INR	A		;ADD ONE
		STA	RETRYCOUNT
		CPI	RETRYLIMIT+1	;HAVE WE RETRIED ENOUGH?
		RZ			;IF YES, RETURN WZERO FLAG OFF
		MVI	A,77H		;IS ERROR A TRACK ERROR?
		CMP	L		;L HOLDS LOCATION OF ERROR
		RNZ			;IF NOT AT 77 THEN NOT TRACK ERROR
;	TRACKERROR
		LDA	RETRYCOUNT
		SUI	10
		RM
		LDA	TRACK
		MOV	C,A		;GET TRACK IN C
		LDA	SECTOR
		MOV	B,A		;GET SECTOR IN B
		PUSH	B		;SAVE TRACK AND SECTOR ON STACK
		CALL	HOME		;PROM RTN TO HOME HEAD
		POP	B		;RESTORE TRACK AND SECTOR
		PUSH	B		;SAVE TRACK AND SECTOR
		CALL	SETTRK		;PROM RTN TO FIND TRACK IN REG C
		POP	B		;GET TRACK AND SECTOR
		MOV	C,B		;GET SECTOR IN REG C
		CALL	SETSEC		;PROM RTN TO FIND SECTOR IN REG C
		MVI	A,0FFH		;TURN OFF THE
		DCR	A		;    ZERO FLAG FOR RETURN
		RET
;
;
RETV:
	RET	;LEAVE ROOM FOR PATCHED I/O ROUTINES
