;
;
;THIS IS THE  BOOTSTRAP LOADER FOR MICROMATION DISKS AND A 16K SYSTEM.
;  TO MODIFY THE BOOT FOR A LARGER SYSTEM CHANGE THE VALUE OF MSIZE TO THE
;  SIZE OF THE NEW SYSTEM (IN KILOBYTES)
;
;                  OCTOBER 12, 1977
;
;
;
;	BOOTSTRAP PROGRAM FOR MICROMATION
;
;		SKEW IS EVERY 4 SECTORS!!
;
	ORG	0000H
;
;
;
;	EQUATES FOR CP/M LOCATIONS
;       MSIZE DETERMINES THE LOCATION IN MEMORY WHERE THE BOOTSTRAP LOADS
;       THE CP/M OPERATING SYSTEM.
;
MSIZE		EQU	16	;SET FOR A 16K SYSTEM, CHANGE WHEN SYSTEM
				;SIZE CHANGES.
;
CBASE		EQU	(MSIZE-16)*1024	;BIAS FOR SYSTEMS LARGER THAN 16K
CCP		EQU	CBASE+2900H	;BASE OF CONSOLE COMMAND PROCESSOR, 16K
CCPM		EQU	CCP-128	;START OF LOAD TO SKIP BOOT
BOOT		EQU	CBASE+3E00H	;COLD START BOOT
;
;	EQUATES FOR RESERVED RAM LOCATIONS
HOME		EQU	0F822H	;MOVE HEAD TO HOME POSITION
SETTRK		EQU	0F83FH	;SET TRACK
SETSEC		EQU	0F94CH	;SET SECTOR NUMBER
SETDMA		EQU	0F95AH	;SET DMA FUNCTION
;
;	SUBROUTINES IN ROM
DMA		EQU	0FA74H	;DMA FUNCTION
DISKREAD	EQU	0F8B6H	;DISK READ
SECTOR		EQU	0FA79H	;SET SECTOR NUMBER
TRACK		EQU	0FA77H	;SET TRACK
;
;
;	MOVE DRIVE ZERO TO HOME POSITION
		LXI	SP,CCPM
		CALL	HOME
;	READ DISKETTE FOR TWO TRACKS, STARTING AT BOOT LOADER POSITION
		LXI	B,CCPM	;ONE SECTOR BOOT
		CALL	SETDMA
RDTRK:	;READ THE FIRST/NEXT TRACK
		LXI	D,0	;SECTOR NUMBER = 0000
RDSEC:	;READ THE FIRST/NEXT SECTOR
		MOV	A,E	;E IS SECTOR NUMBER
		CPI	26	;
		JZ	NXTTRK 	;0...25 COUNTS SECTORS
;	GET SKEWED SECTOR NUMBER
		LXI	H,TRAN
		DAD	D	;HL IS ADDRESS OF SKEWED SECTOR NUMBER
		MOV	A,M	;1...26 IN REG A
		INX	D	;TO NEXT SECTOR
		PUSH	D	;SAVE SECTOR NUMBER
		PUSH	B	;SAVE DMA ADDRESS
		MOV	C,A	;READY FOR SECTOR SET
		PUSH	PSW	;SAVE SKEWED SECTOR NUMBER
		CALL	SETSEC
		POP	PSW	;COUNT TO DMA POSITION
		POP	H	;COPY OF DMA BASE ADDRESS
		PUSH	H	;BACK TO STACK
		LXI	D,128	;SECTOR SIZE
MUL:
		DCR	A	;REGA*128
		JZ	MUL1
		DAD	D	;+128
		JMP	MUL
MUL1:	;HL IS DMA ADDRESS FOR THIS SECTOR
		SHLD	DMA	;STORE IT DIRECTLY
RELP:
		CALL	DISKREAD	;READ THE DATA
		JNZ	RELP	;STAY HERE WHILE ERRORS OCCUR
		POP	B	;RECALL BASE DMA ADDRESS
		POP	D 	;RECALL SECTOR NUMBER
		JMP	RDSEC	;FOR ANOTHER SECTOR
NXTTRK:
		LDA	TRACK	;0,1?
		ORA	A
		JNZ	COLDBOOT;STOP AT TRACK 1
		MVI	C,1	;SEEK 1 IF NOT
		CALL	SETTRK
		LXI	B,CCPM+26*128	;MOVE TO NEXT TRACK POSITION
		JMP	RDTRK	;TO READ THE ENTIRE TRACK
COLDBOOT:
		EI
		NOP		;SPARE BYTE
		JMP	BOOT
;
;
TRAN:		;TRANSLATION TABLE FOR SKEW FACTOR
;
		DB	01H
		DB	05H
		DB	09H
		DB	0DH
		DB	11H
		DB	15H
		DB	19H
		DB	03H
		DB	07H
		DB	0BH
		DB	0FH
		DB	13H
		DB	17H
		DB	02H
		DB	06H
		DB	0AH
		DB	0EH
		DB	12H
		DB	16H
		DB	1AH
		DB	04H
		DB	08H
		DB	0CH
		DB	10H
		DB	14H
		DB	18H
