;
;********************************************************
;*							*
;*		C1 board SASI hard disk I/O		*
;*			Xebec version			*
;*		Version 1.0.  23 may 83			*
;*		Copyright (C) 1983, V. Nadvornik	*
;*							*
;********************************************************
;
hdio:		;hard disk I/O module entry point
	call	sel_sasi	;select SASI controller
	call	set_dcb		;send command to SASI
	call	sasi_rw		;get/put data to SASI port
	ret
;
;	Select the SASI controller (0 or 1)
;
sel_sasi:	;select the Xebec controller
;
;	Test for SASI busy, reset controller if busy
;
	in	sasi_stat	;SASI status port
	ani	sasi_busy
	cz	rst_sasi	;reset the SASI controller
	jrc	sel_sasi	;retry
;
;	Build the SASI select bits and select controller
;
	ldx	a,dsktyp-xdpb	;get physical select bits
	rrc			;position controller select bit
	ani	0000_0001b	;remove extraneous bits
	out	sasi_data	;put on bus
	out	sasi_sel	;pulse select line
	in	sasi_stat	;check for controller busy
	ani	sasi_busy
	cnz	sasi_err1	;NO BUSY from controller, treat as FATAL ERROR
	ret
;
;	Build and output SASI DCB
;
set_dcb:	;check for SASI command mode
	in	sasi_stat	;get SASI status
	ani	sasi_cd		;test command*/data bit
	cnz	sasi_err2	;NO COMMAND MODE from ctlr, non-fatal error
	cc	rst_sasi	;reset and reselect controller
	cc	sel_sasi
;
;	SASI selected and in command mode, build DCB
;
	lda	rw_op		;get read/write command
	rept 4			;position for sasi command
	rrc
	endm
	ani	0000_1010b	;remove extraneous bits
	call	sasi_ot		;output command byte
	ldx	a,dsktyp-xdpb	;get drive bit
	rar			;position drive select bit
	rar
	rar
	ani	0010_0000b	;remove extraneous bits
	mov	b,a		;save in B for high sector address
	lhld	hsttrk		;get cylinder and head, (track)
;
;	Build middle and low sector address bytes
;
	rept 5			;multiply by spt (32 sectors per track)
	dad	h
	cc	inc_hi		;add 1 to high sector address if overflow
	endm
	lda	hstsec		;sector offset
	mov	e,a
	mvi	d,0
	dad	d		;add in sector offset
	cc	inc_hi		;incase of overflow
	mvi	c,sasi_data	;data port
	outp	b		;output sector addres high byte and drive sel.
	outp	h		; and middle sector address
	outp	l		; and low sector address
;
;	Send sector count and control byte to SASI controller
;
	mvi	a,04		;read/write 4 256 byte sectors
	outp	a
	xra	a		;control byte
	outp	a
	ret
;
;
sasi_rw:	jmp	cfger1
		ret
;
;	Input a byte from the SASI data port to A
;
sasi_in:
	in	sasi_stat	;wait for REQ
	ani	sasi_req
	jrnz	sasi_in
	in	sasi_data	;get byte
	ret
;
;	Output the byte in A to the SASI data port
;
sasi_ot:
	push	psw		;save byte
;
sasi_ot_1:
	in	sasi_stat	;test for data request
	ani	sasi_req
	jrnz	sasi_ot_1	;wait for REQ line
	pop	psw		;restore byte
	out	sasi_data
	ret
;
;	Pulse the SASI reset line
;
rst_sasi:
	out	sasi_rst
	stc
	ret
;
;	Add 1 to the SASI dcb drive select/high sector address byte
;
inc_hi:	inr	b		;+1
	ret
;
;	End of C1-Board Hard Disk (XEBEC version) I/O module
;
