;
;********************************************************
;*							*
;*	C1 board floppy disk read/write module.		*
;*		Version 1.0.   26 dec 83		*
;*		Copyright (C) 1983, V. Nadvornik	*
;*							*
;********************************************************
;
fdio:	;Floppy disk read/write module entry point
	call	seldrv
	call	seek
	mvi	a,tries		;read/write error counter
	sta	errcnt
	call	fd_rw
	ret
;
;
seldrv:	;Select the physical drive
;
;	Test the see if the new drive is the same as the
;	old drive, if the same then just return.
;
	ldx	a,dsktyp-xdpb	;diskette type information
	lxi	h,cdrive	;currently selected drive
	cmp	m		;the same ?
	rz			;return if same
;
;	Different drives, build new pointers
;
	mov	m,a		;save new type information
	ani	03
	mvi	d,00		;build offset
	mov	e,a
	lxi	h,cfgtbl
	dad	d
	shld	cfgptr		;new pointer to drive config. table
;
;	Check the drive and diskette configurations
;	IE. 8" drive and 8" diskette, 5.25" drive and 5.25" diskette.
;	FATAL ERROR if 80 track diskette in a 40 track drive.
;
	ldx	a,dsktyp-xdpb	;get diskette info.
	xra	m		;combine the diskette type with the
				;drive type
	ani	0111_0000b	;remove extraneous bits
	jrz	cfgok
;
;	Check for match, execpt for 80/40 drive and diskette
;
	ani	0101_0000b
	cnz	cfger1		;fatal error, configuration mismatch
;
;	Check for 80 track diskette in a 40 track drive
;	A 40 track diskette in a 80 track drive is OK.
;
	bit	5,m		;test for 80 track drive
	jrnz	cfgok		;80 track drive, all's well
	bitx	5,dsktyp-xdpb	;80 track diskette ?
	cnz	cfger2		;in a 40 track drive, fatal error
;
;	Build the select bit for the physical drive
;
cfgok:	mov	b,e		;E still has the physical drive NO.
	inr	b		;prepare for shift left
	xra	a
	stc
;
sftbit:	ral			;move carry from right to left
	djnz	sftbit		;loop
;
;	Build the drive control byte and output it
;
	mov	b,a		;save select bit
	ldx	a,dsktyp-xdpb
	ani	1001_0000b	;get density and size bits
	ora	b		;combine with select bit
	ori	0010_0000b	; and ROM off
	out	drvctl
	sta	drvcpy		;in memory for write-only port
;
;	Test if the drive motor is on
;
;	lda	motflg
;	ora	a		;non-zero of motor is on
;	cz	motron		;start motor
;
;	A new drive has been selected.  Read the address of the
;	first avaliable sector to get the current track number.
;
;	mvi	a,wait_on	;enable auto-wait
;	out	auto_wait
;	lxi	b,(6 shl 8) + fdc_data	;byte count and port number
;
;	New code to support DMA
;
	lxi	h,0005		;<hl> has DMA count
	lxi	d,id_vec	;<de> has base pointer
	lxi	b,(fdc_data shl 8) + dma_fdc
	call	inidma		;start DMA controller
	mvi	a,rd_adr_opc	;read address
;	out	fdc_cmd		;start controller
;
;rd_adr:	inp	a		;get byte from controller
;	djnz	rd_adr		;loop 6 times
;	call	bsywait		;wait for controller to finish
;
;	New code
;
	call	cmd_fdc
	ani	addr_err	;any errors
	jrz	seldr1
	jr	homdrv		;could not read so restore head and return
;
seldr1:	in	fdc_sec		;get current track number
	out	fdc_trk		;update track register
	xra	a
	ret			;with no errors
;
;
;	Motor start code, test if the drive requires motor control,
;	if so then time the index pulses until the drive motor is up
;	to speed.
;
;motron:	lhld	cfgptr		;test motor on bit
;	bit	7,m
;	jrz	motret		;motor control not required
;
;	Motor control required.  wait a maximum of 20 revolutions
;	for motor to get to speed, error out if no index or motor slow.
;
;	mvi	a,force_irq	;force type I status
;	out	fdccmd
;	mvi	d,20
;
;mtron0:	dcr	d		;outer loop counter
;	cz	idxerr		;timeout, non-fatal error
;	jrc	motron		;user said try again
;	lxi	b,0000
;
;	Wait for index to go true (high), error if timeout
;
;mtron1:	in	fdcstat
;	ani	fdc_index
;	jrnz	mtron2		;index true, start timing
;	dcx	b		;timeout counter
;	mov	a,b
;	ora	c
;	cz	idxerr		;non-fatal error
;	jrc	motron		;user said try again
;
;	Wait for index to go low, and time to next index
;
;	lxi	b,14483		;approx. 210ms
;
;mtron2:	in	fdcstat		;wait for index to go low
;	ani	fdc_index
;	jrnz	mtron2
;
;	in	fdcstat		;get index bit
;	ani	fdc_index
;	jrnz	motret		;exit when motor is at speed
;
;	dcx	b		;timer
;	mov	a,b
;	ora	c
;	jrz	mtron0		;timeout try again
;	jr	mtron2		;continue timing index pulse
;
;motret:	mvi	a,0ffh
;	sta	motflg		;set flag true
;	ret			;return no errors
;
;	Home (restore) the currently selected drive,
;	update the track table to track 0.
;
homdrv:	lhld	cfgptr		;get step-rate
	mov	a,m
	ani	0000_0011b
	ori	hom_opc		;restore command
	call	cmdfdc		;do the restore
	ani	seek_err	;error mask
	rz
	call	homerr		;non-fatal error
	jr	homdrv
;
;	Output the command in the A reg. to the FDC, delay
;	and wait for command completion.  Return FDC status
;	in the A reg.
;
cmdfdc:	out	fdccmd		;start the controller
	sta	fdc_op		;save command
	xthl			;delay 8us
	xthl
;
bsywait:	;wait for FDC busy bit to reset
	in	fdcstat
	bit	0,a		;test busy bit
	jrnz	bsywait
	ret			;with FDC status in A
;
;	Move the drive head to the track requested by
;	'hsttrk'.
;
seek:	lxi	h,hsttrk
	mov	d,m		;save track in <d>
;
;	Test for extended track diskette, subtract and
;	set side bit.
;
	ldx	a,dsktyp-xdpb	;config. info.
	ani	0000_1100b
	jrz	seek1		;single sided diskette
	cpi	0000_1100b
	jrnz	seek3		;not extended, try alternate
	mvi	b,77		;8" tracks per disk
	bitx	4,dsktyp-xdpb
	jrz	seek4
	mvi	b,40		;side bias
	bitx	5,dsktyp-xdpb	;check 80/40 tracks
	jrz	seek4		;40 track
	mvi	b,80
;
seek4:	mov	a,d		;get track
	sub	b		;remove bias
	jrc	seek1		;not on side 1
	mov	d,a		;update
	jr	seek5		;set side-1
;
;	Alternate track diskette, (even side 0, odd side 1)
;	divide track by 2 and set side 1 if required.
;
seek3:	cpi	0000_1000b
	jrnz	seek1		;not alternate
	srlr	d		;divide by 2
	jrnc	seek1		;don't update side bit
;
;	Track is on side 1, set side 1 bit in read/write command
;
seek5:	lda	rw_op
	ori	side_1		;set side 1
	sta	rw_op
;
seek1:	lhld	cfgptr
	mov	a,m		;get step-rate
	ani	0000_0011b
	ori	sek_opc		;combine with seek command
	mov	c,a		;save in C
;
;	Do the seek if 8" or 5.25" 40 track drive
;
	bit	4,m		;8" drive
	jrz	seek2		;no special handling required
	bit	5,m
	jrz	seek2		;40 track mini drive
;
;	80 track drive handler
;
;	Test for 40 track diskette in a 80 track drive
;
	lxi	h,hsttrk
	bitx	5,dsktyp-xdpb
	jrnz	seek2		;80 track diskette
;
;	40 track diskette in a 80 track drive, double 'hsttrk'
;
	mov	a,d
;	push	psw		;save track for verify
	add	a		;times 2
	out	fdc_data
	mov	a,c		;get seek opcode
	ani	1111_1011b	;remove verify bit
	call	cmdfdc		;do the seek
;	pop	psw
	mov	a,d		;get track for R/W verify
	out	fdc_trk
	sta	ctrack
	jr	xltsec		;do the sector
;
;	All is setup, now move the head
;
seek2:	in	fdc_trk		;get track number
;	mov	b,a
;	lda	hsttrk		;get the track number
	cmp	d		;see if tracks are the same
	jrz	xltsec
	mov	a,d		;get new track
	out	fdc_data
	sta	ctrack		;save for back-track
	mov	a,c		;get command
	call	cmdfdc
	ani	seek_err
	cnz	sekerr		;non-fatal error
	jrc	seek		;retry
;
;	Translate the sector in 'hstsec', output it to the FDC
;	and set the side bit as appropriate.
;
xltsec:	pushix
	pop	h		;get base of xlt table
	lxi	d,xlttbl-xdpb	;offset from start
	dad	d		;HL now point to xlttbl
	lda	hstsec		;get sector number
	add	l		;add sector to pointer
	mov	l,a
	jrnc	xsect1
	inr	h
;
;	get translated sector and test for side select.
;
xsect1:	mov	a,m		;get new sector
	ora	a		;test for side 1
	jp	xsect2		;side 0, if positive
	push	psw		;save sector number
	lda	rw_op
	ori	side_1
	sta	rw_op
	pop	psw		;restore sector number
;
xsect2:	ani	0111_1111b	;kill side bit
	out	fdc_sec
	sta	csector		;save for back-trace
	xra	a
	ret			;all done with track and sector
;
;
;	Read or write the sector to the diskette
;
fd_rw:	ldx	d,secmsk-xdpb	;get sector size
	inr	d
	lxi	h,hstbuf	;source/destination address
;
;	Test DMA status port to see if DMA controller
;	is present.
;
;	mvi	a,0bfh		;read DMA status byte command
;	out	dma
;	in	dma
;	cpi	0ffh		;should not be 0ffh if DMA is present
;	jrz	fdc_rw
;
fd_dma:	push	h		;save source/dest. base address
	mov	l,d
	mvi	h,00		;build transfer count
	rept 7
	dad	h
	endm
	dcx	h		;-1, current transfer count
	pop	d		;DE= source/dest. base address
	mvi	b,fdc_data	;source/dest. port
	mvi	c,dma_fdc	;DMA ready, mux address
	call	inidma		;setup DMA command and start controller
;
;	Get read or write error mask
;
	lda	rw_op		;test for read or write
	cpi	0a0h
	mvi	e,writ_err	;write error mask
	jrnc	dma_rw		;write command
	mvi	e,read_err	;read error mask
;
dma_rw:	call	cmdfdc		;start FDC, and return with status
	jr	fdcrw1		;FDC finshed, test for errors
;
;	Programmed I/O read or write from/to the FDC
;
;fdc_rw:	mvi	a,wait_on
;	out	auto_wait	;start auto wait hardware
;	mvi	c,fdc_data	;i/o port number
;	lda	rw_op		;test for read or write
;	cpi	0a0h
;	mvi	e,writ_err	;write error mask
;	out	fdc_cmd		;start the FDC
;	jrnc	fdc_wr		;write command
;	mvi	e,read_err	;read error mask
;
;	Read command
;
;fdc_rd:	mvi	b,128		;inner loop counter
;
;fdcrd1:	ini			;read byte
;	djnz	fdcrd1		;read loop
;	dcr	d		;outer loop counter
;	jrnz	fdc_rd
;	jr	fdcrw1		;finish read sector
;
;	Write command
;
;fdc_wr:	mvi	b,128		;B*D = sector length
;
;fdcwr1:	outi			;write byte
;	djnz	fdcwr1		;write loop
;	dcr	d		;outer loop counter
;	jrnz	fdc_wr
;
fdcrw1:	call	bsy_wait	;wait for FDC complete
	ana	e		;check for errors
	sta	erflag
	rz
	bit	4,a		;check for R.N.F. error
	jrz	fdcrw2
	call	homdrv		;try a restore and seek
	call	seek
;
fdcrw2:	lda	errcnt		;retry counter
	dcr	a
	rz
	sta	errcnt
	jr	fd_rw
;
;	Initialize DMA command variables, output DMA command
;	block, and start DMA controller.
;
inidma:	shld	dma_cnt		;update DMA data block xfer count
	xchg
	shld	dma_bas		;update DMA data block address
;
;	Set DMA ready mux from C
;
	in	sys_ctl
	ani	1111_1000b	;remove old mux address
	ora	c		;add new address
	out	sys_ctl
	mov	a,b
	sta	dmaport		;update DMA data block port
;
;	Send DMA command block to the controller
;
	lxi	b,(dma_len shl 8) + dma	;count and output port
	lxi	h,dma_blk
	outir
	ret
;
;	End of floppy disk I/O module
;
