;
;********************************************************
;*							*
;*	M-labs C1-Board Floppy Disk Boot module		*
;*	Version 1.0   26 dec 83				*
;*	Copyright (C) 1983, V. Nadvornik		*
;*							*
;********************************************************
;
;	Warm boot code, read track 0, sectors 1 through 18 (256 byte
;	sector size) and track 1, sectors 1 through 5.
;	Setup the page 0 vectors and jump to the CCP entry point.
;
wboot:	lxi	sp,savesp	;put the stack somewhere safe
	lxi	h,cfgtbl
	shld	cfgptr
;	xra	a
;	mov	c,a
;	call	seldsk		;select the drive
;
;	Drive selected, check for system type diskette,
;	print boot error if not system.
;
;	xchg				;get xdpb pointer
;	lxi	d,(dsktyp+1)-xdpb	;offset the diskette type byte
;	dad	d
;	mov	a,m
;	ora	a		;test sign bit
;	cp	boot_err	;error if not system diskette
;
	mvi	a,high(dma_vec)	;high byte of DMA interrupt vector
	stai			;into vector register
	in	sasi_stat	;get boot jumper switches
	rlc
	rlc
	rlc			;position switches
	ani	0000_0011b
;
;	jz	sasi_boot	;boot from the hard disk
;
	mvi	b,0010_0001b	;8" select bits
	dcr	a
	jrz	rd_sys
	mvi	b,0011_0001b	;5.25" select bits
;
;	Read the system off of tracks 0 and 1
;
rd_sys:	in	sys_ctl		;set DMA mux
	ani	1111_1000b
	ori	dma_fdc
	out	sys_ctl
	mov	a,b		;get select bits
	out	drv_ctl		;start up drive
	call	hom_drv		;home the drive
;
;	call	motron		;test motor speed
	mvi	e,tries		;retry count
	lxi	h,dma_rd0	;first dma block of load
	call	rd_trk		;read track 0
;
	mvi	a,0101_1111b	;step in command
	call	cmd_fdc
;
	mvi	e,tries		;error counter
	lxi	h,dma_rd1
	call	rd_trk		;read track 1
	jmp	go_cpm		;finish boot, and restart
;
;	Read the required sectors on the current track
;
rd_trk:	push	d		;save reg.s
	push	h
	mvi	a,01
	out	fdc_sec		;and sector #1
	call	wbt_dma
	mvi	a,1001_1100b	;read multi. sectors
	call	cmd_fdc		;start FDC reading
	ani	read_err	;error test
	pop	h
	pop	d		;restore original condition
	rz
	dcr	e
	jnz	rd_trk		;retry
	push	b
	push	d
	push	h
	call	ilprn
	db	'Having trouble reading system',cr,lf,0
	pop	h
	pop	d
	pop	b
	mvi	e,tries
	jmp	rd_trk
;
;	Motor start code, test if the drive requires motor control,
;	if so then time the index pulses until the drive motor is up
;	to speed.
;
;	Motor control required.  wait a maximum of 20 revolutions
;	for motor to get to speed, error out if no index or motor slow.
;
;motron:	mvi	d,21		;loop counter
;
;mtron:		dcr	d
;		jrz	mot_err
;		lxi	b,0000
;
;	Wait for index to go true (high)
;
;mtron1:	in	fdcstat
;		ani	fdc_index
;		jrnz	mtron1a		;index true, start timing
;		dcx	b
;		mov	a,b
;		ora	c
;		jrz	mot_err
;		jr	mtron1
;
;	Wait for index to go low, and time to next index
;
;mtron1a:	lxi	b,14483		;approx. 210ms
;
;mtron2:	in	fdcstat		;wait for index to go low
;		ani	fdc_index
;		jrnz	mtron2
;
;		in	fdcstat		;get index bit
;		ani	fdc_index
;		rnz			;exit when motor is at speed
;		dcx	b		;timer
;		mov	a,b
;		ora	c
;		jrz	mtron		;timeout try again
;		jr	mtron2		;continue timing index pulse
;
;mot_err:	lxi	h,mot_msg
;		call	prnmsg
;		call	ci
;		jmp	motron
;
;	DMA interrupt service routine
;
dma_isr:	;abort the FDC, and reset the DMA
	push	psw
	mvi	a,force_irq	;terminate FDC read command
	out	fdc_cmd
	mvi	a,0c3h
	out	dma		;reset dma controller
	pop	psw
	reti
;
;	Initialize and start the DMA chip
;
wbt_dma:	;send string to DMA, and enable interrupts
	lxi	b,(wbt_len shl 8) + dma	;length and port
	outir
	ei			;start interrupts
	ret			;DMA setup
;
dma_rd0	db	1100_0011b	;reset DMA
	db	0111_1101b	;port address and block count follow
	dw	fdc_data	;port address
	dw	(256*18)-1	;block count for track 0
	db	0011_1100b	;port a is fixed
	db	0001_0000b	;port b is memory, incrementing
	db	1101_1101b	;port B address follows
	dw	ccp-256		;base of system load
	db	0001_0010b	;interrupt at EOB, vector follows
	db	low(dma_vec)	;low byte of vector
	db	1000_0010b	;read active low, end of block
	db	0cfh		;load registers
	db	05h		;transfer A -> B
	db	0cfh		;reload registers
	db	8bh		;reinit. status register byte
	db	0abh		;enable interrupts
	db	87h		;arm the DMA
;
wbt_len	equ	$-dma_rd0	;length of DMA string
;
dma_rd1	db	1100_0011b	;reset DMA
	db	0111_1101b	;port address and block count follow
	dw	fdc_data	;port address
	dw	(256*5)-1	;block count for track 1
	db	0011_1100b	;port a is fixed
	db	0001_0000b	;port b is memory, incrementing
	db	1101_1101b	;port B address follows
	dw	(ccp-256)+(256*18)	;base of system load
	db	0001_0010b	;interrupt at EOB, vector follows
	db	low(dma_vec)	;low byte of vector
	db	1000_0010b	;read active low, end of block
	db	0cfh		;load registers
	db	05h		;transfer A -> B
	db	0cfh		;reload registers
	db	8bh
	db	0abh		;enable interrupts
	db	87h		;arm the DMA
;
;	Initialize page zero vectors
;
go_cpm:	mvi	a,(jmp)		;setup bdos and boot vectors
	sta	bootv
	sta	bdosv
	lxi	h,wmboot
	shld	bootv+1
	lxi	h,bdos
	shld	bdosv+1
	xra	a
	sta	hstact		;make host inactive
	sta	cdrive		;invalidate drive number
	lda	cdisk		;get currently selected disk
	mov	c,a
	jmp	ccp		;off to system
;
;	End of floppy disk boot module
;
