	title	'C1-board Cbios, standard version.  26 dec 83'
;
;	Copyright (C) 1983 V. Nadvornik
;
maclib	z80
$*Macro
;
false	equ	0000h
true	equ	not false
;
vers	equ	22		;cp/m version number
rev	equ	10		;cbios version
release	equ	'D'
;
msize	equ	64		;cp/m memory size in kilobytes
;
extra	equ	msize*1024-0c00h	;allocate extra space for large bios
bios	equ	extra-600h	;base of bios
bdos	equ	bios-0e00h+6	;base of bdos
ccp	equ	bdos-806h	;base of ccp
savesp	equ	0fffeh		;bdos SP save and top of bios stack
;
bootv	equ	0000h		;warm boot entry vector
iobyte	equ	0003h		;address of i/o control byte
cdisk	equ	0004h		;address of bdos current disk
bdosv	equ	0005h		;BDOS entry vector
;
drives	equ	4		;number of drives supported
;
cr	equ	0dh		;ascii carriage return
lf	equ	0ah		;ascii line feed
bell	equ	07		;ascii bell character
ctrlc	equ	03		;control c
;
tries	equ	15		;# disk error retries
;
;	Bdos constants on entry to write
;
wrall	equ	0		;write to allocated
wrdir	equ	1		;write to directory
wrual	equ	2		;write to unallocated
;
	include c1equ
;
	org	bios		;origin of this program
;
;	jump vector for individual subroutines
;
	jmp	c1init		;cold start
wmboot:	jmp	wboot		;warm start
	jmp	cstat		;console status
	jmp	conin		;console character in
	jmp	conout		;console character out
	jmp	list		;list character out
	jmp	punch		;punch character out
	jmp	reader		;reader character out
	jmp	home		;move head to home position
	jmp	seldsk		;select disk
	jmp	settrk		;set track number
	jmp	setsec		;set sector number
	jmp	setdma		;set dma address
	jmp	read		;read disk
	jmp	write		;write disk
	jmp	lstat		;return list status
	jmp	sectran		;sector translate
;
;	Spare jump table entries
;
	db	0,0,0
	db	0,0,0
	db	0,0,0
;
;	DMA interrupt vector
;
dma_vec	dw	dma_isr		;warm boot DMA interrupt service routine
;
	include c1sboot
;
	include c1scio
;
seldsk:		;select the disk given in reg. C
	lxi	h,0000h		;error return value
	mov	a,c
	cpi	drives		;number of floppy drives in system
	jnc	selerr		;return error if not within range
	sta	sekdsk		;save new select number
	mov	l,a		;setup to return .dph
	rept 4			;multiply by 16
	dad	h
	endm
	lxi	d,dpbase	;base of parameter blocks
	dad	d		;HL=.dpb(curdisk)
	push	h		;save .dph
	lxi	d,0010		;offset in dph to .dpb
	dad	d
	mov	e,m		;get dpb address
	inx	h
	mov	d,m
	sded	sekdpb		;save .dpb for physical r/w
	pop	h		;restore .dph
	ret			;return HL=.dph, DE=.dpb
;
;
home:		;restore (home) the currently selected drive
	lxi	b,0000		;seek to track zero (0)
				;fall through to set track routine
;
;
settrk:		;set track given by regs. BC
	sbcd	sektrk
	ret
;
;
setsec:		;set sector given by reg. C
	mov	a,c
	sta	seksec
	ret
;
;
setdma:		;set current dma address given by regs. BC
	sbcd	dmaadr
	ret
;
;
sectran:	;sector translation is done by the physical r/w
		;routine, return logical sector in HL
	mov	h,b
	mov	l,c
	ret
;
;
;********************************************************
;*							*
;*	Sector Deblocking Algorithms for CP/M 2.2	*
;*	Originally written by DRI.			*
;*	Modified by:  V. Nadvornik			*
;*							*
;*							*
;*	The READ entry point takes the place of		*
;*	the previous BIOS defintion for READ.		*
;*							*
;********************************************************
;
read:		;read the selected 128 byte CP/M sector
	sspd	savesp		;save bdos stack
	lxi	sp,savesp	;get local stack area
	pushix			;save user IX register
	lixd	sekdpb		;get pointer to .dpb
	xra	a		;zero A
	sta	unacnt		;unallocated count = 00
	inr	a		;make A a one
	sta	readop		;set read operation
	sta	rsflag		;set must read flag
	inr	a		;make A = wrual
	sta	wrtype		;treat read as unallocated operation
	jr	rwoper		;goto common code to finish read
;
;
;********************************************************
;*							*
;*	The WRITE entry point takes the place of	*
;*	the previous BIOS definition for WRITE.		*
;*							*
;********************************************************
;
write:		;write the selected 128 byte CP/M sector
	sspd	savesp		;save bdos stack
	lxi	sp,savesp	;set stack to bios local stack
	pushix			;save user IX register
	lixd	sekdpb		;get pointer to .dpb
	xra	a		;zero A
	sta	readop		;set not a read operation
	mov	a,c		;write type passed in C
	sta	wrtype
	cpi	wrual		;a write to unallocated?
	jrnz	chkuna		;no, check for unallocated remaining
;
;	write to unallocated, setup parameters
;
	ldx	a,blkmsk-xdpb	;get unallocated record count
	inr	a
	sta	unacnt
	lxi	d,unadsk	;destination
	call	movsek		;mov sek--- to una---
;
chkuna:		;check for write to unallocated sector
	lda	unacnt		;any unallocated sectors remaining?
	ora	a
	jrz	alloc		;skip if not
;
;	more unallocated records remain
;
	dcr	a		;now one less
	sta	unacnt
	lxi	h,unadsk
	call	cmptrk		;compare disks and tracks
	jrnz	alloc		;skip if not
;
;	disks and tracks are the same
;
	lda	seksec		;check sectors
	lxi	h,unasec
	cmp	m		;seksec = unasec
	jrnz	alloc		;skip if not
;
;	disks, tracks and sectors match, inc. una--- to
;	next sector (and track) for future reference
;
	inr	m		;unasec = unasec+1
	mov	a,m		;test for track overflow
	cmpx	00		;check for end of track
	jrc	noovf		;skip if no overflow
;
;	overflow to next track, zero sector and bump track number
;
	mvi	m,00		;unasec = 0
	lhld	unatrk
	inx	h
	shld	unatrk		;unatrk = unatrk+1
;
noovf:		;match found, mark as unnecessary read
	xra	a		;zero A
	sta	rsflag		;not necessary to read
	jr	rwoper		;common read/write code
;
alloc:		;not an unallocated sector, requires pre-read
	xra	a		;zero A
	sta	unacnt		;unacnt = 0
	inr	a
	sta	rsflag		;force pre-read
;
;********************************************************
;*							*
;*	Common code for READ and WRITE follows		*
;*							*
;********************************************************
;
rwoper:		;enter here to perform the read/write
	xra	a		;zero A
	sta	erflag		;no errors (yet)
	cmpx	secshf-xdpb	;check for single density disk
	lda	seksec		;prepare to compute host sector no.
	jrz	singrw		;bypass sector shifts
	ldx	b,secshf-xdpb	;get sector shift count
;
physhf:	srlr	a		;shift right (divide) to get physical sector
	djnz	physhf		;loop
;
singrw:	sta	sekhst		;host sector number
;
;	active host sector?
;
	lxi	h,hstact	;host sctive flag
	mov	a,m
	mvi	m,01		;always becomes active
	ora	a		;was it already active?
	jrz	filhst		;pre-read host buffer if not
;
;	host buffer active, same as seek buffer
;
	lxi	h,hstdsk
	call	cmptrk		;compare disks and tracks
	jrnz	nomatch
;
;	same disk, same track, same sector?
;
	lda	sekhst
	lxi	h,hstsec	;sekhst = hstsec?
	cmp	m
	jrz	match		;skip if match
;
nomatch:	;proper disk and track, but not correct sector
	lda	hstwrt		;host written (buffer flushed)?
	ora	a
	cnz	writehst	;empty host buffer if dirty
	lda	erflag		;test for any errors
	ora	a
	jrnz	rwret		;abort if error
;
filhst:		;may have to fill the host buffer
	lxi	d,hstdsk	;destination
	call	movsek		;move sek--- to hst---
	lhld	sekdpb
	shld	hstdpb		;update parameter pointer
	lda	sekhst
	sta	hstsec		;fixup host sector number
	lda	rsflag		;do we need to pre-read?
	ora	a
	cnz	readhst		;yes, if non-zero
	lda	erflag		;test for error(s)
	ora	a
	jrnz	rwret		;abort if error(s)
;
	xra	a
	sta	hstwrt		;no pending write
;
match:		;copy data to/from host buffer
	lda	seksec		;mask buffer number
	andx	secmsk-xdpb	;get offset into buffer
	mov	l,a		;setup to shift (multiply)
	mvi	h,00
	rept 7			;shift left 7 (times 128)
	dad	h
	endm
;
;	HL has relative host buffer offset
;
	lxi	d,hstbuf
	dad	d		;HL = host address
	lded	dmaadr		;address to get/put CP/M data
	lxi	b,0128		;length of move
	lda	readop		;which way?
	ora	a
	jrnz	rwmove		;skip if read
;
;	write operation, mark and switch pointer direction
;
	mvi	a,01
	sta	hstwrt		;set hstwrt
	xchg			;swap source/destination pointers
;
rwmove:		;BC = 128, DE = destination, HL = source
	ldir			;move cp/m sector
;	
;	data has been moved to/from the host buffer
;
	lda	wrtype
	cpi	wrdir		;flush buffer if directory operation
	lda	erflag		;in case of errors
	jrnz	rwret		;no further processing
;
;	write host buffer for directory write
;
	ora	a		;check for errors
	jrnz	rwret		;abort if errors
	xra	a
	sta	hstwrt		;set buffer flushed
	call	writehst
	lda	erflag
;
rwret:	popix			;restore user IX register
	lspd	savesp		;recover bdos SP
	ret
;
movsek:		;move sek--- to una--- or to hst---
		; DE = destination pointer
	lxi	b,0004		;move 4 bytes
	lxi	h,sekdsk	;source pointer
	ldir			;move them
	ret
;
cmptrk:		;compare sek--- to una--- or to hst---
	lxi	d,sekdsk	;pointer to CP/M data block
	mvi	b,03		;bytes to check
;
cmptk1:	ldax	d
	cmp	m		;compare
	rnz			;return if not equal
	inx	d
	inx	h		;next byte
	djnz	cmptk1
	ret
;
;
;********************************************************
;*							*
;*	WRITEHST performs the physical write to		*
;*	the host disk, READHST reads the physical	*
;*	disk.						*
;*							*
;********************************************************
;
writehst:	;hstdsk = host disk #, hsttrk = host track #,
		;hstsec = host sector #.  Write "hstsiz" bytes
		;from "hstbuf" and return errors in "erflag".
		;
	mvi	a,wr_sec_opc	;write sector op-code
	mvi	b,01		;DMA direction control
	jr	hst_rw		;common code
;
readhst:	;hstdsk = host disk #, hsttrk = host track #,
		;hstsec = host sector #.  Read "hstsiz" bytes
		;into "hstbuf" and return errors in "erflag".
		;
	mvi	a,rd_sec_opc	;read sector op-code
	mvi	b,05		;DMA direction control
;
hst_rw:	sta	rw_op		;save op-code
	mov	a,b		;get direction control byte
	sta	dma_dir		;into data block
	lixd	hst_dpb		;diskette data pointer
	bitx	6,dsktyp-xdpb	;hard or floppy disk
	jz	hdio		;hard disk
	jmp	fdio		;floppy disk
;
	include c1sfdio
;
	include	c1ssasi
;
	include c1serr
;
	include c1sdseg
;
	include	c1sinit
;
endbios	equ	$
;
		END	bios
