	title	'M-LABS, c1-board rom cbios,	05 mar 83'
;
;	Copyright (C) 1983 M-LABS.
;	Written by:  V. Nadvornik
;
	maclib	z80
	maclib	c1dseg
$*Macro
;
false	equ	0000h
true	equ	not false
;
rombios	equ	true		;true for rom bios
cbios	equ	not rombios	;true for standard bios
;
;********************************************************
;*							*
;*	     Bdos constants on entry to write		*
;*							*
;********************************************************
;
wrall	equ	0		;write to allocated
wrdir	equ	1		;write to directory
wrual	equ	2		;write to unallocated
;
;
;********************************************************
;*							*
;*	Sector Deblocking Algorithms for CP/M 2.2	*
;*	Originally written by DRI.			*
;*	Modified by:  V. Nadvornik			*
;*							*
;*							*
;*	The READ entry point takes the place of		*
;*	the previous BIOS defintion for READ.		*
;*							*
;********************************************************
;
read:		;read the selected 128 byte CP/M sector
	lixd	sekdpb		;get pointer to .dpb
	xra	a		;zero A
	sta	unacnt		;unallocated count = 00
	inr	a		;make A a one
	sta	readop		;set read operation
	sta	rsflag		;set must read flag
	inr	a		;make A = wrual
	sta	wrtype		;treat read and unallocated operation
	jr	rwoper		;goto common code to finish read
;
;
;********************************************************
;*							*
;*	The WRITE entry point takes the place of	*
;*	the previous BIOS definition for WRITE.		*
;*							*
;********************************************************
;
write:		;write the selected 128 byte CP/M sector
	lixd	sekdpb		;get pointer to .dpb
	xra	a		;zero A
	sta	readop		;set not a read operation
	mov	a,c		;write type passed in C
	sta	wrtype
	cpi	wrual		;a write to unallocated?
	jrnz	chkuna		;no, check for unallocated remaining
;
;	write to unallocated, setup parameters
;
	ldx	a,3		;get unallocated record count
	inr	a
	sta	unacnt
	lxi	d,unadsk	;destination
	call	movsek		;mov sek--- to una---
;
chkuna:		;check for write to unallocated sector
	lda	unacnt		;any unallocated sectors remaining?
	ora	a
	jrz	alloc		;skip if not
;
;	more unallocated records remain
;
	dcr	a		;now one less
	sta	unacnt
	lxi	h,unadsk
	call	cmptrk		;compare disks and tracks
	jrnz	alloc		;skip if not
;
;	disks and tracks are the same
;
	lda	seksec		;check sectors
	lxi	h,unasec
	cmp	m		;seksec = unasec
	jrnz	alloc		;skip if not
;
;	disks, tracks and sectors match, inc. una--- to
;	next sector (and track) for future reference
;
	inr	m		;unasec = unasec+1
	mov	a,m		;test for track overflow
	cmpx	00		;check for end of track
	jrc	noovf		;skip if no overflow
;
;	overflow to next track, zero sector and bump track number
;
	mvi	m,00		;unasec = 0
	lhld	unatrk
	inx	h
	shld	unatrk		;unatrk = unatrk+1
;
noovf:		;match found, mark as unnecessary read
	xra	a		;zero A
	sta	rsflag		;not necessary to read
	jr	rwoper		;common read/write code
;
alloc:		;not an unallocated sector, requires pre-read
	xra	a		;zero A
	sta	unacnt		;unacnt = 0
	inr	a
	sta	rsflag		;force pre-read
;
;********************************************************
;*							*
;*	Common code for READ and WRITE follows		*
;*							*
;********************************************************
;
rwoper:		;enter here to perform the read/write
	xra	a		;zero A
	sta	erflag		;no errors (yet)
	cmpx	secshf-dpb	;check for single density disk
	lda	seksec		;prepare to compute host sector no.
	jrz	singrw		;bypass sector shifts
	ldx	b,secshf-dpb	;get sector shift count
;
physhf:	srlr	a		;shift right (divide) to get physical sector
	djnz	physhf		;loop
;
singrw:	sta	sekhst		;host sector number
;
;	active host sector?
;
	lxi	h,hstact	;host sctive flag
	mov	a,m
	mvi	m,01		;always becomes active
	ora	a		;was it already active?
	jrz	filhst		;pre-read host buffer if not
;
;	host buffer active, same as seek buffer
;
	lxi	h,hstdsk
	call	cmptrk		;compare disks and tracks
	jrnz	nomatch
;
;	same disk, same track, same sector?
;
	lda	sekhst
	lxi	h,hstsec	;sekhst = hstsec?
	cmp	m
	jrz	match		;skip if match
;
nomatch:	;proper disk and track, but not correct sector
	lda	hstwrt		;host written (buffer flushed)?
	ora	a
	cnz	writehst	;empty host buffer if dirty
;
filhst:		;may have to fill the host buffer
	lxi	d,hstdsk	;destination
	call	movsek		;move sek--- to hst---
	lhld	sekdpb
	shld	hstdpb		;update parameter pointer
	lda	sekhst
	sta	hstsec		;fixup host sector number
	lda	rsflag		;do we need to pre-read?
	ora	a
	cnz	readhst		;yes, if non-zero
	xra	a
	sta	hstwrt		;no pending write
;
match:		;copy data to/from host buffer
	lda	seksec		;mask buffer number
	andx	secmsk-dpb	;get offset into buffer
	mov	l,a		;setup to shift (multiply)
	mvi	h,00
	rept 7			;shift left 7 (times 128)
	dad	h
	endm
;
;	HL has relative host buffer offset
;
	lxi	d,hstbuf
	dad	b		;HL = host address
	lded	dmaadr		;address to get/put CP/M data
	lxi	b,0128		;length of move
	lda	readop		;which way?
	ora	a
	jrnz	rwmove		;skip if read
;
;	write poeration, mark and switch pointer direction
;
	mvi	a,01
	sta	hstwrt		;set hstwrt
	xchg			;swap source/destination pointers
;
rwmove:		;BC = 128, DE = destination, HL = source
	push	h		;save dest ptr
	lxi	h,rwret
	xthl			;put return addr on stack
	push	h		;save dest ptr again
	push	d		;  and source ptr
	lhld	0001h		;get base of CBIOS jump table
	lxi	d,0036h		;add offset to move routine
	dad	d
	pchl			;swap banks and do the move
;
;	data has been moved to/from the host buffer
;
rwret:	lda	wrtype
	cpi	wrdir		;flush buffer if directory operation
	lda	erflag		;in case of errors
	rnz			;no further processing
;
;	write host buffer for directory write
;
	ora	a		;check for errors
	rnz			;abort if errors
	xra	a
	sta	hstwrt		;set buffer flushed
	call	writehst
	lda	erflag
	ret
;
movsek:		;move sek--- to una--- or to hst---
		; DE = destination pointer
	lxi	b,0004		;move 4 bytes
	lxi	h,sekdsk	;source pointer
	ldir			;move them
	ret
;
cmptrk:		;compare sek--- to una--- or to hst---
	lxi	d,sekdsk	;pointer to CP/M data block
	mvi	b,03		;bytes to check
;
cmptk1:	ldax	d
	cmp	m		;compare
	rnz			;return if not equal
	inx	d
	inx	h		;next byte
	djnz	cmptk1
	ret
;
;
;********************************************************
;*							*
;*	WRITEHST performs the physical write to		*
;*	the host disk, READHST reads the physical	*
;*	disk.						*
;*							*
;********************************************************
;
writehst:	;hstdsk = host disk #, hsttrk = host track #,
		;hstsec = host sector #.  Write "hstsiz" bytes
		;from "hstbuf" and return errors in "erflag".
	ret
;
readhst:	;hstdsk = host disk #, hsttrk = host track #,
		;hstsec = host sector #.  Read "hstsiz" bytes
		;into "hstbuf" and return errors in "erflag".
	ret
;
;
$+MACRO
	c1dseg
;
;	include c1dseg
;
;
		end
