;
	title	'CCS disk initialization vers 3.0, 2 nov 81'
	page	58
;
	maclib	z80
;
	org	100h		;run from the tpa
;
vers	equ	30
;
bdosv	equ	5
cr	equ	0dh
lf	equ	0ah
lcmsk	equ	5fh
;
;
dcmd	equ	30h
dstat	equ	dcmd
dtrk	equ	dcmd+1
dsctr	equ	dcmd+2
ddata	equ	dcmd+3
dctrl	equ	dcmd+4
bctrl	equ	04
;
trck	equ	41h
sde	equ	43h		;side indicator location
;
;
next:	lxi	sp,sstack	;set stack to known value
	di			;can not afford any interrupts
	in	bctrl		;see if mini or maxi
	ani	2
	mvi	a,20h		;mini selbits
	jnz	entr		;jump if mini is selected
	mvi	a,30h		;else, set maxi selbits
;
entr:	mov	b,a		;save for a moment
	in	bctrl		;now, get the dden bit
	ani	40h
	ora	b		;add on the mini/maxi bits
	mov	b,a		;save again in b
	in	dctrl		;get the unit bit
	rar			;shift it over
	ani	0fh		;isolate the select bit
	ora	b		;add on the rest of the selbits
	sta	selsv		;save for later restoral
	in	dtrk		;save the track register
	sta	trksv
	lxi	h,hello		;address of sign-on message
	call	prtln		;go print it
;
nxtdrv:	lxi	h,msg1		;ask for drive assignment
	call	prtrd	
	sta	drv		;save for error message
	sui	'1'		;get rid of ascii zone
	jc	nxtdrv		;bad assignment, try again
	cpi	4		;insure a good assignment
	jnc	nxtdrv		;bad, jump
	sta	drive		;save it for later use
;
sid:	lxi	h,msg7		;side message
	call	prtrd
	sui	'0'		;check for valid side # (0 or 1)
	jc	sid
	cpi	2
	jnc	sid
	sta	side		;save for later use
;
den:	lxi	h,msg3		;ask for density
	call	prtrd
	ani	lcmsk		;get rid of lower case
	sui	'D'		;check for valid input (s or d)
	jz	den1
	sui	'S'-'D'
	jnz	den
	inr	a		;flag single density
;
den1:	sta	dens		;save for later use
;
tkno:	lxi	h,msg5		;ask for track number (0-4c) or all (*)
	call	prtln
	call	getnum		;go get the number
	jc	tkno		;bad number, try again
	sta	trkno		;save for later use
	call	pcrlf
;
secsz:	lxi	h,msg4		;ask for sector size
	call	prtrd
	sui	'0'		;see if valid (0-3)
	jc	secsz
	cpi	4
	jnc	secsz
	sta	sctsz		;save for later use
;
typdrv:	lxi	h,msg2		;see if a mini drive
	call	prtrd	
	ani	lcmsk	
	sta	drva		;save for later use
	cpi	'Y'		;see if mini
	jnz	typdra		;jump if not
;
typdr0:	lxi	h,msg9		;yes, ask for number of tracks
	call	prtln
	call	getnum		;get the answer
	jc	typdr0		;bad answer, try again
	sta	maxtrk		;save the answer
	call	pcrlf		;start a new line
	lda	drva		;reget drive type
;
typdra:	lxi	b,200bh		;mini drive commands
	cpi	'Y'	
	lxi	h,s5s
	lxi	d,d5s-s5s
	jz	sord
	dad	d
	dad	d
	lxi	b,700ah
	cpi	'N'
	jnz	typdrv
	mvi	a,77		;set 8" number of tracks
	sta	maxtrk
;
sord:	lda	dens
	dcr	a
	mov	a,b
	jz	sorda
	dad	d
	ori	40h
;
sorda:	sta	drvtyp
	mov	b,a
	push	b
	call	seldrv
	pop	b
	mov	a,c
	sta	rscmd
	call	cmdout
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	xchg
	shld	bufend
	xchg
	mov	e,m
	inx	h
	mov	d,m
	lda	sctsz
	inr	a
;
sordb:	inx	h
	dcr	a
	jnz	sordb
	mov	a,m
	inr	a
	jz	tryagn
	xchg
	mov	m,a
	lxi	d,-11
	dad	d
	lda	maxtrk		;get number of tracks
	mov	m,a		;put into table
	lda	trkno
	inr	a
	jz	trklp
	cmp	m		;insure track sel is in range
	jnc	tryagn		;jump if not
	dcr	a		;see if a seek is needed
	jz	trklp		;jump if not
	out	ddata
	lda	rscmd
	ori	18h
	call	cmdout
	in	dtrk
;
trklp:	sta	track		;initialize track counter
	mvi	a,0d0h		;select side 0
	out	bctrl
	xra	a		;set the current side number
;
trklp1:	sta	cside
	push	h		;save for later use
	inx	h		;point to # of sectors per track
	lxi	d,buffer	;init buffer pointer
	mvi	c,5		;first 5 entries are for leader
	call	mmov		;expand them into track image
	mvi	a,1		;initialize sector counter
;
sctrlp:	sta	sctr		;init or update sector counter
	push	h		;save for sector repeat function
	inx	h		;point to data dtable
	mvi	c,3		;next 3 are the pre header fill
	call	mmov		;put them into the image
	lda	track
	stax	d
	inx	d
	lda	cside
	stax	d
	inx	d
	lda	sctr
	stax	d
	inx	d
	lda	sctsz
	stax	d
	inx	d
	mvi	c,5		;do the pre-data fill
	call	mmov
	lda	sctsz		;initialize the data area
	inr	a		;set up loop control
	push	h		;save (h,l)
	lxi	h,40h
;
sszlp:	dad	h		;double (h,l)
	dcr	a
	jnz	sszlp		;loop til byte count in (h,l)
	mov	b,h
	mov	c,l
	pop	h		;restore (h,l)
;
stsclp:	mov	a,m
	stax	d
	inx	d
	dcx	b
	mov	a,b
	ora	c
	jnz	stsclp
	inx	h
	mvi	c,2		;2 more entries complete the sector
	call	mmov
	lda	sctr		;increment the sector counter
	inr	a
	pop	h		;reget pointer to sectors per track
	cmp	m		;all for this track?
	jnz	sctrlp
	dcx	h		;point to gap 4 fill character
	lda	bufend		;find the end of the track buffer
	sub	e
	mov	c,a		;# of gap 4 fill char in (b,c)
	lda	bufend+1
	sbb	d
	mov	b,a
;
g4fill:	mov	a,m		;get the fill character
	stax	d		;put it in the buffer
	inx	d
	dcx	b
	mov	a,b
	ora	c
	jnz	g4fill		;continue til filled
	call	outrk		;write the track
	pop	h		;reget table pointer
	lda	side		;get single/double side flag
	mov	b,a		;save for a moment
	lda	cside		;get current side indicator
	sub	b
	jz	nxtrk		;jump if done with this side
	mvi	a,90h		;select other side
	out	bctrl
	mvi	a,1		;set indicator
	jmp	trklp1		;go do other side
;
;
nxtrk:	lda	trkno		;see if single track request
	inr	a
	jnz	xnxtdrv		;jump if so
	lda	rscmd		;else, step in one track
	ori	58h
	call	cmdout
	lda	track		;get track counter
	inr	a		;advance track counter
	cmp	m		;see if done with disk
	jnz	trklp		;no, jump
	xra	a
;
xxxx:	sta	trkno
	mvi	a,1
	sta	sctsz
	mvi	a,2
	sta	maxtrk
;
;	sta	sctsz
;	sta	trkno
;	inr	a
;	sta	dens
;
	lda	drva
	jmp	typdra		;go do track 0
;
xnxtdrv:	cpi	2
	jnz	xxxx
	jmp	nxtdrv
;
;
tryagn:	lxi	h,msg8		;bad selection message
	call	prtln
	jmp	den		;get a new selection
;
;
cmdout:	sta	cmndsv		;save the command
	out	dcmd		;output the command
	xthl
	xthl			;delay for a while
;
weoc:	in	dctrl		;get the status
	rar			;see if -intrq is set
	jnc	weoc		;no, jump and try again
	xthl
	xthl
	in	dstat		;get the 1791 chip status
	sta	statsv		;save it
	ani	9ch		;mask out the non-error bits
	rz
	ani	4
	rnz
;
skerr:	lxi	h,seekms	;address of 'seek'
	jmp	prterr		;go print the error
;
;
mmov:	call	movent		;move the current table entry
	dcr	c		;more entries to do?
	jnz	mmov		;yes, jump
	ret
;
;
movent:	mov	b,m		;get the # of bytes
	inx	h		;point to next entry
	mov	a,m		;get the current data value
	inx	h		;point to next value
;
movlp:	stax	d		;put value into track image
	inx	d		;point to next location
	dcr	b		;loop control
	jnz	movlp
	ret
;
;
outrk:	lda	drvtyp		;get control bits
	ori	80h		;add on the auto-wait bit
	mov	b,a
	in	ddata		;clear any junk out
	call	seldrv
	lhld	bufend		;compute the buffer length
	lxi	b,-buffer
	dad	b
	mov	b,h
	mov	c,l		;byte count in (b,c)
	lxi	h,0		;save the stack pointer
	dad	sp
	lxi	sp,buffer	;use the stack as a buffer pointer
	pop	d
	mvi	a,0f4h		;get the write track command
	out	dcmd		;start it going
;
outlp:	mov	a,e		;get next byte
	out	ddata
	dcr	c		;do loop control now
	dcr	c
	mov	a,d		;get next byte
	pop	d		;get next two bytes of data
	out	ddata
	jnz	outlp		;flags were set by last dcr c
	dcr	b		;secondary loop control
	jnz	outlp
	sphl
;
eoj:	in	dctrl		;wait for not busy
	rar
	jnc	eoj		;loop until not busy
;
cmdend:	in	dstat	
	sta	statsv	
	ani	64h	
	rz	
	lxi	h,initms	
;
prterr:	lxi	d,errtyp	
	lxi	b,4	
	ldir
	lxi	h,errmsg	
	call	lnprt	
	jmp	next	
;
;
drvtyp	db	0	
;
;
seldrv:	lda	drive	
	mov	c,a
	inr	c
	xra	a
	stc
;
drvlp:	ral			;rotate select bit into position
	dcr	c
	jnz	drvlp
	ora	b	
	out	dctrl	
	ret	
;
;
pcrlf:	lxi	h,crlf	
;
prtln:	mov	a,m	
	ana	a	
	rz	
	call	pchar	
	inx	h	
	jmp	prtln	
;
;
hex1:	push	psw	
	rar	
	rar	
	rar	
	rar	
	call	hex2	
	pop	psw	
;
hex2:	ani	0fh	
	adi	90h
	daa
	aci	40h
	daa
;
pchar:	push	h	
	push	d	
	push	b	
	mov	e,a	
	mvi	d,0	
	mvi	c,2	
	call	bdosv	
	pop	b	
	pop	d	
	pop	h	
	ret	
;
;
prtrd:	call	prtln	
	call	getchr	
	push	psw	
	call	pcrlf	
	pop	psw	
	cpi	cr
	rnz
;
rtcpm:	lda	selsv		;restore the current unit select
	out	dctrl
	lda	sde		;restore the side selected on entry
	out	bctrl
	lda	trksv
	out	dtrk
	sta	trck
	mvi	c,13	
	call	bdosv	
	ei			;reenable interrupts
	call	0	
	hlt	
;
;
getchr:	mvi	c,1	
	jmp	bdosv	
;
;
getnum:	call	getchr		;get the first character
	cpi	cr		;see if abort wanted
	jz	rtcpm		;jump if so
	cpi	'*'		;see if entire disk wanted
	mov	c,a
	mvi	a,0ffh
	rz
	mov	a,c
	mvi	b,0		;initialize hold area
;
numb:	sui	'0'		;see if valid hex digit
	rc			;bad entry
	cpi	'G'-'0'
	cmc
	rc			;bad value exit
	cpi	'9'-'0'+1
	jc	nxtnum		;jump if good number
	sui	'A'-'9'-1
	cpi	10
	rc			;bad value exit
;
nxtnum:	add	b		;build the value
	mov	b,a
	push	b
	call	getchr
	pop	b
	mov	c,a
	cpi	' '
	mov	a,b
	rz
	rlc			;old value * 16
	rlc
	rlc
	rlc
	mov	b,a		;save it in (b)
	mov	a,c		;restore (a)
	jmp	numb		;go get next character
;
;
prthex:	inx	h	
	mov	a,m	
	inx	h	
	call	hex1	
;
lnprt:	mov	a,m	
	ana	a	
	rz	
	cpi	80h	
	jz	prthex	
	call	pchar	
	inx	h	
	jmp	lnprt	
;
;
hello	db	cr,lf,'CCS disk formatter program, vers-'
	db	vers/10+'0','.',vers mod 10+'0',cr,lf,lf,0
msg1	db	'Which drive (1,2,3,4), or <return> to reboot : ',0
msg2	db	'Is it a mini (yn) : ',0
msg3	db	'Single or Double density (S or D) : ',0
msg4	db	'Sector size (0=128, 1=256, 2=512, 3=1024) : ',0
msg5	db	'Track number (0-4Ch or *) : ',0
msg6	db	'Is the diskette mounted (y/n) : ',0
msg7	db	'Single or Double sided (0 or 1) : ',0
msg8	db	'BAD TRACK or SECTOR SIZE/DENSITY selection',cr,lf,lf,0
msg9	db	'number of tracks (23, 28, or 46) : ',0
;
;
s5s	dw	buffer+3450
	dw	s5+11
	db	18
	db	10
	db	5
	db	0ffh
;
d5s	dw	buffer+6500
	dw	d5+11
	db	0ffh
	db	18
	db	10
	db	5
;
s8s	dw	buffer+5500
	dw	s8+11
	db	26
	db	15
	db	8
	db	0ffh
;
d8s	dw	buffer+10800
	dw	d8+11
	db	0ffh
	db	26
	db	15
	db	8
;
;
s8	db	77		;tracks per side
	db	20,0ffh		;gap 4 data
	db	20,0ffh		;gap 4 data
	db	6,0
	db	1,0fch		;index mark
	db	26,0ffh		;gap 1 data
	db	27		;sectors per track + 1
	db	3,0
	db	3,0
	db	1,0feh		;address mark
	db	1,0f7h		;crc request
	db	5,0ffh		;gap 2 data
	db	6,0ffh
	db	6,0
	db	1,0fbh		;data mark
	db	0e5h		;data fill
	db	1,0f7h		;crc request
	db	27,0ffh		;gap 3 data
;
d8	db	77		;tracks per side
	db	80,4eh		;gap 4 data
	db	12,0		;gap 4 data
	db	3,0f6h
	db	1,0fch		;index mark
	db	50,4eh		;gap 1 data
	db	27		;sectors per track + 1
	db	12,0
	db	3,0f5h
	db	1,0feh		;address mark
	db	1,0f7h		;crc request
	db	22,4eh		;gap 2 data
	db	12,0
	db	3,0f5h
	db	1,0fbh		;data mark
	db	0e5h		;data fill
	db	1,0f7h		;crc request
	db	54,4eh		;start of gap 3 or 4
;
s5	db	35		;tracks per side
	db	3,0ffh		;gap 4 data
	db	3,0ffh		;gap 4 data
	db	4,0ffh		;gap 4 data
	db	3,0ffh		;gap 4 data
	db	3,0ffh		;gap 4 data
	db	19		;sectors per track + 1
	db	3,0
	db	3,0
	db	1,0feh		;address mark
	db	1,0f7h		;crc request
	db	5,0ffh		;gap 2 data
	db	6,0ffh
	db	6,0
	db	1,0fbh		;data mark
	db	0e5h		;data fill
	db	1,0f7h		;crc request
	db	11,0ffh		;start of gap 3 or 4
;
d5	db	35		;tracks per side
	db	6,4eh		;gap 4 data
	db	6,4eh		;gap 4 data
	db	8,4eh		;gap 4 data
	db	6,4eh		;gap 4 data
	db	6,4eh		;gap 4 data
	db	19		;sectors per track + 1
	db	8,0
	db	3,0f5h
	db	1,0feh		;address mark
	db	1,0f7h		;crc request
	db	22,04eh		;gap 2 data
	db	12,0
	db	3,0f5h
	db	1,0fbh		;data mark
	db	0e5h		;data fill
	db	1,0f7h		;crc request
	db	22,4eh		;start of gap 3 or 4
;
;
seekms	db	'Seek'
initms	db	'Init'
errmsg	db	cr,lf
errtyp	db	'     ERROR:  Drive-'
drv	db	0,', side-',80h
side	db	0,', track-',80h
track	db	0,', sector-',80h
sctr	db	0,', command-',80h
cmndsv	db	0,', status-',80h
statsv	db	0,0
rscmd	db	0
bufend	dw	0
drive	db	0
dens	db	0
trkno	db	0
sctsz	db	0
crlf	db	cr,lf,0
drva	ds	1
selsv	ds	1		;entry drive select bits save
trksv	ds	1		;track save area
sidsv	ds	1		;side save area
maxtrk	ds	1		;temp number of tracks hold
cside	ds	1		;current side hold
	ds	20h		;stack area
sstack	ds	0		;start the stack here
;
	org	($+0ffh) and 0ff00h
buffer	ds	10800
;
;
	end
