;
;************************************************
;*						*
;*	M-Labs C1-board, Hardware Equates.	*
;*	Version 1.0   26 dec 83			*
;*	Copyright (C) 1983, V. Nadvornik	*
;*						*
;************************************************
;
;	SASI hard disk interface port addresses
;
sasi_data	equ	00h		;SASI interface data read/write port
sasi_stat	equ	01h		;SASI interface stat read port
sasi_sel	equ	02h		;SASI select line write port
sasi_rst	equ	01h		;SASI reset line write port
;
;	SASI interface commands
;
sasi_read	equ	0000_1000b	;read block command
sasi_writ	equ	0000_1010b	;write block command
;
;	SASI interface status lines
;
;	NOTE:	all SASI status line are inverted with the
;		exception of the request line
;
sasi_io		equ	0000_0001b	;SASI input*/output line
sasi_busy	equ	0000_0010b	;SASI busy**line
sasi_cd		equ	0000_0100b	;SASI command*/data line
sasi_req	equ	0000_1000b	;SASI request**line
sasi_msg	equ	0001_0000b	;SASI message**line
;
;	Boot jumpers
;
jumper_w4	equ	0010_0000b
jumper_w6	equ	0100_0000b
jumper_w5	equ	1000_0000b
;
;	Memory address control RAM base port address
;
memmap		equ	03h
;
;	Auto-wait flip/flop port address
;		Note:  auto-wait hardware removed from c1-board  06 dec 83 V.N.
;
;auto_wait	equ	04h
;
;wait_on	equ	0000_0001b	;enable wait on FDC data register
;wait_off	equ	0000_0000b	;disable wait, also cleared by FDC 
					;interrupt line
;
;	Floppy drive control port address
;
drv_ctl		equ	05h
;
;	Floppy drive control port bit definitions:
;
drv_sd_dd	equ	1000_0000b	;select single/double**density
;
;  Note:  motor-on moved to FDC head load line 06 dec 83 V.N.
;	  replaced with side select line for 1793 compatability
;drv_mot_on	equ	0100_0000b	;set drive motor on bit
;
drv_sid_1	equ	01000_000b	;select side one of diskette
rom_on		equ	1101_1111b	;enable monitor/boot rom
rom_off		equ	not (rom_on)	;disable monitor/boot rom
drv_5_8		equ	0001_0000b	;select 5.25"/8"**drive type
drv_ds3		equ	0000_1000b	;floppy drive select line 4
drv_ds2		equ	0000_0100b	;floppy drive select line 3
drv_ds1		equ	0000_0010b	;floppy drive select line 2
drv_ds0		equ	0000_0001b	;floppy drive select line 1
;
;	Floppy disk controller port addresses
;
fdc_cmd		equ	40h		;command register
fdc_stat	equ	fdc_cmd		;status register
fdc_trk		equ	41h		;track register
fdc_sec		equ	42h		;sector register
fdc_data	equ	43h		;data read/write register
;
;	FDC commands
;
hom_opc		equ	0000_1000b	;restore (home) drive command
sek_opc		equ	0001_1100b	;seek to track command
stp_in_opc	equ	0101_1100b	;step-in one track command
rd_sec_opc	equ	1000_1000b	;read one sector command
wr_sec_opc	equ	1010_1000b	;write one sector command
rd_adr_opc	equ	1100_0000b	;read address command
force_irq	equ	1101_0000b	;abort command
;
;	FDC command special bits
;
side_1		equ	0000_0010b	;select side-one (rd/wr command)
dly_15ms	equ	0000_0100b	;delay head-load test 15 ms
;
;	FDC status bits
;
;	Type I,  head movement commands
;
fdc_rdy		equ	1000_0000b	;drive ready status
fdc_wr_p	equ	0100_0000b	;drive write protected status
fdc_hd_ld	equ	0010_0000b	;head-loaded status bit
fdc_sek_err	equ	0001_0000b	;seek error status bit
fdc_crc_err	equ	0000_1000b	;crc error status bit
fdc_trk0	equ	0000_0100b	;copy of drive track zero line
fdc_index	equ	0000_0010b	;copy of drive index line
fdc_busy	equ	0000_0001b	;FDC busy (command in process) bit
;
;	Type II & III (read/write commands) status bits
;
fdc_wr_flt	equ	fdc_hd_ld	;write fault status bit
fdc_rnf		equ	fdc_sek_err	;record not found status bit
fdc_lost_data	equ	fdc_trk0	;data over/underrun status bit
fdc_drq		equ	fdc_index	;copy of FDC data request line
;
;	FDC error status masks
;
seek_err	equ	1001_1000b	;seek error mask
addr_err	equ	1001_1100b	;read address error mask
read_err	equ	1001_1100b	;read error mask
writ_err	equ	1111_1100b	;write error mask
;
;	Real-time clock port address
;
wall_clk	equ	44h
;
;	Pio base port addresses
;
pio_u85		equ	4ch		;centronics data/control/status
pio_u84		equ	50h		;system control/status
;
;	Pio internal control port address
;
pio_u85_bctl	equ	pio_u85+3
pio_u85_actl	equ	pio_u85+2
pio_u84_bctl	equ	pio_u84+3
pio_u84_actl	equ	pio_u84+2
;
;	Centronics/bi-directional parallel port address
;
cen_data	equ	pio_u85+1	;centronics data output port
cen_cmd		equ	pio_u85+0	;centronics command/status port
cen_stat	equ	cen_cmd
;
;	System parallel control port address
;
sys_ctl		equ	pio_u84+0	;dma select, and clock register port
sys_stat	equ	pio_u84+1
;
;	Centronics command/status bit definitions:
;
cen_ack		equ	1000_0000b	;centronics data acknowledge bit
cen_busy	equ	0100_0000b	;centronics printer busy bit
cen_out		equ	0010_0000b	;centronics paper out bit
cen_sel		equ	0001_0000b	;centronics printer selected bit
cen_flt		equ	0000_1000b	;centronics printer fault bit
cen_rst		equ	0000_0010b	;centronics reset printer command bit
cen_stb		equ	0000_0001b	;centronics data strobe command bit
;
;	System parallel port bit definitions:
;
dma_hdc		equ	0000_0111b	;dma mux. select SASI dma
dma_fdc		equ	0000_0100b	;select FDC dma
dma_sio3	equ	0000_0011b	;select sio3 dma
dma_sio2	equ	0000_0010b	;select sio2 dma
dma_sio1	equ	0000_0001b	;select sio1 dma
dma_sio0	equ	0000_0000b	;select sio0 dma
;
drv_2_sid	equ	1000_0000b	;2-sided line from floppy drives
buf_dir_b	equ	0100_0000b	;parallel port buffer direction select
buf_dir_a	equ	0010_0000b
;
cent_dir	equ	0100_0000b	;direction select for centronics port
;
;	Arithmetic chip base port address
;
apu		equ	58h
;
;	DMA controller base port address
;
dma		equ	5ch
;
;	CTC baud-rate generators and interrupt controller base address
;
ctc_u5		equ	80h		;interrupt and console baud
ctc_u4		equ	84h		;list, pun/rdr, aux baud
;
;	CTC internal counter register offsets
;
cntr_d		equ	03h
cntr_c		equ	02h
cntr_b		equ	01h
cntr_a		equ	00h
;
;  Note:  SASI interrupt moved to system control PIO bit 7
;sasi_irq	equ	ctc_u5+cntr_b	;used as interrupt controller for SASI I/F
fdc_irq		equ	ctc_u5+cntr_c	;used as interrupt controller for FDC
perr_irq	equ	ctc_u5+cntr_d	;used as interrupt controller for PARITY checker
;
baud_u3b	equ	ctc_u4+cntr_c	;baud-rate for PUN/RDR (MODEM) u-3 side B
baud_u3a	equ	ctc_u4+cntr_b	;baud-rate for AUX u-3 side A
baud_u2b	equ	ctc_u4+cntr_a	;baud-rate for serial LIST u-2 side B
baud_u2a	equ	ctc_u5+cntr_a	;baud-rate for CONSOLE u-2 side A
;
;	SIO base port addresses
;
sio_u3		equ	88h		;punch/reader and modem
sio_u2		equ	8ch		;console and serial list
;
;	Serial I/O device assignmemts
;
cons_data	equ	sio_u2+0	;CONSOLE data port
cons_stat	equ	sio_u2+1	;CONSOLE status port
list_data	equ	sio_u2+2	;serial LIST data port
list_stat	equ	sio_u2+3	;serial LIST status port
pun_data	equ	sio_u3+2	;PUNCH data port
pun_stat	equ	sio_u3+3	;PUNCH status port
rdr_data	equ	pun_data	;READER data port
rdr_stat	equ	pun_stat	;READER status port
aux_data	equ	sio_u3+0	;AUX data port
aux_stat	equ	sio_u3+1	;AUX status port
;
wr1		equ	0000_0001b	;SIO write register #1
wr2		equ	0000_0010b	;  register #2
wr3		equ	0000_0011b	;  register #3
wr4		equ	0000_0100b	;  register #4
wr5		equ	0000_0101b	;  register #5
rst_irq		equ	0011_1000b	;reset SIO interrupt command
					;  (same as an reti instr.)
txrdy		equ	0000_0100b	;transmitter buffer reg. empty
rxrdy		equ	0000_0001b	;receiver buffer char. available
;
;	End of C1-board hardware equate module
;
