;	title	Common data segment, c1-board bios.  '15 feb 83'
;
;	Copyright (C) 1983 M-Labs.
;	Written by:  V. Nadvornik
;
;********************************************************
;*							*
;*		Initialized RAM data areas		*
;*							*
;*		Disk parameter headers			*
;*							*
;********************************************************
;
;
dpbase	equ	$		;base of disk parameter headers
;
	if rombios
	ds	16*4		;no initialized data in rom bios
	else
;
dph0	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,dpb
	dw	ckv0,alv0
;
dph1	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,dpb1
	dw	ckv1,alv1
;
dph2	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,dpb2
	dw	ckv2,alv2
;
dph3	dw	0000,0000
	dw	0000,0000
	dw	dirbuf,dpb3
	dw	ckv3,alv3
	endif
;
;********************************************************
;*							*
;*		Uninitialized RAM data areas		*
;*							*
;*		Disk parameter blocks			*
;*							*
;********************************************************
;
xdpb	ds	2		;cp/m sectors per track
	ds	1		;block shift factor
blkmsk	ds	1		;block mask
	ds	1		;extent mask
	ds	2		;blocks per disk-1
	ds	2		;# of directory entries-1
	ds	1		;directory pre-allocation
	ds	1
	ds	2		;dir. checksum vect. size
	ds	2		;system track offset
;
secmsk	ds	1		;sector mask ((hstsiz/128)-1)
secshf	ds	1		;sector shift (log2(hstsiz))
;
dskstpr	ds	1		;drive type and steprate
dsktyp	ds	1		;disk configuration byte
;
xlttbl	ds	26		;physical sector xlt table
;
xdpb1	ds	2		;cp/m sectors per track
	ds	1		;block shift factor
	ds	1		;block mask
	ds	1		;extent mask
	ds	2		;blocks per disk-1
	ds	2		;# of directory entries-1
	ds	1		;directory pre-allocation
	ds	1
	ds	2		;dir. checksum vect. size
	ds	2		;system track offset
;
	ds	1		;sector mask ((hstsiz/128)-1)
	ds	1		;sector shift (log2(hstsiz))
;
	ds	1		;drive type and steprate
	ds	1		;disk configuration byte
;
	ds	26		;physical sector xlt table
;
dpb2	ds	2		;cp/m sectors per track
	ds	1		;block shift factor
	ds	1		;block mask
	ds	1		;extent mask
	ds	2		;blocks per disk-1
	ds	2		;# of directory entries-1
	ds	1		;directory pre-allocation
	ds	1
	ds	2		;dir. checksum vect. size
	ds	2		;system track offset
;
	ds	1		;sector mask ((hstsiz/128)-1)
	ds	1		;sector shift (log2(hstsiz))
;
	ds	1		;drive type and steprate
	ds	1		;disk configuration byte
;
	ds	26		;physical sector xlt table
;
dpb3	ds	2		;cp/m sectors per track
	ds	1		;block shift factor
	ds	1		;block mask
	ds	1		;extent mask
	ds	2		;blocks per disk-1
	ds	2		;# of directory entries-1
	ds	1		;directory pre-allocation
	ds	1
	ds	2		;dir. checksum vect. size
	ds	2		;system track offset
;
	ds	1		;sector mask ((hstsiz/128)-1)
	ds	1		;sector shift (log2(hstsiz))
;
	ds	1		;drive type and steprate
	ds	1		;disk configuration byte
	ds	26		;physical sector xlt table
;
cfgtbl	ds	8		;floppy and hard disk config. table
;
iotbl1	ds	2
iotbl2	ds	2
iotbl3	ds	2
iotbl4	ds	2
iotbl5	ds	2
;
;********************************************************
;*							*
;*	       Uninitialized RAM data areas		*
;*							*
;*		  Deblocking variables			*
;*							*
;********************************************************
;
;	CP/M variables
;
sekdsk	ds	1		;seek disk number
sektrk	ds	2		;seek track number
seksec	ds	1		;seek sector number
sekdpb	ds	2		;seek disk param. block
;
;	Physical variables
;
hstdsk	ds	1		;host disk number
hsttrk	ds	2		;host track number
hstsec	ds	1		;host sector number
hstdpb	ds	2		;host disk param. block
;
;	Deblocking varibles
;
sekhst	ds	1		;seek shr secshf
hstact	ds	1		;host active flag
hstwrt	ds	1		;host written flag
;
unacnt	ds	1		;unalloc. record count
unadsk	ds	1		;last unalloc. disk
unatrk	ds	2		;last unalloc. track
unasec	ds	1		;last unalloc. sector
;
;	FDC register copy
;
cdrive	ds	1		;current drive config. byte
csector	ds	1		;current sector number
ctrack	ds	1		;current track number
;
;	Misc. varibles
;
drvcpy	ds	1		;copy of drive control port
erflag	ds	1		;error reporting
errcnt	ds	1		;error retry counter
fdc_op	ds	1		;FDC opcode byte
motflg	ds	1		;motor-on flag, 0= motor off
readop	ds	1		;one (1) if read operation
rsfla	d			;rea secto flag
rw_op	ds	1		;read/write opcode byte/flag
wrtype	ds	1		;bdos write operation type
;
cfgptr	ds	2		;pointer to config. table
dmaadr	ds	2		;last dma address
;
;
;********************************************************
;*							*
;*    Disk allocation and directory checksum arrays	*
;*							*
;********************************************************
;
alv0	ds	128		;allocation table vector
ckv0	ds	64		;directory checksum vector
alv1	ds	128		;allocation table vector
ckv1	ds	64		;directory checksum vector
alv2	ds	128		;allocation table vector
ckv2	ds	64		;directory checksum vector
alv3	ds	128		;allocation table vector
ckv3	ds	64		;directory checksum vector
;
;********************************************************
;*							*
;*		CP/M directory buffer and		*
;*		Host deblocking sector buffer		*
;*							*
;********************************************************
;
dirbuf	ds	128		;cp/m directory buffer
;
hstbuf	ds	1024		;host buffer
;
	ds	32		;16 levels of stack
biossp	equ	$
savesp	ds	2		;bdos or user stack save
;
endbios	equ	$
;
