	title	'M-LABS, c1-board Cbios,	05 mar 83'
;
;	Copyright (C) 1983 M-LABS.
;	Written by:  V. Nadvornik
;
	maclib	z80
$*Macro
;
false	equ	0000h
true	equ	not false
;
rombios	equ	false		;true for rom bios
cbios	equ	not rombios	;true for standard bios
;
vers	equ	22		;cp/m version number
rev	equ	10		;cbios version
;
msize	equ	64		;cp/m memory size in kilobytes
bias	equ	(msize-20)*1024
ccp	equ	3000h+bias	;base of ccp
bdos	equ	ccp+806h	;base of bdos
bios	equ	ccp+1600h	;base of bios
;
bootv	equ	0000h		;warm boot entry vector
iobyt	equ	0003h		;address of i/o control byte
cdisk	equ	0004h		;address of bdos current disk
bdosv	equ	0005h		;BDOS entry vector
;
drives	equ	5		;number of drives supported
;
cr	equ	0dh		;ascii carriage return
lf	equ	0ah		;ascii line feed
bell	equ	07		;ascii bell character
ctrlc	equ	03		;control c
;
;
tries	equ	10		;# disk error retries
;
;
		org	bios		;origin of this program
;
;	jump vector for individual subroutines
;
	jmp	cboot		;cold start
wmboot:	call	prom		;warm start
	call	prom		;console status
	call	prom		;console character in
	call	prom		;console character out
	call	prom		;list character out
	call	prom		;punch character out
	call	prom		;reader character out
	jmp	home		;move head to home position
	jmp	seldsk		;select disk
	jmp	settrk		;set track number
	jmp	setsec		;set sector number
	jmp	setdma		;set dma address
	call	prom		;read disk
	call	prom		;write disk
	call	prom		;return list status
	jmp	sectran		;sector translate
;
;
seldsk:		;select the disk given in reg. C
	lxi	h,0000h		;error return value
	mov	a,c
	cpi	drives		;number of floppy drives in system
	rnc			;return error if not within range
	sta	sekdsk		;save new select number
	mov	l,a		;setup to .dph
	rept 4			;multiply by 16
	dad	h
	endm
	lxi	d,dpbase	;base of parameter blocks
	dad	d		;HL=.dpb(curdisk)
	push	h		;save .dph
	lxi	d,0010		;offset in dph to .dpb
	dad	d
	mov	e,m		;get dpb address
	inx	h
	mov	d,m
	sded	sekdpb		;save .dpb for physical r/w
	pop	h		;restore .dph
	ret
;
;
home:		;restore (home) the currently selected drive
	lxi	b,0000		;seek to track zero (0)
				;fall through to set track routine
;
;
settrk:		;set track given by regs. BC
	sbcd	sektrk
	ret
;
;
setsec:		;set sector given by reg. C
	mov	a,c
	sta	seksec
	ret
;
;
setdma:		;set current dma address given by regs. BC
	sbcd	dmaadr
	ret
;
;
sectran:	;sector translation is done by the physical r/w
		;routine, return logical sector in HL
	mov	h,b
	mov	l,c
	ret
;
;
prom:		;call routines in prom
	pop	h		;get jump table offset
	sspd	savesp		;save user (bdos) SP
	lxi	sp,biossp	;and use our stack
	pushix			;save user IX register
	lxix	promret
	pushix
	mvi	h,00h		;prom lives in base page (0000h-07ffh)
	pchl			;off to prom
;
promret:	;return here after prom operation
	popix			;restore user IX register
	lspd	savesp		;  and user SP
	ret
;
;
	include	c1dseg.asm
;
;
		end
