	title	'Imac -- i/o module, version 4.0.  27 aug 82'
;
;
	public	init,setup,gnc,pnc,pnb,pchar,pcon,wobuff,perr,errcnt
	public	dhex,eor,setsym,setlib,readlib,pagset,pagej,setinc
	public	rd$inc,lcnt
;
	extrn	dvalue,cnv$dec,accum
	extrn	pbuff,pentry,macsp,qbp,token,value,acclen,sytop
	extrn	acc$ptr,evalue,symax,pass,fpc,aspc,sybas,syadr
	extrn	sypar,deflev,nextc,copytyp,libinp,symlst,maclst
	extrn	macbeg,titloc,qsymlst,liblst,lstflg,relflg,incinp
	extrn	endas,suppress,al$ptr
;
boot		equ	0000h		;reboot location
;
;	(assumes 80h area for stack after data)
;
;	i/o module entry points
;	irp	entryp,<init,setup,gnc,pnc,pnb,pchar,pcon,wobuff,perr,dhex,eor>
;	jmp	entryp
;	endm
;
;
;	data for i/o module
;
pnsize		equ	3		;size of page number (in digits)
pagcnt		ds	pnsize		;ascii page number
defpag		equ	58		;default page size
pagsiz		ds	1		;current page size
lincnt		ds	1		;line count for current page
paszer		ds	1		;true if printing on pass 0
;***************
lcnt		ds	2		;current program line count
;***************
;
;
bpc		ds	2		;base pc for current hex record
dbl		ds	1		;hex buffer length
dbuff		ds	16		;hex buffer
;
;	disk names
;	temps for disk drives, current, asm, prn, sym, hex
;
	irpc	?d,CAPSHL
?d&disk		ds	1		;one char drive name
	endm
;
;	.lib file is read from default buffer
;
libchr		ds	1		;holds 'nextc' during .lib file read operation
lsize		equ	80h		;length of default buffer
lbuff		equ	80h		;address of default buffer for .lib
libbp		ds	2		;buffer pointer for lib file (00-lsize)
;
lptcol		ds	1		;current line printer column
;***************
errcnt		ds	2		;no. of errors detected in assembly
;***************
;
;	common equates
;
;
ptsize		equ	16		;parameter hash table size
pbmax		equ	132		;max print size
srcstrt		equ	32		;start of source line in output
incplus		equ	30		;position of "+" for include file
lcmax		equ	5		;number of line count characters
lcstrt		equ	25		;start of line number
acmax		equ	64		;max accumulator length
;
cr		equ	0dh		;carriage return
lf		equ	0ah		;line feed
tab		equ	09h		;horizontal tab
eof		equ	1ah		;end of file mark
ej		equ	0ch		;page eject (ctl-l)
;
;	dos entry points
;
bdos		equ	5h		;dos entry point
readc		equ	1		;read console device
writc		equ	2		;write console device
redyc		equ	11		;console character ready
wrlist		equ	5		;write to list device
select		equ	14		;select disk specified by register <e>
openf		equ	15		;open file
closf		equ	16		;close file
delef		equ	19		;delete file
readf		equ	20		;read file
writf		equ	21		;write file
makef		equ	22		;make a file
csel		equ	25		;return currently selected disk
setdm		equ	26		;set dma address
;
;	file and buffering parameters
;
inp		equ	0
outp		equ	1		;for the macro expansion type
;
;
fileset	macro	fn,ftype,nbufs,io
;;
;;	fn is letter which denotes file name (s=source, p=print, h=hex)
;;	ftype is file type (3 characters)
;;	nbufs is the number of buffers for the file
;;	io = inp or outp
;;
n&fn&b		equ	nbufs		;number of buffers
;;
fn&size		equ	n&fn&b*128	;buffer size
;
;	file control block
;
fn&cb		ds	9		;file name
		db	'&FTYPE'	;file type
;
fn&cbr		db	0		;extent number
		ds	19		;misc fields and disk map
;
fn&cbcr		db	0		;current record
;
;	index and buffer pointer
;
		if	io = inp
;
fn&bp		dw	fn&size		;to cause immediate read
	else
fn&bp		dw	0		;to fill first byte of buffer
	endif
fn&buffa	ds	2		;address of buff
	endm
;
		fileset I,ASM,8,inp
;
		fileset	S,ASM,8,inp
;
		fileset	P,PRN,8,outp
;
		fileset	H,HEX,8,outp
;
;
fcb		equ	5ch		;file control block address
fcb2		equ	fcb+16		;second default file control block
fnm		equ	1		;position of file name
fln		equ	9		;file name length
fcr		equ	32		;current record position
buff		equ	80h		;input disk buffer address
;
;
setdma:		;set dma address to <de>
		mvi	c,setdm		;setdma function
		jmp	bdos		;return thru bdos
;
;
setdmb:		;set dma to default buffer
		lxi	d,buff
		jmp	setdma		;return thru setdma
;
;
sel:		;select disk in reg-<a>
		lxi	h,cdisk
		cmp	m		;same?
		rz
		mov	m,a		;change current disk
		mov	e,a
		mvi	c,select
		call	bdos
		ret
;
;
;	individual procedures for disk selection
;
	irpc	?d,APSHL
sel&?d:		lda	?d&disk
		jmp	sel
	endm
;
pcon:		;print message at h,l to console device
;--------------
		mov	a,m
		cpi	tab
		jz	pconcr
		call	pchar
;
;	mov	a,m
;
		inx	h
		jmp	pcon
;
;	cpi	cr
;	jnz	pcon
;
pconcr:		mvi	a,cr
		call	pchar
		mvi	a,lf
		call	pchar
		ret
;
;--------------
;
fname:		;fill name from default file control block
		lxi	d,fcb
		mvi	b,fln
;
fnam0:		ldax	d		;get next file character
		cpi	'?'
		jz	fnerr		;file name error
		cpi	'$'		;don't allow $, confuses param scanner
		jz	fnerr
		mov	m,a		;store to file cntrl block
		inx	h
		inx	d
		dcr	b
		jnz	fnam0		;for next character
		ret
;
;
;***************
;	set up FCB to open included file
;
setinc:		lxi	h,icb		;adisk is selected
		mvi	m,0
		lxi	d,acclen
		ldax	d
		cpi	fln
		jc	incnam0		;is the filename too long (>8)?
		mvi	a,8		;if so, truncate to 8 characters
;
incnam0:	mov	b,a		;reg b holds length
		mov	c,a		;reg c is count-down
;
incnam1:	;load characters of filename
		;into file control block
		inx	d
		inx	h
		ldax	d
		mov	m,a
		dcr	c
		jnz	incnam1
;
;	if name short, pad with blanks
;
		mvi	a,fln-1
		sub	b
		mov	c,a
		inr	c		;c reg holds no.of blanks+1
;
incnam2:	inx	h
		dcr	c
		jz	incnam3
		mvi	m,' '
		jmp	incnam2
;
;
incnam3:	; fill the .ASM tag
		irpc	?ex,ASM
		mvi	m,'&?EX'
		inx	h
		endm
		xra	a
		mov	m,a
		sta	icb+fcr
;
;	the FCB is now set up -- so open included file
;
		call	sela	;select .asm disk
		lxi	d,icb
		jmp	open
;
;
;***************
;
;	.lib file handlers, read from .lib if libinp is set
;
setlib:		;set up the file control block at fcb with the name.lib in accum
		lxi	h,fcb
		mvi	m,0		;ldisk is selected each time around
		lxi	d,acclen	;accumulator length (followed by accum)
		ldax	d		;length is in <a>, allow only 8 char names
		cpi	fln		;file name length+1
		jc	libnam0
		mvi	a,8		;truncate to 8 characters if longer
;
libnam0:	mov	b,a
		mov	c,a		;<b> holds length, <c> counts down during copy
;
;	c is length counter, de addresses accum-1, hl addresses fcb fill-1
;
libnam1:	inx	d		;next to get
		inx	h		;next to fill
		ldax	d		;accum char in <a>
		mov	m,a		;to fcb
		dcr	c
		jnz	libnam1
;
;	arrive here with '<b>' characters of name filled (1-8)
;	pad with 8-b blanks
;
		mvi	a,fln-1
		sub	b
		mov	c,a		;number of blank fills to <c>
		inr	c		;+1 since increment occurs at top of loop
;
libnam2:	inx	h		;next to fill is ready
		dcr	c		;count fill chars down
		jz	libnam3
		mvi	m,' '
		jmp	libnam2
;
;
libnam3:	;fill the .lib extent
		irpc	?ex,LIB
		mvi	m,'&?EX'
		inx	h
		endm
		xra	a		;zero in acc
		mov	m,a		;clear the extent number
		sta	fcb+fcr		;clear the current record
;
;	file control block is now set up - open file
;
		call	sell		;select the .lib disk
		lxi	d,fcb
		jmp	open		;return through open to main program
;
;
readlib:
;	enter here to set the input to the previously opened lib
;	file.  all subsequent character input comes from the file
;	until the end of file is encountered
;
		mvi	a,0ffh
		sta	libinp
		lxi	h,lsize		;set to end of buffer to initiate read
		shld	libbp		;note that high byte not used now (may be later)
		lxi	h,nextc		;.next character under scan
		mov	a,m
		sta	libchr		;hold it
		xra	a
		mov	m,a		;cleared to zero
		ret			;ready for subsequent input
;
;
rd$inc:		;reinitialize buffer pointer for include
		lxi	h,isize
		shld	ibp
		ret
;
;
init:		;set up , start assembler
		call	setdmb		;set dma address to default area
		lxi	h,titl
		call	pcon
;
;	set the page parameters
;
		mvi	a,defpag	;default page size
		sta	pagsiz		;set initially, may change
		xra	a
		sta	lincnt		;set to zero lines
;
		lxi	h,0
		shld	titloc		;clear the title to 0000
;
;	compute the buffer addresses
;
		lhld	bdos+1		;address of bdos
		shld	symax		;end of symbol table
		lxi	h,endas		;end of assembler and common areas
;
		irpc	file,ISPH	;repeat for source, print, hex files
		shld	file&buffa	;store buffer address
		lxi	d,file&size	;size of buffer
		dad	d		;for next time around
		endm
;
		inx	h		;next to fill
		shld	sytop
		shld	sybas		;symbol table initialized
		jmp	set0

;
;
prchr:		;print character in <a> if not blank
		cpi	' '
		rz
		push	b		;save counter
		push	h		;save character address
		mov	e,a		;ready the character
		mvi	c,writc		;write to console
		call	bdos
		pop	h		;restore character address
		pop	b		;restore counter
		ret
;
;
prfield:	;print the next field, length in <c>
		inx	h
		mov	a,m
		call	prchr
		dcr	c
		jnz	prfield
		ret
;
;
prfile:		;de is fcb address, hl is message to print related to the file
		;print file name, then message
		push	h		;save message address
		xchg			;fcb address to hl
;
;	print the disk name first
;
		lda	cdisk		;it has been selected
		adi	'A'
		call	prchr
		mvi	a,':'
		call	prchr		;now ready for the file name
		mvi	c,8		;no more than 8 characters
		call	prfield		;name field
		mvi	a,'.'
		call	prchr		;dot between name.typ
		mvi	c,3
		call	prfield
		mvi	a,'-'
		call	prchr
		pop	h		;recall message address
		jmp	pcon		;return through pcon
;
;
open:		;open file addressed by d,e
		mvi	c,openf
		push	d		;save for errors
		call	bdos
		cpi	255
		pop	d		;recall fcb address
		rnz
;
;	open error
;
		lxi	h,errop
		call	prfile
		jmp	boot
;
;
close:		;close file addressed by d,e
		mvi	c,closf
		push	d		;fcb address for error
		call	bdos
		cpi	255
		pop	d		;recall fcb address
		rnz			;close ok
		lxi	h,errcl
		call	pcon
		jmp	boot
;
;
delete:		;delete file addressed by d,e
		mvi	c,delef
		jmp	bdos
;
;
make:		;make file addressed by d,e
		mvi	c,makef
		push	d		;save fcb address
		call	bdos
		cpi	255
		pop	d		;recall fcb address
		rnz
;
;	make error
;
		lxi	h,errma
		call	prfile
		jmp	boot
;
;
npr:		;return zero flag if no print file
		lda	pdisk
		cpi	'Z'-'A'		;bit bucket
		rz
		cpi	'X'-'A'		;console
		rz
		cpi	'Y'-'A'		;printer?
		ret
;
;
lptout:		;write character from register a to printer
		cpi	tab		;tab character?
		jnz	lptchr		;skip if not
;
lptab:		;fill out to next 8 col count
		mvi	a,' '
		call	lptchr		;print blank
		lda	lptcol		;current column
		ani	111b
		jnz	lptab		;for another
		ret
;
;
lptchr:		;send a register char to printer (not tab)
		push	psw
		mov	e,a		;ready for print
		mvi	c,wrlist	;list function
		call	bdos
		pop	psw		;check column changes
		lxi	h,lptcol
		cpi	lf		;end of line
		jnz	lptch0		;skip if not
		mvi	m,0		;clear printer position
		ret
;
;
lptch0:		cpi	' '		;graphic character?
		rc			;skip increment if not graphic
		inr	m		;lptcol=lptcol+1
		ret
;
;
set0:		;set up files for input and output
		xra	a
		sta	lptcol		;line printer column
		sta	libinp		;no lib input now
;***************
		sta	incinp		;no include input
		sta 	lcnt		;initialize line count to 0
		sta	lcnt+1
		sta	errcnt		;initialize error count
		sta	errcnt+1
;***************
		sta	liblst		;no list on .lib files
		sta	qsymlst		;no ?? symbols in dump
		sta	relflg		;no default rel-1 image
		sta	paszer		;no listing on pass zero
		lda	fcb		;get first character
		cpi	' '		;may have forgotten name
		jz	fnerr		;file name error
		mvi	c,csel		;current disk?
		call	bdos		;get it to reg-<a>
;
;	fill the current disk to each disk name (asm,prn,sym,hex,lib)
;
		lxi	h,cdisk
;
		irpc	?d,CAPSHL
		mov	m,a
		inx	h
		endm
;
;	scan parameters
;
		mvi	a,1		;set symlst,maclst to 'on' initially
		sta	symlst
		sta	maclst
		lda	fcb2+1		;must be $ for params
		cpi	'$'
		jnz	nopar
;
;	scan for the $
;
		lxi	h,buff+1
;
scndol:		mov	a,m
		inx	h
		cpi	'$'
		jnz	scndol
;
;	the dollar has been found, scan individual parms
;
scnpar:		mov	a,m		;next in line
		ora	a
		jz	nopar		;parm scan complete
		inx	h
		cpi	' '		;blank fill?
		jz	scnpar		;for another
		lxi	d,adisk		;assigned in order adisk,pdisk,sdisk,hdisk,ldisk
;
		irpc	?d,APSHL
		cpi	'&?D'
		jz	setdsk
		inx	d
		endm
;
;	disk name not found, may be *,+,- or condition
;
		mvi	b,0000$0111b	;in case of *
		cpi	'*'
		jz	setpm
		mvi	b,0000$0011b	;in case '+' found
		cpi	'+'
		jz	setpm		;set parm to 3 if so
		mvi	b,0
		cpi	'-'		;to turn parameter off
		jnz	badpar		;invalid parameter if not
;
setpm:		;set parameter
		lxi	d,symlst	;test 's' first
		mov	a,m		;reads next parameter
		cpi	'S'
		jz	setpmv		;to set value
;
;	not 's', may be 'm'
;
		inx	d		;to maclst
		cpi	'M'
		jz	setpmv		;set to -,+
		lxi	d,liblst	;check for +l,-l
		cpi	'L'
		jz	setpmv
		lxi	d,qsymlst	;?? symbols on/off?
		cpi	'Q'
		jz	setpmv
		lxi	d,relflg	;for generating rel-1 image
		cpi	'R'
		jz	setpmv
		lxi	d,paszer	;for pass zero print
		cpi	'1'
		jnz	badpar
;
setpmv:		;set value of parameter
		mov	a,b		;get parm value 00b or 11b to a-reg
		stax	d		;stored to parm variable (symlst or maclst)
		inx	h		;to next to get
		jmp	scnpar		;for another parameter
;
;
setdsk:		;disk name found, hl addresses next char, de addresses disk number
		mov	a,m		;disk name
		sui	'A'
		cpi	26
		jnc	badpar		;must be in range a-z
		stax	d		;store the disk number to appropriate variable
		inx	h
		jmp	scnpar		;for another disk
;
;
badpar:		;invalid parameter, hl addresses character in error
		inx	h
		mvi	m,cr		;end of message
		lxi	h,parerr	;parameter error message
		call	pcon
		lxi	h,buff+1	;start of parameter
		call	pcon
		jmp	boot
;
;
nopar:		;no more parameters to fill
		lxi	h,scb		;address source file control block
;--------------
		lxi	d,fcb
		lda	fcb+10
		cpi	' '		;check for file type
		mvi	b,12		;move 12 characters
		jz	nopar1
		call	fnam0
		jmp	nopar2
;
;
nopar1:		call	fname		;file name obtained from default fcb
;--------------
;
nopar2:		lxi	h,pcb		;address print file control block
		push	h		;save a copy for open
		call	fname		;fill name field
		pop	h		;restore fcb address
		call	npr		;x p or z?
		jz	nopr		;skip file operations if so
		push	h		;save a copy for delete
		push	h		;save a copy for make
		call	selp
		pop	d		;fcb address
		call	delete
		pop	d		;fcb address
		call	make
;
nopr:		;test for hex file
		lda	hdisk
		cpi	'Z'-'A'
		jz	nohex
		lxi	h,hcb
		push	h
		push	h
		call	fname
		call	selh
		pop	d
		call	delete
		pop	d
		call	make
;
;	files set up, call assembler
;
nohex:		ret			;to complete assembly
;
;
setup:		;setup input file for source program
;
;	clear the page count
;
		lxi	h,pagcnt
;
;	clear to ascii '0'
;
		rept	pnsize
		mvi	m,'0'
		inx	h
		endm
;
		mvi	a,0ffh
		sta	lstflg		;set listing on initially
		lxi	h,0		;set print buff ptr to 0000
		shld	pbp
		lda	pass
		ora	a
		cnz	pagej		;eject page if start of pass > 0
		lxi	h,ssize
		shld	sbp		;cause immediate read
		xra	a		;zero value
		sta	scbr		;clear reel number
		sta	scbcr		;clear current record
		sta	dbl		;clear hex buffer length
		call	sela
		lxi	d,scb
		call	open
		ret
;
;
fnerr:		;file name error
		lxi	h,errfn
		call	pcon
		jmp	boot
;
;
gcomp:		;compare d,e agains h,l
		mov	a,d
		cmp	h
		rnz
		mov	a,e
		cmp	l
		ret
;
;
gnc:		;get next character from source buffer
		push	b
		push	d
		push	h		;environment saved
		lda	libinp
		ora	a
		jz	notlib
;
;	we are reading from a .lib file, get next character
;
		lhld	libbp
		lxi	d,lsize		;at end of buffer?
		call	gcomp
		jnz	gnlib		;non zero if not at end of lib
;
;	read another .lib record
;
		lxi	h,0
		shld	libbp		;to start at beginning of buffer
		call	sell		;select ldisk
		mvi	c,readf
		lxi	d,fcb
		call	bdos		;read record
		ora	a
		jnz	eolib		;end of .lib if non zero
;
;	read another character
;
gnlib:		lhld	libbp
		inx	h
		shld	libbp		;ready for the next read
		dcx	h		;restored
		lxi	d,lbuff
		dad	d		;hl = .next character
		mov	a,m
		cpi	eof		;end of .lib?
		jnz	gnc3		;to return the character
;
eolib:		;end of .lib file
		lda	macsp
		ora	a		;level 0 at end of .lib?
		sta	libinp		;clear lib input flag
		jz	notlib		;to return 00
;
;	error in macro at eof to lib file
;
		call	sell		;for output message
		lxi	d,fcb
		lxi	h,unbal		;unbalanced error
		call	prfile		;error message
		jmp	boot
;
;
;***************
;
notlib:		;not reading from a .lib file
		lda	incinp		;reading from an include file?
		ora	a
		jn	gncin		;i soge nex characte fro
					;the included file
;
;	not reading a .LIB or an included file
;
		lhld	sbp
		lxi	d,ssize
		call	gcomp
		jnz	gnc2
;
;***************
;
;	read another buffer
;
		call	sela
		lxi	h,0
		shld	sbp
		mvi	b,nsb		;number of source buffers
		lhld	sbuffa
;
gnc0:		;read 128 bytes
		push	b		;save count
		push	h		;save buffer address
		xchg			;dma address to de
		call	setdma
		mvi	c,readf
		lxi	d,scb
		call	bdos		;perform the read
		pop	h		;restore buffer address
		lxi	d,128		;buffer address advanced by 128
		dad	d		;to hl
		pop	b		;restore buffer count
		ora	a		;set flags
		jnz	gnc1
;
;	normal read occurred
;
		dcr	b
		jnz	gnc0
		jmp	gncdma
;
;
gnc1:		;eof or error
		cpi	3		;allow 0,1,2
		jnc	frerr		;file read error
		dcr	b		;may be last buffer full
		jz	gncdma		;skip fill if so
		mvi	c,128		;fill 128 eof's
;
gnce:		mvi	m,eof		;store and end of file character
		inx	h
		dcr	c
		jnz	gnce		;fill current buffer with eof's
;
gncdma:		call	setdmb		;restore dma address back to 80
;
gnc2:		;get character to accumulator and return
		lhld	sbuffa
		xchg
		lhld	sbp
		push	h		;save current sbp
		inx	h		;ready for next read
		shld	sbp
		pop	h		;restore previous sbp
		dad	d		;absolute address of character
;
;***************
;
		mov	a,m
;
gnca:		cpi	0dh		;is it a carriage return?
		jnz	gnc3		;if so,increment line counter
		lhld	lcnt		
		inx	h		;increment line counter
		shld	lcnt
;
;***************
;
gnc3:		pop	h
		pop	d
		pop	b
		ani	7fh		;strip off parity
		ret
;
;
;***************
;
gncinc:		lhld	ibp
		lxi	d,isize
		call	gcomp
		jnz	inc2
;
;	read another buffer of included file
;
		call	sela
		lxi	h,0
		shld	ibp
		mvi	b,nib		;b holds no.of include buffers
		lhld	ibuffa
;
;	read 128 bytes (1 buffer)
;
inc0:		push	b		; save the no.of buffers
		push	h		;save buffer address
		xchg
		call	setdma
		mvi	c,readf		;set DOS entry pt.to read
		lxi	d,icb		;load starting addr of filename
		call	bdos
		pop	h		;restore buffer address
		lxi	d,128		;and advance by 128 to hl
		dad	d
		pop	b		;restore buffer count
		ora	a
		jnz	inc1
		dcr	b
		jnz	inc0
		jmp	incdma
;
;
inc1:		;end of file error
		cpi	3		;check return code for read error
		jnc	frerr
		dcr	b		;is buffer full?
		jz	incdma
;
ince:		;fill current buffer with eof's
		mvi	m,eof
		inx	h
		dcr	c
		jnz	ince
;
incdma:		call	setdmb
;
inc2:		;get character to accum. and return
		lhld	ibuffa
		xchg
		lhld	ibp
		push	h
		inx	h
		shld	ibp
		pop	h
		dad	d
		mov	a,m
;
inc3:		;if eof, reset include flag to indicate include process ended
		cpi	1ah
		jnz	gnca
		lxi	h,incinp
		mvi	m,00h
		jmp	gnc+3
;
;***************
;
frerr:		lxi	h,errfr
		call	pcon		;print read error message
		jmp	boot
;
;
pnc:		;same as pncf, but environment is saved first
		push	b
;
;	check for console output / no output
;
		mov	b,a		;save character
		lda	pdisk		;z or x?
		cpi	'Z'-'A'		;z no output
		jz	pnret
;
		cpi	'X'-'A'
		jnz	pngo
		mov	a,b		;recover character for con output
		call	pchar
		jmp	pnret
;
;
;	not x or z, so print it
;
pngo:		push	d
		push	h
		cpi	'Y'-'A'		;to printer?
		mov	a,b		;character to print
		jnz	pngo0
		call	lptout		;output to printer
		jmp	pngo1		;to unstack
;
;
pngo0:		;print to console
		call	pncf
;
pngo1:		pop	h
		pop	d
;
pnret:		pop	b
		ret
;
;
pncf:		;print next character
		lhld	pbp
		xchg
		lhld	pbuffa
		dad	d
		mov	m,a		;character stored at pbp in pbuff
		xchg			;pbp to h,l
		inx	h		;point to next character
		shld	pbp		;replace it
		xchg
		lxi	h,psize
		call	gcomp		;at end of buffer?
		rnz			;return if not
;
;	overflow, write buffer
;
		call	selp
		lxi	h,0
		shld	pbp
		lhld	pbuffa
		lxi	d,pcb		;d,e address file control block
		mvi	b,npb		;number of buffers to <b>
;
;	(drop through to wbuff)
;
wbuff:		;write buffers starting at h,l for <b> buffers
		;check for eof's
		mov	a,m
		cpi	eof
		jz	wbuffdma
;
;	<b> is count, de is fcb addr, hl is buffer addr
;
		push	b		;save number of buffers
		push	d		;save fcb address
		push	h		;save buffer address
		xchg			;buffer address to de for dma
		call	setdma		;dma address set
		pop	h		;recall buffer address
		lxi	d,128		;buffer size
		dad	d		;advanced to next buffer
		pop	d		;recall fcb
		push	d		;save it again for later
		push	h		;save buffer address
;
;	de is fcb address, stacked is buffer address, fcb address, count
;
		mvi	c,writf		;dos write function
		call	bdos
		pop	h		;recover buffer address
		pop	d		;recover fcb address
		pop	b		;recover buffer count
		ora	a		;set error return flags
		jnz	fwerr
;
;	write ok
;
		dcr	b
		jnz	wbuff		;for another buffer
;
wbuffdma:	;set dma address back to default area
		call	setdmb
		ret			;with the data read
;
;
fwerr:		;error in write
		lxi	h,errfw
		call	pcon		;error message out
		jmp	eorc		;to close and reboot
;
;
pnb:		;put next hex byte
		push	b
		push	d
		push	h
		call	pnbf
		pop	h
		pop	d
		pop	b
		ret
;
;
pnbf:		;put next byte
		;(similar to the pncf subroutine)
		lhld	hbp
		xchg
		lhld	hbuffa
		dad	d
		mov	m,a		;character stored at hbp in hbuff
		xchg
		inx	h		;hbp incremented
		shld	hbp
		xchg			;back to d,e
		lxi	h,hsize
		call	gcomp		;equal?
		rnz
;
;	overflow, write buffers
;
		call	selh
		lxi	h,0
		shld	hbp
		lhld	hbuffa
		lxi	d,hcb		;file control block for hex file
		mvi	b,nhb
		jmp	wbuff		;write buffers
;
;
pchar:		;print character in register <a>
		push	b
		push	d
		push	h
		mvi	c,writc
		mov	e,a
		call	bdos
		pop	h
		pop	d
		pop	b
		ret
;
;
ppage:		;print page number
		lxi	h,pagcnt+pnsize-1	;end of page# in ascii
		mvi	c,pnsize
;
ppag0:		mov	a,m		;get next digit
		inr	a		;to next digit
		mov	m,a		;back to memory
		cpi	'9'+1		;past 9?
		jc	ppag1		;carry gen'ed if 0...9
		mvi	m,'0'
		dcx	h		;to previous digit
		dcr	c		;count down
		jnz	ppag0
;
ppag1:		;end of page increment
		lxi	h,pagcnt
		mvi	c,pnsize
;
ppag2:		;print the next digit
		mov	a,m
		call	pnc
		inx	h
		dcr	c
		jnz	ppag2
		ret
;
;
pagej:		;perform page eject and title operation
		lda	pagsiz		;must be > 00
		ora	a
		rz
		mvi	a,ej		;page eject
		call	pnc		;sent to printer
		xra	a
		sta	lincnt		;clear the line counter
;
;	title set, print assembler header
;
		lxi	h,titl
;
pagej0:		mov	a,m
		cpi	cr
		jz	pagej1
		call	pnc
		inx	h
		jmp	pagej0
;
;
pagej1:		;end of title, print page number
;--------------
;	mvi	a,tab
;	call	pnc
;	mvi	a,'#'
;	call	pnc
;--------------
		call	ppage
		mvi	a,tab
		call	pnc
;
;	print title
;
		lhld	titloc		;0000?
		mov	a,l
		ora	h
		jz	pagej3
;	rz			;skip title if not set
;
pagej2:		mov	a,m		;next char of title
		ora	a
		jz	pagej3
		call	pnc
		inx	h		;to next position
		jmp	pagej2
;
;
pagej3:		;end of title
		mvi	a,cr
		call	pnc
		mvi	a,lf
		call	pnc
		mvi	a,lf
		jmp	pnc
;
;
pagset:		;set the line size for the output page from hl
		mov	a,l
		sta	pagsiz
		lxi	h,lincnt	;past pagsiz?
		sub	m
		rnc
		jmp	pagej		;eject page if too long
;
;
wochar:		;write character in reg-<a> with reflect at console if error
		mov	c,a		;save the char
		call	pnc		;print char
		lda	pbuff
		cpi	' '
		rz
		lda	pass
		cpi	2
		rz			;not an error if pass > 1
;
;	error in line
;
		lda	pdisk
		cpi	'X'-'A'
		rz			;already printed if 'x'
;
		mov	a,c		;recover character
		call	pchar		;print it
		ret
;
;
wobuff:		;write the output buffer to the print file
		lda	paszer		;printing on pass 0?
		lxi	h,pass		;or on pass 1
		ora	m		;print if paszer or pass=1
		jnz	chkerr
;
;	pass 0, list only if in lib file and lib list is true
;
		lda	liblst		;true if listing lib file
		lxi	h,libinp	;true if in .lib file
		ana	m
		jnz	lstline		;list line if so
		mov	a,m		;libinp flag is in a reg
		ora	a
		jz	wobez		;to zero the pointers
;
;	in lib file, is there an error in the line
;
		lda	pbuff
		cpi	' '
		jz	wobez		;to zero pointers
;
chkerr:		lxi	h,pbuff		;base of buffer
		mov	a,m		;error flagged?
		cpi	' '
		jnz	lstline		;to list the line
;
;	no error on line, so skip if no list is set
;
		lda	lstflg
		ora	a
		jz	wobez		;to skip line generation
;
;	no error on line, is this a macro?
;
		lda	pbuff+5
		cpi	'+'		;marked with + if so
		jnz	lstline		;list the line if not
;
;	this is a macro line, check maclst flag true
;
		lda	maclst
		ora	a
		jz	wobez		;which zeros the pbp and returns
		cpi	11b		;+m?
		jz	lstline
		lda	pbuff+6		;set?
		cpi	'#'
		jz	wobez
		lda	pbuff+1		;code on line?
		cpi	' '
		jz	wobez
;
;	code gen'ed, normal list (=1) or machine code only (=111b)
;
		lda	maclst
		dcr	a		;1 goes to 0
		jz	lstline		;list entire line if so
;
;	otherwise backscan to first non blank and print it
;
;--------------
;
		lxi	h,qbp
		mvi	m,srcstrt-1
;
;	lxi	d,srcstrt	;start in column 33
;
;macbak:	dcx	d		;pbp=pbp-1
;
;	lxi	h,pbuff
;	dad	d		;hl is char to scan
;	mov	a,m
;	cpi	' '
;	jz	macbak		;to remove another
;	inx	d		;<e> is pbp deblanked from right
;	lxi	h,qbp
;	mov	m,e		;drop thru to print line
;--------------
;
;	otherwise, list the line
;
lstline:
;
;	check for page eject
;
		lxi	h,lincnt
		push	h		;save lincnt address
		mov	a,m		;number of lines printed
		lxi	h,pagsiz	;number allowed in text
		sub	m
		cnc	pagej		;page eject if overflow
		pop	h		;address of lincnt
		inr	m		;to next line
;
;***************
;
		lda	pcb+fln
		cpi	'S'		;listing a sym file?
		jz	inst1		;if so,don't insert line no's 
;
;	convert line count to decimal number
;
		xra	a
		sta	suppress
		sta	al$ptr
		lhld	lcnt
		shld	dvalue
		call	cnv$dec		;call convert routine
;
;	load print buffer with decimal program line number
;
		mvi	c,lcmax
		lxi	h,acc$ptr	;start addr of line number
		lxi	d,pbuff+lcstrt	;start addr of position in 
					;print buffer for line no
;
insert:		mov	a,m		;reg<a>=accum
		stax	d		;pbuff+18=accum
		inx	h		;go to next positions in print
		inx	d		;buffer and accum
		dcr	c
		jnz	insert
; 
;***************
;
;	check if in include and insert indicator as needed
;
inst1:		lda	incinp
		ora	a
		jz	wob11
		lxi	h,pbuff+incplus
		mvi	m,'+'
;
wob11:		lda	qbp
		lxi	h,pbuff
;
wob0:		ora	a		;zero count?
		jz	wobe
;
;	not end, save count and get character
;
		mov	b,a		;save count
		mov	a,m
		call	wochar		;write character
		inx	h		;address next character of buffer
		mov	a,b		;get count
		dcr	a
		jmp	wob0
;
;
wobe:		;end of print - zero qbp
;
;	follow by cr lf
;
		mvi	a,cr
		call	wochar
		mvi	a,lf
		call	wochar
;
wobez:		;zero the character count
		xra	a
		sta	qbp
		lxi	h,pbuff
		mvi	a,pbmax		;ready to blank out
;
wob2:		mvi	m,' '
		inx	h
		dcr	a
		jnz	wob2
		ret
;
;
perr:		;fill pbuff error message position
		mov	b,a		;save error character
		lxi	h,pbuff
		mov	a,m
		cpi	' '
		rnz			;don't change it if already set
		mov	m,b		;store error character in pbuff
;***************
		lhld	errcnt
		inx	h		;increment error count
		shld	errcnt
;***************
		ret
;
;
clospr:		;close the prn or sym file
		call	npr		;not a file on disk?
		rz			;return if p,x, or z
;
clospr0:	;fill the buffer with eof's
		lhld	pbp
		mov	a,l
		ora	h		;value 0000?
		jz	clospr1
		mvi	a,eof
		call	pnc		;put another eof out
		jmp	clospr0
;
;
clospr1:	call	selp		;select the prn,sym disk
		lxi	d,pcb		;prn or sym fcb
		call	close
		ret
;
;
setsym:		;setup the .sym file at end of pass 2
		lda	symlst		;11b if concatenating at end of .prn
		cpi	11b
		jz	pagej		;page eject and return
;
;	otherwise, continue in .sym file
;
		call	clospr		;close out if open
		lxi	h,pcb+fln	;fill with .sym
;
		irpc	?ext,SYM
		mvi	m,'&?EXT'
		inx	h
		endm
;
		xra	a		;clear the extent and cr fields
		mov	m,a
		lxi	h,pcb+fcr
		mov	m,a		;fcb set up for file
;
		lda	sdisk		;.sym disk (may be p,x,z)
		sta	pdisk
		lxi	h,0		;initialize the pbuff pointer
		shld	pbp		;start at next to fill=0000
		call	npr		;is this a disk file?
		jz	pagej		;page eject and return for sym dump
;
		xra	a
		sta	pagsiz		;otherwise act like no eject
;
;	open the .sym file
;
		call	selp		;select the sym disk
		lxi	d,pcb
		push	d		;for the open
		call	delete		;if it is already present
		pop	d
		call	make		;create it
		ret
;
;
eor:		;end of assembler
		call	clospr		;close the .prn/.sym file
;
;	now check the .hex file
;
		lda	hdisk
		cpi	'Z'-'A'
		jz	eorc
;
eor0:		;write terminating record into hex file
		lda	dbl		;may be zero already
		ora	a
		cnz	whex		;write hex buffer if not zero
		lhld	fpc		;get current fpc as last address
		shld	bpc		;record length zero, base address 0000
		call	whex		;write hex buffer
;
;	now clear output buffer for hex file
;
eor1:		lhld	hbp
		mov	a,l
		ora	h
		jz	eorc
		mvi	a,eof
		call	pnb
		jmp	eor1
;
;
;	close files and terminate
;
eorc:
;	call	clospr		;close the prn or sym file
		lda	hdisk
		cpi	'Z'-'A'
		jz	eorhc
		call	selh
		lxi	d,hcb
		call	close
;
eorhc:
;***************
		lda	errcnt
		ora	a
		jnz	notzer
		lda	errcnt+1
		ora 	a		;any errors?
		jz	noerr
;
notzer:		xra	a
		sta	suppress
		sta	al$ptr
		lhld	errcnt
		shld	dvalue
		call	cnv$dec		;convert the error count to decimal
;
		mvi	c,4
		lxi	h,acc$ptr+1	;conversion routine returns with
		lxi	d,pbuff+2	;decimal no. at acc$ptr
;
insrt:		;insert error count into print buffer
		mov	a,m
		stax	d
		inx	h
		inx	d
		dcr	c
		jnz	insrt
;
		lxi	h,pbuff+6
		lxi	d,errmsg
;
insrt1:		;insert error message into print buffer
		ldax	d
		ora	a
		jz	enderr		;encounter zero?
		mov	m,a
		inx	h
		inx	d
		jmp	insrt1
;
;
enderr:		lxi	h,pbuff+2
		call 	pcon
		jmp	endit
;
;
;	no errors occurred in assembly
;
noerr:		lxi	h,noerrm
		call	pcon
;
;***************		
;
endit:		lxi	h,enda
		call	pcon
		jmp	boot
;
;
titl		db	'CP/M Macro assembler v4.0R',tab,'Page #',cr
errop		db	'No source file present',tab
errma		db	'No directory space',tab
errfn		db	'Source FILENAME error',tab
parerr		db	'Invalid parameter:',tab
errfr		db	'Source file READ error',tab
errfw		db	'Output file WRITE error',tab
errcl		db	'Can not CLOSE files',tab
unbal		db	'Unbalanced macro lib.',tab
enda		db	'End of assembly',tab
errmsg		db	' Error(s)',9,0
noerrm		db	'No Errors',tab
;
dhex:		;data to hex buffer (byte in reg-a)
		push	b
		mov	b,a		;hold character for 'z' test
		lda	hdisk
		cpi	'Z'-'A'
		mov	a,b		;recover character
		jz	dhret
		push	d		;environment saved
		push	psw		;save data byte
		lxi	h,dbl		;current length
		mov	a,m		;to accum
		ora	a		;zero?
		jz	dhex3
;
;	length not zero, may be full buffer
;
		cpi	16
		jc	dhex1		;br if less than 16 bytes
;
;	buffer full, dump it
;
		call	whex		;dbl = 0 upon return
		jmp	dhex3		;set bpc and data byte
;
;
dhex1:		;partial buffer in progress, check for sequential byte load
		lhld	fpc
		xchg
		lhld	bpc		;base pc in h,l
		mov	c,a		;current length of buffer
		mvi	b,0		;is in b,c
		dad	b		;bpc+dbl to h,l
		mov	a,e		;ready for compare
		cmp	l		;equal?
		jnz	dhex2		;br if not
		mov	a,d		;check hi byte
		cmp	h
		jz	dhex4		;br if same address
;
dhex2:		;non sequential address, dump and change base address
		call	whex
;
dhex3:		;set new base
		lhld	fpc
		shld	bpc
;
dhex4:		;store data byte and inc dbl
		lxi	h,dbl
		mov	e,m		;length to reg-<e>
		inr	m		;dbl=dbl+1
		mvi	d,0		;high order zero for double add
		lxi	h,dbuff
		dad	d		;dbuff+dbl to h,l
		pop	psw		;restore data byte
		mov	m,a		;into data buffer
		pop	d
;
dhret:		pop	b		;environment restored
		ret
;
;
wrc:		;write character with check sum in <d>
		push	psw
		rrc
		rrc
		rrc
		rrc
		ani	0fh
		call	hexc		;output hex character
		pop	psw		;restore byte
		push	psw		;save a version
		ani	0fh
		call	hexc		;write low nibble
		pop	psw		;restore byte
		add	d		;compute checksum
		mov	d,a		;save cs
		ret
;
;
hexc:		;write character
		adi	90h
		daa
		aci	40h
		daa
		jmp	pnb		;put byte
;
;
whex:		;write current hex buffer
		mvi	a,':'		;record header
		call	pnb		;put byte
		lxi	h,dbl		;record length address
		mov	e,m		;length to reg-<e>
		xra	a		;zero to reg-<a>
		mov	d,a		;clear checksum
		mov	m,a		;length is zeroed for next write
		lhld	bpc		;base address for record
		mov	a,e		;length to <a>
		call	wrc		;write hex value
		mov	a,h		;high order base addr
		call	wrc		;write hi byte
		mov	a,l		;low order base addr
		call	wrc		;write lo byte
		xra	a		;zero to a
		call	wrc		;write record type 00
		mov	a,e		;check for length 0
		ora	a
		jz	whex1
;
;	non - zero, write data bytes
;
		lxi	h,dbuff
;
whex0:		mov	a,m		;get byte
		inx	h
		call	wrc		;write data byte
		dcr	e		;end of buffer?
		jnz	whex0
;
;	end of data bytes, write check sum
;
whex1:		xra	a
		sub	d		;compute checksum
		call	wrc
;
;	send crlf at end of record
;
		mvi	a,cr
		call	pnb
		mvi	a,lf
		call	pnb
		ret
;
;
		end
