	title	'Hard Disk Z-80 Monitor, hd and fd boots. 11 oct 82'
;
	maclib	z80
$*Macro
;
;
true		equ	0ffffh		;true condition
false		equ	not true	;false
;
vers		equ	3		;version number
rev		equ	3		;revision
;
;
	org	08800h
;
rst1		equ	0008h		;software breakpoint
bkbyte		equ	0cfh		;restart 1 instruction
nbkpts		equ	2		;number of breakpoints
;
bksp		equ	08h		;back space char
space		equ	' '
coma		equ	','
crtls		equ	'S'-40h		;control s
cr		equ	0dh
lf		equ	0ah
;
;
sdata		equ	20h		;serial data port base address
sinten		equ	sdata+1		;serial interrupt enable register
sident		equ	sdata+2		;serial interrupt identification register
slctrl		equ	sdata+3		;serial line control register
smdmct		equ	sdata+4		;serial modem control register
slstat		equ	sdata+5		;serial line status register
smdmst		equ	sdata+6		;serial modem status register
;
condata		equ	sdata		;console data port
constat		equ	slstat		;console status port
;
rxrdy		equ	0000$0001b
txrdy		equ	0010$0000b
;
dcntl		equ	34h		;auto boot port
;
;
;	hard disk equates
;
hdstat		equ	50h		;base port
hdcntl		equ	hdstat		;control register
hdcmnd		equ	hdstat+1	;command port
hdrslt		equ	hdstat+1	;command result port
hdfunc		equ	hdstat+2	;function register
hddata		equ	hdstat+3	;controller data port
;
tkzero		equ	01h
opdone		equ	02h		;operation done bit
retry		equ	02h
complt		equ	04h		;seek complete bit
timout		equ	08h		;controller time out bit
wrprot		equ	08h		;write protect bit
drvrdy		equ	20h		;drive ready bit
pstep		equ	04h
nstep		equ	0fbh
dskclk		equ	07h
wrenbl		equ	0fh
null		equ	0fch
isbuff		equ	08h
rdsect		equ	01h
;
;
;	disk controller unique equates
;
dstat		equ	30h		;disk status port
dcmmd		equ	dstat		;disk command port
dtrck		equ	dstat+1		;disk track port
dsctr		equ	dstat+2		;disk sector port
ddata		equ	dstat+3		;disk data port
dflag		equ	dstat+4		;disk flag port
dcntl		equ	dstat+4		;disk control port
;
;
diskno		equ	40h		;active disk number
track		equ	diskno+1
sector		equ	track+1
side		equ	sector+1	;side select hold area
spt		equ	side+1		;sectors per track hold
twosid		equ	spt+1		;single/double sided switch hold
stprat		equ	46h		;step rate save area
status		equ	47h
cmnd		equ	status+1
lunit		equ	49h		;last used drive
cunit		equ	lunit+1		;current drive
rwflg		equ	4bh
hstbuf		equ	4ch		;host buffer address
idsv		equ	4eh		;disk id save area
tbuf		equ	80h
;
;
;	stack frame memory image
;
stkbase		equ	$		;top of register and variable
;
disloc		equ	stkbase-2
bk2byt		equ	disloc-1
bk2adr		equ	bk2byt-2
bk1byt		equ	bk2adr-1
bk1adr		equ	bk1byt-2
;
pcloc		equ	bk1adr-2
hloc		equ	pcloc-1
lloc		equ	hloc-1
hlloc		equ	lloc
skloc		equ	hlloc-2
dloc		equ	skloc-1
eloc		equ	dloc-1
deloc		equ	eloc
bloc		equ	deloc-1
cloc		equ	bloc-1
bcloc		equ	cloc
aloc		equ	bcloc-1
floc		equ	aloc-1
afloc		equ	floc
;
yloc		equ	afloc-2
xloc		equ	yloc-2
rloc		equ	xloc-1
iloc		equ	rloc-1
;
hpcloc		equ	iloc-1
lpcloc		equ	hpcloc-1
dpcloc		equ	lpcloc-1
epcloc		equ	dpcloc-1
bpcloc		equ	epcloc-1
cpcloc		equ	bpcloc-1
apcloc		equ	cpcloc-1
fpcloc		equ	apcloc-1
;
;
;	jump targets for basic input/output
;
zmon:	jmp	init		;cold entry point
;
bkjmp:	jmp	bkpt		;breakpoint entry point
;
;
;	tbl contains the addresses of the action routines
;	the executive uses it to look up the desired address.
;
comtbl		dw	fboot		;a-floppy disk cold boot
		dw	hboot		;b-hard disk cold boot
		dw	qprt		;c-not used
		dw	dump		;d-dump memory
		dw	examn		;e-examine/change memory
		dw	fillm		;f-fill memory with constant
		dw	goto		;g-reload reg's and enter user program
		dw	hmath		;h-hex 'add' and 'sub' routine
		dw	inport		;i-input from port
		dw	qprt		;j-not used
		dw	qprt		;k-not used
		dw	qprt		;l-not used
		dw	move		;m-moves a block of memory
		dw	next		;n-next (trace) command
		dw	otport		;o-output to port
		dw	qprt		;p-not used
		dw	qprt		;q-not used
		dw	xamin		;r-examine/change registers
		dw	search		;s-search for byte string
;
;	note: T through Z removed
;
;	the cold initialization code
;
init:		di			;disable interrupts
		mvi	a,0000$0010b	;set wr prot on hard disk
		out	hdcntl
		lxi	sp,stkbase	;clear var's and regs
		mvi	b,20		;loop count
		lxi	d,0000		;init to zero's
;
init2:		push	d
		djnz	init2		;loop
		dcx	d
		sdcd	disloc
		lxi	sp,fpcloc	;init user stack
		sspd	skloc
;
		call	i8250		;go init uart
;
		lxi	h,signon	;print message
		call	prtmcr		;write it
;
command:	di			;kill interrupts
		lxi	sp,fpcloc	;init stack
		call	crlf
		call	decho		;go get first command
		lxi	h,command	;init sp for return
		push	h
		lxi	h,comtbl	;point to command table
		mvi	b,2		;start with 2 parameters
		sui	'A'		;remove ascii bias
		jrc	qprt		;command error
		cpi	'S'-'A'+1
		jrnc	qprt
		add	a		;times 2
		add	l
		mov	l,a		;<hl> now have indirect pointer
		mov	e,m		;get low byte
		inx	h
		mov	h,m		;now high byte
		mov	l,e		;<hl> now point to routine
		pchl			;goto routine
;
;
;	routine exf reads one parameter.  it expects the first
;	character of the parameter to be in the <a> register
;	on entry.
;
exf:		mvi	b,1		;set up for one parameter
		lxi	h,0
		jr	ex1		;first character in <a> already
;
;
;	routine expr reads parameters from the console
;	and develops a 16 bit hexadecimal for each one.
;	the number of parameters wanted is in the <b> reg
;	on entry.  a carriage return will terminate the
;	entry sequence; a blank or a comma will end the
;	current parameter entry.  each parameter only
;	takes the last 4 digits typed in, any excess is
;	discarded.  a non-hex digit will terminate the
;	entry sequence and cause a warm boot of the monitor.
;
ex3:		jrnz	qprt		;non-zero is error
;
expr1:		dcr	b		;more parameters?
		rz			;no, return
;
expr:		lxi	h,0		;initialize parameter
;
ex0:		call	echo		;get next number
;
ex1:		mov	c,a		;save char for later use
		call	nibble
		jrc	ex2		;not a number, jump
		dad	h		;multiply by 16
		dad	h
		dad	h
		dad	h
		ora	l		;add on new digit
		mov	l,a
		jr	ex0		;go get next digit
;
ex2:		xthl			;put under return address on stack
		push	h		;restore return address
		mov	a,c		;reget the last character
		call	p2c		;test for delimiter
		jrnc	ex3		;jump if not carriage return
		djnz	qprt		;carret with more param means error
		ret
;
;
;	this is the only error routine,except for ccs boot,
;	it prints and beeps the bell, then jumps back
;	to get another command.
;
qprt:		lxi	h,qmsg		;get address of question mark msg
		call	prnmsg
		jr	command		;return to main on error
;
;
;	fill action routine
;
;	this routine fills a block of memory with a user
;	determined constant.  it expects three parameters
;	to be entered in the following order:
;
;	start address
;	finish address
;	fill value
;
;	syntax:
;		fssss,ffff,vv<cr>	fill memory from
;					ssss to ffff with vv
;
fillm:		call	expr3		;get three parameters
;
fi0:		mov	m,c		;put down the fill value
		call	hilo		;increment and check the pointer
		jrnc	fi0		;not done yet, jump
		jr	command		;incase stack was overwritten
;
;
;	display action routine
;
;	this routine displays a block of memory on the
;	current console device (console dump).
;
;	syntax:
;		d<cr>		displays 256 bytes of memory
;				starting at the end of the last dump.
;		dxxxx<cr>	displays 256 bytes of memory
;				starting at address xxxx.
;		dxxxx,yyyy<cr>	displays memory from xxxx to
;				yyyy inclusive.
;
;	the display is organized to display up to 16 bytes
;	per display line, with all columns aligned so
;	each column has the same last hex digit in its address.
;
dump:		call	pchk		;check for delimiter or value
		jrc	disphl		;display memory(<hl>)
		mvi	b,01		;go get value
		lxi	h,0000h
		call	ex1
		jrc	dispblk		;one value display 256 bytes
		mvi	b,01h		;two values
		call	expr		;display range
		pop	d
		pop	h
		jr	dis1		;display given range
;
dispblk:	;display 256 bytes starting
		;at given address
		pop	d		;get it
		jr	disphl1
;
disphl:		;display memory starting at
		;the location pointed to by <hl>
		lded	disloc		;get start address
		inx	d		;point to next byte
;
disphl1:	lxi	h,0ffh		;one page long
		dad	d		;end address
		xchg			;<de>= end, <hl>=start
;
dis1:		sded	disloc		;save ending address
;
dis1a:		call	ladrb		;display the start address
		mov	a,l		;see if on 16 byte boundary
		call	trplsp		;skip over to right column
		push	h		;save <hl>
;
dis2:		mov	a,m		;get the contents
		call	hex1		;output it
		call	hilo		;increment, check pointer
		jrc	dis7		;done if carry set
		call	blk		;make columns
		mov	a,l		;ready for new line?
		ani	0fh
		jrnz	dis2
;
dis3:		pop	h		;reget line start address
		mov	a,l		;skip over to right space
		ani	0fh
		call	trpl2
;
dis4:		mov	a,m		;get memory value
		mov	c,a		;set up for output
		cpi	' '		;see if printable in ascii
		jrc	dis5		;jump if so
		cpi	7fh
		jrc	dis6
;
dis5:		mvi	c,'.'		;else, print a dot
;
dis6:		call	co
		call	hilox		;increment <hl> and see if done
		mov	a,l		;not done, ready for new line?
		ani	0fh
		jrnz	dis4		;jump if not
		jr	dis1a		;do the next line
;
dis7:		xra	a
		call	trplsp
		jr	dis3		;go print the ascii
;
trplsp:		ani	0fh		;isolate the low four bits
		mov	b,a		;prepare to space over to right column
		add	a		;triple the count
		add	b
;
trpl2:		mov	b,a		;put back into b
		inr	b		;adjust counter
;
trpl1:		call	blk		;do the spacing
		djnz	trpl1		;no, do another column
		ret
;
;
;	go to action routine
;
;	goto command transfers control to a specified address.
;	it allows the selective setting of up to two breakpoints
;	as well as allowing any console input to breakpoint
;	the run, as long as interrupt 1 is active.
;
;	syntax:
;		g<cr>		goto address stored in register
;				save area.
;		gxxxx<cr>	goto address specified by xxxx.
;		gxxxx,yyyy,(zzzz)<cr>	goto address specified
;					by xxxx, and set break-
;					points at yyyy & (zzzz).
;
goto:		call	pchk		;see if old address wanted
		jrc	go3		;  yes, jump
		jrz	go0		;  yes, but set some breakpoints
		call	exf		;get new goto address
		pop	d 
		sded	pcloc		;put address in <pc> location 
		mov	a,c 
		cpi	cr		;see if a cr was last entered
		jrz	go3 
;
go0:		mvi	b,nbkpts 
		lxi	h,bk1adr	;point to trap storage
;
go1:		push	b		;save number of breakpoints
		push	h		;save storage pointer
		mvi	b,2		;set up to get a trap address
		call	expr1		;get a trap address
		pop	d		;get the trap address into <de>
		pop	h		;reget the storage address
;
bkgo:		mov	m,e		;save the breakpoint address
		inx	h 
		mov	m,d 
		inx	h 
		ldax	d		;save the instruction from the bp address
		mov	m,a 
		inx	h 
		mvi	a,bkbyte	;insert the breakpoint
		stax	d 
;
go2:		mov	a,c		;reget the delimiter to see
		cpi	cr		;  if we are done setting breakpoints
		pop	b		;  unload the stack first
		jrz	go3		;yes, jump
		djnz	go1		;jump if not at bp limit
;
go3:		call	crlf 
		mvi	a,jmp		;setup restart 1
		sta	rst1
		lxi	h,bkjmp
		shld	rst1+1
		pop	h		;clean up stack
		pop	psw		;restore all registers
		pop	b
		pop	d
		pop	h
		exaf
		exx			;swap register banks
		pop	b
		mov	a,c
		stai			;put back irq reg
		popix
		popiy
		pop	psw
		pop	b
		pop	d
		pop	h		;stack pointer
		sphl
		lhld	pcloc		;get user pc
		push	h		;save on user stack
		lhld	hlloc		;get user hl
		ei			;reenable interrupts
		ret			;enter user code
;
;
;	general purpose input/output routines
;
;	these routines allow byte-by-byte input or output from
;	the current console device.  they are invoked by
;	the monitor "i" or "o" command.
;
;	syntax:
;		ixx	prints the value from port xx
;		oxx,vv	outputs the value vv to port xx
;
inport:		call	expr1		;get input port number
		call	crlf
		pop	d
		mov	a,e
		call	dash1
		mov	c,e
		inp	e		;read value into <e> register
;
bits:		mvi	b,8		;loop control for 8 bits
;
bits1:		mov	a,e		;get next bit
		rlc			;into carry
		mov	e,a		;save rest
		mvi	a,'0'/2		;build ascii 1 or 0
		ral			;carry determines which
		mov	c,a		;now, output it
		call	co
		djnz	bits1
		ret
;
otport:	call	expr		;get the address and data for output
		pop	d		;data value into <e>
		pop	b		;port into <c>
		outp	e		;do the output
		ret
;
;
;	move routine
;
;	this routine expects three parameters, entered in the following order:
;	source first byte address
;	source last byte address
;	destination first byte address
;
;	syntax:
;		mxxxx,yyyy,zzzz	moves a block of memory
;				to zzzz, starting from xxxx
;				to yyyy.
;
move:		call	expr3		;get three parameters
;
mov1:		mov	a,m		;get next byte
		stax	b		;move it
		call	hiloxb		;go increment, check source pointer
		jr	mov1		;not there yet, go do it again
;
;
;	substitute action routine
;
;	this routine allows the user to inspect any memory location
;	and alter the contents, if desired and if the address
;	is in ram.  the contents may be left unaltered
;	by entering a space, comma.  if a carriage return
;	is entered, the routine is terminated.
;	if a space or comma is entered, the routine
;	proceeds to the next location and presents the user
;	with an opportunity to alter it.
;	if a back-space is entered then the previous
;	address is displayed.
;
;	systax:
;		exxxx<cr>	display and/or replace
;				memory.
;
examn:		call	expr1		;go get one parameter
		pop	h		;get the start address
		jr	subs4
;
sub1:		mov	a,m		;get the contents of the address
		call	dash1		;display it on console and a dash
		call	pchk		;get, check character
		rc			;done if carriage return
		jrz	sub2		;no change if blank or,
		cpi	bksp		;see if previous byte wanted
		jrz	sub3		;yes, do it
		push	h		;save memory pointer
		call	exf		;go get rest of new value
		pop	d		;new value to <e> register
		pop	h		;restore memory pointer
		mov	m,e		;put down new value
		mov	a,c		;get the delimiter
		cpi	cr		;see if done (carriage return)
		rz			;yes, return to monitor
;
sub2:		inx	h		;no, increment memory pointer
		inx	h		;allow a fall-through on the next instruction
;
sub3:		dcx	h		;adjust <hl> as appropriate
;
subs4:		call	ladra		;print new location
		call	blk		;print a space between addr and data
		jr	sub1		;go do the next location
;
;
;	examine registers command inspects the values of the
;	the registers stored by the last encountered breakpoint.
;	the values may be modified if desired.
;
;	syntax:
;		l<cr>		displays all z80 registers.
;		l'<cr>		displays the z80 prime registers.
;		lrr		displays the register rr and
;				opens it for modification.
;		l'rr		displays the z80 prime register rr
;				and opens it for modification.
;
xaa:		inx	h 		;skip over to next entry
		inx	h 
;
xa:		mov	a,m		;get table char
		inr	a		;check for end of table
		rz
		dcr	a		;fix char
		ani	7fh		;kill crlf bit
		cmp	c		;char passed in <c>
		jrnz	xaa		;no, go try again
		call	blk 		;yes, prepare to show current value
		call	prtval		;go print the value
		call	dash 		;prompt a new value
		call	pchk 		;get the input
		rc			;done if carriage return
		jrz	xf 		;jump if no change desired
		push	h 		;to be changed, save pointer
		call	exf 		;get the new value
		pop	h 		;  into <hl>
		mov	a,l 		;get the new low byte
		inx	d		;adjust pointer
		stax	d 		;put it down
		xthl			;recover the table pointer
		mov	a,m		;get the attributes
		xthl			;set the stack straight
		rlc			;see if 8 bit register
		jrnc	xe		;jump if so
		inx	d		;register pair, do other 8 bits 
		mov	a,h 
		stax	d 
;
xe:		pop	h		;restore the table pointer 
;
xf:		mov	a,c		;see if it was a cr 
		cpi	cr 
		rz			;done if so
;
xamin:		lxi	h,actbl		;get address of register look-up table
;
xmne1:		call	pchk		;find out what action is wanted
		mov	c,a		;save char in <c>
		jrc	xg		;show all if carriage return 
		jrz	xmne1		;ignore blanks or commas
		cpi	''''		;see if primes wanted
		jrnz	xa		;no, must be single register
		lxi	h,prmtb		;yes, set table address
		jr	xmne1		;  and find out which one
;
xg:		mov	a,m 
		adi	20h		;make lower case to print
		mov	c,a 
		sui	20h
		inr	a		;see if at end of table
		rz			;done if so
		cm	crlf		;start a new line if bit 7 is set
		call	co 
		call	dash		;prompt for a new value 
		call	prtval		;go print the value
		call	blk		;formatter
		inx	h		;point to next entry
		jr	xg		;do the next value
;
prtval:		inx	h		;point to next entry
		mov	a,m		;get offset and attributes byte
		ani	3fh		;isolate the offset
		push	h
		mov	e,a
		mvi	d,0
		lxi	h,stkbase
		ora	a
		dsbc	d
		xchg
		pop	h
		mov	a,m		;now find out attributes
		mvi	b,1		;set up for single reg value
		ani	0c0h		;get attributes
		jrz	one$byte
		cpi	80h
		jrc	tst$flags
		jrz	two$byte
		push	h
		lhld	hlloc
		mov	a,m
		pop	h
		jr	prn$byte
;
tst$flags:	push	b
		push	d
		ldax	d
		mov	e,a
		call	bits
		pop	d
		pop	b
		dcx	d		;adjust <de> so fill reg will work
		ret
;
two$byte:	inr	b
;
one$byte:	ldax	d		;get the register contents
;
prn$byte:	call	hex1		;output the value
		dcx	d		;adjust the memory pointer
		djnz	one$byte
		ret
;
actbl		db	80h+'A',stkbase-aloc
		db	'F',(stkbase-floc) or 40h
		db	'B',stkbase-bloc
		db	'C',stkbase-cloc
		db	'D',stkbase-dloc
		db	'E',stkbase-eloc
		db	'H',stkbase-hloc
		db	'L',stkbase-lloc
		db	'M',0c0h
		db	'S',(stkbase-skloc-1) or 80h
		db	'P',(stkbase-pcloc-1) or 80h
;
;	rest of z-80 register offsets
;
prmtb		db	80h+'A',stkbase-apcloc
		db	'F',(stkbase-fpcloc) or 40h
		db	'B',stkbase-bpcloc
		db	'C',stkbase-cpcloc
		db	'D',stkbase-dpcloc
		db	'E',stkbase-epcloc
		db	'H',stkbase-hpcloc
		db	'L',stkbase-lpcloc
		db	'I',stkbase-iloc
		db	'R',stkbase-rloc
		db	'X',(stkbase-xloc-1) or 80h
		db	'Y',(stkbase-yloc-1) or 80h
;
		db	0ffh		;end if table
;
;
;	single step routine
;
;	this routine examines the instruction pointed
;	to by the <pc> and figures out how many byte
;	to the next instruction, it then sets a break-
;	point at that address and goes to the "go" routine.
;
;	syntax;
;		n		start execution at the
;				current <pc>, and displays
;				the registers after it break-points.
;
fndoff:		inx	d		;point to offset
		ldax	d
		inx	d
		ora	a		;test for negative
		jp	fwdref
		add	e		;neg. offset
		mov	e,a
		jr	exnext
;
fwdref:		add	e	
		mov	e,a
		mvi	a,00		;add 8-bit to 16-bit
		adc	d
		mov	d,a
;
exnext:		push	b		;fix up stack
		lxi	b,010dh		;fake goto
		lxi	h,bk1adr
		jmp	bkgo
;
next:		lded	pcloc		;get user <pc>
		ldax	d		;get current instruction
		cpi	0ddh		;check for index
		jrz	opixiy		;indexed instruction
		cpi	0fdh
		jrz	opixiy
		cpi	0cbh		;check for bit op
		jz	skip2		;yes, so instr is 2 bytes long
		cpi	0edh		;check for specials
		jrz	edopc
		cpi	09
		jrz	skip1
		cpi	0d9h
		jrz	skip1
		cpi	010h		;check for uncond rel branch
		jrz	spljmp
		cpi	018h
		jrz	fndoff
		lxi	b,4		;search rel jump table
		lxi	h,reltbl
		ccir
		push	psw		;save instr
		mov	a,b
		ora	c		;check for not in table
		jrz	op8080		;must be 8080 op-code
		pop	psw
		ani	0001$1000b	;mask all but cond bits
		call	fndcond		;check cond true/false
		jr	skip2		;condition failed so inc by 2
		jr	fndoff		;cond passed, so find offset
;
badopc:		jmp	qprt		;can't figure out op-code
					;so do error exit
;
spljmp:		lda	bloc		;test for djnz instruction
		dcr	a
		jrz	skip2		;test passed so bypass
		jr	fndoff		;onward
;
opixiy:		inx	d		;move past prefix byte
		ldax	d		;get second instr byte
		cpi	0cbh		;all index bit op's are 3 bytes long
		jrz	skip3
		cpi	036h		;special
		jrz	skip3
		cpi	035h
		jrz	skip2
		cpi	034h
		jrz	skip2
		push	psw		;save
		ani	0fh		;check for non8080 opcode
		cpi	006
		jrz	ck4tob		;check high nibble
		cpi	00eh
		jrnz	op8080		;8080 indexed op code
;
ck4tob:		pop	psw		;restore
		push	psw		;resave
		ani	0f0h		;now test upper nibble
		cpi	040h
		jrc	op8080		;not z80
		cpi	0c0h
		jrnc	op8080
		pop	psw
		jr	skip2		;2 byte opcode
;
edopc:		inx	d		;get next byte
		ldax	d
		lxi	b,006		;check for special 'ed' op's
		lxi	h,edtbl
		ccir
		mov	a,b		;test count
		ora	c
		jrz	skip1		;failed
;
skip3:		inx	d		;skip the appropriate # of bytes
;
skip2:		inx	d
;
skip1:		inx	d
		jmp	exnext
;
op8080:		pop	psw		;get byte
		mov	b,a
		lxi	h,byt1tbl
		mvi	c,10		;test for 1-byte instr
		call	stab		;search
		jr	skip1
		lxi	h,byt2tbl
		mvi	c,3		;test for 2-byte instr
		call	stab
		jr	skip2
		lxi	h,byt3tbl	;test for 3-byte instr
		mvi	c,2
		call	stab
		jr	skip3
		lxi	h,xfrtbl
		mvi	c,4
		call	stab		;now check for jmp,call op's
		jr	xfropc
;
special:	mov	a,b		;get new copy of instr
		cpi	1110$1001b	;is it a pchl
		jrz	oppchl
		cpi	1100$1001b	;how about a return
		jrz	opret
		ani	1100$0111b	;now check for cond ret
		cpi	1100$0000b
		jrz	condret
		cpi	1100$0111b
		jnz	badopc
		mov	a,b		;new copy
		ani	0011$1000b
		mov	e,a		;must be rst instr
		mvi	d,00
		jmp	exnext
;
condret:	mov	a,b
		call	fndcond		;figure out flags
		jr	skip1		;failed
		jr	opret
;
oppchl:		lded	hlloc		;get <hl> into <de>
		jmp	exnext		;and exit
;
opret:		lhld	skloc		;get sp
		mov	e,m
		inx	h
		mov	d,m		;get return address in <de>
		jmp	exnext
;
xfropc:		mov	a,b
		ani	1		;test for unconditional
		jrnz	uncond
		mov	a,b
		call	fndcond
		jr	skip3
;
uncond:		xchg
		inx	h		;put target in <de>
		mov	e,m
		inx	h
		mov	d,m
		jmp	exnext
;
stab:		mov	a,b
		xra	m
		inx	h
		ana	m
		rz
		inx	h
		dcr	c
		jrnz	stab
;
skipret:	xthl
		inx	h
		inx	h
		xthl
		ret
;
fndcond:	lhld	afloc		;get flags
		push	h
		ani	0011$1000b	;mask all but flag bits
		rrc
		mov	c,a
		mvi	b,0
		lxi	h,condtbl
		dad	b
		pop	psw
		pchl
;
condtbl:	rz
		jmp	skipret
		rnz
		jmp	skipret
		rc
		jmp	skipret
		rnc
		jmp	skipret
		rpe
		jmp	skipret
		rpo
		jmp	skipret
		rm
		jmp	skipret
		rp
		jmp	skipret
;
byt1tbl		db	00,0c7h
		db	03,0c3h
		db	09,0cfh
		db	02,0e7h
		db	04,0c6h
		db	40h,0c0h
		db	80h,0c0h
		db	0c1h,0cbh
		db	0e3h,0e7h
		db	0f9h,0ffh
;
byt2tbl		db	06,0c7h
		db	0c6h,0c7h
		db	0d3h,0f7h
;
byt3tbl		db	22h,0e7h
		db	01,0cfh
;
xfrtbl		db	0c3h,0ffh
		db	0cdh,0ffh
		db	0c2h,0c7h
		db	0c4h,0c7h
;
reltbl		db	20h,28h,30h,38h
;
edtbl		db	43h,4bh,53h,5bh
		db	73h,7bh
;
;
;	search memory routine
;
;	search range memory for the entered number of bytes
;	syntax:
;		sxxxx,yyyy,<byte-1>,<byte-2>,<etc.><cr>
;			where xxxx is the starting address,
;			and yyyy is the ending address.
;
search:		call	expr		;get start and end addresses
		popix
		popiy			;save in <x> and <y>
		mvi	d,00		;clear byte count
;
sear1:		mvi	b,01		;init "expr" count
		call	expr		;get byte to search for
		pop	h		;recover from stack
		mov	h,l
		push	h		;save single byte on stack
		inx	sp		;correct stack
		inr	d		;count=count+1
		mov	c,a
		cpi	cr		;check for end of string
		jrnz	sear1		;loop 'till all bytes in
		mvi	h,00
		mov	l,d		;count to <hl>
		dcr	l
		dad	sp		;pointer to search string in <hl>
		push	h
		pushiy
		pop	h		;recover start address to <hl>
		pushix
		mov	b,d
		mov	c,d		;count to <b> and save in <c>
		pop	d		;end address of search
		popix			;<x> has start of search string
;
find:		ldx	a,00		;first byte
		cmp	m		; =??
		jrz	found		;yes, go check rest of string
		call	hilo		;range check
		jc	command		;past end of range
		jr	find		;loop
;
found:		pushix			;save pointer to string
		push	h		;and first address
;
fndlop:		cmp	m		;check rest of string
		jrnz	notfnd		;no compare
		dcxix
		inx	h		;next byte
		ldx	a,0
		djnz	fndlop		;loop as long as they compare
		jrz	tell		;found string, print address
;
notfnd:		pop	h
;
found1:		popix			;restore
		mov	b,c
		inx	h		;point to next memory loc.
		jr	find
;
tell:		pop	h		;restore memory address
		push	b		;save
		call	ladra		;print address
		pop	b
		jr	found1		;some more?
;
;
;	general purpose routines
;
;	routine conv converts the low order nibble of the 
;	accumulator to its ascii equivalent.  it
;	puts the result into c for later output.
;
conv:		ani	0fh		;strip off bits 4-7
		adi	90h		;put on the ascii zone
		daa
		aci	40h
		daa
		mov	c,a		;put in output pass register
		ret
;
;
;	routine echo reads a byte from a half-duplex console
;	device, then echoes the character back to the
;	console.
;
decho:		call	dash		;print a dash
;
echo:		call	ci		;console read, write routine
;
ech1:		push	b		;  save <bc>
		mov	c,a		;  pass character in <c> register
		cpi	cr
		jrz	echo2
		cpi	lf
		jrz	echo2
		call	co		;  output it
;
echo2:		mov	a,c		;  put character back into <a>
		cpi	'A'
		jrc	echo3
		ani	05fh
;
echo3:		pop	b		;  restore <bc>
		ret
;
;
;	routine expr3 gets three parameters, does a cr, lf and 
;	then loads <bc>, <de>, and <hl> with the parameters.
;
expr3:		inr	b		;2 is already in the <b> register
		call	expr		;get the parameters
		pop	b		;put parameters into registers
		pop	d
		jmp	crlfa		;go do the carriage return sequence
;
;
;	routine hilo increments <hl>.  it then checks for and
;	disallows a wrap-around situation.  if it occurs,
;	the carry bit will be set on return.  if no wrap-
;	around occurred, <hl> is compared to <de> and
;	the flag bits set accordingly.
;
hilo:		inx	h		;increment <hl>
		mov	a,h		;test if zero
		ora	l		;  in <hl>
		stc			;set carry for <hl>=0
		rz			;return if <hl> = 0
		mov	a,e		;compare <hl> to <de>
		sub	l
		mov	a,d
		sbb	h
		ret			;return with flags set
;
;
;	routine hilox increments <hl>, compares it to <de> and
;	if equal, returns control to the monitor executive.
;	otherwise, control returns to the calling routine.
;
hilod:		pop	d		;get rid of return address
		ret			;return to monitor
;
hiloxb:		inx	b		;increment <bc>
;
hilox:		call	hilo		;inc and check <hl>

		jrc	hilod		;done if carry set
		call	csts		;see if console break pending
		ora	a
		rz			;none, return to continue
		call	ci		;see if wait or break
		cpi	crtls		;check for control-S 
		jrnz	hilod		;jump if break
		jmp	ci		;go wait for next character
;
;
;	routine nibble converts the ascii characters 0-9 and
;	a-f to their equivalent hexadecimal value.  if
;	the character is not in range, the carry bit is set to
;	flag the error.
;
nibble:		sui	'0'		;ascii to hex conversion
		rc			;  done if out of range
		cpi	'G'-'0'		;check upper end
		cmc			;  toggle the carry bit
		rc			;  done if out of range
		cpi	'9'-'0'+1	;see if numeric
		cmc			;  toggle the carry bit
		rnc			;  done if so
		sui	'A'-'9'-1	;subtract the alpha bias
		cpi	10		;  set carry for invalid char
		ret
;
;
;	routine pchk reads a character from the console, then
;	checks it for a delimiter. if it is not
;	a delimiter, a non-zero condition is returned.
;	if it is a delimiter, a zero condition is returned.
;	further, if the delimiter is a carriage return,
;	the carry bit is set.  a blank or a comma resets
;	the carry bit.
;
pchk:		call	echo		;get, test for delimiter
;
p2c:		cpi	' '		;  blank?
		rz			;  yes, done
		cpi	','		;  no, comma?
		rz			;  yes, done
		cpi	cr		;  no, carriage return?
		stc			;  show it in carry bit
		rz			;  done if cr
		cmc			;clear carry for no delimiter
		ret
;
;
;	routine rest traps all of the register contents whenever a
;	restart 1 instruction is executed.  the trapped contents
;	are stored in the system stack area for later access and
;	use by the goto and the examine registers commands.
;
bkpt:		di			;kill interrupts
		shld	hlloc		;save user <hl>
		pop	h		;get user <pc>
		dcx	h		;correct
		shld	pcloc
		push	psw		;save flags first
		pop	h
		shld	afloc
		lxi	h,0000
		dad	sp		;get user stack
		lxi	sp,skloc+2	;point to register save area
		push	h		;save user <sp>
		push	d		;save user registers
		push	b
		dcx	sp		;ajust stack
		dcx	sp
		pushiy
		pushix
		ldar
		mov	b,a
		ldai
		mov	c,a
		push	b		;save <i> & <r> reg's
		exaf
		exx			;swap banks
		push	h
		push	d
		push	b
		push	psw
		lxi	b,bk1byt	;setup to clear bkpt
		lhld	bk1adr		;get a bkpt address
		lded	pcloc		;get user <pc>
		ora	a		;clear carry
		dsbc	d		;compare bkpt with <pc>
		jrz	clrbkpt		;clear bkpt
		lxi	b,bk2byt
		lhld	bk2adr
		ora	a
		dsbc	d
		jrnz	exbkpt
;
clrbkpt:	ldax	b		;get byte from table
		stax	d		;restore instruction
		xra	a		;clear <a>
		stax	b
		dcx	b
		stax	b
		dcx	b
		stax	b		;clear table
;
exbkpt:		lxi	h,brkmsg
		call	prnmsg
		lhld	pcloc
		call	ladr
		mvi	c,'='
		call	co
		mov	a,m
		call	hex1
		lxi	h,actbl		;get register table
		call	xg		;go print registers
		jmp	command		;return to monitor
;
;
brkmsg		db	'Break ',' '+80h
;
qmsg		db	07h,'-Er','r'+80h
;
signon		db	'HDmon-8800h v'
		db	vers+'0','.',rev+'0'
;
crmsg		db	cr,lf+80h
;
dskmsg		db	'HD err: rd','y'+80h
;
;
;	hexn routine
;
;	this routine adds and subtracts two hexadecimal 16-bit
;	unsigned numbers and displays the results on the
;	console.
;
hmath:		call	exlf		;get the two numbers
		push	h		;save it for the subtract
		dad	d		;add them
		call	ladrb		;output them
		pop	h		;reget the first number
		ora	a		;clear the carry bit
		dsbc	d		;do the subtract
		jr	ladr		;go output the result
;
;
;	routine ladr prints the contents of <hl> on the 
;	current console, either at the start of a new
;	line (ep = ladra or at the current location (ep
;	= ladr.
;
ladra:		call	crlf		;start a new line
;
ladr:		mov	a,h		;get high two digits
		call	hex1		;print them
		mov	a,l		;get low two digits
;
hex1:		push	psw		;save the low digit
		rrc			;put high nibble into bits 0-3
		rrc
		rrc
		rrc
		call	hex2		;go print single digit
		pop	psw		;reget the low digit
;
hex2:		call	conv		;go insert ascii zone
		jr	co		;do the character output
;
;
;	routine dash types a dash on the current console device.
;
dash1:		call	hex1		;first, print accum as two hex digits
;
dash:		mvi	c,'-'		;get an ascii dash
		jr	co		;go type it
;
ladrb:		call	ladra		;output <hl> as 4 ascii digits
;
blk:		mvi	c,' '		;output a blank
		jr	co		;print it
;
;
;	routine prtmcr prints an ascii string onto the console.
;	the string must be terminated by bit 7 set in the
;	last character of the string.  the string will start
;	a new line (ep = prtmcr or continue on the same
;	line (ep = prnmsg
;
prtmcr:		call	crlf		;start a new line
;
prnmsg:		push	b		;save <bc>
;
prta:		mov	c,m		;get next character from memory
		call	co		;output it
		inx	h		;increment memory pointer
		mov	a,c
		rlc			;test for bit 7 delimiter
		jrnc	prta		;no delimiter, go do next character
;
prtb:		pop	b		;restore <bc>
		ret
;
;
;	routine exlf reads two parameters, puts them into the
;	<de> and <hl> registers, then does a carriage return,
;	line feed sequence.
;
exlf:		call	expr		;go get two parameters
		pop	d
		pop	h
;
;
;	routine crlf generates a carriage return, line feed
;	sequence on the current console to start a new line
;
crlf:		push	h		;save the contents of <hl>
;
crlfa:		lxi	h,crmsg		;address of cr,lf message
		call	prnmsg		;  output it
		pop	h		;restore <hl>
		ret
;
;
;	i/o drivers for the 8250 comm element
;
csts:		in	constat		;get 8250 line status
		ani	rxrdy		;see if receive data available
		rz			;return if not
		ori	not rxrdy	;flag that data is available
		ret
;
;
ci:		call	csts
		jrz	ci		;loop until data is in
		in	condata		;read the data
		ani	07fh
		ret
;
;
co:		in	constat		;get 8250 line status
		ani	txrdy		;isolate thre bit
		jrz	co		;wait until one of the registers empties
		mov	a,c		;move the data over
		out	condata		;output the data
		ret
;
;
;	routine boot loads in the first sector of
;	drive 00 into locations 80h-ffh, then
;	transfers program control to location 80h.
;	it expects the dos loader to be on the
;	first sector.
;
;	syntax:
;		a		boots the floppy disk
;
fboot:		lxi	h,0000		;set up the disk parms
		shld	diskno
		lxi	h,0d001h	;side 0, sector 1
		shld	sector
		lxi	h,tbuf
		shld	lunit		;force a disk determination
		call	dreadh		;go get a sector
		jz	tbuf		;go to the loader
		jmp	command
;
;
;	the following routines do the primitive disk accesses.
;	in all cases, one sector of data is transferred.
;	if the disk has not been previously accessed,
;	these routines will automatically determine
;	single or double density, and sector size.
;
;	before the desired data is transferred, the desired
;	track is seeked out, the desired sector and side is
;	set, then the actual data transfer.
;
;	up to ten tries will be attempted before the data
;	transfer is aborted.  on return to the calling
;	routine, the <a> register will contain a zero if the
;	operation was successful, or non-zero if not
;	successful.  the flag register will not necessarily
;	correspond with the a register content.
;
;	these routines are cp/m compatable, and may be used
;	as part of the bios.
;
;
dreadh:		shld	hstbuf		;save the dma address
		mvi	b,10		;number of retries
;
agn:		push	b
		call	seek
		cz	rdwr
;
read3:		pop	b
		rz
		djnz	agn
		ret
;
rdwr		equ	$
rdat:		sta	cmnd
		out	dcmmd		;disk command port
;
read1:		inir
		dcr	d
		jrnz	read1
		call	eoj
		ani	9ch		;isolate read error bits
		ret
;
eojb:		mvi	b,8		;basis of restore command
;
eoja:		lda	stprat		;get the step rate bits
		ora	b		;add on the command
		sta	cmnd
		out	dcmmd		;do the command
;
eoj:		in	dflag		;disk flag port
		rar
		jrnc	eoj
;
eoj1:		in	dstat		;get the disk status
		sta	status
		ani	0fch
		ret
;
seek:		call	idrd		;insure header has been read
		cnz	eojb		;restore the drive if error
		rm			;done if no drive
;
seek1:		lda	sector		;set the sector
		out	dsctr		;disk sector port
		in	dtrck		;disk track port
		mov	c,a		;save it
		lda	track		;get desired track
		cmp	c
		jrz	rdwrt		;jump if no seek needed
		out	ddata		;set the seek track
		mvi	b,1ch		;build the seek command
		call	eoja		;do the seek
		ani	98h		;seek error mask
		rnz			;done if seek error
		in	dtrck		;check for track 00
;
rdwrt:		ora	a
		lxi	h,40h		;build sector byte count
		jrz	rdwrt0		;jump if track 00
		lda	idsv+3		;get sector size
;
rdwrt0:		dad	h		;double <hl>
		dcr	a		;loop control
		jp	rdwrt0
		push	h
		mvi	c,80h		;auto-wait bit
		call	setup
		in	dflag		;disk flag port
		ani	20h		;see if head is loaded
		mvi	a,4
		jrz	rdwrt1		;jump if not
		xra	a		;else, reset the head load flag
;
rdwrt1:		adi	88h		;build a read sector command
		lhld	hstbuf		;get the dma address
		pop	d		;get the byte count
		mov	b,e		;set up for z-80 i/o
		dcr	d		;see if 128 byte sector
		inr	d
		jrnz	rdwrt2		;jump if not
		inr	d
;
rdwrt2:		mvi	c,ddata
		cmp	a		;clear the flags
		ret
;
idrd5:		mvi	b,58h		;build a step-in command
		call	eoja
;
idrd:		lhld	lunit
		mov	a,h		;get the cunit value
		cmp	l		;see if same as lunit
		rz			;return if so
;
idrd1:		mvi	c,80h		;set the auto-wait bit
		call	setup
		call	eoj1		;insure a drive is there
		rm			;error if not
		push	h		;save pointer
		lxi	h,idsv		;set up to read address
		lxi	b,600h+ddata
		mvi	d,1
		mvi	a,0c4h		;read address command
		call	rdat
		pop	h		;restore pointer
		jrz	idrd2		;jump if good read
		mvi	a,40h		;see if dden is set
		cmp	m
		rc			;take the error if so
		ora	m		;else, try dden
		mov	m,a
		jr	idrd
;
idrd2:		in	dsctr		;get the track number
		out	dtrck		;set the track register
		ora	a		;insure not on track 0
		jrz	idrd5		;jump if not okay
		mov	a,m		;reget selbits
		sta	lunit		;update last used unit
		xra	a		;reset error flags
		ret
;
;	set up drive number
;
setup:		lxi	h,cunit		;see if drive has been active
		mov	a,m		;get the selbits
		ora	a		;see if set up yet
		jrnz	su0		;yes, skip init code
;
setit:		lda	diskno		;get the desired drive
		mov	b,a		;save in work register
		inr	b		;prepare to convert to selbits
		xra	a		;zero to <a>
		stc			;drive select bit
;
set1:		ral			;shift bit into position
		djnz	set1		;loop til bit is in position
		ori	20h		;add on motor on bit
		mov	m,a		;save it
		out	dcntl		;select the drive
		lxi	d,stprat	;set initial step rate
		mvi	a,3		; to slowest possible
		stax	d
		call	eojb		;restore the drive
		rm			;done if drive not ready
		mvi	a,10h		;else, add on maxi bit
		ora	m
		mov	m,a
		mvi	a,2		;set maxi step rate
		stax	d
;
su0:		in	dtrck		;else, see if track zero
		ora	a
		mov	a,m		;reget the selbits
		jrnz	su1
		ani	0bfh		;insure dden is reset
;
su1:		ora	c		;add on autowait bit
		out	dcntl		;output the selbits
		lda	side		;set the side select
		out	4
		ret
;
;
;	routine boot loads in the first sector of
;	drive 00 into the location provided by the
;	first two bytes of the loader, then
;	transfers program control to the goto command.
;	it expects the dos loader to be on the
;	first sector.
;
;	syntax:
;		b		boots the hard disk
;
hboot:		mvi	a,null		;set head=00,dir=out,disk=00
		out	hdfunc
		mvi	a,0000$0011b
		out	hdcntl		;wr prot,bus clk, run
		xri	0000$1000b	;toggle fault clear
		out	hdcntl
		xri	0000$1000b
		out	hdcntl
		in	hdstat		;check for disk ready
		ani	drvrdy
		jrnz	rdyerr		;disk not ready, send message
		mvi	a,dskclk	;disk ready, do final setup
		out	hdcntl
;
movhom:		in	hdstat		;check for track zero
		ani	tkzero
		jrz	athome
		mvi	a,null		;now home the disk
		ani	nstep
		out	hdfunc
		ori	pstep
		out	hdfunc
;
sekdon:		in	hdstat		;wait for seek complete
		ani	complt
		jrz	sekdon
		jr	movhom
;
athome:		mvi	a,isbuff	;set pointer to header area
		out	hdcmnd
		xra	a
		out	hddata		;head number 0
		out	hddata		;track number 0
		inr	a
		out	hddata		;sector number 1
		xra	a		;get a zero, normal key
		out	hddata		;normal key byte
		out	hdcmnd		;set pointer to data buffer
		cma
		out	hddata
		out	hddata
		mvi	a,rdsect	;read sector command
		out	hdcmnd		;do it
;
opwait:		in	hdstat		;wait for op done bit
		ani	38h
		xri	10h		;flip wr fault bit
		mov	e,a		;save status register
		in	hdstat
		ani	opdone
		jrz	opwait
		in	hdrslt
		ani	retry
		ora	e		;combine statuses
		jrnz	rslterr
		xra	a
		out	hdcmnd		;set for data buffer
		in	hddata
		in	hddata
		in	hddata		;get loader size
		mov	b,a		;to <b>
		in	hddata		;get load address from loader
		mov	l,a
		in	hddata
		mov	h,a
		shld	pcloc		;setup goto command
		mvi	c,hddata	;<b>= bytes to load
					;<c>= data port
		inir			;read <b> bytes
		mvi	c,'.'		;tell user cold boot is loaded
		call	co
		jmp	goto		;go set some break points if wanted
;
rslterr:	sta	status		;save for debug
		jmp	qprt
;
rdyerr:
prnerr:		lxi	h,dskmsg
		call	prtmcr
;
perr1:		jmp	command		;let user retry
;
;
;	initialization code for the 8250 asynchronous communication
;	element.  this code will initialize the baud rate
;	of the 8250, as will as the word format.  8-data bits,
;	1 stop bit and no parity are selected.  either 2 or 3 carriage
;	returns must be entered to establish the correct buad rate.
;	
i8250:		mvi	a,0fh		;set up the 8250
		out	smdmct
		lxi	h,0006h		; 19.200 kbaud
;
i8250d:		mvi	a,83h		;set divisor register access
		out	slctrl
		mov	a,h
		out	sinten
		mov	a,l		;set the divisor
		out	sdata
		mvi	a,3		;set data register access
		out	slctrl
		xra	a		;disable interrupts
		out	sinten
		out	slstat		;and reset error flags
		call	ci		;get a character
		ani	7fh		;strip off any parity bit
		cpi	0dh		;see if it is a carriage return
		rz			;done if carriage return received
		dad	h		;baud rate *2
		jr	i8250d		;go set the new divisor
;
;
		end	zmon		;thats all folks
