	title	'FOXCALC overlay handler module, version 1.0'
;
;
	page	58
;
;
bdos		equ	0005h		;bdos entry point
;
set$dma		equ	26		;set dma address function number
ran$rd		equ	33		;read random sector function number
;
rr		equ	32		;random record offset from start of fcb
;
;
	cseg
;
;
	public	ld$ovly, ovl$ret
;
	extrn	ovl$fcb, ovl$buf
;
;
;	this module handles the loading and returning of overlays
;	overlays are limited to maximum of 16, and may nest other
;	overlays to the limit of the machine stack.
;
;
ld$ovly:	shld	ovl$num
		call	rd$ovly
		lda	ovl$cnt		;get nested count
		inr	a		;one more nested overlay
		sta	ovl$cnt
		lhld	ovl$num		;save overlay name on stack
		push	h
		lxi	h,ovl$ret	;and return handler for return from ovl
		push	h
		lhld	ovl$start	;execute overlay
		pchl
;
;
;	return from overlay handler, clears the previous overlay name
;	from the stack (if any) and loads the previous overlay into
;	the buffer, then returns to whatever call load$overlay.
;
ovl$ret:	pop	h		;get previous overlay name
		shld	ovl$num
		lda	ovl$cnt		;one less overlay
		dcr	a
		sta	ovl$cnt
		rz			;no load if last level
		call	rd$ovly		;load previous overlay
		ret			;and return to it
;
;
;	read the overlay off the disk into the overlay buffer
;
;	first setup the buffer at 80h and read in the index sector
;
rd$ovly:	lxi	d,0080h		;use default cp/m buffer for index
		mvi	c,set$dma
		call	bdos
		lxi	h,0000h		;clear record address
		shld	ovl$fcb+rr	;index sector is first sector
		lxi	d,ovl$fcb
		mvi	c,ran$rd	;read index sector
		call	bdos
		ora	a
		jnz	rd$index$err	;error in trying to read index sector
;
;	index read in, get the starting sector, execution address,
;	and length of the overlay
;
		lhld	ovl$num		;overlay name
		dad	d
		dad	d
		dad	d
		dad	d		;index is 8 bytes long
		lxi	d,0080h		;base of index buffer
		dad	d
;
;	starting sector of overlay
;
		mov	e,m		;get low byte
		inx	h
		mov	d,m		;get high byte
		xchg
		shld	ovl$fcb+rr	;setup to read overlay in
;
;	get execution address
;
		xchg
		inx	h
		mov	e,m
		inx	h
		mov	d,m
		xchg
		shld	ovl$start
;
;	get number of sectors to load
;
		xchg
		inx	h
		mov	b,m		;load count in <b>
;
;	read the overlay into the overlay buffer
;
		lxi	d,ovl$buf
		mvi	c,ran$rd	;<b>= count, <c>= function code
;
rd$ovl$2:	push	d
		push	b
		mvi	c,set$dma
		call	bdos
		pop	b		;get count and read function
		lxi	d,ovl$fcb
		call	bdos		;read sector
		pop	b
		pop	d
		ora	a		;test for errors
		sta	rd$stat
		jnz	rd$ovl$err
		dcr	b		;no error
		rz			;return if no more sectors to load
		lxi	h,0080h		;sector size
		dad	d
		xchg
		lhld	ovl$fcb+rr
		inx	h
		shld	ovl$fcb+rr
		jmp	rd$ovl$2	;loop
;
;
rd$index$err:
;
rd$ovl$err:	jmp	$
;
;
	dseg
;
ovl$num		dw	0000h		;overlay name variable
ovl$cnt		db	00h		;nesting level
ovl$start	dw	0000h		;execution address
;
rd$stat		db	00h		;error status after disk read
;
;
