	title	'FOXYCALC terminal i/o module, version 1.0'
;
	page	58
;
;
	public	goto$xy, clr$scn, clr$lin, clr$eol, inv$on, inv$off
	public	dsp$msg, read$ln, char$st, char$in, chr$out
	public	rd$para, rd$nx$pr
;
	extrn	msg$fcb, crt$col, crt$row, typ$num
	extrn	idx$off, column, old$col
;
	extrn	crt$xy, era$scn, era$lin, era$eol, cur$on, cur$off
	extrn	crt$off, inv$spc, rc$cr
;
	extrn	exp$mem, exp$fcb, ex$para, rw$flag, tmp$fcb
;
;
bdos		equ	0005h
set$dma		equ	26		;set dma address function number
ran$rd		equ	33		;read random sector function number
ran$wr		equ	34		;write random sector function number
rr$off		equ	33		;random record offset from fcb(0)
;
cr		equ	0dh
bksp		equ	08h
dele		equ	07fh
fence		equ	'|'
;
msg$buf		equ	0080h		;default message buffer
eo$buff		equ	msg$buf+80h
;
cmd$row		equ	23		;row 23
;
max$col		equ	76		;last colunm number
;
;
	cseg
;
;
;
;	display message
;	reads and displays the prompt line, error message, or help frame
;	from the file, FOXMSG.OVL, at the screen address given by the
;	the first two bytes of the message.  the message is terminated
;	by a 00h byte.
;
dsp$msg:	shld	typ$num		;save address of message in file
		push	h
;
;	the first 24 sectors of the msg file are an index table into the file,
;	so first get the random sector number from the type/number passed in <hl>
;
		dad	h		; *2 is the same as /128
		dad	h		;move index sector number into <h>
		mov	l,h
		mvi	h,00h
		shld	msg$fcb+rr$off	;random record address
		pop	h
		mov	a,l		;message number
		ani	31		;remove sector information
		add	a		;index table entries are word addresses
		sta	idx$off
;
;	file is opened in "init", so all we need is to read the file
;
		lxi	d,msg$buf	;default cpm buffer
		mvi	c,set$dma	;use default buffer
		call	bdos
		lxi	d,msg$fcb	;message file
		mvi	c,ran$rd	;read random function number
		call	bdos
		ora	a
		jnz	rd$error	;a random read error was returned
;
		lda	idx$off		;offset into index table
		lxi	h,msg$buf
		add	l		;don't worry about carry (<100h)
		mov	l,a
;
;	get absolute sector and offset of message from index table
;
		mov	e,m
		mvi	d,00h		;random sector number in <de>
		inx	h
		mov	l,m		;offset in sector in <l>
		xchg
		shld	msg$fcb+rr$off	;absolute sector number
		push	d		;save offset
;
;	read the starting sector of the message in the buffer at msg$buf
;
		lxi	d,msg$fcb
		mvi	c,ran$rd
		call	bdos
		pop	d		;clear stack
		ora	a
		jnz	rd$error
;
;	restore sector offset into <de>, and build buffer offset
;
		lxi	h,msg$buf
		mov	a,e
		add	l
		mov	l,a
;
;	<hl> now point to the cursor address bytes of the message
;	setup to print the message, checking for end of buffer (100h)
;	or message terminator byte (00h).
;
dsp$msg$1:	mov	d,m		;crt row byte
		inx	h
		mov	e,m		;crt column byte
		inx	h
		xchg
		push	d		;save pointer into buffer
;
;	if row/column are = to zero then clear the screen instead of
;	just clearing a line.
;
		mov	a,h
		ora	l
		push	h
		cz	clr$scn		;erase screen function
		pop	h
		call	goto$xy		;position cursor
		call	clr$eol
;
;	display loop print characters untill the 00h terminator
;	byte is encountered.  read sectors if the buffer empties.
;
disp$loop:	pop	h		;recover pointer into buffer
;
disp$lp$1:	mov	a,h		;test of <hl> = eo$buff
		ora	a
		jnz	disp$rd$nxt	;read next sector if equal
		mov	a,m
		ora	a		;test for terminator
		rz
		inx	h
;
;	test for end of line, get new row/column and start over
;
		cpi	cr		;eol flag
		jz	dsp$msg$1
		push	h		;and pointer
		mov	e,a		;get char to output
		call	chr$out		;print it
		jmp	disp$loop
;
;
;	we have reached the end of the buffer and we have more to display
;
disp$rd$nxt:	lhld	msg$fcb+rr$off	;bump sector number
		inx	h
		shld	msg$fcb+rr$off
		lxi	d,msg$fcb
		mvi	c,ran$rd
		call	bdos
		ora	a
		jnz	rd$error
		lxi	h,msg$buf	;start of buffer
		jmp	disp$lp$1
;
;
;	random read error handler
;
rd$error:	jmp	$
;
;
read$ln:	call	goto$cmd$ln	;position cursor at start of command ln
;
;	setup column counter
;
		xra	a
		sta	column		;position 1
;
;	erase command line, display char. counter and prompt
;
		call	clr$lin
		call	disp$prompt
;
		lxi	h,ln$buff	;address of line buffer
;
		push	h
		push	h
;
;	start of main loop.  collect and display chars
;
read$lp:	call	char$in		;get character
		ani	7fh		;strip parity bit
;
;	test for line terminator
;
		cpi	cr		;carrage return
		jz	line$end	;finish line if so
;
;	test for back space or delete keys
;
		cpi	bksp		;back space
		jz	back$sp		;backup one if so
;
		cpi	dele		;delete key
		jz	back$sp		;same as back space
;
;	test for delete entire line
;
		cpi	'X'-40h		;control-X
		jz	era$ln		;kill display line and buffer
;
;	test for re-display line command
;
		cpi	'R'-40h		;control-R
		jz	rept$ln		;erase and re-display command line
;
;	all special characters have been tested for
;	now allow only printable ascii characters (20h-7eh)
;
		cpi	' '		;must be .ge. than space
		jc	read$lp
;
		cpi	7fh		;and .lt. than delete
		jnc	read$lp
;
;	char is printable, send it to the display and
;	put it into the line buffer
;
		push	psw		;save char
		mov	e,a		;put char in <e> for output
		call	chr$out		;display it
		pop	psw
		pop	h		;restore line buff pointer
		inx	h		;next position
		mov	m,a		;store it
		push	h
		lxi	h,column	;point to char count
		inr	m		;now one more
		mov	a,m
		cpi	max$col		;test for max line (max$col chars)
		jz	line$end	;all done if at col 79
;
;	update display character counter
;
		call	disp$prompt
		jmp	read$lp		;end of main loop
;
;	finish up by putting a 00h at the end of the line,
;	and putting the char count in the first byte of the line buffer
;
line$end:	call	disp$prompt
		pop	h		;restore pointer into buffer
		inx	h		;end of line +1
		mvi	m,00h		;end of line flag
		pop	h		;reget pointer to start of line buffer
		lda	column		;character count
		mov	m,a
		ret
;
;
;	back space function, delete character to the left of
;	the cursor
;
back$sp:	lda	column		;test if at left most column
		ora	a
		jz	read$lp		;return if at column 00
;
		dcr	a		;column = column - 1
		sta	column
		pop	h		;line buffer pointer now -1
		dcx	h
		push	h		;save pointer
;
;	output (backspace, space, backspace)
;
		mvi	e,bksp
		call	chr$out
		mvi	e,' '
		call	chr$out
		mvi	e,bksp
		call	chr$out
;
;	update display char counter
;
		call	disp$prompt
		jmp	read$lp
;
;
;	erase entire display line and zero char counter
;
era$ln:		pop	h		;clear stack
		pop	h
		lda	column
		sta	old$col		;save column number
		jmp	read$ln		;start from beginning
;
;
;	re-display line, erase line and write a new copy
;
;	re-print buffer
;
rept$ln:	lda	old$col
		ora	a		;test for zero
		jz	read$lp		;bypass if zero
;
		call	clr$lin		;erase line
		lda	old$col		;get saved count
		sta	column		;restore column number
		mov	b,a		;counter
		lxi	h,ln$buff
;
rept$ln$lp:	inx	h
		mov	e,m		;output char in <e>
		push	b
		push	h		;save count and pointer
		call	chr$out
		pop	h
		pop	b
		dcr	b
		jnz	rept$ln$lp	;loop
;
		xra	a
		sta	old$col		;clear repeat flag/counter
		xthl			;replace line buffer pointer
		call	disp$prompt	;update display char count
		jmp	read$lp		;around again
;
;
;	position cursor at the display command line,
;
goto$cmd$ln:	lxi	h,(cmd$row shl 8) and 0ff00h	;row 23 column 1
		jmp	goto$xy
;
;
;	display the char count and prompt
;
disp$prompt:	call	goto$cmd$ln	;position cursor at beginning of line
		lda	column		;get count
		push	psw		;save column count
		call	prn$dec		;output it
		mvi	e,fence		;prompt character
		call	chr$out
		mvi	h,cmd$row	;row number
		pop	psw		;restore colunm count
		adi	3		;offset past prompt
		mov	l,a
		shld	crt$col		;update current cursor address
		jmp	goto$xy		;put cursor at proper place
;
;
;	clear terminal screen function
;	erases the screen and homes the cursor
;
clr$scn:	lxi	h,era$scn	;clear crt string
		call	crt$fnc
		lxi	h,0000h		;row=00, column=00
		jmp	goto$xy
;
;
;	clear single line function
;	erases the line currently addressed by the cursor
;	psoitions to cursor to the beginning of the line
;
clr$lin:	lxi	h,era$lin	;terminal dependent function string
		mov	a,m
		ora	a
		jnz	crt$fnc		;output to terminal
;
;
;	clear to end of line
;	erases from the cursor to the end of the line
;	including the character under the cursor
;
clr$eol:	lxi	h,era$eol
		jmp	crt$fnc
;
;
;	active cell cursor on
;	set the active cursor on either an atribute or a char
;
inv$on:		lxi	h,cur$on	;cell cursor on string
		jmp	crt$fnc
;
;
;	active cell cursor off
;	sets the active cursor off either an attribute or a char
;
inv$off:	lxi	h,cur$off	;cell cursor off string
;
;
;	crt function sender
;	sends terminal dependent function strings to the
;	terminal.  pointer to function string passed in <hl>
;
;	string structure:
;		byte one -- number of bytes in string
;		byte two..n -- actual string
;
crt$fnc:	mov	b,m		;get byte count
;
crt$fnc$lp:	inx	h
		dcr	b
		rm
		mov	e,m		;get byte
		push	b		;save registers
		push	h
		call	chr$out
		pop	h
		pop	b
		jmp	crt$fnc$lp	;loop
;
;
;	display two (2) decimal digits on the terminal
;		byte to be converted in <a>
;		range is 0 to 99
;
prn$dec:	mvi	e,00h
;
prn$dec$1:	sui	10		;subtract 10 until value is .lt. 10
		jc	prn$dec$2
		inr	e		;add 1 for each subtraction
		jmp	prn$dec$1
;
prn$dec$2:	push	psw		;save remainder
		call	dec$out		;print decimal digit
		pop	psw
		adi	10		;correct remainder
		mov	e,a		;output from <e>
		jmp	dec$out		;and finish
;
;
;	position cursor at row/column using terminal
;	dependent offsets.
;
;	row passed in <h>, column passed in <l>
;
goto$xy:	shld	crt$col		;get new cursor position
		lxi	h,crt$xy	;first function bytes
		call	crt$fnc
		lhld	crt$col		;get cursor position
		lda	rc$cr		;check for row,col or col,row
		ora	a
		jz	goto$xy$1
;
;	swap row and column bytes in <hl>
;
		mov	a,l
		mov	l,h
		mov	h,a
;
goto$xy$1:	lda	crt$off		;get row offset value
		add	h
		push	h
		mov	e,a		;output from <e>
		call	chr$out
		pop	h
		lda	crt$off		;and column offset value
		add	l
		mov	e,a
		jmp	chr$out
;
;
;	character output functions
;
;	print decimal digit
;
dec$out:	mvi	a,30h		;ascii numeric bias
		add	e		;make decimal
		mov	e,a
;
;	output character using BDOS function 6
;
;		character passed in <e>
;
chr$out:	mvi	c,06		;function number
		jmp	bdos		;do it
;
;
;	character input using BDOS function 6 (direct console i/o)
;
;		return with character in <a>
;
char$in:	mvi	e,0ffh		;char in flag
		mvi	c,06h		;function number
		call	bdos
		ora	a
		jz	char$in		;loop if no char
		ret			;return with char in <a>
;
;
;	character status check routine
;
;	return	<a> = 00, if NO character ready
;		<a> = non-zero if char ready
;
char$st:	mvi	e,0feh		;check console status flag
		mvi	c,06h		;function number
		jmp	bdos
;
;
;	read$paragraph
;	reads a block of expression file into the expr$mem
;	the address of the fcb is passed in <hl>
;
rd$nx$pr:	lxi	h,ex$para	;get paragraph number
		inr	m		; +1
;
rd$para:	lxi	h,exp$fcb
		xra	a
		sta	rw$flag
		lda	ex$para
;
rd$para$4:	shld	tmp$fcb		;save fcb address
		push	h		;save fcb address on stack
		mov	l,a		;paragraph number in <l>
		mvi	h,00h
;
;	calculate starting random record from paragraph number
;	multiply paragraph number by 64
;
	rept	5
		dad	h
	endm
		push	h		;save starting record
		lhld	tmp$fcb
		lxi	d,33		;get pointer to random rec field
		dad	d
		shld	tmp$fcb		;save pointer to rr field
		pop	d		;get record number
		mov	m,e		;low byte
		inx	h
		mov	m,d		;middle byte
		inx	h
		mvi	m,00h		;high byte of rr field
		pop	d		;get fcb pointer
;
;	check for read or write operation
;
		lda	rw$flag		;test 00h=read op., non-zero write op.
		ora	a
		jz	rd$para$rd	;read operation
		lxi	b,(32 shl 8) or ran$wr
		jmp	rd$para$com
;
rd$para$rd:	lxi	b,(32 shl 8) or ran$rd
;
rd$para$com:	lxi	h,exp$mem-128
;
rd$para$1:	push	b		;save machine state
		push	d
		lxi	d,0080h		;sector size 128 bytes
		dad	d
		push	h		;save dma address
		xchg			;put dma address in <de>
		mvi	c,set$dma	;set dma function number
		call	bdos
		pop	h		;restore machine state
		pop	d
		pop	b
		push	b		;save registers for bdos call
		push	d
		push	h
		call	bdos		;do sector read
		pop	h
		pop	d
		pop	b		;restore machine
		ora	a		;test for errors
		jnz	rd$err
		dcr	b		;sector count -1
		jz	rd$para$3
		push	h		;save dma address
		lhld	tmp$fcb		;pointer to rr field
		inr	m		;next random record
		jnc	rd$para$2
		inx	h
		inr	m		;middle byte
;
rd$para$2:	pop	h
		jmp	rd$para$1
;
rd$para$3:	jmp	$
;
rd$err:		jmp	$
;
;
	dseg
;
ln$buff		ds	max$col+1
;
