;	SKELETAL CBIOS FOR FIRST LEVEL OF CP/M ALTERATION
;
;	NOTE :  MSIZE DETERMINES WHERE THIS CBIOS IS LOCATED
MSIZE	EQU	16	;CP/M VERSION MEMORY SIZE IN KILOBYTES
PATCH	EQU	MSIZE*1024-2*256	;START OF THE CBIOS PATCH
;
;	WE WILL USE A SCRATCH AREA STARTING AT 40H
;	 FOR HOLDING THE VALUES OF:
;		TRACK   =  LAST SELECTED TRACK
;		SECTOR  =  LAST SELECTED SECTOR
;		DMAAD   =  LAST SELECTED DMA ADDRESS
;		DISKNO  =  LAST SELECTED DISK NUMBER
;	(NOTE THAT ALL ARE BYTE VALUES EXCEPT FOR DMAAD)
;
SCRAT	EQU	40H		;START OF SCRATCH AREA
TRACK	EQU	SCRAT		;CURRENT TRACK ON DRIVE 0
TRAK1	EQU	TRACK+1		;CURRENT TRACK ON DRIVE 1
SECTOR	EQU	SCRAT+2		;CURRENTLY SELECTED SECTOR
DMAAD	EQU	SCRAT+3		;CURRENT DMA ADDRESS
DISKNO	EQU	SCRAT+5		;CURRENT DISK NUMBER
DUMMY	EQU	DISKNO+1	;MUST BE 0 FOR DOUBLE ADD
;
;
	ORG	PATCH	;ORGIN OF THIS PROGRAM
CBASE	EQU	(MSIZE-16)*1024	;BIAS FOR SYSTEMS LARGER THAN 16K
CPMB	EQU	CBASE+2900H	;BASE OF CP/M (= BASE OF CCP)
BDOS	EQU	CBASE+3206H	;BASE OF RESIDENT PORTION OF CP/M
CPML	EQU	$-CPMB		;LENGTH OF THE CP/M SYSTEM IN BYTES
NSECTS	EQU	CPML/128	;NUMBER OF SECTORS TO LOAD ON WARM START
;
;	JUMP VECTOR FOR INDIVIDUAL SUBROUTINES
	JMP	GOCPM		;COLD START
WBOTE:
	JMP	WBOOT		;WARM START
	JMP	CONST		;CONSOLE STATUS
	JMP	CONIN		;CONSOLE CHARACTER IN
	JMP	CONOUT		;CONSOLE CHARACTER OUT
	JMP	LIST		;LIST CHARACTER OUT
	JMP	PUNCH		;PUNCH CHARACTER OUT
	JMP	READER		;READER CHARACTER OUT
	JMP	HOME		;MOVE HEAD TO HOME POSITION
	JMP	SELDSK		;SELECT DISK
	JMP	SETTRK		;SET TRACK NUMBER
	JMP	SETSEC		;SET SECTOR NUMBER
	JMP	SETDMA		;SET DMA ADDRESS
	JMP	READ		;READ DISK
	JMP	WRITE		;WRITE DISK
;
;	INDIVIDUAL SUBROUTINES TO PERFORM EACH FUNCTION
;
WBOOT:	;SIMPLEST CASE IS TO READ THE DISK UNTIL ALL SECTORS LOADED
;
	LXI	SP,80H		;USE SPACE BELOW BUFFER FOR STACK
	MVI	C,0		;SELECT DISK 0
	CALL	SELDSK
	CALL	HOME		;GO TO TRACK 00
;
	MVI	B,NSECTS	;B COUNTS THE NUMBER OF SECTORS TO LOAD
	MVI	C,0		;C HAS THE CURRENT TRACK NUMBER
	MVI	D,2		;D HAS THE NEXT SECTOR TO READ
;	NOTE THAT WE BEGIN BY READING TRACK 0, SECTOR 2 SINCE SECTOR 1
;	CONTAINS THE COLD START LOADER, WHICH IS SKIPPED IN A WARM START
	LXI	H,CPMB		;BASE OF CP/M (INITIAL LOAD POINT)
LOAD1:	;LOAD ONE MORE SECTOR
	PUSH	B	;SAVE SECTOR COUNT, CURRENT TRACK
	PUSH	D	;SAVE NEXT SECTOR TO READ
	PUSH	H	;SAVE DMA ADDRESS
	MOV	C,D	;GET SECTOR ADDRESS TO REGISTER C
	CALL	SETSEC	;SET SECTOR ADDRESS FROM REGISTER C
	POP	B	;RECALL DMA ADDRESS TO B,C
	PUSH	B	;REPLACE ON STACK FOR LATER RECALL
	CALL	SETDMA	;SET DMA ADDRESS FROM B,C
;
;	DRIVE SET TO 0, TRACK SET, SECTOR SET, DMA ADDRESS SET
	CALL	READ
	ORA	A	;ANY ERRORS?
	JNZ	WBOOT	;RETRY THE ENTIRE BOOT IF AN ERROR OCCURS
;
;	NO ERROR, MOVE TO NEXT SECTOR
	POP	H	;RECALL DMA ADDRESS
	LXI	D,128	;DMA=DMA+128
	DAD	D	;NEW DMA ADDRESS IS IN H,L
	POP	D	;RECALL SECTOR ADDRESS
	POP	B	;RECALL NUMBER OF SECTORS REMAINING, AND CURRENT TRK
	DCR	B	;SECTORS=SECTORS-1
	JZ	GOCPM	;TRANSFER TO CP/M IF ALL HAVE BEEN LOADED
;
;	MORE SECTORS REMAIN TO LOAD, CHECK FOR TRACK CHANGE
	INR	D
	MOV	A,D	;SECTOR=27?, IF SO, CHANGE TRACKS
	CPI	27
	JC	LOAD1	;CARRY GENERATED IF SECTOR<27
;
;	END OF CURRENT TRACK, GO TO NEXT TRACK
	MVI	D,1	;BEGIN WITH FIRST SECTOR OF NEXT TRACK
	INR	C	;TRACK=TRACK+1
;
;	SAVE REGISTER STATE, AND CHANGE TRACKS
	PUSH	B
	PUSH	D
	PUSH	H
	CALL	SETTRK	;TRACK ADDRESS SET FROM REGISTER C
	POP	H
	POP	D
	POP	B
	JMP	LOAD1	;FOR ANOTHER SECTOR
;
;	END OF LOAD OPERATION, SET PARAMETERS AND GO TO CP/M
GOCPM:
	LXI	SP,80H
	MVI	A,0C3H	;C3 IS A JMP INSTRUCTION
	STA	0	;FOR JMP TO WBOOT
	LXI	H,WBOTE	;WBOOT ENTRY POINT
	SHLD	1	;SET ADDRESS FIELD FOR JMP AT 0
;
	STA	5	;FOR JMP TO BDOS
	LXI	H,BDOS	;BDOS ENTRY POINT
	SHLD	6	;ADDRESS FIELD OF JUMP AT 5 TO BDOS
;
	LXI	B,80H	;DEFAULT DMA ADDRESS IS 80H
	CALL	SETDMA
;
;PUT ACTIVE DISK NUMBER (STORED IN LOCATION 4) IN C
	LDA	04H
	MOV	C,A
	EI		;ENABLE INTERRUPTS
PATLP:
;WRITECPM ASSUMES THIS LOCATION
	JMP	CPMB	;GO TO CP/M FOR FURTHER PROCESSING
;
;
;	SIMPLE I/O HANDLERS (MUST BE FILLED IN BY USER)
;	IN EACH CASE, THE ENTRY POINT IS PROVIDED, WITH SPACE RESERVED
;	TO INSERT YOUR OWN CODE
;
CONST:	;CONSOLE STATUS, RETURN 0FFH IF CHARACTER READY, 00H IF NOT
;SPACE FOR STATUS SUBROUTINE
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	MVI	A,00H
	RET
;
CONIN:	;CONSOLE CHARACTER INTO REGISTER A
;SPACE FOR INPUT ROUTINE
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	ANI	7FH	;STRIP PARITY BIT
	RET
;
CONOUT: ;CONSOLE CHARACTER OUTPUT FROM REGISTER C
	JMP	CONOUT	;HANGS HERE SO USER CAN STOP AND PATCH
;SPACE FOR OUTPUT ROUTINE
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	DB	0,0,0,0
	RET
;
LIST:	;LIST CHARACTER FROM REGISTER C
	MOV	A,C	;CHARACTER TO REGISTER A
	RET		;NULL SUBROUTINE
;
PUNCH:	;PUNCH CHARACTER FROM REGISTER C
	MOV	A,C	;CHARACTER TO REGISTER A
	RET		;NULL SUBROUTINE
;
;
READER: ;READ CHARACTER INTO REGISTER A FROM READER DEVICE
	MVI	A,1AH	;ENTER END OF FILE FOR NOW (REPLACE LATER)
	ANI	7FH	;REMEMBER TO STRIP PARITY BIT
	RET
;
;
;	I/O DRIVERS FOR THE DISK FOLLOW
;
HOME:	;MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
	LDA	DISKNO	;SELECTED DISK
	MOV	C,A	;FOLLOW PARAMETER CONVENTIONS
	CALL	SELDSK	;ROUTINE TO SELECT THE DISK
;SET UP H,L TO POINT TO WORD WITH TRACK FOR SELECTED DISK
	LXI	D,TRACK
	LHLD	DISKNO
	DAD	D
HOMEL:
	MVI	M,00	;SET CURRENT TRACK PTR BACK TO 0
	IN	127	;READ FDC STATUS
	ANI	4	;TEST TRACK 0 BIT
	RNZ		;RETURN IF AT 0
	STC		;DIRECTION=OUT
	CALL	STEP	;STEP ONE TRACK
	JMP	HOMEL	;LOOP
;
SELDSK:	;SELECT DISK GIVEN BY REGISTER C
;MAKE SURE DUMMY IS 0 (FOR USE IN DOUBLE ADD TO H,L)
	XRA	A
	STA	DUMMY
	MOV	A,C
	STA	DISKNO
	RRC		;PUT INTO BITS 4,5
	RRC
	RRC
	RRC
	ORI	08	;ENABLE DISK SELECT
	OUT	127	;SELECT THE DISK
	RET
;
SETTRK:	;SET TRACK GIVEN BY REGISTER C
;FIRST REFERENCE CORRECT TRACK INDICATOR ACCORDING TO
;SELECTED DISK
	LXI	D,TRACK	;ADDRESS OF TRACK FOR DISK 0
	LHLD	DISKNO	;FIND OUT WHICH DISK IS SELECTED
	DAD	D
	MOV	A,C	;DESIRED TRACK
	CMP	M
	RZ		;WE ARE ALREADY ON THE TRACK
SETTKX:
	CALL	STEP	;STEP TRACK-CARRY HAS DIRECTION
			;STEP WILL UPDATE TRACK INDICATOR
	MOV	A,C
	CMP	M	;ARE WE WHERE WE WANT TO BE
	JNZ	SETTKX	;NOT YET
;HAVE STEPPED ENOUGH
SEEKRT:
;DELAY 18 MSEC FOR FINAL STEP TIME AND HEAD SETTLE TIME
	MVI	A,18D
	CALL	DELAY
	RET		;END OF SETTRK ROUTINE
;
DELAY:	;ROUTINE TO DELAY C(A) MILLISECONDS
	MVI	C,82H	;ADJUST FOR 1 MSEC LOOP DELAY
			;THIS IS THE VALUE FOR OUR IMSAI
LDXA:
	DCR	C
	JNZ	LDXA	;LOOP 1 MSEC
	DCR	A
	JNZ	DELAY
	RET		;END OF DELAY ROUTINE
;
SETSEC:	;SET SECTOR GIVEN BY REGISTER C
	MOV	A,C
	STA	SECTOR
	RET
;
SETDMA:	;SET DMA ADDRESS GIVEN BY REGISTERS B AND C
	MOV	L,C	;LOW ORDER ADDRESS
	MOV	H,B	;HIGH ORDER ADDRESS
	SHLD	DMAAD	;SAVE THE ADDRESS
	RET
;
;
ERRORS:	DB	0	;KEEP TRACK OF NUMBER OF ERRORS
READ:	;PERFORM READ OPERATION.
	;THIS IS SIMILAR TO WRITE, SO SET UP READ COMMAND AND USE
	;COMMON CODE IN WRITE
	MVI	D,40H	;SET READ FLAG
	JMP	WAITIO	;TO PERFORM THE ACTUAL I/O
;
WRITE:	;PERFORM A WRITE OPERATION
	MVI	D,80H	;SET WRITE COMMAND
;
WAITIO:
;ENTER HERE FROM READ AND WRITE TO PERFORM THE ACTUAL I/O 
;OPERATION.  RETURN A 00H IN REGISTER A IF THE OPERATION COMPLETES
;PROPERLY, AND 01H IF AN ERROR OCCURS DURING THE READ OR WRITE
;
;IN THIS CASE, WE HAVE SAVED THE DISK NUMBER IN 'DISKNO' (0,1)
;			THE TRACK NUMBER IN 'TRACK' (0-76)
;			THE SECTOR NUMBER IN 'SECTOR' (1-26)
;			THE DMA ADDRESS IN 'DMAAD' (3-3F80H)
			;D STILL HAS R/W FLAG
	MVI	A,10D	;SET ERROR COUNT
	STA	ERRORS	;RETRY SOME FAILURES 10 TIMES
			;BEFORE GIVING UP
TRYAGN:
;FIRST WE HAVE TO FIGURE OUT WHICH DRIVE IS SELECTED
;AND WHICH TRACK IS DESIRED
	LXI	B,TRACK
	LHLD	DISKNO
	DAD	B	;H,L POINT TO CORRECT TRACK INDICATOR
	MOV	A,M
	PUSH	PSW	;NEED IT LATER
	LHLD	DMAAD	;GET BUFFER ADDRESS
	DCX	H	;SAVE AND REPLACE 3 BYTES BELOW
			;BUF WITH TRACK,SECTOR,ADDRESS MARK
	MOV	B,M
	MVI	A,0FBH	;ADDRESS MARK
	MOV	M,A
	DCX	H
	MOV	C,M
	LDA	SECTOR	;NOTE THAT INVALID SECTOR NUMBER
			;WILL RESULT IN HEAD UNLOADED
			;ERROR, SO DONT CHECK
	MOV	M,A
	DCX	H
	MOV	E,M
	POP	PSW
	MOV	M,A
	MOV	A,H	;SET UP FDC DMA ADDRESS
	OUT	126	;HIGH BYTE
	MOV	A,L
	OUT	125	;LOW BYTE
	MOV	A,D	;GET R/W FLAG
	OUT	127	;START DISK READ/WRITE
RWWAIT:	IN	127	;READ FDC STATUS
	ANI	0F8H	;TEST FOR ANY ERROR OR IOF
	JZ	RWWAIT
	MOV	M,E	;RESTORE 3 BYTES BELOW BUF
	INX	H
	MOV	M,C
	INX	H
	MOV	M,B
	IN	127	;TEST FOR ERRORS
	ANI	0F0H
	RZ		;A WILL BE 0 IF NO ERRORS
;COME HERE ON ERROR FROM DISK
	PUSH	PSW	;SAVE ERROR CONDITION
;CHECK FOR 10 ERRORS
	LXI	H,ERRORS
	DCR	M
	JNZ	REDO	;NOT TEN YET.  DO A RETRY
;WE HAVE TOO MANY ERRORS. PRINT OUT HEX NUMBER FOR LAST
;RECEIVED ERROR TYPE. CPM WILL PRINT PERM ERROR MESSAGE.
	POP	PSW	;GET CODE
	RRC
	RRC
	RRC
	RRC
;MAKE IT ASCII
	ORI	030H
	MOV	C,A
	CALL	CONOUT
;SET ERROR RETURN FOR OPERATING SYSTEM
	MVI	A,1
	RET
REDO:
;D STILL HAS READ/WRITE FLAG
	POP	PSW	;GET ERROR CODE
	ANI	0E0H	;RETRY IF NOT TRACK ERROR
	JNZ	TRYAGN
;WAS A TRACK ERROR SO NEED TO RESEEK
	PUSH	D	;SAVE	READ/WRITE INDICATOR
;FIGURE OUT THE DESIRED TRACK
	LXI	D,TRACK
	LHLD	DISKNO	;SELECTED DISK
	DAD	D	;POINT TO CORRECT TRACK INDICATOR
	MOV	A,M	;DESIRED TRACK
	PUSH	PSW	;SAVE IT
	CALL	HOME
	POP	PSW
	MOV	C,A
	CALL	SETTRK
	POP	D	;GET READ/WRITE INDICATOR
	JMP	TRYAGN
;
;
;
STEP:				;STEP HEAD OUT TOWARDS ZERO
				;IF CARRY IS SET; ELSE
				;STEP IN
; H,L POINT TO CORRECT TRACK INDICATOR WORD
	PUSH	PSW	;SAVE DIRECTION
STWAIT:	IN	127	;INPUT FDC STATUS
	ANI	2	;TEST STEP READY BIT
	JZ	STWAIT	;WAIT FOR STEP READY(MAX 10 MSEC)
	POP	PSW	;GET DIRECTION TO STEP
	JC	OUTX
	INR	M	;INCREMENT CURRENT TRACK BYTE
	MVI	A,4	;SET DIRECTION = IN
DOSTEP:
	OUT	127	;SET DIRECTION BIT IN FDC
	ORI	2
	OUT	127	;PULSE STEP BIT
	ANI	0FDH
	OUT	127	;TURN OFF PULSE
	RET
;
OUTX:
	DCR	M	;UPDATE TRACK BYTE
	XRA	A	;SET DIRECTION = OUT
	JMP	DOSTEP
;
;
;
	END
