;	L i s t   O u t p u t.
;
;	Send a character to the list device.  If the list
;	device is not ready to receive a character wait
;	until the device is ready.
;
;	ENTRY	C = ASCII character to be output.

I3LIST:	LDA	IOBYTE		;Get IOBYTE status
	ANI	0C0H		;Check for UL1:
	SUI	0C0H
	MVI	A,ULS
	JZ	I3UL1
	MVI	A,PRN
I3UL1:	OUT	GBI3U
I3LS1:	IN	GBI3S
	ANI	GBI3DS+GBI3MT
	SUI	GBI3DS+GBI3MT
	JNZ	I3LS1
	MOV	A,C
	OUT	GBI3D
	RET
	space	4,10
;	L i s t   S t a t u s.
;
;	Return the ready status for the list device.
;
;	EXIT	A = 0 (zero), list device is not ready to
;		accept another character.
;		A = FFh (255), list device is ready to accept
;		a character.

I3LST:	LDA	IOBYTE
	ANI	0C0H		;Ceck for UL1:
	SUI	0C0H
	MVI	A,ULS
	JZ	I3UL
	MVI	A,PRN
I3UL:	OUT	GBI3U
	IN	GBI3S
	ANI	GBI3DS+GBI3MT
	SUI	GBI3MT+GBI3DS
	MVI	A,0FFH
	RZ
	XRA	A
	RET
