	page
;	MOVDTA	- Move data in memory.
;
;	ENTRY	C = number of bytes to move
;		DE = destination address.
;		HL = source address.

MOVDTA:
	XCHG			DE = source, HL = source
	ORA	A
	MOV	A,C
	RAR
	MOV	B,A		;B = words to move
	MVI	A,BXADR		;A = extended address
OUTOF:	ORA	A		;Clear carry
	RAL			;Move extended bank to high nibble
	RAL
	RAL
	RAL
	STA	DSH86		;Set 8086 Ds register to extended bank (source)
	MVI	A,BXADR*16	;Cbios bank
	STA	ESH86		;Set 8086 ES register to cbios bank (dest)
	JMP	TRN86
INTO:	XCHG
	ORA	A		;Clear carry
	RAL			;Move extended bank to high nibble
	RAL
	RAL
	RAL
	STA	ESH86		;Set 8086 Ds register to extended bank (dest)
	MVI	A,BXADR*16	;Cbios bank
	STA	DSH86		;Set 8086 Es register to cbios bank (source)
TRN86:	SHLD	DI86		;8086 Destination index
	XCHG
	SHLD	SI86		;8086 source index
	MOV	A,B		;Get # of words to move
	STA	CL86		;Low byte of 8086 CX register
	XRA	A
	STA	CH86		;High byte of 8086 CX register
	STA	DSL86		;Low byte of 8086 DS register
	STA	ESL86		;High byte of 8086 ES register
	IN	swapp		;Switch to 8086 CPU
	RET
di86:
dil86:	db	0		;Low byte of DI
dih86:	db	0		;High byte of DI
esl86:	db	0		;Low byte of ES
esh86:	db	0		;High byte of ES
si86:
sil86:	db	0		;Low byte of SI
sih86:	db	0		;High byte of SI
dsl86:	db	0		;Low byte of DS
dsh86:	db	0		;High byte of DS
cx86:
cl86:	db	0		;Low byte of CX
ch86:	db	0		;High byte of CX

;
;	The following is 8086 code which is used for moving
;	data via the 8086.
;

lop86:
	db	0e4h,swapp	;inb bankp ; wait for transfer
	db	0fch		;cld	   ; Set direction
	db	0b8h		;ld ax,#bxadr ;Set AX to Cbios bank
	dw	bxadr * 16
	db	08eh,0d8h	;mov ds,ax ;Set DS to Cbios bank
	db	08bh,0eh	;ld cx,[cx86] ;Set CX
	dw	cx86
	db	0c4h,03eh	;les di,[di86] ;Set DI and ES
	dw	di86
	db	0c5h,036h	;lds si,[si86] ;Set SI and DS
	dw	si86
	db	0f2h		;rep
	db	0a5h		;movs word
	db	0ebh		;jmp lop86
	db	-($-lop86+1)
	space	4,10
;	Check blocked disk transfer.
;
;	EXIT	Cbit set, unblocked device.
;		Cbit clear, blocked device.

CHKBKD:
	XRA	A
	STA	ERFLAG		;Clear error flag
	LDA	SEKTYP
	CPI	DSKD1
	JC	CBKD2		;If not blocked device
	CPI	MEMTYP
	JZ	CBKD2

CBKD0:	LHLD	SEKTRK
	MOV	A,H
	ORA	L
	MVI	A,DSKS1		;A = Single density
	JZ	CBKD2		;If zero force non-blocked

CBKD1:	LDA	SAVSEC
	STA	SEKSEC
	XRA	A		;Clear carry flag
	RET

SETACT:	LDA	SEKTYP
CBKD2:	STA	ACTTYP		;Set actual disk type
	LHLD	DMAADR
	SHLD	BUFADR
	LDA	DMAADE
	STA	BUFADE

	LDA	SEKDSK
	STA	ACTDSK
	LHLD	SEKTRK
	SHLD	ACTTRK
	LDA	SAVSEC
	STA	ACTSEC
	STC			;Set carry flag
	RET
	space	4,10
;	Delay	Delay the millisecond count contained in BC.
;
;	Destroys  A and flags.

DELAY:	MVI	A,DELCNT/26
DLAY1:	DCX	B
	INX	B
	DCR	A
	JNZ	DLAY1		;If not 1 millisecond
	DCX	B
	MOV	A,C
	ORA	B
	JNZ	DELAY		;If not desired count
	RET
	space	4,10
;	Print message terminated by zero byte.
;
;	ENTRY	HL -> message buffer, terminated by zero.
;
;	EXIT	HL -> zero byte + 1.
;		A = 0.
;		Z bit set.
;
;	Destroys only HL, Flags, and A registers.

PRINT:	MOV	A,M		;Get a character
	ORA	A
	INX	H
	RZ			;If zero the terminate
	PUSH	H
	MOV	C,A
	CALL	J.COUT		;Output to the console
	POP	H
	JMP	PRINT
