	TITLE	'ROM Boot for CompuPro DISK2 Controller.'
;GBCROM2 - G and G Engineering ROM Boot for CompuPro Disk Controller.
;
;	+-----------------------+
;	|			|
;	|    R O M   B O O T	|
;	|			|
;	+-----------------------+
;
;	COMPUPRO			G and G Engineering
;	Oakland, CA			San Leandro, CA
;
;	This product is a copyright program product
;	of CompuPro and is supplied for use with the
;	CompuPro IEEE 696 Floppy Disk Controller.
;
false	equ	0
true	equ	not false
DELCNT:	EQU	5*1000		;Delay count for 5 Mhz CPU
OPARM:	EQU	*o		;Capture O parameter
gbc10	equ	true		;10 megabyte
gbc20	equ	false		;20 megabyte
gbc26	equ	false		;26 megabyte

;****************************************************************
;*								*
;* CompuPro Disk2 equates.					*
;*								*
;****************************************************************

hdport	equ	0c8h		;Base port address
hdctl	equ	hdport		;Control/Status port
hddata	equ	hdport+1	;Data port

;
;	out	hdctl	7   6   5   4   3   2   1   0
;			|   |   |   |   |   |   |   |
;	attn <----------+   |   |   |   |   |   |   |
;	run <---------------+   |   |   |   |   |   |
;	opcode <----------------+---+---+   |   |   |
;	fault clear <-----------------------+   |   |
;	Unit select <---------------------------+---+
;
;	in	hdctl	7   6   5   4   3   2   1   0
;			|   |   |   |   |   |   |   |
;	opdone* <-------+   |   |   |   |   |   |   |
;	timeout <-----------+   |   |   |   |   |   |
;	not equal <-------------+   |   |   |   |   |
;	over run <------------------+   |   |   |   |
;	ready* <------------------------+   |   |   |
;	seek complete* <--------------------+   |   |
;	write fault* <--------------------------+   |
;	track 0* <----------------------------------+

;	DISK2 Commands

h.red	equ	0c8h		;Read data command
h.wrt	equ	0d0h		;Write data command
h.tim	equ	6		;Time out
h.dvs	equ	80h		;Drive strobe
h.hed	equ	90h		;Head register
h.cyl	equ	88h		;Cylinder register
h.sec	equ	98h		;Sector register
h.sin	equ	0a0h		;Step in
h.sou	equ	80h		;Step out

;	Selector channel equates

selchan	equ	0f0h		;Selector channel port
pri	equ	10		;Disk priority
selbyt	equ	0fh-pri+20h	;Selector channel command byte

	page

	org	100h
	lda	80h
	cpi	2
	jnz	errx
	lda	82h
	cpi	'0'
	jc	errx
	cpi	'3'+1
	jnc	errx
	sui	'0'
	sta	switchs
	jmp	start
errx	lxi	d,msg
	mvi	c,9
	jmp	5
msg	db	0dh,0ah
	db	'Invalid switch parameter.$'
	ds	2048
start

boot:	lxi	sp,stack	;Initialize the stack
	mvi	b,2		;Drive select retry
boot0	mvi	a,h.dvs		;Drive select register
	out	hdctl		;Select the drive select register
	mvi	a,10h		;Drive 0 head 0
	out	hddata		;Select drive 0 and head 0
	in	hdctl		;Get status
	ani	88h		;Test Opdone and Ready
	cpi	80h		;Test for opdone and ready*
	jz	boot1		;If drive ready
	dcr	b		;Update repeat count
	jnz	boot0		;If retry
	lxi	b,500		;Delay 500 milliseconds
	lxi	h,boot
delay	mvi	a,delcnt/26
dlay1	dcx	b
	inx	b
	dcr	a
	jnz	dlay1
	dcx	b
	mov	a,c
	ora	b
	jnz	delay
	pchl

boot1	mvi	a,4		;Get fault clear bit
	out	hdctl		;Clear any faults

home	in	hdctl		;Get status
	ani	1		;Test track zero bit
	jz	home3		;If at track 0
	mvi	a,4+h.sou	;Seek out pattern
	out	hdctl		;Set up direction
	if	gbc20
	mvi	b,0		;Auto step
	endif
	if	gbc10
	mvi	b,0		;Auto step
	endif
	if	gbc26
	mvi	b,1		;Step once
	endif
home1	in	hddata		;Step one track
	dcr	b		;Update repeat count
	jnz	home1		;If not all steps
home2	in	hdctl		;Get status
	ani	4		;Test seek complete
	jnz	home2		;If not homed
	if	gbc26
	jmp	hdsk0		;If more steps
	endif
home3:
	if	gbc26
	lxi	b,50		;50 millisecond head settle
	lxi	h,read
	jmp	delay
read:
	endif

;
;	Read a sector
;
hdxfer	mvi	b,10		;Retry count
hdxfr1	mvi	a,h.dvs		;Drive slect register
	out	hdctl		;Select the drive select register
	mvi	a,10h		;Drive 0 head 0
	out	hddata		;Select drive 0 and head 0
	mvi	a,h.cyl		;Cylinder select register
	out	hdctl		;Select the cylinder register
	xra	a		;Zero A
	out	hddata		;Select cylinder zero
	mvi	a,h.hed		;Head select register
	out	hdctl		;Select the head register
	xra	a		;Zero A
	out	hddata		;Select head zero
	mvi	a,h.sec		;Sector select register
	out	hdctl		;Select the sector register
	xra	a		;Get the sector to read
	out	hddata		;Select the cylinder
	lxi	h,100h		;Get transfer address
	in	selchan		;Ready the selector channel
	xra	a		;Zero A
	out	selchan		;MSB of DMA
	mov	a,h		;High byte of dma address
	out	selchan		;Middle byte of DMA
	mov	a,l		;Low byte of dma address
	out	selchan		;LSB of DMA
	mvi	a,80h+selbyt	;Selector channel read command
	out	selchan		;Set up the selector channel
	mvi	a,h.red		;Disk2 read command
	out	hdctl		;Read the sector
hdxfr2	in	hdctl		;Get status
	ani	80h		;Test op done
	jnz	hdxfr2		;If operation not done
	in	hdctl		;Get status
	ani	50h		;Mask timeout and overrun
	jz	hdxfr3		;If read ok
	dcr	b		;Update retry count
	jnz	hdxfr1		;If retry attempts
	jmp	boot		;Start all over
hdxfr3	mvi	c,0
switchs	equ	$-1
	jmp	100h		;Enter the secondary boot

	ds	10
stack	db	0
