;	CompuPro Interfacer board equates.

GBP0:	EQU	0		;Serial port zero
GBP1:	EQU	2		;Serial port one
GBP2:	EQU	4		;Serial port two
GBDATA:	EQU	0		;Data on even I/O unit
GBSTAT:	EQU	1		;Status on odd I/O unit

GBTBMT:	EQU	0000_0001b	;Transmit buffer empty
GBDAV:	EQU	0000_0010b	;Data available
GBOPT:	EQU	0000_0100b	;Optional status line
GBPE:	EQU	0000_1000b	;Parity error
GBOR:	EQU	0001_0000b	;Overrun error
GBFE:	EQU	0010_0000b	;Framing error
GBCC:	EQU	0100_0000b	;RS 232 CC input
GBCB:	EQU	1000_0000b	;RS 232 CB input

GBRIE:	EQU	0000_0001b	;Receiver interrupt enable
GBTIE:	EQU	0000_0010b	;Transmitter interrupt enable
GBCD:	EQU	0000_0100b	;RS 232 CD output
GBCA:	EQU	0000_1000b	;RS 232 CA output
GBTSB:	EQU	0001_0000b	;Number of stop bits
GBNP:	EQU	0010_0000b	;No parity
GBEPS:	EQU	0100_0000b	;Even parity
GBNBI:	EQU	1000_0000b	;number of bits/character
	page
	space	4,10
;	L i s t   O u t p u t.
;
;	Send a character to the list device.  If the list
;	device is not ready to receive a character wait
;	until the device is ready.
;
;	ENTRY	C = ASCII character to be output.

LIST:	LDA	IOBYTE		;Get IOBYTE status
	ANI	0C0H		;Check for UL1:
	SUI	0C0H
	JZ	UL1
LIST1:	IN	GBP1+GBSTAT	;Get status
	ANI	GBCC+GBTBMT
	SUI	GBTBMT
	JNZ	LIST1
	MOV	A,C
	OUT	GBP1+GBDATA
	RET
	space	4,10
;	U L 1 :    L I S T   O U T P U T
;
;	Send a character to the second interfacer
;

UL1:	IN	GBP2+GBSTAT	;Get status
	ANI	GBCC+GBTBMT
	SUI	GBTBMT
	JNZ	UL1
	MOV	A,C
	OUT	GBP2+GBDATA
	RET
	space	4,10
;	L i s t   S t a t u s.
;
;	Return the ready status for the list device.
;
;	EXIT	A = 0 (zero), list device is not ready to
;		accept another character.
;		A = FFh (255), list device is ready to accept
;		a character.

LISTST:	LDA	IOBYTE
	ANI	0C0H		;Ceck for UL1:
	SUI	0C0H
	JZ	UL1ST
	IN	GBP1+GBSTAT
LSTAT:	ANI	GBCC+GBTBMT
	SUI	GBTBMT
	RZ			;If ready
	ORI	0FFh
	RET

UL1ST:	IN	GBP2+GBSTAT
	JMP	LSTAT
