	page

;	CompuPro Interfacer 3 support routines

GBI3:	EQU	10h		;Interfacer 3 Base address
GBI3D:	EQU	GBI3+0		;Uart data location
GBI3S:	EQU	GBI3+1		;Uart status
GBI3M:	EQU	GBI3+2		;Uart mode register
GBI3C:	EQU	GBI3+3		;Uart command register
GBI3U:	EQU	GBI3+7		;Uart select register

GBI3DV:	EQU	0000_0010b	;Interfacer 3 Data Available
GBI3MT:	EQU	0000_0001b	;Interfacer 3 Transmit Buffer Empty
GBI3DS:	EQU	1000_0000b	;Interfacer 3 Data set ready
CON:	EQU	7		;Interfacer 3 Console Select
PRN:	EQU	4		;Interfacer 3 Printer Select
ULS:	EQU	5		;Interfacer 3 User list 1 select
	page
;	C O N S O L   I N I T I A L I Z A T I O N
;
;	This routine performs the initialization required by
;	the Interfacer 3.
;

I3INIT:
	lxi	h,bauds		;Point to initialization table
	call	cinit		;initialize console
	call	cinit		;initialize list
cinit:	mov	a,m		;Get relative port number for ul1:
	out	gbi3u		;Select console
	inx	h		;Skip relative port number byte
	mov	a,m		;Get mode register 1 byte
	inx	h		;Skip mode register 1 byte
	out	gbi3m		;Set up mode register 1
	mov	a,m		;Get mode register byte
	inx	h		;Skip mode register 2 byte
	out	gbi3m		;Set up mode register 2
	mov	a,m		;Get command byte
	inx	h		;Skip command register byte
	out	gbi3c		;Set up command register
	ret
	space	4,10
	IF 	INTER3 
;	C O N S O L   S T A T U S
;
;	This routine samples the Console status and returns the
;	following values in the A register.
;
;	EXIT	A = 0 (zero), means no character
;		currently ready to read.
;
;		A = FFh (255), means character
;		currently ready to read.

I3CONST:
	MVI	A,CON
	OUT	GBI3U
	IN	GBI3S		;Input from port
	ANI	GBI3DV		;Mask data available
	RZ			;If data not available
	ORI	0FFH
	RET
	space	4,10
;	C O N S O L   I N P U T
;
;	Read the next character into the A register, clearing
;	the high order bit.  If no character currently ready to
;	read then wait for a character to arrive before returning.
;
;	EXIT	A = character read from terminal.

I3CONIN:
	MVI	A,CON
	OUT	GBI3U
	IN	GBI3S		;Get status from uart
	ANI	GBI3DV
	JZ	I3CONIN
	IN	GBI3D
	ANI	7Fh
	RET
	space	4,10
;	C O N S O L   O U T P U T
;
;	Send a character to the console.  If the console
;	is not ready to receive a character wait until
;	the console is ready.
;
;	ENTRY	C = ASCII character to output to console.

I3CONOUT:
	MVI	A,CON
	OUT	GBI3U
	IN	GBI3S		;Get uart status
	ANI	GBI3MT		;Test if buffer empty
	JZ	I3CONOUT
	MOV	A,C
	OUT	GBI3D
	RET
	space	4,10
	ENDIF 			; INTER3
;	L i s t   O u t p u t.
;
;	Send a character to the list device.  If the list
;	device is not ready to receive a character wait
;	until the device is ready.
;
;	ENTRY	C = ASCII character to be output.

I3LIST:	
;  UL1 OMITTED IN M26 VERSION TO SAVE SPACE
	IF 	NOT GBC26
	LDA	IOBYTE		;Get IOBYTE status
	ANI	0C0H		;Check for UL1:
	SUI	0C0H
	MVI	A,ULS
	JZ	I3UL1
	ENDIF
	MVI	A,PRN
I3UL1:	OUT	GBI3U
I3LS1:	IN	GBI3S
	ANI	GBI3DS+GBI3MT
	SUI	GBI3DS+GBI3MT
	JNZ	I3LS1
	MOV	A,C
	OUT	GBI3D
	RET
	space	4,10
;	L i s t   S t a t u s.
;
;	Return the ready status for the list device.
;
;	EXIT	A = 0 (zero), list device is not ready to
;		accept another character.
;		A = FFh (255), list device is ready to accept
;		a character.

I3LST:	
; UL1 NOT USED IN M26 VERSION TO SAVE SPACE	
	IF	NOT GBC26
	LDA	IOBYTE
	ANI	0C0H		;Ceck for UL1:
	SUI	0C0H
	MVI	A,ULS
	JZ	I3UL
	ENDIF
	MVI	A,PRN
I3UL:	OUT	GBI3U
	IN	GBI3S
	ANI	GBI3DS+GBI3MT
	SUI	GBI3MT+GBI3DS
	MVI	A,0FFH
	RZ
	XRA	A
	RET

;	Endx	GBcbiov3.asm
