	page

;	CompuPro System Support 1 equates.

GBSS:	EQU	50h		;System Support starting port
GBMP0:	EQU	GBSS+0		;Master PIC port 0
GBMP1:	EQU	GBSS+1		;Master PIC port 1
GBSP0:	EQU	GBSS+2		;Slave PIC port 0
GBSP1:	EQU	GBSS+3		;Slave PIC port 1
GBT0:	EQU	GBSS+4		;Timer number 0
GBT1:	EQU	GBSS+5		;Timer number 1
GBT2:	EQU	GBSS+6		;Timer number 2
GBTC:	EQU	GBSS+7		;Timer control port
GBFPPD:	EQU	GBSS+8		;Floating point processor data port
GBFPPC:	EQU	GBSS+9		;Floating point processor command port
GBCLKC:	EQU	GBSS+10		;Clock command port
GBCLKD:	EQU	GBSS+11		;Clock data port
GBUD:	EQU	GBSS+12		;Uart data port
GBUS:	EQU	GBSS+13		;Uart status port
GBUM:	EQU	GBSS+14		;Uart modem port
GBUC:	EQU	GBSS+15		;Uart command port

SSDAV:	EQU	0000_0010b	;System Support Data Available
SSTBMT:	EQU	0000_0001b	;System Support Transmit Buffer Empty
	page
;	C O N S O L   I N I T I A L I Z A T I O N
;
;	This routine performs the initialization required by
;	the System Support UART.
;

sTINIT:
	lxi	h,bauds		;Point to initialization table
	inx	h		;Skip relative port number byte
	mov	a,m		;Get mode register 1 byte
	inx	h		;Skip mode register 1 byte
	out	gbum		;Set up mode register 1
	mov	a,m		;Get mode register byte
	inx	h		;Skip mode register 2 byte
	out	gbum		;Set up mode register 2
	mov	a,m		;Get command byte
	out	gbuc		;Set up command register
	ret
	space	4,10
;	C O N S O L   S T A T U S
;
;	This routine samples the Console status and returns the
;	following values in the A register.
;
;	EXIT	A = 0 (zero), means no character
;		currently ready to read.
;
;		A = FFh (255), means character
;		currently ready to read.

sCONST:
	IN	GBUS		;Input from port
	ANI	SSDAV		;Mask data available
	RZ			;If data not available
	ORI	0FFH
	RET
	space	4,10
;	C O N S O L   I N P U T
;
;	Read the next character into the A register, clearing
;	the high order bit.  If no character currently ready to
;	read then wait for a character to arrive before returning.
;
;	EXIT	A = character read from terminal.

sCONIN:
	IN	GBUS		;Get status from uart
	ANI	SSDAV
	JZ	sCONIN
	IN	GBUD
	ANI	7Fh
	RET
	space	4,10
;	C O N S O L   O U T P U T
;
;	Send a character to the console.  If the console
;	is not ready to receive a character wait until
;	the console is ready.
;
;	ENTRY	C = ASCII character to output to console.

sCONOUT:
	IN	GBUS		;Get uart status
	ANI	SSTBMT		;Test if buffer empty
	JZ	sCONOUT
	MOV	A,C
	OUT	GBUD
	RET

;	Endx	GBcbiou3.asm
