	page
;
	link	bios		;configuration equates

BIOSLN	EQU	1400H		;Bios length

CR:	EQU	0Dh
LF:	EQU	0Ah
DELCNT:	EQU	5*1000		;Delay count for 5 Mhz CPU


OPARM:	EQU	*o		;Capture O parameter
K:	EQU	1024
	IF	OPARM < (64+2)	;If absolute
MSIZE:	EQU	OPARM		;Size of CP/M memory
BIOS:	EQU	MSIZE*K-BIOSLN	;Start of CP/M jump table
LWAMEM:	EQU	MSIZE*K-1
	MSG	'Assembling for BIOS LWA of ',LWAMEM,'h.'
	ENDIF
	IF	OPARM > (64+1)	;If PRL generation
MSIZE:	EQU	(OPARM+BIOSLN)/K	;Size of CP/M memory
BIOS:	EQU	OPARM		;Start of CP/M jump table
LWAMEM:	EQU	OPARM+BIOSLN-1
	MSG	'Assembling for relocation.'
	ENDIF
BDOS:	EQU	BIOS-0E00h+6	;BDOS entry point
CCP:	EQU	BIOS-1600h
	space	4,10
;	Page Zero Definitions.
IOBYTE:	EQU	3		;Location of IOBYTE
CDISK:	EQU	4		;Location of current disk
BIORAM:	EQU	40h		;16 ram cells
OPTS:	EQU	BIORAM		;GBC DISK1 board switch options
;		BIORAM+1	;GBC (cell before TICK)
TICK:	EQU	BIORAM+2	;GBC Sample period
DBUF:	EQU	80h		;Default sector buffer
	space	4,10
;	Extended bank addresses.

CXADR:	EQU	00h		;CP/M Bank
BXADR:	EQU	00h		;BIOS Bank


;	Disk Input / Output port assignments.

FDPORT	EQU	0C0h		;Base port address for Controller
FDCS	EQU	FDPORT		;Status register
FDCD	EQU	FDPORT+1	;Data register
DMA	EQU	FDPORT+2	;Dma address (when write)
INTS	EQU	FDPORT+2	;Status Register (when read)
SER	EQU	FDPORT+3	;Serial port

;	Controller function definitions

F.SPEC	=	03	;Specify
F.DSTS	=	04	;Drive status
F.WRT	=	05	;Write data
F.RDAT	=	06	;Read data
F.RECA	=	07	;recalibrate
F.RSTS	=	08	;Read status
F.DRID	=	10	;Read ID
F.SEEK	=	15	;Seek


;	Disk drive constants

STEPR:	=	8		;Shugart SA 800
SRT:	=	16-STEPR	;Controller value
HUT:	=	240/16		;Head unload = 240 ms
HLT:	=	35		;Head load = 35 ms
ND:	=	0b		;Set DMA mode
	space	4,10
;		   7    6    5    4    3    2    1    0
;		+----+----+----+----+----+----+----+----+
;	ST0	|    IC   | SE | EC | NR | HD |    US   |
;		+----+----+----+----+----+----+----+----+
;	ST1	| EN |    | DE | OR |    | ND | NW | MA |
;		+----+----+----+----+----+----+----+----+
;	ST2	|    | CM | DD | WC | SH | SN | BC | MD |
;		+----+----+----+----+----+----+----+----+
;	ST3	| FT | WP | RY | T0 | TS | HD |    US   |
;		+----+----+----+----+----+----+----+----+
;
;	IC - Interrupt code.
;		00 - Normal termination by TC signal.
;		01 - Abnormal termination.
;		10 - Invalid command.
;		11 - Abnormal termination (READY dropped).
;
;	SE - Seek end, inticates end of seek.
;
;	EC - Equipment Check.
;
;	NR - Not ready.
;
;	HD - State of the head select.
;
;	US - State of the unit select.
;
;
;	EN - End of Cylinder, Read EOT sector.
;
;	DE - CRC error in ID or data fields.
;
;	OR - Over run.
;
;	ND - No Data.
;
;	NW - Not writable (write protect detected)
;
;	MA - Missing address mark.
;
;
;	CM - Control Mark (deleted data address mark).
;
;	DD - CRC error in data field.
;
;	WC - Wrong cylinder.
;
;	SH - Scan equal hit.
;
;	SN - Scan not satisfied.
;
;	BC - Bad cylinder.
;
;	MD - Missing data mark.
;
;
;	FT - Fault.
;
;	WP - Write protect signal.
;
;	RY - Ready.
;
;	T0 - Track zero.
;
;	TS - Two sided disk is inserted.
	space	4,10
;****************************************************************
;*								*
;* CompuPro Disk2 equates.					*
;*								*
;****************************************************************

hdport	equ	0c8h		;Base port address
hdctl	equ	hdport		;Control/Status port
hddata	equ	hdport+1	;Data port

;
;	out	hdctl	7   6   5   4   3   2   1   0
;			|   |   |   |   |   |   |   |
;	attn <----------+   |   |   |   |   |   |   |
;	run <---------------+   |   |   |   |   |   |
;	opcode <----------------+---+---+   |   |   |
;	fault clear <-----------------------+   |   |
;	Unit select <---------------------------+---+
;
;	in	hdctl	7   6   5   4   3   2   1   0
;			|   |   |   |   |   |   |   |
;	opdone* <-------+   |   |   |   |   |   |   |
;	timeout <-----------+   |   |   |   |   |   |
;	not equal <-------------+   |   |   |   |   |
;	over run <------------------+   |   |   |   |
;	ready* <------------------------+   |   |   |
;	seek complete* <--------------------+   |   |
;	write fault* <--------------------------+   |
;	track 0* <----------------------------------+

;	DISK2 Commands

h.red	equ	0c8h		;Read data command
h.wrt	equ	0d0h		;Write data command
h.tim	equ	6		;Time out
h.dvs	equ	80h		;Drive strobe
h.hed	equ	90h		;Head register
h.cyl	equ	88h		;Cylinder register
h.sec	equ	98h		;Sector register
h.sin	equ	0a0h		;Step in
h.sou	equ	80h		;Step out

;	Selector channel equates

selchan	equ	0f0h		;Selector channel port
pri	equ	10		;Disk priority
selbyt	equ	0fh-pri+20h	;Selector channel command byte
