/*
 *    Shell sort modifed for determining intervals. Knuth pg 85.
 */

ssort(n,comp,swap)

unsigned	n;		/* number of records to sort */
int	(*comp)();	/* pointer to function which compares two record keys
			 * and with K[i] compared to K[j], returns
			 * K[i] - K[j] (if K[i]>K[j] val>0, K[i]<K[j] val<0)
			*/
int	(*swap)();	/* pointer to function which swaps two records */

{
	int		m;			/* interval indicator */
	int		i,j,k,l;		/* internal counters */

	m=n;				/* initialize interval */

	while(m/=2){			/* while an interval exists */

		k=n-m;			/* initialize i */
		j=1;			/* initialize j */
loop1:
		i=j;
loop:
		l=i+m;
		if((*comp)(i-1,l-1)> 0){
			(*swap)(i-1,l-1);
			i=i-m;
			if(i>=1)
				goto loop;
		}
		if(++j>k)
			continue;
		goto loop1;
	}
}
