/********************************************************************
 *
 *	Program: 1
 *
 *	Bubble Sort as described by Knuth Pg 107
 *
 *	Author: Timothy C. Leslie
 *
*********************************************************************
 *
 *	This program performs a bubble sort on n records.  It is
 *	independent of the record and key.  This independence is
 *	possible because pointers to a key comparison funcion and
 *	record swaping function are passed to the sort. The function
 *	calling convention is:
 *
 *	bsort(n,comp,swap)
 *
 *	where:	n is the number of records to sort.
 *		comp is a pointer to a function which will compare
 *		  two record keys and return an integer representing
 *		  the logical relationship of the keys.
 *		  <0 key[i] <  key[j] (ascending) key[i] > key[j] (descending)
 *		  =0 key[i] == key[j]
 *		  >0 key[i] >  key[j] (ascending) key[i] < key[j] (descending)
 *		swap is a pointer to a function which will swap two
 *		  records.
 *
 *	Both comp and swap are called with two parameters which are
 *	indicies to records with the first record being 0 and the last
 *	record being n-1.
 *
*********************************************************************
 *
 *	This program illustrates the use of pointers to functions.
 *	In this program the pointers to functions are used to allow
 *	the sort algorithm to function independent of the data record.
 *
*********************************************************************
 *
 *			Comments
 *
 *	Line 0001	This is the main entry point for the bubble
 *			sort.  Three parameters are passed.
 *
 *	Line 0002	The number of records to be sorted is the
 *			first parameter and is an unsigned value.
 *
 *	Line 0003	The second parameter is a pointer to a function
 *			which compares all keys of two records, and
 *			returns an integer which expresses the following
 *			relationships for an ascending order sort.
 *
 *			r[i]-r[j] such that:
 *				if (r[i] > r[j])
 *					return (1);
 *				if (r[i] == r[j])
 *					return (0);
 *				if (r[i] < r[j])
 *					return (-1);
 *
 *			If fact if the two keys were integers the code
 *			can be:
 *
 *				return(r[i]-r[j]);
 *
 *			bsort() will adjust the pointers i and j so that
 *			they are relative base 0.
 *
 *	Line 0004	The third parameter is a pointer to a function
 *			which swaps two records.
 *
 *			bsort() will adjust the pointers i and j so that
 *			they are relative base 0.
 *
 *	Line 0006	t is a variable used to determine if a swap has
 *			occured.
 *
 *
 *	Line 0007	j is a variable used to index records.
 *
 *	Line 0008	This function assumes that at least two records
 *			exist for sorting. Therefore at least one
 *			comparison is to be made.
 *
 *	Line 0009	The swap flag is initially set to FALSE.
 *
 *	Line 0010	The record numbers vary from 0 to n-1. Since
 *			the 'for' loop consists of a single statement
 *			braces are not required.
 *
 *	Line 0011	The compare function is called with the two
 *			record counts as parameters. The parenthesis
 *			are required around the *comp because of the
 *			heirarchy of C. (function calls have higher
 *			precedence than indirection)
 *
 *	Line 0012	If a swap is required based on the results of
 *			the compare, the swap is executed here.
 *
 *	Line 0013	Since a swap occured, set the swap flag TRUE (1).
 *
 *	Line 0015	Continue sort until no swaps occur.
 *
**************************************************************************/


bsort(n,comp,swap)						/* 0001 */

unsigned	n;						/* 0002 */
int	(*comp)();						/* 0003 */
int	(*swap)();						/* 0004 */

{								/* 0005 */
	unsigned	t;					/* 0006 */
	unsigned	j;					/* 0007 */

	do{							/* 0008 */
		t=0;						/* 0009 */
		for(j=0;j<n-1;++j)				/* 0010 */
			if((*comp)(j,j+1) > 0){			/* 0011 */
				(*swap)(j,j+1);			/* 0012 */
				t=1;				/* 0013 */
			}					/* 0014 */
	}while(t);						/* 0015 */
}								/* 0016 */

/*********************** End of Function ********************************/
