
;REMOV"   A PROGRAM TO REMOVE ALL QUOTE MARKS FROM A FILE
;USED AFTER CREATING A FILE WITH EBASIC WHICH LEAVES
;THE " CHARACTERS AS AN ARTIFACT OF ITS METHOD OF WRITING
;DISK FILES.

;REFER TO THE CP/M INTERFACE GUIDE (C) DIGITAL RESEARCH

	ORG	100H
BDOS	EQU	5	;DOS ENTRY
CR	EQU	13	;ASCII CAR. RET.
LF	EQU	10	;ASCII LINE FEED
OPENF	EQU	15	;OPEN FILE CODE
CLOSF	EQU	16	;CLOSE FILE CODE
READF	EQU	20	;READ FUNCTION CODE
TYPEF	EQU	2	;TYPE CHAR AT CONSOLE
CONS	EQU	1	;INPUT CHAR FROM CONSOLE
RESTRT	EQU	0	;CP/M REBOOT
WRITF	EQU	21	;WRITE RECORD CODE
DMAF	EQU	26	;SER DMA ADDRESS CODE
TEXTF	EQU	9	;PRINT TEXT AT CONSOLE


FCB	EQU	5CH	;FILE CONTROL BLOCK ADDRESS
BUFF	EQU	80H	;DISK INPUT BUFFER ADDRESS

;SET UP THE STACK

	LXI	H,0
	DAD	SP
	SHLD	OLDSP
	LXI	SP,STKTOP
	CALL	SETUP	;OPEN FILE
	CALL	READ
	LXI	H,FBUFF
	LXI	D,FBUFF
SLOOP	MOV	A,M
	CPI	'"'
	JZ	OMIT
	STAX	D
	INX	D
OMIT	INX	H
	CPI	1AH
	JNZ	SLOOP
	PUSH	D
	CALL	CLOSE
	CALL SETUP	;OPEN FILE
	POP	H
	SHLD	ENDAD
	CALL	WRITE
	LHLD	OLDSP
	SPHL
	JMP	RESTRT

;READ FILE TO FBUFF

READ	LXI	D,FBUFF
RDLP	PUSH	D	;SAVE CURRENT BUFFER POSITION
	MVI	C,DMAF	;SET ADRESS TO READ TO
	CALL	BDOS
	LXI	D,FCB
	MVI	C,READF	;READ A SECTOR
	CALL	BDOS
	POP	H	;GET BUFFER POSITION
	LXI	D,128	;MOVE UP 128
	DAD	D	;TO GET NEW POS
	XCHG		;PUT IT IN DE
	CPI	0	;ZERO MEANS OK
	JZ	RDLP
	CPI	1	;ONE MEANS EOF
	RZ
DERR	LXI	D,DERMSG	;TELL ABOUT ERROR
	MVI	C,TEXTF	;TYPE A LINE ON CONSOLE
	CALL	BDOS
	JMP	RESTRT	;BACK TO CP/M CONTROL

WRITE	LXI	D,FBUFF
WRLP	PUSH	D
	MVI	C,DMAF	;SET ADDRESS FOR WRITE
	CALL	BDOS
	LXI	D,FCB
	MVI	C,WRITF
	CALL	BDOS
	POP	H
	CPI	2	;EOF
	JZ	WREOF
	CPI	0
	JNZ	DERR
	LXI	D,128
	DAD	D
	XCHG
	LHLD	ENDAD
	MOV	A,D
	CMP	H
	JC	WRLP
	MOV	A,E
	CMP	L
	JC	WRLP
WREOF	RET

SETUP	XRA	A
	STA	FCB+32	;SET REC TO 0
	LXI	D,FCB
	MVI	C,OPENF
	CALL	BDOS
	CPI	255
	JZ	NOFIL
	RET

NOFIL	LXI	D,NOFMS
	MVI	C,TEXTF
	CALL	BDOS
	JMP	RESTRT

CLOSE	LXI	D,FCB
	MVI	C,CLOSF
	CALL	BDOS
	CPI	255
	JZ	DERR
	RET

NOFMS	DB	'FILE NOT FOUND',CR,LF,'$'
DERMSG	DB	'DISK ERROR',CR,LF,'$'

OLDSP	DS	2	;OLD STACK POINTER SAVE
ENDAD	DS	2	;TEMP STORE OF BUFF END ADDR
	DS	64	;STACK
STKTOP

FBUFF			;FILE BUFFER
	END	100H
