REM WRITES A FILE ON DISK FOR INPUT TO ASM
REM  CONTAINING DB EXPRESSIONS FOR 256 POINTS
REM FOR EACH WAVEFORM OF 4 VOICES
REM  TO DEFINE THE WAVEFORM TABLE FOR MUSIC4
DIM POINT(256)
INPUT "FILE NAME";W$
FILE W$
HT$=CHR$(9)
ORG$=HT$+"ORG"+HT$+"100H"
DB$=HT$+"DB"+HT$
PRINT #1; ORG$
FOR WF=1 TO 4
PRINT "WAVEFORM ";WF
INPUT "PLOT (Y OR N)"; PLT$
IF PLT$<>"Y" THEN 50
INPUT "PLOT INTERVAL"; STP
50 INPUT "WAVE TYPE...S=SINE,Q=SQUARE,R=RAMP,T=SAWTOOTH";WV$
IF WV$="Q" THEN GOTO 600
IF WV$="R" THEN GOTO 630
IF WV$="T" THEN GOTO 650
 INPUT "SCALING--(ADD, MULT)";ADD,MULT
INPUT "FIRST (HARMONIC,COEF.,PHASE ADV.)";HAR1,CO1,PHASE1
INPUT "2ND (HARMONIC,COEF.,PHASE ADV.)";HAR2,CO2,PHASE2
INPUT "3RD (HARMONIC,COEF.,PHASE ADV.)";HAR3,CO3,PHASE3
INPUT "4TH (HARMONIC, COEF., PHASE ADV.)";HAR4,CO4, PHASE4
FOR I=0 TO 255
A=360/256*I/57.296
WAVE=CO1*SIN(HAR1*A+PHASE1)+CO2*SIN(HAR2*A+PHASE2)+CO3*SIN(HAR3*A+PHASE3)
WAVE=WAVE+CO4*SIN(HAR4*A+PHASE4)
POINT(I)=INT((WAVE+ADD)*MULT)
IF PLT$ <>  "Y" THEN 100
IF INT(I/STP)<>I/STP THEN 100
PRINT I;POINT(I);TAB(9+POINT(I));"."
100 NEXT I
110 J=0
120 LINE$=DB$
FOR I=1 TO 8
LINE$=LINE$+MID$(STR$(POINT(J)),1,2)
IF I<>8 THEN LINE$=LINE$+","
J=J+1
NEXT I
PRINT  #1; LINE$
IF J<255 THEN 120
NEXT WF
CLOSE (1)
STOP
600 FOR I=0 TO 255
POINT(I)=INT(I/128)*63
GOSUB 660
NEXT I
GOTO 110

630 FOR I=0 TO 255
POINT(I)=63-INT(I/4)
GOSUB 660
NEXT I
GOTO 110

650 FOR I=0 TO 127
POINT(I)=INT(I/2)
GOSUB 660
NEXT I
FOR I=128 TO 255
POINT(I)=INT((255-I)/2)
GOSUB 660
NEXT I
GOTO 110

660 IF PLT$<>"Y" THEN 670
IF INT(I/STP)<>I/STP THEN 670
PRINT POINT(I);TAB(POINT(I)+6);"."
670 RETURN
END
