T
	LDAX	D
	MOV	C,A
	MVI	B,0
;
;	COPY BLOCK FROM BEGINNING
;	HL IS DESTIN ADDR, DE IS SOURCE ADDR, BC IS COUNT
;
LMOV:	LDAX	D
	MOV	M,A
	INX	D
	INX	H
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	LMOV
	RET
;
;	COPY BLOCK STARTING AT END
;	HL IS DESTIN ADDR, DE IS SOURCE ADDR, BC IS COUNT
;
RMOV:	LDAX	D
	MOV	M,A
	DCX	H
	DCX	D
	DCX	B
	MOV	A,B
	ORA	C
	JNZ	RMOV
	RET
;
;	COMPUTE FILE MOVE COUNT
;
;	BC GETS (EOFA)-(HL), RET Z SET MEANS ZERO COUNT
;
NMOV:	LDA	EOFA
	SUB	L
	MOV	C,A
	LDA	EOFA+1
	SBB	H
	MOV	B,A
	ORA	C
	RET
;
;	ADD A TO HL
;
ADR:	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET
;
;	CHECK FOR FILE OVERFLOW, LEAVES NEW EOFA IN DE
;	A HAS INCREASE IN SIZE
;
FULL:	LHLD	EOFA
	CALL	ADR
	XCHG
	LXI	H,MEMTOP
	CALL	DCMP
	JNC	E8
	RET
;
;	COMMANDS
;
CSCR:	LHLD	BOFA
	MVI	M,EOF
	SHLD	EOFA
;
;	'CLEAR'
;
CCLEAR:	LHLD	EOFA	;CLEAR FROM EOFA TO MEMTOP
	INX	H
	SHLD	MATA
	LHLD	STB
	XCHG
	LXI	H,MEMTOP;END OF ASSIGNED MEMORY
CCLR1:	XRA	A
	STAX	D
	CALL	DCMP
	INX	D
	JNZ	CCLR1
	LHLD	MEMTOP
	SHLD	STB
	LXI	H,CSTKL+CSTKSZ-1
	MVI	M,ETYPE
	SHLD	CSTKA
	LXI	H,ASTKL+ASTKSZ+FPSIZ-1
	SHLD	ASTKA
	RET
;
;	'NULL'
;
CNULL:	CALL	INTGER
	JC	E3	;NO ARGUMENT SUPPLIED
	MOV	A,L
	STA	NULLCT
	JMP	CMND1
;
;	'LIST'
;
CLIST:	CALL	GC
	CPI	CR
	LXI	D,0
	JZ	CL0	;JUMP IF NO ARGUMENT SUPPLIED
	CALL	INTGER	;ERROR DEFAULT IS LIST
CL0:	LHLD	BOFA
CL1:	MOV	A,M
	DCR	A
	RZ
	INX	H
	CALL	DCMP
	DCX	H	;POINT TO COUNT CHAR AGAIN
	JC	CL2
	JZ	CL2
;
;	INCREMENT TO NEXT LINE
;
	MOV	A,M
	CALL	ADR
