	H,DMAR SHL 8 OR B512
	SHLD	WRITOP		;do 512 byte write
	ENDIF
;
	CALL	SETDEN		;set up for double density
	JMPR	RNTRK
;
SETDEN:	LDA	CLATCH		;get current code
	ORI	8		;set double density code
	STA	CLATCH		;save it
	CALL	WAIT1		;set latch for d.density
	LDA	SIDED		;doing doub sided?
	ORA	A		;= to 0?
	JRNZ	RSIDED		;not =, doing double sided
	MVI	A,5BH		;step command.
	OUT	DCOM		;issue it.
	IN	WAIT		;wait until done.
	RET
;
RSIDED:	LDA	CLATCH		;get current drive code
	ORI	40H		;switch side
	CALL	WAIT1		;switch side now
	RET
;
RRED	EQU	$
;
	IF	DMACNTL AND TARBELL
	CALL	DMARW		;use common routine
	ENDIF
;
	IF	NOT DMACNTL	;if not using dma control.
DATA	EQU	DISK+3		;data port.
;
	LHLD	SYSVAL
	MVI	A,0D0H		;force intrp command
	OUT	DCOM
	MOV	A,C		;get sector to do
	OUT	SECT
	CALL	HDLD		;check for head loaded
	ORA	B		;merge in disk command
	OUT	DCOM		;send disk command
RLOOP:	IN	WAIT		;wait for drq.
	ORA	A		;set flags.
	JP	RCHK		;jump if done.
	IN	DATA
	MOV	M,A		;put in memory.
	INX	H		;increment pointer.
	JMPR	RLOOP		;loop until done.
RCHK	EQU	$
	ENDIF

	SHLD	SYSVAL		;save next address
	IN	DSTAT		;read status.
	ANI	09DH		;look at error bits.
	RZ			;ok if zero.
	DCR	E		;decrement retry count.
	JRNZ	RBLOOP		;try again if not zero.
	LXI	D,RRERR		;retry exausted
	CALL	PRINT		;print the error message
	JMP	BOOT		; and return to cpm.
;
DSKWRT	EQU	$
;
	IF	DMACNTL AND TARBELL
	LXI	H,DMAW SHL 8 OR B128
	SHLD	WRITOP
	ENDIF
;
	MVI	A,SDSPT+1	;number of single density sects
	STA	SECTSZ+1
	MVI	E,RTCNT		;get retry count.
BLOOP:	LXI	H,SYSTEM	;cp/m starts here.
	SHLD	SYSVAL		;save it
	MVI	D,NSECTS	;number of sectors to write.
WNTRK:	MVI	C,1		;sector number.
	MVI	B,0A0H		;for head load.
WNSEC:	CALL	WRIT		;write first sector.
	DCR	D		;if done,
	RZ
	INR	C		;increment sector count.
	MOV	A,C		;done with
SECTSZ:	CPI	SDSPT+1		;this track?
	JRC	WNSEC		;if not,write next sector.
	MVI	A,DDSPT+1	;number of doub den sectors
	STA	SECTSZ+1	;modify the code.
;
	IF	DMACNTL AND TARBELL
	LXI	H,DMAW SHL 8 OR B512
	SHLD	WRITOP		;do 512 byte write
	ENDIF
;
	CALL	SETDEN
	JMPR	WNTRK		;write next track.
;
WRIT	EQU	$
;
	IF	DMACNTL AND TARBELL
	CALL	DMARW		;use common routine
	ENDIF
;
	IF	NOT DMACNTL	;if not using dma control.
	LHLD	SYSVAL
	MVI	A,0D0H		;force intrp command
	OUT	DCOM
	MOV	A,C		;get sector to do
	OUT	SECT
	CALL	HDLD		;check for head loaded
	ORA	B		;merge in disk command
	OUT	DCOM		;send disk command
WLOOP:	IN	WAIT		;wait for drq.
	ORA	A		;set flags.
	JP	WCHK		;jump if done.
	MOV	A,M		;put in memory.
	OUT	DATA
	INX	H		;increment pointer.
	JMPR	WLOOP		;loop until done.
WCHK	EQU	$
	ENDIF

	SHLD	SYSVAL		;save next address
	IN	DSTAT		;read status.
	ANI	0FDH		;look at error bits.
	RZ			;ok if zero.
	DCR	E		;decrement retry count.
	JRNZ	BLOOP		;try again if not zero.
	LXI	D,WRITER
	CALL	PRINT
	JMP	BOOT
;
	IF	DMACNTL AND TARBELL		;if using dma control.
DMARW:	XRA	A		;clear chan 0
	OUT	CMND
	MVI	A,0D0H		;force intrp command
	OUT	DCOM		;clear floppy chip
	PUSH	D		;save d,e
	LDED	WRITOP		;get write operation
	LHLD	SYSVAL		;get memory pointer
	DCX	D		;count = count-1
	MOV	A,E		;count byte
	OUT	WCT0
	MOV	A,D		;write command
	OUT	WCT0
	INX	D
	MOV	A,L		;get low address byte
	OUT	ADR0
	MOV	A,H		;high address byte
	OUT	ADR0
	MVI	A,41H		;chan 0 request
	OUT	CMND
	MOV	A,C		;sector in a.
	OUT	SECT		;set sector register.
	CALL	HDLD
	ORA	B		;get head load bit.
	OUT	DCOM		;issue command.
RLOPP:	IN	DMACHK		;check dma status
	RLC			; bit 7
	JRC	RLOPP		;loop if carry
	XRA	A		;clear accum
	OUT	CMND		;reset dma chip
	MOV	A,D
	ANI	3FH		;strip command byte
	MOV	D,A
	DAD	D		;h,l = (h,l + d,e)
	POP	D
	RET
	ENDIF
;
;check head load bit
;
HDLD:	IN	DSTAT		;get disk status
	ANI	20H		;mask head load bit
	MVI	A,4		;get a 4 for load head
	RZ			;reload the head
	MVI	A,0		;else, head is load already
	RET
;
	IF	DMACNTL AND TARBELL
WRITOP:	DS	2		;dma write operation storage
	ENDIF
;
	IF	TARBELL
WAIT1	OUT	DCONT
	RET
	ENDIF
;
	IF	SUPRQAD
WAIT1	PUSH	B			; save 'bc'
	PUSH	PSW			; save flags
	MOV	C,A			; save byte
	ANI	70H			; mask good bits
	RRC
	RRC
	RRC
	RRC				; shifted to right
	MOV	B,A			; save byte
	MOV	A,C			; get orig byte
	ANI	8H			; mask density byte
	ADD	B			; complete control byte
	OUT	DCONT			; send byte
	POP	PSW			; recover flags
	POP	B			; recover 'bc'
	RET
	ENDIF
;
SYSVAL:	DS	2		;system pointer storage
CLATCH:	DS	1		;current drive select code
SIDED:	DS	1		;doub sided flag byte
SELD:	DS	1		;current drive to select
	DS	30		;stack area
STACK:	DS	1
;
	END	BEGIN
C
	RRC
	RRC
	RRC				; shifted to right
	MOV	B,A			; save byte
	MOV	A,C			; get orig byte
	ANI	8H			; mask density byte
	ADD	B			; complete control byte
	OUT	DCONT			; send byte
	POP	PSW			; recover flags
	POP	B			; recover 'bc'
	RET
	ENDIF
;
SYSVAL:	DS	2		;system pointer storage
CLATCH:	DS	1		;current drive select code
SIDED:	DS	1		;doub sided flag byte
SELD:	DS	1	;
;	FF.ASM		4/10/83
;
;	SEND FORM-FEED TO PRINTER
;
	ORG	0100H
	MVI	E,8CH		;USE '8CH' FOR '0CH' TO
	MVI	C,5		;FOOL ZCPR ON CONTROL KEY
	JMP	5
;
	END
;
 LSTDRIVRASM   Q                SETMRGN COM   N                SETMRGN ASM   	V                SETLINESCOM   J                FF      $$$                     SETMRGN BAK   	W               SQBI62DYBAK  k l m n         SQBI62DYBAK  o               ;
;	SETLINES.ASM	4/9/83	***DJ***
;
;	Select lines per inch on TALLEY 160L Printer
;
	MACLIB	MACRO
;
PSTRNG	EQU	9		;PRINT STRING AT 'DE' 'TILL '$'
LOUT	EQU	5		;LIST OUTPUT
BDOS	EQU	5
CPM	EQU	0		;SYSTEM RETURN
ESC	EQU	1BH		;ESCAPE CHAR
;
	ORG	100H
	PRINT	<CR,LF,'	 	TALLEY 160L PRINTER'>
	CCRLF
	PRINT	<CR,LF,LF,'	SET LINES PER INCH, 6 OR 8 LPI'>
	PRINT	<CR,LF,'	  ENTER 6 OR 8 ONLY		'>
AGN1	CHARIN
	CPI	'6'
	MVI	C,'3'
	JZ	SETLNS
	CPI	'8'
	MVI	C,'4'
	JZ	SETLNS
	CPI	3
	JZ	CPM
	PRINT	<CR,LF,'	ENTRY ERROR, RE-ENTER 6 OR 8	'>
	JMP	AGN1
;
SETLNS	MOV	A,C
	STA	PRNT2+3
;
LSTRNG	LXI	H,PRNT2
	MVI	C,LOUT
LOOP	MOV	A,M
	CPI	'$'
	JZ	CPM
	INX	H
	MOV	E,A
	PUSH	B
	PUSH	H
	CALL	BDOS
	POP	H
	POP	B
	JMP	LOOP
;
PRNT2	DB	ESC,'[3z$'
;
	END
;
 

 
R 6 OR 8 ONLY		'>
AGN1	CHARIN
	CPI	'6'
	MVI	C,'3'
	JZ	SETLNS
	CPI	'8'
	MVI	C,'4'
	JZ	SETLNS
	CPI	3
	JZ	CPM
	PRINT	<CR,;
;	setmode.ASM	4/9/83	***DJ***
;
;	Select Correspondence, Word processing or Data Modes
;
	MACLIB	MACRO
;
PSTRNG	EQU	9		;PRINT STRING AT 'DE' 'TILL '$'
LOUT	EQU	5		;LIST OUTPUT
BDOS	EQU	5
CPM	EQU	0		;SYSTEM RETURN
ESC	EQU	1BH		;ESCAPE CHAR
;
	ORG	100H
	CALL	CCRLF
        PRINT	<'		TALLEY 160 PRINTER ',CR,LF>
;
	PRINT	<LF,'		Select printer display MODE',CR,LF>
	PRINT	<LF,'	1. Word Processing',CR,LF>
	PRINT	<'	2. Data Processing',CR,LF>
	PRINT	<'	3. Proportional Space ON',CR,LF>
	PRINT	<'	4. Proportional Space OFF',CR,LF>
	PRINT	<'	5. 10 Pitch CORR QUAL',CR,LF>
	PRINT	<'	6. 12 Pitch CORR QUAL',CR,LF>
	PRINT	<'	   Enter number desired 1-6	'>
AGN3	CHARIN
	PUSH	PSW
	CALL	CCRLF
	POP	PSW
	CPI	'1'	
	MVI	C,'1'		;ESC[1y = Word processing
	JZ	SETMOD
	CPI	'2'
	MVI	C,'0'		;ESC[0y = Data processing
	JZ	SETMOD
	CPI	'3'
	MVI	C,'2'		;ESC[2y = Proportional Space ON
	JZ	SETMOD
	CPI	'4'
	MVI	C,'3'		;ESC[3y = Proportinal Space OFF
	JZ	Setmod
	CPI	'5'
	MVI	C,'4'		;ESC[4y = 10 PITCH CORR QUAL
	JZ	SETMOD
	CPI	'6'
	MVI	C,'5'		;ESC[5y = 12 PITCH CORR QUAL
	JZ	SETMOD
	CPI	3		;^C
	JZ	CPM
	PRINT	<'	ENTRY ERROR, ENTER 1 - 6	',CR,LF>
	JMP	AGN3
SETMOD	MOV	A,C
	STA	PRNT3
;
LSTRNG	LXI	H,STRNG
	MVI	C,LOUT
LOOP	MOV	A,M
	CPI	'$'
	JZ	CPM
	INX	H
	MOV	E,A
	PUSH	B
	PUSH	H
	CALL	BDOS
	POP	H
	POP	B
	JMP	LOOP
;
STRNG	DB	ESC,'['
PRNT3	DB	'1y$'
;
CCRLF	PRINT	<CR,LF>
	RET
;
	END
;
;
;	SETMARGN.ASM	4/9/83	***DJ***
;
;	Adjust the margins on the talley 160L Printer
;
	MACLIB	MACRO
;
PSTRNG	EQU	9		;PRINT