; * * * * *
;
;	TASK RECORD DEFINITION
;
; * * * * *
	ORG	0
TSKSTS:	DB	??		;TASK STATUS(STOP,NEW,ACTIVE)
TSKADR:	DW	??		;TASK ADDRESS(STARTING ADDRESS)
	DW	??		;TASK CODE SEGMENT
TSKSTK:	DW	??		;TASK STACK(ASSOCIATED STACK)
	DW	??		;TASK STACK SEGMENT
TSKLNK:	DW	??		;TASK LINK (LINK TO NEXT TASK)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		;TASK STATUS IS STOP
TSKNEW	EQU	1		;TASK STATUS IS NEW
TSKACT	EQU	2		;TASK STATUS IS ACTIVE
;
; * * * * *
;
;	TASK VARIABLES AND TASK BLOCKS
;
; * * * * *
;
	SEGMENT	MTKDATA
TSKPTR:	DW	??		;TASK POINTER
TASK1:	DS	TSKSZE		;TASK ONE
TASK2:	DS	TSKSZE		;TASK TWO
TASK3:	DS	TSKSZE		;TASK THREE
	ENDS
;
; * * * * *
;
;	TASK INITIALIZATION
;
; * * * * *
;
	SEGMENT	MTKCODE
;
	ASSUME	CS:MTKCODE,DS:MTKDATA
;
START:
;
	MOV	BX,MTKDATA
	MOV	DS,BX
;
	MOV	SI,OFFSET TASK1			;TASK1 TAB INITIALIZATION
	MOV	TSKADR+0[SI],OFFSET CODE1	;STARTING ADDRESS
	MOV	TSKADR+2[SI],PARA CODE1
	MOV	TSKSTK+0[SI],OFFSET STACK1	;STACK POINTER
	MOV	TSKSTK+2[SI],PARA STACK1
	MOV	TSKSTS[SI],TSKNEW		;NEW TASK
	MOV	TSKLNK[SI],OFFSET TASK2		;LINK TO TASK2
;
	MOV	SI,OFFSET TASK2			;TASK2 TAB INITIALIZATION
	MOV	TSKADR+0[SI],OFFSET CODE2	;STARTING ADDRESS
	MOV	TSKADR+2[SI],PARA CODE2
	MOV	TSKSTK+0[SI],OFFSET STACK2	;STACK POINTER
	MOV	TSKSTK+2[SI],PARA STACK2
	MOV	TSKSTS[SI],TSKNEW		;NEW TASK
	MOV	TSKLNK[SI],OFFSET TASK3		;LINK TO TASK3
;
	MOV	SI,OFFSET TASK3			;TASK3 TAB INITIALIZATION
	MOV	TSKADR+0[SI],OFFSET CODE3	;STARTING ADDRESS
	MOV	TSKADR+2[SI],PARA CODE3
	MOV	TSKSTK+0[SI],OFFSET STACK3	;STACK POINTER
	MOV	TSKSTK+2[SI],PARA STACK3
	MOV	TSKSTS[SI],TSKNEW		;NEW TASK
	MOV	TSKLNK[SI],OFFSET TASK1		;LINK TO TASK1
;
	MOV	SI,OFFSET TASK3			;SI = TSKPTR
	JMP	NEAR NXTTSK			;START TASK1
;
; * * * * *
;
;	SYSTEM TASK SCHEDULER
;	ENTERED VIA CALL FROM ACTIVE TASK
;
; * * * * *
;
SYSTEM:
	PUSHF			;SAVE ALL REGISTERS ON THE TASK STACK
	PUSH	AX		;(CS/IP FROM CALL)
	PUSH	BX		;CS/IP/FF/AX/BX/CX/DX/BP/SI/DI/DS/ES
	PUSH	CX
	PUSH	DX
	PUSH	BP
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
;
	CLI				;INTERRUPTS OFF
;
	MOV	BP,SP			;RE-ORDER STACK FOR SIMULATED INT
	MOV	AX,WORD PTR[BP+18]	;GET FLAG REGISTER
	XCHG	AX,WORD PTR[BP+22]	;FLAG REGISTER BOTTOM-MOST
	XCHG	AX,WORD PTR[BP+20]	;NEXT, CODE SEGMENT
	MOV	WORD PTR[BP+18],AX	;FINALLY, INSTRUCTION POINTER
					;ORDER IS NOW: FF/CS/IP/AX/BX...
;
; * * * * *
;
;	ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
;
TSKINT:
;
	MOV	BX,MTKDATA		;SET THE DATA SEGMENT REGISTER
	MOV	DS,BX
;
	MOV	SI,TSKPTR		;SI POINTS TO THE CURRENT TAB
	MOV	TSKSTK+0[SI],SP		;UPDATE THE STACK POINTER
	MOV	BX,SS
	MOV	TSKSTK+2[SI],BX
;
;	NEXT TASK
;
NXTTSK:	MOV	SI,TSKLNK[SI]		;POINT TO THE NEXT TASK
;
	CMP	TSKSTS[SI],TSKSTP
	JE	NXTTSK			;IF STATUS=STOP THEN NXTTSK
;
	MOV	TSKPTR,SI		;SAVE ADDR OF TAB
;
	MOV	BX,TSKSTK+2[SI]		;SET-UP STACK REGISTERS
	MOV	SS,BX
	MOV	SP,TSKSTK+0[SI]
;
	CMP	TSKSTS[SI],TSKNEW
	JE	NEWTSK			;IF STATUS=NEW THEN NEWTSK
;
;	RETURN TO ACTIVE TASK
;
	POP	ES
	POP	DS
	POP	DI
	POP	SI
	POP	BP
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	IRET				;RETURN TO ACTIVE TASK
					;(NEW CS/IP/FF)
;
;	ACTIVATE NEW TASK
;
NEWTSK:	MOV	TSKSTS[SI],TSKACT	;STATUS=ACTIVE
;
	STI				;ENABLE INTERRUPTS
	CALL	DWORD PTR TSKADR[SI]	;START TASK
;
;	DEACTIVATE ACTIVE TASK (WHEN IT RETURNS)
;
ENDTSK:	CLI				;DISABLE INTERRUPTS
;
	MOV	BX,MTKDATA
	MOV	DS,BX
;
	MOV	SI,TSKPTR		;SI=TSKPTR
	MOV	TSKSTS[SI],TSKSTP	;STATUS=STOP
;
	MOV	TSKSTK+0[SI],SP		;UPDATE THE STACK POINTER
	MOV	BX,SS
	MOV	TSKSTK+2[SI],BX
	JMP	NXTTSK			;SCHEDULE NEXT TASK
	ENDS
;
; * * * * *
;
;	USER DEFINED TASK ONE
;
; * * * * *
;
	SEGMENT	T1STACK
	DS	100			;STACK ONE
STACK1:	DS	0
	ENDS
;
	SEGMENT	T1CODE
	ASSUME	CS:T1CODE
CODE1:
	CALL	SYSTEM			;SCHEDULE OTHER TASK
	JMP	CODE1			;DO TASK AGAIN
	ENDS
;
; * * * * *
;
;	USER DEFINED TASK TWO
;
; * * * * *
;
	SEGMENT	T2STACK
	DS	100			;STACK TWO
STACK2:	DS	0
	ENDS
;
	SEGMENT	T2CODE
	ASSUME	CS:T2CODE
	PROC	FAR
CODE2:
	RET
	ENDS
;
; * * * * *
;
;	USER DEFINED TASK THREE
;	INITIATES TASK TWO IF IT IS INACTIVE
;
; * * * * *
;
	SEGMENT	T3STACK
	DS	100			;STACK THREE
STACK3:	DS	0
	ENDS
;
	SEGMENT	T3CODE
	ASSUME	CS:T3CODE
CODE3:
	MOV	BX,PARA TASK2
	MOV	ES,BX
;
	CMP	ES:TASK2+TSKSTS,TSKSTP
	JNE	C3SKP
;
	MOV	ES:TASK2+TSKSTS,TSKNEW	;TASK2 STATUS = TSKNEW
;
C3SKP:
	CALL	SYSTEM			;SCHEDULE OTHER TASK
	JMP	CODE3			;DO TASK AGAIN
	ENDS
;
	END	START
                                                                                     