	ASEG
; * * * * *
;
;  TASK RECORD DEFINITION
;
; * * * * *
	ORG	0
TSKSTS:	DS	1		;TASK STATUS (STOP,NEW,ACTIVE)
TSKADR:	DS	2		;TASK ADDRESS (STARTING ADDRESS)
TSKSTK:	DS	2		;TASK STACK (ASSOCIATED STACK)
TSKLNK:	DS	2		;TASK LINK (LINK TO NEXT TASK)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		;TASK STATUS IS STOP
TSKNEW	EQU	1		;TASK STATUS IS NEW
TSKACT	EQU	2		;TASK STATUS IS ACTIVE
; * * * * *
;
;  TASK VARIABLES AND TASK BLOCKS
;
; * * * * *
	ORG	8000H
TSKPTR:	DS	2		;TASK POINTER
TASK1:	DS	TSKSZE		;TASK ONE
TASK2:	DS	TSKSZE		;TASK TWO
TASK3:	DS	TSKSZE		;TASK THREE
; * * * * *
;
;  USER DEFINED STACKS FOR ASSOCIATED TASKS
;
; * * * * *
	DS	59
STACK1:	DS	1		;STACK ONE
	DS	59
STACK2:	DS	1		;STACK TWO
	DS	59
STACK3:	DS	1		;STACK THREE
; * * * * *
;
;  TASK INITIALIZATION
;
; * * * * *
	ORG	1000H
	LD	HL,CODE1		;CODE FOR TASK ONE
	LD	(TASK1+TSKADR),HL
	LD	HL,STACK1		;STACK FOR TASK ONE
	LD	(TASK1+TSKSTK),HL
	LD	A,TSKNEW		;NEW TASK
	LD	(TASK1+TSKSTS),A
	LD	HL,TASK2
	LD	(TASK1+TSKLNK),HL	;LINK TO TASK2
;
	LD	HL,CODE2		;CODE FOR TASK TWO
	LD	(TASK2+TSKADR),HL
	LD	HL,STACK2		;STACK FOR TASK TWO
	LD	(TASK2+TSKSTK),HL
	LD	A,TSKSTP		;INACTIVE TASK
	LD	(TASK2+TSKSTS),A
	LD	HL,TASK3
	LD	(TASK2+TSKLNK),HL	;LINK TO TASK3
;
	LD	HL,CODE3		;CODE FOR TASK THREE
	LD	(TASK3+TSKADR),HL
	LD	HL,STACK3		;STACK FOR TASK THREE
	LD	(TASK3+TSKSTK),HL
	LD	A,TSKNEW		;NEW TASK
	LD	(TASK3+TSKSTS),A
	LD	HL,TASK1
	LD	(TASK3+TSKLNK),HL	;LINK TO TASK1
;
	LD	IX,TASK3	;IX = TSKPTR
	LD	(TSKPTR),IX	;TSKPTR = ADDRESS OF TASK 3
	JR	NXTTSK		;START TASK1
; * * * * *
;
;  SYSTEM TASK SCHEDULER
;  ENTERED VIA CALL FROM ACTIVE TASK
;
; * * * * *
SYSTEM:	DI			;DISABLE INTERRUPTS
	PUSH	AF		;SAVE TASK STATE
	PUSH	BC
	PUSH	DE
	PUSH	HL
;  ****  ALTERNATE REGISTER SET MAY BE SAVED HERE AS NECESSARY
	PUSH	IX
	PUSH	IY
; * * * * *
;
;  ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
TSKINT:	LD	IX,(TSKPTR)	;IX = TSKPTR
	LD	HL,0
	ADD	HL,SP		;HL = SP
	LD	(IX+TSKSTK+0),L
	LD	(IX+TSKSTK+1),H	;TASK STACK = SP
;
;  NEXT TASK
;
NXTTSK:	LD	L,(IX+TSKLNK+0)
	LD	H,(IX+TSKLNK+1)	;HL = LINKAGE TO NEXT TASK
	LD	(TSKPTR),HL
	LD	IX,(TSKPTR)	;IX = TSKPTR
;
	LD	A,(IX+TSKSTS)	; A = TASK STATUS
	CP	TSKSTP
	JR	Z,NXTTSK	;IF TASK STATUS = STOP THEN  NXTTSK
;
	LD	L,(IX+TSKSTK+0)
	LD	H,(IX+TSKSTK+1)	;HL = TASK STACK
	LD	SP,HL		;SP = HL
;
	CP	TSKNEW
	JR	Z,NEWTSK	;IF TASK STATUS = NEW THEN  NEWTSK
;
;  RETURN TO ACTIVE TASK
;
	POP	IY		;RESTORE TASK STATE
	POP	IX
;  ****  ALTERNATE REGISTER SET MAY BE RESTORED HERE AS NECESSARY
	POP	HL
	POP	DE
	POP	BC
	POP	AF
	EI			;ENABLE INTERRUPTS
	RET			;RETURN TO ACTIVE TASK
;
;  ACTIVATE NEW TASK
;
NEWTSK:	LD	(IX+TSKSTS),TSKACT	;TASK STATUS = ACTIVE
;
	LD	HL,ENDTSK
	PUSH	HL		;RETURN ADDRESS = ENDTSK
;
	LD	L,(IX+TSKADR+0)
	LD	H,(IX+TSKADR+1)	;HL = TASK ADDRESS
	EI			;ENABLE INTERRUPTS
	JP	(HL)		;ACTIVATE THE TASK
;
;  DEACTIVATE ACTIVE TASK
;
ENDTSK:	DI			;DISABLE INTERRUPTS
	LD	IX,(TSKPTR)	;IX = TSKPTR
	LD	(IX+TSKSTS),TSKSTP	;TASK STATUS = STOP
	LD	HL,0
	ADD	HL,SP		;HL = SP
	LD	(IX+TSKSTK+0),L
	LD	(IX+TSKSTK+1),H	;TASK STACK = SP
	JR	NXTTSK		;SCHEDULE NEXT TASK
; * * * * *
;
;  USER DEFINED CODE FOR TASK ONE
;
; * * * * *
CODE1:
	CALL	SYSTEM		;SCHEDULE OTHER TASKS
	JP	CODE1		;DO TASK AGAIN
; * * * * *
;
;  USER DEFINED CODE FOR TASK TWO
;
; * * * * *
CODE2:
	RET			;ASSUME TASK COMPLETE
; * * * * *
;
;  USER DEFINED CODE FOR TASK THREE
;  THIS EXAMPLE TASK INITIATES TASK 2 IF IT IS INACTIVE
;
; * * * * *
CODE3:
	LD	A,TASK2+TSKSTS
	CP	TSKSTP
	JR	NZ,C3SKP	;IF TASK2 STATUS <> TSKSTP THEN SKIP
	LD	A,TSKNEW
	LD	(TASK2+TSKSTS),A	;TASK2 STATUS = TSKNEW
C3SKP:	CALL	SYSTEM		;SCHEDULE OTHER TASKS
	JP	CODE3
	END
                                