	ASEG
; * * * * *
;
;  TASK RECORD DEFINITION
;
; * * * * *
	ORG	0
TSKSTS:	DS	1		;TASK STATUS (STOP,NEW,ACTIVE)
TSKADR:	DS	2		;TASK ADDRESS (STARTING ADDRESS)
TSKSTK:	DS	2		;TASK STACK (ASSOCIATED STACK)
TSKLNK:	DS	2		;TASK LINK (LINK TO NEXT TASK)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		;TASK STATUS IS STOP
TSKNEW	EQU	1		;TASK STATUS IS NEW
TSKACT	EQU	2		;TASK STATUS IS ACTIVE
; * * * * *
;
;  TASK VARIABLES AND TASK BLOCKS
;
; * * * * *
	ORG	8000H
TSKPTR:	DS	2		;TASK POINTER
TASK1:	DS	TSKSZE		;TASK ONE
TASK2:	DS	TSKSZE		;TASK TWO
TASK3:	DS	TSKSZE		;TASK THREE
; * * * * *
;
;  USER DEFINED STACKS FOR ASSOCIATED TASKS
;
; * * * * *
	DS	59
STACK1:	DS	1		;STACK ONE
	DS	59
STACK2:	DS	1		;STACK TWO
	DS	59
STACK3:	DS	1		;STACK THREE
; * * * * *
;
;  TASK INITIALIZATION
;
; * * * * *
	ORG	1000H
	LXI	H,CODE1		;CODE FOR TASK ONE
	SHLD	TASK1+TSKADR
	LXI	H,STACK1	;STACK FOR TASK ONE
	SHLD	TASK1+TSKSTK
	MVI	A,TSKNEW	;NEW TASK
	STA	TASK1+TSKSTS
	LXI	H,TASK2
	SHLD	TASK1+TSKLNK	;LINK TO TASK2
;
	LXI	H,CODE2		;CODE FOR TASK TWO
	SHLD	TASK2+TSKADR
	LXI	H,STACK2	;STACK FOR TASK TWO
	SHLD	TASK2+TSKSTK
	MVI	A,TSKSTP	;INACTIVE TASK
	STA	TASK2+TSKSTS
	LXI	H,TASK3
	SHLD	TASK2+TSKLNK	;LINK TO TASK3
;
	LXI	H,CODE3		;CODE FOR TASK THREE
	SHLD	TASK3+TSKADR
	LXI	H,STACK3	;STACK FOR TASK THREE
	SHLD	TASK3+TSKSTK
	MVI	A,TSKNEW	;NEW TASK
	STA	TASK3+TSKSTS
	LXI	H,TASK1
	SHLD	TASK3+TSKLNK	;LINK TO TASK1
;
	LXI	H,TASK3		;HL = TSKPTR
	SHLD	TSKPTR		;TSKPTR = ADDRESS OF TASK3
	JMP	NXTTSK		;START TASK 1
; * * * * *
;
;  SYSTEM TASK SCHEDULER
;  ENTERED VIA CALL FROM ACTIVE TASK
;
; * * * * *
SYSTEM:	DI			;DISABLE INTERRUPTS
	PUSH	PSW		;SAVE TASK STATE
	PUSH	B
	PUSH	D
	PUSH	H
; * * * * *
;
;  ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
TSKINT:	LHLD	TSKPTR		;HL = TSKPTR
	LXI	D,TSKSTK
	DAD	D		;HL = ADDRESS OF TASK STACK
	XCHG
	LXI	H,0
	DAD	SP
	XCHG			;DE = SP
	MOV	M,E
	INX	H
	MOV	M,D		;TASK STACK = SP
;
;  NEXT TASK
;
NXTTSK:	LHLD	TSKPTR		;HL = TSKPTR
	LXI	D,TSKLNK
	DAD	D		;HL = ADDRESS OF TASK LINK
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG			;HL = TASK LINK
	SHLD	TSKPTR		;TSKPTR = TASK LINK
;
	LXI	D,TSKSTS
	DAD	D		;HL = ADDRESS OF TASK STATUS
	MOV	A,M		; A = TASK STATUS
;
	CPI	TSKSTP
	JZ	NXTTSK		;IF TASK STATUS = STOP THEN  NXTTSK
;
	LXI	D,TSKSTK-TSKSTS
	DAD	D		;HL = ADDRESS OF TASK STACK
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E		;HL = TASK STACK
	SPHL			;SP = TASK STACK
;
	CPI	TSKNEW
	JZ	NEWTSK		;IF TASK STATUS = NEW THEN  NEWTSK
;
;  RETURN TO ACTIVE TASK
;
	POP	H		;RESTORE TASK STATE
	POP	D
	POP	B
	POP	PSW
	EI			;ENABLE INTERRUPTS
	RET			;RETURN TO ACTIVE TASK
;
;  ACTIVATE NEW TASK
;
NEWTSK:	LHLD	TSKPTR		;HL = TSKPTR
	LXI	D,TSKSTS
	DAD	D		;HL = ADDRESS OF TASK STATUS
	MVI	M,TSKACT	;TASK STATUS = ACTIVE
;
	LXI	D,ENDTSK
	PUSH	D		;RETURN ADDRESS = ENDTSK
;
	LXI	D,TSKADR-TSKSTS
	DAD	D		;HL = ADDRESS OF TASK ADDRESS
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E		;HL = TASK ADDRESS
;
	EI			;ENABLE INTERRUPTS
	PCHL			;ACTIVATE THE TASK
;
;  DEACTIVATE ACTIVE TASK
;
ENDTSK:	DI			;DISABLE INTERRUPTS
;
	LHLD	TSKPTR		;HL = TSKPTR
	LXI	D,TSKSTS
	DAD	D		;HL = ADDRESS OF TASK STATUS
	MVI	M,TSKSTP	;TASK STATUS = STOP
;
	LXI	D,TSKSTK-TSKSTS
	DAD	D		;HL = ADDRESS OF TASK STACK
	XCHG
	LXI	H,0
	DAD	SP
	XCHG			;DE = SP
	MOV	M,E
	INX	H
	MOV	M,D		;TASK STACK = SP
	JMP	NXTTSK		;SCHEDULE NEXT TASK
; * * * * *
;
;  USER DEFINED CODE FOR TASK ONE
;
; * * * * *
CODE1:
	CALL	SYSTEM		;SCHEDULE OTHER TASKS
	JMP	CODE1		;DO TASK AGAIN
; * * * * *
;
;  USER DEFINED CODE FOR TASK TWO
;
; * * * * *
CODE2:
	RET			;ASSUME TASK COMPLETE
; * * * * *
;
;  USER DEFINED CODE FOR TASK THREE
;  THIS EXAMPLE TASK INITIATES TASK 2 IF IT IS INACTIVE
;
; * * * * *
CODE3:
	LDA	TASK2+TSKSTS
	CPI	TSKSTP
	JNZ	C3SKP		;IF TASK2 STATUS <> TSKSTP THEN SKIP
	MVI	A,TSKNEW
	STA	TASK2+TSKSTS	;TASK2 STATUS = TSKNEW
C3SKP:	CALL	SYSTEM		;SCHEDULE OTHER TASKS
	JMP	CODE3
	END
                                                       