With Jlib86	; Use entries in JLIB86
Package Assembly Util

    ;Copyright 1982,1983  RR Software, Inc., P.O. Box 1512, Madison WI 53701
    ;Permission is hereby given to distribute Object Code produced from
    ;these libraries.

    ;Utility programs
    ;CP/M-86 Version
    ;Last Modified 5/10/83

	Jmp	Pend	;Skip package Body

Proc Halt	;Halt procedure
	Call	EHalt	;Call the library halt entry point
End Proc Halt

Proc Err_Exit	;Error Exit Procedure
	Call	EErr_Exit ;Call the library error exit entry
End Proc Err_Exit

Proc Hi		;Return the high byte of the argument
	Pop	DI	;Return Address
	Pop	AX	;Argument
	Push	DI	;Toss argument from stack
	Mov	AL,AH
	Ret		;The return value is left in AL
End Proc Hi

Proc Lo		;Return the low byte of the argument
	Pop	DI	;Return Address
	Pop	AX	;Argument
	Push	DI	;Toss argument from stack
	Ret		;The return value is left in AL
End Proc Lo

Proc Memavail	;Return the amount of memory available in the system
	Call	EMemAvail ;Call the memory available entry point
	Ret		;The return value is in AX
End Proc Memavail

Proc Maxavail	;Return the amount of memory available in the system
		;including that on the free chain
	Call	EMaxAvail ;Call the memory available entry point
	Ret		;The return value is in AX
End Proc Maxavail

Proc Command_Line	;Return the address of the command line
	Mov	AX,80h		;The address of the command line
	Ret			;May return it this way since it cannot
				;change
End Proc Command_Line

Proc FConvert
    ;Convert the limited private type File into the type File_ptr
	Pop	DI	;Return Address
	Pop	AX	;Argument
	Push	DI	;Toss argument from stack
	Ret
	;The value is now in AX, ready to be converted
End Proc FConvert

Proc FFConvert
   ;Convert a File_ptr into the limited private type File
	Pop	DI	;Return Address
	Pop	BX	;Argument (File)
	Pop	AX	;    "    (File_Ptr)
	Push	AX
	Push	BX
	Push	DI	;Leave the stack the same, as has IN OUT Params
	Mov	[BX],AX	;Move the pointer into the file
	Ret
End Proc FFConvert

	DSEG
Std_Input: RW	1	;Standard Input pointer
Std_Output: RW	1	;Standard Output pointer

Temp: RW 3

	CSEG

Proc Standard_Input
    ;Return a pointer to the initial default standard input file
	Mov	AX,[Std_Input]
	Ret
End Proc Standard_Input

Proc Standard_Output
    ;Return a pointer to the initial default standard output file
	Mov	AX,[Std_Output]
	Ret
End Proc Standard_Output

Proc Current_Input
    ;Return a pointer to the current default input file
	Mov	AX,[Input_File]
	Ret
End Proc Current_Input

Proc Current_Output
    ;Return a pointer to the current default output file
	Mov	AX,[Output_File]
	Ret
End Proc Current_Output

Proc Set_Input
    ;Set the current input file to the parameter
	Pop	DI	;Return Address
	Pop	AX	;Argument
	Push	DI	;Toss argument from stack
	Cmp	AX,0	;Test to see if the file is open
	Je	FErr
	Xchg	AX,BX
	Test	Byte([BX+1]),1	;Test the mode for read access
	Jz	FErr
	Mov	[Input_File],BX	;Set the file
	Ret
End Proc Set_Input

Proc Set_Output
    ;Set the current output file to the parameter
	Pop	DI	;Return Address
	Pop	AX	;Argument
	Push	DI	;Toss argument from stack
	Cmp	AX,0	;File is not open
	Je	FErr
	Xchg	AX,BX
	Test	Byte([BX+1]),2	;Test the mode for write access
	Jz	FErr
	Mov	[Output_File],BX ;Set the file
	Ret
End Proc Set_Output

FErr:	;Raise an exception when the file is not open or the mode is
	;wrong
	Mov	BX,[Output_File]
	Mov	AX,FErr_mess
	Call	Put_CStr
	Jmp	EErr_Exit
FErr_Mess: DB	36,"File Mode incorrect for default file"


Proc Has_8087
    ;Returns whether the system has an 8087 installed
	Mov	AL,[Have_8087]
	Ret
End Proc Has_8087

Pend:
	;Set Std_Input and Std_Output to the initial values
	Mov	AX,[Input_File]
	Mov	[Std_Input],AX
	Mov	AX,[Output_File]
	Mov	[Std_Output],AX
	;End of initialization code

End Util;

is
	;wrong
	Mov	BX,[Output_File]
	Mov	AX,FErr_mess
	Call	Put_CStr
	Jmp	EErr_Exit
FErr_Mess: DB	36,"File Mode incorrect foOutput
    ;Set the current output file to the parameter
	Pop	DI	;Return Address
	Pop	AX	;Argument
	Push	DI	;Toss argument f