 READ    ME    %<=>?@            PRIMES  PKG   A                QSORT   PKG   <BCDEFGHI         XREF    PKG   IJKLMNOPQRS       KALAHA  PKG   TUVWXYZ[\]^_`abc KALAHA  PKG                   With Floatio,Timelib,Util;
Package Body Matmul Is
    -- Jerry Pournelle's Floating Point Benchmark
    -- October 1982 Byte, pages 254 - 270
    -- Translated from Pascal into Janus/Ada, 3/13/83

    start_time,end_time : Timelib.Time;

    MAXSIZE : Constant := 45;
    M : Constant := 20;
    N : Constant := 20;

    Subtype Real Is Float; -- Also can use Long_Float for comparision
    Subtype Dim1 Is Integer Range 1..M;
    Subtype Dim2 Is Integer Range 1..N;

    -- The following mess since Janus/Ada does not yet have multi-dim.
    -- arrays.
    Type Col1 Is Array (Dim2) Of Real;
    Type Col2 Is Array (Dim1) Of Real;
    Type Mat1 Is Array (Dim1) Of Col1;
    Type Mat2 Is Array (Dim2) Of Col2;
    Type Mat3 Is Array (Dim1) Of Col2;

    -- Effect is:
    -- Type Mat1 Is Array (Dim1,Dim2) Of Real;
    -- Type Mat2 Is Array (Dim2,Dim1) Of Real;
    -- Type Mat3 Is Array (Dim1,Dim1) Of Real;

    A : Mat1;
    B : Mat2;
    C : Mat3;

    Summ : Real;


    Procedure Fill_A Is
    Begin
        For i In Dim1 Loop
            For j In Dim2 Loop
                A(i)(j) := Real(i + j);
            End Loop;
        End Loop;
    End Fill_A;

    Procedure Fill_B Is
    Begin
        For i In Dim2 Loop
            For j In Dim1 Loop
                B(i)(j) := Real((i + j) / j);
            End Loop;
        End Loop;
    End Fill_B;

    Procedure Fill_C Is
    Begin
        For i In Dim1 Loop
            For j In Dim1 Loop
                C(i)(j) := 0.0;
            End Loop;
        End Loop;
    End Fill_C;

    Procedure Matrix_Multiply Is
    Begin
        For i In Dim1 Loop
            For j In Dim2 Loop
                For k In Dim1 Loop
                    C(i)(k) := C(i)(k) + A(i)(j) * B(j)(k);
                End Loop;
            End Loop;
        End Loop;
    End Matrix_Multiply;

    Procedure Summit Is
    Begin
        For i In Dim1 Loop
            For j In Dim1 Loop
                Summ := Summ + C(i)(j);
            End Loop;
        End Loop;
    End Summit;

Begin
    Summ := 0.0;
    Put("J.E. Pournelle's Matrix Multiply Benchmark"); New_line;
    If Not Util.Has_8087() Then
	Put("Cannot run this program - Needs an 8087"); New_line;
	Util.Halt;
    End If;
    Put("This Program times itself"); New_Line;
    Start_time := Timelib.Get_Time();
    Fill_A;
@   Put(" A filled. "); New_line;
    Fill_B;
@   Put(" B filled. "); New_line;
    Fill_C;
@   Put(" C filled. "); New_line;
    Matrix_Multiply;
@   Put("Multiplied."); New_line;
    Summit;
@   Put("Summ is : "); Floatio.Put(Summ); New_Line;
    end_time := Timelib.Get_Time();
    Put("Checksum is : "); Floatio.Put(Summ); New_line;
    Put("Elapsed time was "); Timelib.Put_Time(Util.Current_Output(),
        Timelib.Elapsed_Time(start_time,end_time)); New_line;
End Matmul;
ew_line;
    Fill_B;
@   Put(" B filled. "); New_line;
    Fill_C;
@   Put(" C filled. "); New_line;
    Matrix_Multiply;

@   Put("Multiplied."); New_line;
    Summit;
@   Put("Summ is : "); Floatio.Put(Summ); New_Line;
    end_time := Timelib.GeWith Jlib86;
Package Assembly Longops

    ; Copyright 1983  RR Software, Inc., P.O. Box 1512, Madison WI 53701
    ; Permission is hereby given to distribute Object Code produced from
    ; these libraries.  All Other rights reserved.

    ; Long Integer Operations
    ; Last Modified 4/29/83
    ; The names of these routines will be changed when operator overloading
    ; is implemented.

	Jmp	Pend	;Skip Package Body

Return:
	;Returns the result (which is in BX & CX; BX being low)
	;This entry ought to be JMPed to.
	Push	BX
	Push	CX
	Call	Func_Ret
	DW	4	;Return 4 byte record, pointer in AX
	Mov	SI,AX	;Copy the pointer to use it
	Pop	CX
	Pop	BX
	Mov	[SI],BX
	Mov	[SI+2],CX ;Copy the result into the return block
	Ret		;The pointer is still in AX

;Function Labs (Item : In Long_Integer) Return Long_Integer;
;    Operator "ABS" - Take the absolute value of operand
Proc Labs
	Pop	SI	;Return Address
	Pop	DI	;Address of Item
	Push	SI	;Replace return address - Params tossed
	Mov	BX,[DI]	;Get the value
	Mov	CX,[DI+2]
	Cmp	CX,0	;Test sign of upper byte
	Jge	LabsEnd
	Not	BX	;Negative, so negate CX:BX
	Not	CX
	Add	BX,1	;Make into 2's complement
	Adc	CX,0	;Add carry, if any
	Into		;Check for Overflow Error
LabsEnd:Jmp	Return	;Return the value in CX:BX
End Proc Labs

;Function Lneg (Item : In Long_Integer) Return Long_Integer;
;    Operator "-" - Negate the operand
Proc Lneg
	Pop	SI	;Return Address
	Pop	DI	;Address of Item
	Push	SI	;Replace return address - Params tossed
	Mov	BX,[DI]	;Get the value
	Mov	CX,[DI+2]
	Not	BX	;Negate CX:BX
	Not	CX
	Add	BX,1	;Make into 2's complement
	Adc	CX,0	;Add carry, if any
	Into		;Check for Overflow error
	Jmp	Return	;Return the value in CX:BX
End Proc Lneg

;Function Lint (Item : In Integer) Return Long_Integer;
;   Type Conversion Integer => Long_Integer
Proc Lint
	Pop	SI	;Return Address
	Pop	AX	;Item Value
	Push	SI	;Replace return address - Params tossed
	Cwd		;Sign Extend Number
	Mov	BX,AX
	Mov	CX,DX	;Get value from DX:AX => CX:BX
	Jmp	Return
End Proc Lint

;Function L_to_int (Item : In Long_Integer) Return Integer;
;    Type Conversion Long_Integer => Integer
Proc L_to_int
	Pop	SI	;Return Address
	Pop	DI	;Address of Item
	Push	SI	;Replace return address - Params tossed
	Mov	AX,[DI]	;Get the value
	Mov	CX,[DI+2]
	Cwd		;Sign Extend to see if the result is the same
	Cmp	CX,DX
	Jne	Conv_Err
	Ret		;Return the value in AX
Conv_Err: Int	4	;Force Arith. Overflow!
	Ret
End Proc L_to_int

;Function Ladd (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "+" - Long Integer addition
Proc Ladd
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Add	BX,[DI]	;Add Item2 (low)
	Adc	CX,[DI+2];Add Item2 (high)
	Into		;Check for Overflow error
	Jmp	Return
End Proc Ladd

;Function Lsub (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "-" - Long Integer subtraction
Proc Lsub
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Sub	BX,[DI]	;Subtract Item2 (low)
	Sbb	CX,[DI+2];Subtract Item2 (high)
	Into		;Check for Overflow error
	Jmp	Return
End Proc Lsub

;Function Lmul (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "*" - Long Integer multiply
Proc Lmul
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Mov	AX,[DI]	;Get Item2
	Mov	DX,[DI+2]
	Mov	SI,0
	Mov	DI,0	;Zero out accumulator
	Mov	BP,CX	;Use BP as upper bytes
	Mov	CX,32	;Loop counter
Mult_Loop:
	;Shift DI:SI Left
	Sal	SI,1
	Rcl	DI,1	;Include Carry
	;Shift BP:BX Left
	Sal	BX,1
	Rcl	BP,1	;Include Carry; Most sig. bit not in carry
	;Add  DX:AX to DI:SI if Carry
	Jnc	MAdd_Skip
	Add	SI,AX
	Adc	DI,DX
Madd_Skip:
	Loop	Mult_Loop	;Do it until the loop counter runs out
	Mov	CX,DI
	Mov	BX,SI
	Jmp	Return	;Return value in accumulator (no overflow check,
			; sorry)
End Proc L