.title	'Print the list of current Network users'
	.ident Who
version	==	3
revision==	06	;last revised, 04/28/83, DRB
patch	==	' '
        .pabs
	.phex
	.loc	100h
;
;		Table of Contents
;
; Update history			2
; Equates       			3
; Check user    			4
; Process the request			5
; Test for who HIST or AM I		7
; Process HIST request			8
; Print the who HIST request		9
; Print the who table			10
; Subroutines   			11
;      Print the spool table		11
;      Print line of who table		13
;      Print the time			15
;      CRT I/O subroutines		16
; Define storage			20
; CRT messages				21
.page
.sbttl	'Update History'
;---------------
; Originally written by Dave Stein, Nov 1980
;  Modified by Peter Kavaler (version 3)
;  to print spool information
;
; Update History:
;
;  revision 1:  Modified to print a history of who
;               has been logged into HiNet.  Who am I
;               tells the user what their present login
;               status is.  9/14/81 DB.
;
;  revision 2:  The network hard disk status command
;		is now recognized. (1Dh=volstat)
;
;  revision 3:  Who prints the user numbers. Organize
;		WHO, add a table of contents.  DB
;
;  revision 4:  Upgraded to utilize bios244 network 
;		error checking and recovery techniques.
;		Update table of contents. KGH and DRB
;
; 3.05 3/31/83 	Modify who so blanks are printed if
;		the user name in the users table is
;		blank.  Eliminated lots of unnecessary
;		code.  Prttime now does all LDIR's of
;		time from memory.  If time is not set
;		in memory, it is blank in who.  DRB
; 'A' 04/12/83  Add HiNet request for Date and Time.
; 'B' 04/22/83  Who version 3.05 only works on BIOS
;		version 2.244 and later.  The login
;		message indicates this. DRB
; 3.06 04/28/83 Eliminate patch in version.  Add
;		slowpol to delay logging out message
;		on the CRT.
.page
.sbttl	'Equates'
;
WBOOT	==	00h	; Bios entry point location
WBaddr	==	01h     ; Warm boot location
numusr	==	32	; number of users
curdrive==	04	; current drive number
BIOSsec	==	41h	; BIOS maintained time
retry	==	3	; # of poll tries
loop	==	5	; # of recnet loop retries
usernum ==	47h	; assigned user number loc
cmdlin  ==      80h     ; addr of the command line
userlist==	4000h	; addr of user table
spoollist==	4200h	; addr of spool table
numspl	==	16	; number of spool jobs
whoNET	==	10h	; Network 'who' command
cr	==	0Dh	; Ascii carriage return
lf	==	0Ah	; Ascii line feed
slowpol	==	224	; BIOS equate to slow  message
.sbttl	'Check user'
;
	sspd	saveSP	 ;save stack pointer addr
	lxi	sp,stack ;stack at end of prog.
	lda	usernum
	cpi	0FFh
	jrnz	..ok
	lxi	H,notnet
	call	PRTMSG	; not on net
	jmp	retCCP	; so cant do who
..ok:
	lxi	H,LOGmsg ; Print log-on message
	call	prtmsg
	mvi	B,18
	call	spaces
	lxi	H,TIMEmsg; Print time message
	call	prtmsg
	lxi	H,BIOSsec ;addr for LDIR in prttime
	call	prttime	 ; Print the time.
;
; Initialize BIOS subroutine jump addresses.
	lded	WBaddr	; DE = Warm boot address
	lxi	H,6Ch
	dad	D
	shld	SENDNET+1  ; jump address to SENDNET
	lxi	H,6Fh
	dad	D
	shld	RECVNET+1  ; jump address to RECVNET
	lxi	H,75h
	dad	D
	shld	Ackpoll+1  ; jump address to Ackpoll
	lxi	H,72h
	dad	D
	shld	Nackpoll+1 ; jump address to Nackpoll
;----------
; If we are on the Master, the user table is in
; memory.  We copy it into our userlist and print it
; out. If we are on a Network Station, send the 
; whonet command, receive the userlist from the
; Network.  Then, test if there is a command line.
; If there is determine if the request is for HIST or
; AM I.  If there is no command line, print out who
; is currently logged into HiNet.
.page
.sbttl	'Process the request'
;
        lda	usernum ; process conventional who
        cpi	00	; are we on the master?
        jrnz    userwho ; no, get the user table
;---------------
; process the HiNet master who
;
	lxi	H,0FC00h   ; HL = table addr in Bios
	lxi	D,userlist ; DE = our userlist addr
	lxi	B,numusr*16; BC = length of table
	ldir		; Copy from BIOS to userlist
	lxi	H,0F500h
	lxi	D,spoollist
	lxi	B,numspl*16
	ldir
 	jmpr    comlintst ;test for a command line
;--------------- 
USERWHO:		; process user station who
	lxi	H,loops
	mvi	M,loop
..loop: push	H
..retry:
	lxi	H,retries
	mvi	M,retry
..poll:	push	H
	call	NACKpoll ; no poll acknowledge
	bit	0,A	 ; no poll, 3 retries
	pop	H
	jrnz	..cont
	dcr	M
	jrnz	..poll
	jmpr	NETdead
..cont:	mvi	A,0	; to master
	lxi	B,1	; length of our data
	lxi	H,NETcmd; Our data buffer addr
	mvi	M,whoNET; Load the 'whoNET' byte
	call	SENDNET	; and send it over HiNet
;
; Get user table and spool table from master

	lda	usernum	; get our user number
	lxi	H,userlist ; Our destination addr
	lxi	B,numusr*16; max num of bytes to recv
	call	RECVNET	  ; Get user list from Master
	call	CKrecstat ; Check recnet status
	jrz	..recnet2
	pop	H	; get loop pointer
	dcr	M
	jrnz	..loop
	jmpr	NETdead
.page
..recnet2:
	lda	usernum ; get spool table
	lxi	H,spoollist
	lxi	B,numspl*16
	call	RECVNET
	call	CKrecstat
	pop	H	; get loop pointer
	jrz	..recok
	dcr	M
	jrnz	..loop
	jmpr	NETdead
..recok:
	call	ACKpoll ; resume polls and
	jmpr    comlintst ;test for a command line  
;----------------
; Dead network message
;
NETdead:
	call	ACKpoll
	lxi	H,deadMSG
	call	prtmsg
	jmp     retCCP  ;Network is down so start over
.page
.sbttl	'Test for who HIST or AM I'
;---------------
comlintst:
; Test for a command line.
	lda     cmdlin   ;load com line in accum
        cpi	00       ;0 means no com line so
	jz	PRTTABL  ;print the regular who, else
TSTcmdline:		 ;test the command line
;
	lxi     H,cmdlin ;get command line addr
..1:    inr     L    	;increment the cmdlin
	mov     a,m	;get the contents of cmdlin 
	cpi	' '	; it is a blank?
	jrz	..1	; yes, go back and get another
	cpi	'H'     ; no, is it an H for who Hist? 
	jrz	hstreq  ; if it is, process HIST req
	cpi	'A'     ; no, is an A for who AM I?
	jrz     amireq	; if yes, process AM I request
  	lxi	h,crlf  ; space one line
	call    prtmsg  ; and print it
	lxi	H,errcmd ; load command error msg
	call    prtmsg  ;print the message
        call    retCCP  ;and start over
;
AMIREQ:
	lxi	h,crlflf
	call 	prtmsg	;space two lines
	mvi	B,18
	call	spaces	;over 18 spaces
	lxi     H,AMItitl ;title of the report
	call    prtmsg  ;print it
	lxi     h,crlf	
	call	prtmsg	;print a space
	lxi	h,HEADmsg  
	call	prtmsg	;print the heading
	lxi	h,userlist ;bring in user table
	mvi	b,16	;byte length of each line
	lda	usernum
	sta 	unit
	call	addrfind ;find the line for this user
	call	prtline ;print the line
	jmp     retCCP  ;finished, return to CCP
.page
.sbttl	'process HIST request'
;begi processin HSTRE (wh history here
;
HSTREQ:
	lxi	h,crlf
	call 	prtmsg	;space one line
	lxi     H,HISTitl ;title of the report
	call    prtmsg  ;print it
	lxi	h,crlf	
	call 	prtmsg	;space one line
	lxi  	h,HISTmsg ;print the heading
	call    prtmsg  ;print the heading
   	lxi	h,userlist ;get userlist address
	sub	A
	sta	histnum
..1:    lda	histnum
	cpi	numusr	;must be done here to avoid
	jrnc	..3	;an endless loop
	push    H	;save the table address
	pop	x	;addr in x for offset
	mov	A,+15(x) ;get what is in x memory loc
	cpi	20h	;activity is not blank
	jrnz	..2	;so continue processing
	mov	A,m	;else, if user logged in
	cpi	0
	jrnz	..2	;continue processing
	lda	histnum	;else, increment counter
	inr	A
	sta	histnum
	lxi	D,16
	dad	D	;HL points to next entry
	jmpr	..1	;check next entry
..2:	mov     a,m     ;get contents of memory
        call    testwho ;is this entry logged on?
	lda	histnum
	inr	A
	sta	histnum ;one more user done
	cpi	numusr  ;if have not processed all
	jrnz	..1     ;users so go back for another
..3:    lxi     H,crlf	;else fall thru,
	call    prtmsg	;space one line
        jmp     retCCP  ;go back to CCP
.page
.sbttl	'Print the WHO HIST request'
;----------
; Print current user entry for HIST
PRTWHO:
;
	push    H	;save current table addr
	lxi	H,crlf	;space down a line
	call	prtmsg
	mvi	b,3
	call	spaces	;space over 3 spaces
	lda	histnum ;user number of this entry
	call 	prtby2  ;print user number
	mvi	B,6	 
	call    spaces  ;space over 6 spaces
	pop     H       ;get the current user addr
	inx	H	;HL = 8 chr name addr
	mvi	B,8
	call	prtchr	; print 8 chr name
	inx	H	; next addr in table
	mvi	B,4	
	call	spaces	; skip 4 spaces
	call	prttime	; print login time
	lxi     D,4     ;add 4 to HL
	dad     D       ;to get to the next entry
        jmp     FINISH  ;back to history request
;---------------
; Print one user for HIST that has logged out
PRTHIST:
	push    H	;save current table addr
	lxi	H,crlf	;space down a line
	call	prtmsg
	mvi	b,3
	call	spaces	;space over 3 spaces
	lda	histnum ;user number of this entry
	call 	prtby2  ;print user number
	mvi	B,6	 
	call    spaces  ;space over 6 spaces
	pop     H       ;get the current user addr
	inx	H	;HL = 8 chr name addr
	mvi	B,8
	call	prtchr	; print 8 chr name
	inx	H	; next addr in table
	mvi	B,4	
	call	spaces	; skip 4 spaces
	call	prttime	; print login time
	mvi	B,5
	call	spaces	; skip 5 spaces
	call	prttime	; print logout time
	inx     H	;get to the next entry in table
        jmp     FINISH  ;back to history request
.page
.sbttl	'Print the who table'
prtTABL:
	sub	A
	sta	unit	; re-initialize 
	lxi	H,crlf
	call	prtmsg
	lxi	H,HEADmsg
	call	prtmsg	; print table header
..1:	lxi	H,userlist ; HL = addr of table
	mvi	B,16	; B = bytes per line
	lda	unit	; user # for look up
	call	ADDRfind ; HL returns with addr
	call	prtline	; Print a line in table
	lda	unit
	inr	A	; increment the line
	sta	unit	
	cpi	numusr	; All users checked?
	jrc	..1	; No.  Loop back.
	lxi	H,crlf	; Yes.
	call	prtmsg	; space down a line
	lxi	H,spoollist ;address of spool table
	lxi	D,16	;length of each entry
	mvi	B,numspl ;number of entrys in table
..look:	push	H
	pop	x	;for a memory location
	mov	A,+1(x)
	cpi	numusr	;if 2nd byte is > numusr
	jrnc	retCCP	;invalid table
	mov	A,M	;ELSE, lets look at it
	cpi	6	;if no carry process entry
	jrc	..ok	
	dad	D	;ELSE, get next table entry
	djnz	..look	;and check it out
	jmp	retCCP	;no spool files, so return
..ok:	mvi	A,0
	sta	unit
	lxi	H,SPLmsg
	call	PRTmsg	;print spool title
..2:	lxi	H,spoollist ;spool list address
	mvi	B,16	;length of each entry
	lda	unit
	call	ADDRfind ;find this table entry
	call	prtspool ;print the entry 
	lda	unit
	inr	A
	sta	unit
	cpi	numspl	;if more entrys, go back for
	jrc	..2	;for another, ELSE, fall thru
;---------------
retCCP:			;and return to CCP 
	lspd	saveSP
	ret
.page
.sbttl 	'Print the spool table'
;----------- 
; Surbroutine prtspool:
; Print one spool table entry
; Regs in:   H, B 
; Regs out:  None
; Destroyed: A
prtspool:
	mov	A,m
	sta 	status
	cpi	6
	rnc
	push	H
	lxi	H,crlf	; skip to next line
	call	PRTMSG
	pop	H
	push	H
	lxi	B,8
	dad	B	; point to spool user name
	mvi	B,8
	call	prtchr	; print spool user name
	pop	H
	inx	H	; skip status and user number
	inx	H
	mvi	B,4
	call	spaces	; space over 5 
	call	prttime ; print the time on the CRT
	mvi	B,3
	call	spaces	; space over 3
	mov	C,M	; track
	inx	H
	inx	H
	mov	E,M	; sector
	call	prtlen	; print spool file length
	mvi	B,4
	call	spaces
	inx	H	; point to spltab
	lda	status
	slar	A	; HL will be incremented
	slar	A	; 8 bytes for each spool
	slar	A	; status type
	mvi	D,0
	mov	E,A
	dad	D	; HL points to spool table
	mvi	B,8
	call	prtchr
	ret
.page
;----------
; Print spool file length
;  Regs in:  C  = track
;	     E  = sector
prtlen:
	mov	A,C
	ani	0Fh
	mov	B,A	; B = number of 16K tracks
	mvi	C,0
	srlr	B
	rarr	C
	mov	L,E
	mvi	H,0
	dad	B
	dcx	H
	dcx	H	; subtract for spool table
	call	cvthlbcd
	push	D
	mov	A,D
	call	PRTby1	; print high byte
	pop	D
	mov	A,E
	call	PRTby2	; print low byte
	lxi	H,recdmsg
	call	PRTMSG
	ret
;--------------
; Subroutine testwho: Test entry, are they logged in
; Reg in:  A,PC
; Reg out: HL (set in prtwho or prthist)
; Destroyed: All (in prtwho or prthist)
;
TESTWHO:
	cpi     0FFh    ;if the entry is logged in, 
	jz 	prtwho  ;print the entry without 
	jmp 	prthist ;logout time,otherwise, 
                        ;print the who history line
FINISH:			;prtwho or prthist is done
	ret		;so return to hist request
.page
.sbttl	'Print line of who table'
; Subroutine prtline:  Print one user table entry
; Regs in:   A,BC,DE,HL
; Regs out:  None
; Destroyed: A,DE
PRTLINE:
	mov	A,M	; get the status
	sta	status	; store the status
	cpi	32	; Entry on this line?
	rc		; No. Return
	mvi	B,2
	call	spaces
	lda	unit	; A = user number
	call	prtby2	; print the user number
	mvi	B,4
	call	spaces
	inx	H	; HL = 8 chr name addr
	mvi	B,8
	call	prtchr 	; print 8 chr name
	inx	H	; addr of time in table
	mvi	B,4
	call	spaces
	call	prttime	; print login time
	mvi	B,5
	call	spaces
	call	prttime	; print last request time
	mvi	B,8
	call	spaces	; skip 8 spaces
	mov	A,M
	sui	10h	; net commands start at 10h
	jrc	..unk
	cpi	11h	; and end at 1Fh (20h is bad)
	jrc	..gdcmd
..unk:	mvi	A,11h	; unknown command
..gdcmd:lxi	H,reqtab
	slar	A	; HL will be incremented
	slar	A	; 8 bytes for each HiNet
	slar	A	; command type
	mvi	D,0
	mov	E,A
	dad	D	; HL points to command type
	mvi	B,8
	call	prtchr	; print request name
	mvi	B,3
	call	spaces	; skip 3 spaces
	lda	status	; Get the entry status
	lxi	H,actMSG ; Load active message
	cpi	slowpol	; Is it active?
	jrnc	..1	; Yes. Print active msg
	lxi	H,nactMSG ; No. Load inactive msg
..1:	call	prtmsg	; and print the message
	lxi	H,crlf
	call	prtmsg
	ora	A	; Clear A,
	ret		; and return
.page
;----------
; Print variable number of spaces
spaces:
	push	H	; save callers HL
	lxi	H,blanks
	call	prtchr	; B = number of spaces to print
	pop	H
	ret
;---------
;		Subroutine: ADDRfind
; Regs  in:    A = A line in table whose addr is needed
;	       B = Bytes per line of the table
;	       HL= addr of the start of the table
; Regs out:    HL= Addr of that line
ADDRfind:
	mvi	D,0
	mov	E,A
..mult:	dad	D	; HL = HL + A*B
	djnz	..mult
	ret
;---------------
; Subroutine CKrecstat: Check network transmissions
; Reg in:  A = RECstatus
; Reg out: Timeout  = Z set,   C set
; 	   CRC$OVR  = Z reset, C set
;	   no error = Z reset, C reset
CKrecst:
	bit	7,A	; check for timeout
	jrz	..bad
	bit	0,A	; check if poll
	jrnz	..bad
	ani	60h	; mask out crc and overrun
	jrnz	..bad
	ret
..bad:	mvi	A,0ffh
	ora	A
	ret

.page        
.sbttl	'Print the time'
;--------------
; Subroutine PRTTIME:  Print the time
; Reg in:  HL points to source for LDIR
; Reg out: None
; Destroyed: All
;
PRTTIME:
	lxi	D,seconds ; get the time location
	lxi	B,3	;number of bytes
	LDIR
	lda	hours	; Print the hours
	cpi	20h	; if no hours, dont print
	jrz	blnk	; anything so no garbage
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	..bb1
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
..bb1:	call	prtbyt
	mvi	A,':'
	call	CONOUT	
prtmin:	lda	minutes ; Print the minutes
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	..bb2
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
..bb2:	call	prtbyt
	mvi	A,':'
	call	CONOUT
prtsec:	lda	seconds	; Print the seconds
	call	cvtbcd
	cpi	10	;is leading 0 necessary?
	jp	..bb3
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
..bb3:	call	prtbyt
	ret		; date and time printed out.
blnk: 	mvi	B,08	; no time in user table,
	call	spaces	; print spaces and 
	ret		; return
.page
.sbttl	'CRT I/O Subroutines'
;-------------
; Print a message on the console
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M	;get what is in memory
	ora	A
	rz
	call	CONOUT
	inx	H	;next address
	jmpr	prtmsg	;do it over again
;----------
;		Subroutine: prtchr
; Regs  in:	B =length of string
;		HL=addr of string
; Regs out:	HL=addr of last chr printed
;Destroyed:	B,A
;Print a specified number of chrs to the console
prtchr:
	mov	A,M	;get what is in memory
	call	CONOUT
	dcr	B
	mov	A,B
	cpi	0	; all B chrs printed?
	rz
	inx	H	; next chr addr
	jmpr	prtchr	
;----------
; Print a byte on the console
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtbyt:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	
	jrz	..1	; dont print leading zeros
	call	prtnbl
..1:	pop	PSW
prtnbl:	ani	0Fh
	adi	'0'
	cpi	'9'+1
	jrc	CONOUT
	adi	'A'-('9'+1)
	jmpr	CONOUT
.page
;----------
; Print a byte on the console
;  (print blanks instead of leading zeros)
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtby1:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	
	jrz	..prtblk
	call	..prtnbl
	pop	PSW
..prtnbl:ani	0Fh
	adi	'0'
	cpi	'9'+1
	jrc	CONOUT
	adi	'A'-('9'+1)
	jmpr	CONOUT
..prtblk:mvi	A,' '
	call	CONOUT
	pop	PSW
	ani	0Fh
	jrnz	prtnbl
	mvi	A,' '
	jmp	CONOUT
;----------
; Print a byte on the console
;  (Do print leading zeros)
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtby2:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	
	call	..prtnbl
	pop	PSW
..prtnbl:ani	0Fh
	adi	'0'
	cpi	'9'+1
	jrc	CONOUT
	adi	'A'-('9'+1)
	jmpr	CONOUT
.page
;----------
; Convert binary to BCD
;  Regs in:   A = byte to be converted
;  Regs out:  A = byte, in BCD format
;  Destroyed: B
cvtbcd:
	ora	A
	rz
	mov	B,A
	xra	A
..1:	inr	A
	daa
	djnz	..1
	ret
;----------
; Subroutine:	cvtHLbcd
; Regs  in:	HL = word to be converted to BCD
; Regs out:	C,D,E = three bytes in BCD format
;Destroyed:	A,HL
;Convert a register pair's contents to BCD
cvtHLbcd:
	lxi	D,00
	lxi	B,00
..tst:	mov	A,H	; HL is our hex counter
	ora	A
	jrnz	..addBCD
	ora	L	; Does HL=0
	rz		; we finished decrementing HL
..addBCD:
	dcx	H	; reduce hex count
	mov	A,E	; now increment decimal count
	adi	1
	daa
	mov	E,A	; put low BCD back byte in E
	jrnc	..tst	; decrement, test again.
	mov	A,D	; Since carry was set
	adi	1	; Increment next BCD byte.
	daa
	mov	D,A	; put high BCD back byte in D
	jrnc	..tst	; decrement, test again.
	mov	A,C	; Since carry was set
	adi	1	; Increment next BCD byte.
	daa
	mov	C,A	; put Meg BCD byte back in C
	jmpr	..tst	; decrement, test again.
.page
;----------
; Print a character on the console
;  Regs in:   A = character to be printed
CONOUT:
	push	H
	push	D
	push	B
	mvi	C,2
	mov	E,A
	call	5	; print using BDOS
	pop	B
	pop	D
	pop	H
	ret
.page
.sbttl	'Define storage'
unit:	.byte	00h	; unit number of entry in table
status:	.byte	00h	; status of entry in stable
saveSP:	.word	0
NETcmd:	.byte	00h	; byte for Network Master
seconds:.byte	00h	; BIOS storage for time
minutes:.byte	00h	; bytes must be kept
hours:	.byte	00h	; TOGETHER*******
loops:	.byte	00h	; counter for HiNet error
retries:.byte	00h	; retries work together
histnum:.byte	00h	; user # to inc in HIST request
;
; BIOS Network jump addresses.
SENDNET:  jmp	0000h	; HiNET send 
RECVNET:  jmp	0000h	; HiNET receive 
Ackpoll:  jmp	0000h	; Acknowledge polls enable
Nackpoll: jmp	0000h	; Acknowledge polls disable
.page
.sbttl	'CRT messages'
;
LOGmsg: .ascii	[cr][lf]'Who for BIOS 2.244 and '
	.ascii		'later, version '
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.byte	patch
crlflf:	.asciz	[cr][lf][lf]
notnet: .asciz	'Must log into HiNet before using WHO'
deadMSG:.ascii	[cr][lf]'Your network is not '
	.ascii		'operational.'
	.ascii  [cr][lf]'Please check your HiNet '
	.asciz		'master station.'
TIMEmsg:.asciz	        'HiNet Status as of '
errcmd: .ascii  [cr][lf]'If you want the HiNet '
        .ascii          'history, enter WHO HIST.'
 	.ascii  [cr][lf]'If you want to know your '
	.ascii          'login data, enter WHO AM I.'
	.asciz  [cr][lf]'Please try again.'
HISTitl:.ascii  [cr][lf]'           This is the '
	.asciz          'login history.' 
AMItitl:.asciz          'This is your login data.'
HISTmsg:.ascii  [cr][lf]'User No  User Name    ' 
	.ascii          'Login Time   Logout Time'
	.ascii  [cr][lf]'-------  ---------    '       
	.asciz          '----------   -----------'
HEADmsg:.ascii  [cr][lf]'User No User Name   Login Time'
	.ascii          '   Last Req Time   Request    '
	.ascii		'Status'
	.ascii  [cr][lf]'------- ---------   ----------'
  	.ascii          '   -------------   -------    '
 	.asciz		'------'[cr][lf]
SPLmsg:	.ascii	[cr][lf]'User Name   Spool Time   '
	.ascii		'File Length   Status'
	.ascii	[cr][lf]'---------   ----------   '
	.asciz		'-----------   ------'
actMSG:	.asciz		'active'
nactMSG:.asciz		'logging out'
crlf:	.asciz	[cr][lf]
blanks:	.ascii	'                  '
recdmsg:.asciz	' records'
spltab:	.ascii	'starting'
	.ascii	'spooling'
	.ascii	'ready   '
	.ascii	'printing'
	.ascii	'finished'
	.ascii	'waiting '
	.ascii	'unknown '
.page
;----------
; Request name table
reqtab:
	.ascii	'who     '
	.ascii	'read    '
	.ascii	'write   '
	.ascii	'login   '
	.ascii	'startspl'
	.ascii	'read    '
	.ascii	'stopspl '
	.ascii	'assign  '
	.ascii	'hog     '
	.ascii	'lock    '
	.ascii	'unlock  '
	.ascii	'clrlock '
	.ascii	'spool   '
	.ascii	'volstat '
	.ascii	'date tim'
	.ascii	'??????  '
	.ascii	'??????  '
	.ascii	'unknown '	; unknown command
;
	.blkw   30
stack:
	.end
