.title 'Key Loader for the FOX'
.ident keyload
.SBTTL 'EQUATE DEFINITION AREA'
	.PABS
	.PHEX
	.sall
	version == '1'
	revision == '0'
	assembly == ' '
;
; *****************************************
;	EQUATE AREA
;	
	lf==0AH
	cr==0DH
	true==0ffH
	false==0
	bell == 07h
	superesc == 0fbh

;  *  *  *  *  *  *  *  *  *  *  *  *
;  internal file has equates for standard BDOS calls
BDOS==5
BDSYSRES==0
BDCONIN==1
BDCONOUT==2
BDREADIN==3
BDPUNOUT==4
BDLSTOUT==5
BDDIRCONIO==6
BDGTIOBYTE==7
BDSTIOBYTE==8
BDPRINT==9
BDRDCONBUF==0AH
BDGTCONSTAT==0BH
BDVERNUM==0CH
BDRESDISK==0DH
BDSELDISK==0EH
BDOPFILE==0FH
BDCLFILE==10H
BDSRCFIRST==11H
BDSRCNEXT==12H
BDDLFILE==13H
BDRDSEQ==14H
BDWRSEQ==15H
BDMKFILE==16H
BDRNFILE==17H
BDLOGVECT==18H
BDCURDISK==19H
BDSTDMA==1AH
BDGTALLOC==1BH
BDWRPROT==1CH
BDGTROVECT==1DH
BDSTFILEATTR==1EH
BDGTDSKPARM==1FH
BDUSERCODE==20H
BDRDRAND==21H
BDWRRAND==22H
BDFLSIZE==23H
BDSTRAND==24H
;
; END BDOS CALL EQUATES
;    * * * * * * 
;
	masktop3 == 1fh
	lastkey == 1eh
;
;  FCB equates
	fcbname==1
	fcbext==9
	fcbex==12
	fcbcr==32
	fcbr0==33
;
;
;	END of EQUATE AREA
; *****************************************
;
.page
.SBTTL 7MACRO DEFINITION AREA7
;    MACRO AREA
;
;  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
; OUTMESS - outputs message name to screen, saves environment	
.define outmess [messname]=
[	lxi	d,messname
	call	messout
]
; END OUTMESS MACRO
;  ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
; jmpdegthl - jmp if de > HL
	.define	jmpdegthl[jmpaddr]=[
	ora	a	; clear cy
	dsbc	d
	jc	jmpaddr ]
;
;    END MACRO AREA
;*****************************************************
.prntx	/ after macros/
.PAGE
.SBTTL  7MAIN LOGIC7
;
	.LOC	100H
start:
;
;  com line processor
	outmess	headMess
	call	cmlproc
	lda	iscomline
	cpi	true
	jz	minFileopen
	call	fileOpen
flopret:
;
; read file 
	lxi	d,last
rdloop:
	push	d
	;set DMA
	mvi	c,bdStDMA
	call	bdos
	; read record
	mvi	c,bdRdSeq
	lxi	d,kbdFCB
	call	bdos
	; returns 0 on succesful read 
	ora	a
	pop	d
	jnz	readDone
	lxi	h,128
	dad	d
	xchg	; d has addr of next read
	jmpr	rdloop

readDone:
; loop reads a key and sends it out to keyboard
;
lxi	h,last
loadloop:
	mov	a,m	; key 
	; if zero last key is sent
	ora	a
	jz	loaddone
	;
	sta	loadstring + 2
	inx	h	; length byte
	mov	a,m
	sta	loadstring + 3
	inx	h	; first byte of string
	lxi	d,loadstring + 4	
	mov	c,a
	mvi	b,0
	ldir	
	; string is moved into loadstring, put
	;	trailing 0, h is incremented to 
	;	start of next string
	push	h
	xra	a
	stax	d
	lxi	h,loadstring
	call	prints
	pop	h
	jmpr	loadloop
	;
loaddone:
	;close file
	lxi	d,kbdFCB
	mvi	c,bdclFile
	call	bdos
	jmp	0
;
minfileopen:
	call	midFileopen
	jmp	flopret
;
;	end of main logic
;
; ++++++++++++++++++++++++++++++++++++++++++++++++
; FILEOPEN gets PRN file name, opens PRN file, erases old XRF file, and opens a work 
; file  
fileOpen:
	outmess	nameMess	;prompts for file name
	call	inmess		; gets name from user
	mvi	a,false
	sta	isComLine	; if we jump here because
				; of bad filename reject 
				; command line
midfileopen:	; jumps here if got name from command line
	lda	conlength	; length of name read must be >0
	ora	a
	jz	badfilename
	call	extractFN
	; put opening message and file name to screen
	outmess	opprnmess
	call	FNprint		
	; open kbd file
	lxi	d,kbdFCB
	call	loadFCB		; loads up PRNfcb
	lxi	d,kbdFCB
	mvi	c,bdOpFile	
	call	bdos		; opens file, returns FFh on failure
	cpi	0FFh	; on ask for new name off
	jz	badfilename
	ret
;
; 
;  if invalid KBD file name was entered
badfilename:
	outmess	badnamemess
	jmp	fileOpen

; FILE OPEN subroutines
;
; EXTRACTFN gets file name and drive number from console buffer, and loads them
;	into FLNAME and DRVNUM
extractFN:
	; load DRVNUM with 0 and filename with blanks
	lxi	b,8
	lxi	d,filename
	lxi	h,blanks
	ldir
	lxi	b,3
	lxi	d,filext
	lxi	h,blanks
	ldir
	xra	a
	sta	DRVNUM	; set drivenum to zero
	;
	lxi	h,conlength
	mov	b,M
	inx	h	; addr of condata
	push	h
	call	capit
	; if length is less than 3 don't check for :
	pop	h	; h has addr condata
	lda	conlength
	mov	c,a
	cpi	3
	jm	extrc1
	; check for : in second character of string
	inx	h	; h now points to second position
	mov	a,M
	dcx	h	; hl points to condata
	cpi	':'
	jnz	extrc1   ; leave drivenum at zero
	; change drivenum
	mov	a,M	; drive char is now in a 
	sta	drvChar
	sbi	'A'-1
	sta	drvnum
	inx	h
	inx	h	; hl now points to start of name
	lda	conlength
	dcr	a
	dcr	a	; a has length of file name
	mov	c,a
; MOVE FILE NAME
; At this point hl points to name in buffer and c holds its length. If length
;	is greater than 8 then truncate to 8
extrc1:
	lxi	d,filename
	mov	a,c
	cpi	9
	jm	extrc2
	mvi	c,8
extrc2:
	; now that c has the maxlength, 
	; h is source, d is target , start 
	; moving till endchar or max length is hit
	mov	a,m
	cpi	' '
	rz	; end of valid entry
	cpi	'.'
	jrz	extrc3
	stax	d
	inx	h
	inx	d
	dcr	c
	jrnz	extrc2
extrc3:
	; get extension if any 
	; at this point h points to . if there is an 
	; extension
	mov	a,m
	cpi	'.'
	rnz
	inx	h	; first char in extension
	push	h
	lxi	h,conlength
	mov	e,m
	mvi	d,0
	dad	d	
	inx	h  ; addr of past last byte in string
	pop	b ; current byte
	push	b
	ora	a	;;reset carry
	dsbc	b	; hl has length of extenison
	mov	a,l	
	cpi	4      ; max length
	jm	extrc4
	mvi	a,3
extrc4:
	mov	c,a
	mvi	b,0
	pop	h    ; current byte in input string
	lxi	d,filext
	ldir
	ret
;	
;
; FILEOPEN error routines
;
; END of FILEOPEN subroutine
;
;
;
; +++++++++++++++++++++++++++++++++++++++++++
; checks for and processes command line
CmlProc:
	mvi	a,false
	sta	iscomLine
	lxi	h,80h
	mov	a,m	; length of command string
	cpi	2
	rc
	dcr	a	;drop leading blank from length
	sta	comlength
	inx	h
	inx	h
	mov	a,m
	cpi	' '
	rz	; second char is a blank, reject
		; command lline
	; there is a command string
	mvi	a,true
	sta	isComline
	; find end of file and extent name
	lxi	b,1
cml1:
	inx	h
	inr	c
	lda	comlength
	cmp	c
	jc	cml2
	mov	a,m
	cpi	' '
	jz	cml2
	jmpr	cml1
cml2:		; bc has length+1, move file name 
		; string into condata
	dcr	c
	lxi	d,conlength
	mov	a,c	; length
	stax	d
	inx	d
	lxi	h,82h	; begining of file name
	ldir
	ret

;++++++++++++++++++++++++++++++++++++++++++++++
; CAPIT capitalizes all letters in string points to by hl of length b
capit:
	mov	a,M
	call	capOne
	inx	h
	dcr	b
	jnz	capit	
	; if we drop through whole string is exameined
	ret
capone:		; checks char to see if it needs to be capitalized
	cpi	'a'
	rm
	cpi	'z'+1
	rp
	res	5,M
	ret
; END of CAPIT
;

; ++++++++++++++++++++++++++++++++++++++++++++
;  LOADFCB - moves file name and drivenum into FCB at addr in de
LOADFCB:
	push	d
	lxi	h,drvnum
	ldi
	lxi	h,filename
	lxi	b,8
	ldir
	lxi	h,filext
	lxi	b,3
	ldir
	; zero out ex,cr,r0,r1,r2
	xra	a	
	pop	h
	lxi	d,fcbex
	dad	d
	mov	m,a	; zeroes ex
	lxi	d,fcbcr-fcbex
	dad	d
	mov	m,a	; zeroes cr
	inx	h
	mov	m,a	; now zero three random bytes
	inx	h
	mov	m,a
	inx	h
	mov	m,a
	ret
; END of LOADFCB
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; FNprint - prints out the file name, checking drive num to see if it needs
;		to print out the drve character also
FNprint:
	lda	drvnum
	cpi	0
	jz	Fnpr1
; drive number not zero so print drive char also
	outmess	drvchar
	ret
FNpr1:
	outmess	filename
	ret
; END of FNPRINT
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;  ++++++++++++++++++++++++++++++++++++++++++++
;
;MESSOUT - outputs message to screen
messout:
	push	h
	push	b
	push	d
	mvi	c,bdprint
	call	bdos
	pop	d
	pop	b
	pop	h
	ret
; END OF MESSOUT
;
prints:
	mov	a,m
	ora	a
	rz
	push	h
	mov	e,a
	mvi	c,6
	call	bdos
	pop	h
	inx	h
	jmpr	prints
;
;
;   ******   ++++++++++++++++++++++++++++
;  CONOUT
; de has addr of message, bc has length
;
conout:
	xchg
..loop:
	push	h
	push	b
	mov	e,m	
	mvi	c,2
	call	bdos
	pop	b
	pop	h
	dcx	b
	mov	a,b
	ora	c
	rz
	inx	h
	jmp	..loop	
;
;	conin  - read one char into a
;
conin:
	mvi	e,0ffh
	mvi	c,1
	call	bdos
	ret
;
;    ++++++++++++++++++++++++++++++++++++++++++
;
; INMESS - gets message from screen of up to 80 chars, saves environment	
INMESS:
	push	h
	push	b
	push	d
	mvi	c,bdrdcon
	lxi	d,conbuff
	call	bdos
	outmess	crlfmess   ; put out carraige return
	pop	d
	pop	b
	pop	h
	ret
; END INMESS SUBROUTINE
;
	
;
;
.PAGE
.SBTTL 'DATA AREA'
;
;  CONSTANTS
;
BLANKS:		.ASCII	'                                                                               '
LOWALPHA:	.ASCII	'abcdefghijklmnopqrstuvwxyz'

; SYtable is list of valid symbol characters.  When looking for first letter of
;  a symbol length of table is 29 to exclude digits, otherwise length of table
;	is 39
CAPALPHA:	.ASCII	'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
RADCHARS:	.ascii	'.%$'
DIGITS:		.ascii	'0123456789'
;
;
;
;
;	MESSAGE AREA 
headMess:	.ascii 'KeyLoader version '
		.byte	version,'.',revision,assembly
crlfmess:	.byte	lf,cr,'$'
badnamemess:	.byte	lf,cr
		.ascii	'Bad file name.$'
nameMess:	.byte	lf,cr
		.ascii 'Enter name of file to load keys from $'
opPrnmess:	.ascii	'Opening file $'

loadstring:	.byte	superesc,'l'
		.blkb	256
;
;	END MESSAGE AREA	
;
;mainDMA:		.byte	0,80H     ; system default value of DMA 
;
;   File Name Variables
drvnum:		.blkb	1
drvchar:	.blkb	1
		.byte	':'
filename:	.blkb	8
		.byte	'.'
filext:		.blkb	3
		.byte	'$'
;
;    ***** FCB area ******
KBDfcb:	;	.BLKB	9	; drive number and file name
		.byte	0
		.ascii	'TEST    '
		.ascii	'   '	; extension
		.BLKB	24	; remainder of FCB
;		
;   **** input form console ****
conbuff:	.BYTE	80	; buffer for console messages (80 max input)
conlength:	.BLKB	1	; length of input
condata:	.BLKB	80	; input data
;
	
; DATA for handleing command line
;
iscomline:	.blkb	1	; is there a command line
comflag	:	.blkb	1	; whats in comand line
comlength:	.blkb	1   ; length of command string 

;
last:
	.end	start
