;
;
;			THIS FILE IS NAMED MMH6BIOS asm

*-----------------------------------------------------------------------------
;	--->	System DISK RELATED SCRATCH is located at 40 hex
;==============================================================================
;   includes MICROMATION MULTI I/O board DRIVER IN SINGLE USER CONFIGURATION
;==============================================================================
;	--->	BIOS scratch 4E-4F is updated on Hard disk select with
;		Hard disk PROM vector
;	--->	This version assumes hard disk is located at F000

;		- - - - - - - - - - - - - - - - - - - - -
;	--->	FOR I/O MAPPED HARD DISK CONTROLLER ONLY
;		- - - - - - - - - - - - - - - - - - - - -

*-----------------------------------------------------------------------------

;			LAST TIME UPDATED	Sept 12 1980
	*****************************************************************
	*								*
	*			   REVISION - 6				*
	*								*
	*	  THIS IS I/O SYSTEM FOR USE WITH MICROMATION		*
	*	"DOUBLER" and "HARD" disk controllers PAIR ONLY.	*
	*								*
	* --->	Sorry, but this bios is not compatible with any other	*
	*			   controllers				*
	*								*
	* --->	8 heads version (SHUGART SA-4008 - 20 meg. drive)	*
	*								*
	*		AS USED WITH <C2> PROM DOUBLER.		        *
	*	    SINGLE/DOUBLE DENSITY, SINGLE/DOUBLE SIDED.		*
	*								*
	*	COPYRIGHT (C) 1979, MICROMATION AND DIGITAL RESEARCH.	*
	*								*
	*****************************************************************

FDRIVES		EQU	4	;4 floppy drives
HEADS		EQU	8	;8 headed hard disk
MSIZE		EQU	60	;SIZE OF OPERATING SYSTEM IN KILOBYTES
				;(CURRENTLY 60K).  THIS NUMBER MUST BE
				;CHANGED FOR LARGER SYSTEMS.

	    * MAXIMUM MEMORY SIZE IN SINGLE USER SYSTEM IS 60K *

*******************************************************************************
;ABSOLUTE LENGTH OF BIOS ASSEMBLED: CANNOT BE MORE THAN 380H BYTES LONG

;------------------------------------------------------------------------------
BIOSIZE		SET	ENDDAT-BIOS
;------------------------------------------------------------------------------


*******************************************************************************
TRUE	EQU	-1		!		FALSE	EQU	0
*******************************************************************************

*==============================================================================
*	I/O BYTE FOR LIST DEVICE IS IMPLEMENTED AS FOLLOWS:
*		"TTY" = MULTLIST (MM MULTI I/O BOARD SERIAL PORT#1)
*		"CRT" = NOT IMPLEMENTED DUE TO LACK OF SPACE IN BIOS
*		"LPT" = CENTLIST (CENTRONICS 703/779 TYPE LIST DEVICE)
*		"UL1" = NOT IMPLEMENTED DUE TO LACK OF SPACE IN BIOS 
*==============================================================================
;
;	LIST DEVICE EQUATES: (THESE SHOULD BE SET FALSE TO SAVE BIOS SPACE SO
;			     THAT A USER DEFINED LIST DRIVER CAN BE INSERTED)
;	
MULTLIST	EQU	TRUE	
CENTLIST	EQU	TRUE
;------------------------------------------------------------------------------
USERLIST	EQU	FALSE	;NOT SUPPORTED DUE TO LACK OF SPACE IN BIOS
;------------------------------------------------------------------------------

;	"BIAS" IS ADDRESS OFFSET FROM 3400H FOR MEMORY SYSTEMS LARGER
;	THAN 20K (REFERRED TO AS "B" THROUGHOUT THE TEXT).

BIAS	EQU	(MSIZE-20)*1024
CCP	EQU	3400H+BIAS	;BASE OF CCP
BDOS	EQU	CCP+806H	;BASE OF BDOS
BIOS	EQU	CCP+1600H	;BASE OF BIOS

IOBYTE	EQU	0003H	;INTEL I/O BYTE

*----------------------------------------------------------------------------
HARDCONT	EQU	0F000H		;location of HARD DISK CONTROLLER
HARDVECTOR	EQU	HARDCONT	;HARD DISK EPROM jump vector table.

HINIT		EQU	HARDVECTOR+3	;location of hard disk initialization
HARDSELECT	EQU	HARDVECTOR+9	;address of hard disk HEAD select
					;subroutine in hard vector table
; --->	above declarations correspond to fixed JUMP VECTORS AND
;	may not be changed.
*-----------------------------------------------------------------------------




	*************************************************
	*     FLOPPY CONTROLLER declarations follow	*
	*************************************************

CONTROLLER	EQU	0F800H		;ADDRESS OF CONTROLLER
PROM		EQU	CONTROLLER	;ADDRESS OF DOUBLER PROM
BUFF		EQU	CONTROLLER+400H	;ADDRESS OF SCRATCH RAM


	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*		HARDWARE PORT DEFINITIONS		*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

WRCONT		EQU	CONTROLLER+600H
RDSTAT		EQU	WRCONT
WRCLK		EQU	WRCONT+1
UARTDATA	EQU	WRCONT+2
RDMARK		EQU	WRCONT+5	;LOADS THE HEAD
UARTSTAT	EQU	WRCONT+0AH


	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*		RAM VARIABLE DEFINITIONS		*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

DENBYTE		EQU	BUFF+1		;0 FOR SINGLDE DEN., 10 FOR DBL.DEN
CTRBYTE		EQU	BUFF+3		;RAM IMAGE OF RDSTAT OR WRCONT
TRACK		EQU	BUFF+4		;TRACK NUMBER FOR CURRENT DRIVE
PRESDSK		EQU	BUFF+5		;CURRENTLY LOGGED IN DRIVE NO.
SECTOR		EQU	BUFF+0AH
NXTDISK		EQU	BUFF+0DH	;DRIVE NO. FOR NEXT I/O (READ/WRITE)
STEPTIME	EQU	BUFF+10H	;STEP TIME IN MSEC
DENMAP		EQU	BUFF+16H	;FOR EACH OF 4 DRIVES,
					;00 FOR SINGLE DENSITY
					;10H FOR <C> PROM
					;04H FOR <C1>PROM FOR DOUBLE DENSITY
TRY1		EQU	BUFF+20H	;CBIOS ERROR CHECK
RETRYCOUNT	EQU	BUFF+21H	;CBIOS TRK./SECTOR ERROR CHK. BYTE
CURRDRIVE	EQU	BUFF+22H	;CBIOS DISK, LOGGED IN BEFORE WARMBOOT


	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	* Jump Vectors to routines in FLOPPY Controller	PROM	*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

CHOME		EQU	PROM+3	;HOMES THE DISK
CSELDSK		EQU	PROM+6	;SELECTS DRIVE POINTED TO BY C REG
					;AND LOADS HEAD
CSETTRK		EQU	PROM+9	;STEPS DRIVE TO TRACK (C)
CSETSEC		EQU	PROM+0CH	;SET SECTOR NUMBER
CSETDMA		EQU	PROM+0FH	;SET DMA ADDRESS
DISKWRITE	EQU	PROM+15H	;WRITE SECTOR
DISKREAD	EQU	PROM+12H	;SECTOR READ
SETDEN		EQU	PROM+1BH	;TEST DENSITY OF CURRENT DRIVE
WRITEPROTECT	EQU	PROM+1EH	;CHECK FOR WRITE PROTECT







	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
		ORG	BIOS	;ORIGIN OF THIS PROGRAM
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

NSECTS		EQU	($-CCP)/128	;WARM START SECTOR COUNT

BOOTBASE	EQU	0		;BOTTOM OF USABLE MEMORY
CPMDRIVE	EQU	BOOTBASE+4	;LOC. 04 OF PAGE 00. CURRENT CPM DISK

		*****************************************
		*					*
		*	  LIST DEVICE EQUATES		*
		*					*
		*****************************************

	IF (MULTLIST OR CENTLIST)
	;ASSEMBLED ONLY FOR PORTS ON MICROMATION MULTI I/O BOARD

*==============================================================================
*
* PORT EQUATES:CHANGE VALUE OF UART1C TO RE-MAP THE PORT DECODING OF I/O BOARD
*
*	NOTE:DECODING OF BOARD I/O SPACE OCCURS ALONG 32 PORT BOUNDRIES 
*	     (I.E.:A5-A7 ARE SIGNIFICANT ADDRESS BITS FOR I/O BLOCK)
*==============================================================================

*******************************************************************************

UART1C	EQU	0		;CONTROL PORT OF 8251 #1 (IC 4B)

*******************************************************************************

BASE	EQU	UART1C		;EQUATE BASE FOR REST OF TABLE
UART1D	EQU	BASE+1 		;DATA PORT OF UART #1

UART2C	EQU	BASE+4		;UART #2 (IC 5B)
UART2D	EQU	BASE+5

UART3C	EQU	BASE+8		;UART #3 (IC 7B)
UART3D	EQU	BASE+9

UART4C	EQU	BASE+0CH	;UART #4 (IC 9B)
UART4D	EQU	BASE+0DH

P8255	EQU	BASE+10H	;8255 CONTROL REG. (IC 1A)
PORTC	EQU	BASE+11H
PORTB	EQU	BASE+12H
PORTA	EQU	BASE+13H

RTC	EQU	BASE+14H	;8253 TIMER/COUNTER CONTROL PORT (IC 3B)
TIMER2	EQU	BASE+15H	;COUNTER #2
TIMER1	EQU	BASE+16H	;COUNTER #1
TIMER0	EQU	BASE+17H	;COUNTER #0

;------------------------------------------------------------------------------
;NOTE THESE VALUES ARE FOR REV 2 MM I/O BRDS. (REV 1 HAS PORTS 0 & 1 ONLY)
;------------------------------------------------------------------------------
PORT0	EQU	BASE+18H	;PARALLEL OUTPUT LATCH (IC 2A) 
PORT1	EQU	BASE+19H	;PARALLEL OUTPUT LATCH (IC 3A)
PORT2	EQU	BASE+1AH	;RESET RTC INTR.1       
PORT3	EQU	BASE+1BH	;RESET RTC INTR.0	
;------------------------------------------------------------------------------

USERPRT	EQU	BASE+1CH	;BASE OF USER DEFINED I/O PORTS (PORTS 1C-1FH)

*******************************************************************************
	ENDIF			;STOP CONDITIONAL ASSEMBLY
		

	IF CENTLIST     
	;CONDITIONAL ASM FOR MM MULTI I/O BRD FOR USE WITH CENRONICS PRINTER

COMMAND		EQU	P8255		;COMMAND WORD REGISTER
DATAPORT	EQU	PORT0		;PARALLEL DATA OUTPUT LATCH TO PRINTER
STATUS		EQU	PORTC		;STATUS BITS:OBF/=BIT 7
					;	     ACK/=BIT 6
					;	     BUSY=BIT 5
	ENDIF			;END OF PORT DEFINITIONS FOR CENTLIST

	IF USERLIST	
	;SPACE RESERVED FOR ANY USER DEFINED LIST DEVICE EQUATES

	ENDIF


	*****************************************************************
	*								*
	*	BIOS SCRATCH FOR BOTH FLOPPY & HARD DISK DRIVES		*
	*								*
	*****************************************************************

BSCRATCH	EQU	40H		;BIOS SCRATCH FOR BIOS USE

SEEKDSK		EQU	BSCRATCH	;DISK # SELECTED ON BIOS SELEC DISK
RWFUNC		EQU	BSCRATCH+1	;READ-WRITE FUNCTION
					;hard disk READ = 05, WRITE = 04
SEEKTRK		EQU	BSCRATCH+2	;requested track # to seek
SEEKSEC		EQU	BSCRATCH+4	;sector #
SEEKDMA		EQU	BSCRATCH+6	;DMA ADDRESS will be stored here

RWRESULT	EQU	BSCRATCH+8	;result of last READ-WRITE operation
					;=00 if ok, 01 if permanent error.
FDENSIDE	EQU	BSCRATCH+9	;FLOPPY density - side information

HSWITCH		EQU	BSCRATCH+10	;HARD - FLOPPY DISK SWITCH
SECSIZSW	EQU	BSCRATCH+0BH	;Sector Size switch (=01 for 128 bytes
					;=02 for 256, 04 for 512)
HFLTSTAT	EQU	BSCRATCH+12	;HARD DISK WRITE FAULT STATUS
					;DURING WRITE SECTOR
SIDE		EQU	BSCRATCH+0DH	;Bios Floppy SIDE info.
HPRVECT		EQU	BSCRATCH+0EH	;Hard disk Prom Start address


	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*	JUMP VECTORS FOR INDIVIDUAL SUBROUTINES		*
	*		USED BY ENTIRE SYSTEM			*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	JMP	BOOT		;COLD START
BWBOOT	JMP	WBOOT		;WARM START
	JMP	CONST		;CONSOLE STATUS
	JMP	CONIN		;CONSOLE CHARACTER IN
	JMP	CONOUT		;CONSOLE CHARACTER OUT
	JMP	LIST		;LIST CHARACTER OUT
	JMP	PUNCH		;PUNCH CHARACTER OUT
	JMP	READER		;READER CHARACTER OUT
	JMP	HOME		;BIOS MOVE HEAD TO HOME POSITION
	JMP	SELDSK		;BIOS SELECT DISK (DOESN'T ACTUALLY SELECTS)
	JMP	SETTRK		;BIOS SET TRACK
	JMP	SETSEC		;BIOS SET SECTOR
	JMP	CSETDMA		;CONTROLLER SET DMA ADDRESS
	JMP	READ		;BIOS READ DISK
	JMP	WRITE		;BIOS WRITE DISK
	JMP	LISTST		;RETURN LIST SEATUS
	JMP	SECTRAN		;SECTOR TRANSLATE


	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*	FIXED DISK PARAMETER BLOCK TABLES FOR FOUR	*
	*		   DRIVE SYSTEM				*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

*--------------------------------
DPBASE	EQU	$	;BASE OF DISK PARAMETER BLOCKS
*--------------------------------

;	DISK PARAMETER BLOCK FOR DRIVE NO. 00

DPE0:	DW	TRANS,0000H	;TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV0,ALV0	;CHECK, ALLOC VECTORS

;	DISK PARAMETER BLOCK FOR DRIVE NO. 01

DPE1:	DW	TRANS,0000H	;TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV1,ALV1	;CHECK, ALLOC VECTORS

;	DISK PARAMETER BLOCK FOR DRIVE NO. 02

DPE2:	DW	TRANS,0000H	;TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV2,ALV2	;CHECK, ALLOC VECTORS

;	DISK PARAMETER BLOCK FOR DRIVE NO. 03

DPE3:	DW	TRANS,0000H	;TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB0	;DIR BUFF, PARM BLOCK
	DW	CSV3,ALV3	;CHECK, ALLOC VECTORS


	* * * * * * * * * * * * * * * * * * * * *
	*	HARD DISK PARAMETER HEADERS	*
	* * * * * * * * * * * * * * * * * * * * *

		;BECAUSE OF CP/M 2.0 LIMITATION ON MAXIMUM STORAGE CAPACITY
		;FOR ANY DRIVE (8 MEGABYTES), WE HAVE TO DIVIDE ONE
		;SHUGART SA-4008 DRIVE INTO FOUR PSEUDO DRIVES.

		;EACH PSEUDO DRIVE IS JUST A 1/4 PART OF SA-4008 DRIVE.
		;SA-4008 DRIVE HAS 8 INDEPENDENT HEADS, 2 ON EACH SIDE OF
		;DOUBLE DISK DRIVE. WE WILL CONSIDER ONE PSEUDO DRIVE TO BE
		;TWO HEADS OF SA-4008, WHICH DECREASES EACH PSEUDO DRIVE
		;CAPACITY TO AROUND 6 MEGABYTES MAX., RESOLVING LIMITATION.


;DISK PARAMETER HEADER FOR DRIVE NO 04 (HARD DISK, HEADS 0,1)

DPE4:	DW	0000H,0000H	;HARD DISK SECTOR TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB4	;DIR BUFF,PARM BLOCK
 	DW	0000H,ALV4	;CHECK, ALLOC VECTORS

;	DISK PARAMETER HEADER FOR DRIVE NO. 05 (HARD DISK, HEADS 2,3)

DPE5:	DW	0000H,0000H	;HARD DISK SECTOR TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB4	;DIR BUFF,PARM BLOCK
	DW	0000H,ALV5	;CHECK, ALLOC VECTORS

;	DISK PARAMETER HEADER FOR DRIVE NO. 06 (HARD DISK, HEADS 4,5)

DPE6:	DW	0000H,0000H	;HARD DISK SECTOR TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB4	;DIR BUFF,PARM BLOCK
	DW	0000H,ALV6	;CHECK, ALLOC VECTORS

;	DISK PARAMETER HEADER FOR DRIVE NO.07 (HARD DISK, HEADS 6,7)

DPE7:	DW	0000H,0000H	;HARD DISK SECTOR TRANSLATE TABLE
	DW	0000H,0000H	;SCRATCH AREA
	DW	DIRBUF,DPB4	;DIR BUFF,PARM BLOCK
	DW	0000H,ALV7	;CHECK, ALLOC VECTORS

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *

;-------------------------------------
TRANS:	;Floppy SECTOR TRANSLATE TABLE
;-------------------------------------
	DB	1,7,13,19	;SECTORS 1,2,3,4
	DB	25,5,11,17	;SECTORS 5,6,7,8
	DB	23,3,9,15	;SECTORS 9,10,11,12
	DB	21,2,8,14	;SECTORS 13,14,15,16
	DB	20,26,6,12	;SECTORS 17,18,19,20
	DB	18,24,4,10	;SECTORS 21,22,23,24
	DB	16,22		;SECTORS 25,26

;------------------------------------------------------------------
DPB0:	;DISK PARAMETER BLOCK FOR SINGLE DENSITY SINGLE SIDED DISKS
	;WITH BLOCK SIZE BLKSZ = 1024 BYTES / BLOCK
;------------------------------------------------------------------
	DW	26		;SECTORS PER TRACK
	DB	3		;BLOCK SHIFT FACTOR
	DB	7		;BLOCK MASK
	DB	0		;NULL MASK
	DW	242		;DISK SIZE-1 (NO. OF BLOCKS/DISK-1)
	DW	63		;NO. OF DIRECTORY ENTRIES MAX.-1
	DB	192		;DIRECTORY ALOCATION SPACE MASK, 1 ST BYTE
	DB	0		;SAME AS ABOVE, 2 ND BYTE
	DW	16		;CHECK SIZE - (64 DIR ENTRIES DIV BY 4)
	DW	2		;NO. OF SYSTEM (NOT ACCESSABLE) TRACKS

;------------------------------------------------------------------
DPB1:	;DISK PARAMETER BLOCK FOR DOUBLE DEN., SINGLE SIDED DISKS
	;WITH BLOCK SIZE BLKSZ = 2048 BYTES / BLOCK
;------------------------------------------------------------------
	DW	52		;SECTORS PER TRACK
	DB	4		;BLOCK SHIFT FACTOR
	DB	15		;BLOCK MASK
	DB	1		;EXTENT MASK
	DW	242		;DISK SIZE-1 (NO. OF BLOCKS/DISK-1)
	DW	127		;NO. OF DIRECTORY ENTRIES MAX.-1
	DB	192		;DIRECTORY ALOCATION SPACE MASK, 1 ST BYTE
	DB	0		;SAME AS ABOVE, 2 ND BYTE
	DW	32		;CHECK SIZE
	DW	2		;NO. OF SYSTEM (NOT ACCESSABLE) TRACKS

;------------------------------------------------------------------
DPB2:	;DISK PARAMETER BLOCK FOR SINGLE DEN., DOUBLE SIDED DISKS
	;WITH BLOCK SIZE BLKSZ = 2048 BYTES / BLOCK
;------------------------------------------------------------------
	DW	52		;SECTORS PER TRACK
	DB	4		;BLOCK SHIFT FACTOR
	DB	15		;BLOCK MASK
	DB	1		;EXTENT MASK
	DW	242		;DISK SIZE-1 (NO. OF BLOCKS/DISK-1)
	DW	127		;NO. OF DIRECTORY ENTRIES MAX.-1
	DB	192		;DIRECTORY ALOCATION SPACE MASK, 1 ST BYTE
	DB	0		;SAME AS ABOVE, 2 ND BYTE
	DW	32		;CHECK SIZE
	DW	2		;NO. OF SYSTEM (NOT ACCESSABLE) TRACKS

;------------------------------------------------------------------
DPB3:	;DISK PARAMETER BLOCK FOR DOUBLE DEN., DOUBLE SIDED DISKS
	;WITH BLOCK SIZE BLKSZ = 4096 BYTES / BLOCK
;------------------------------------------------------------------
	DW	104		;SECTORS PER TRACK
	DB	5		;BLOCK SHIFT FACTOR
	DB	31		;BLOCK MASK
	DB	3		;EXTENT MASK
	DW	242		;DISK SIZE-1 (NO. OF BLOCKS/DISK-1)
	DW	127		;NO. OF DIRECTORY ENTRIES MAX.-1
	DB	128		;DIRECTORY ALOCATION SPACE MASK, 1 ST BYTE
	DB	0		;SAME AS ABOVE, 2 ND BYTE
	DW	32		;CHECK SIZE
	DW	2		;NO. OF SYSTEM (NOT ACCESSABLE) TRACKS


;-----------------------------------
;		HARD DISK PARAMETERS:
;-----------------------------------

;	BLOCK SIZE		16384		- bytes
;	SECTORS			103		- sectors
;	SKEW			0		- no skew
;	MAX DIR	ENTRIES		350		- 350 directory entries
;	CHEC DIR ENTRIES	0		- no directory check
;	SYSTEM TRACKS		2		- 2 system tracks in fact

;DISKDEF	0,0,103,0,16384,323,350,0,2

DPB4:		;DISK PARAMETER BLOCK FOR ALL 4 PSEUDO HARD DISKS.

	DW	103		;SEC PER TRACK
	DB	7		;BLOCK SHIFT
	DB	127		;BLOCK MASK
	DB	7		;EXTNT MASK
	DW	322		;DISK SIZE-1
	DW	349		;DIRECTORY MAX-1
	DB	128		;ALLOC0
	DB	0		;ALLOC1
	DW	0		;CHECK SIZE (IF ZERO, THEN NO DIRECTORY CHECK)
	DW	2		;OFFSET

	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	*							*
	*		END OF FIXED TABLES			*
	*							*
	* * * * * * * * * * * * * * * * * * * * * * * * * * * * *


	*********************************************************
	*	*	*	*	*	*	*	*
	*********************************************************

;--------------------------------
BOOT:	;COLD BOOT ENTRY
;--------------------------------
	MVI	A,81H
	STA	IOBYTE		;INITIALIZE THE IOBYTE
				;(LST:=LPT:, CON:=CRT:)
	XRA	A		;ZERO IN THE ACCUM
	STA	CPMDRIVE	;LOC 0004 - CPM CURRENT DISK NO.

*------------------------------------------------------------------------------
;	INITIALIZATION ROUTINES FOR LIST DEVICES FOLLOW:
*------------------------------------------------------------------------------

	IF MULTLIST
	;CONDITIONAL ASSEMBLY FOR MICROMATION MULTI I/O BOARD FOLLOWS

	;8251 UART INITIALIATION:
	MVI	A,0EH		;THESE FIRST TWO BYTES PUT 8251'S IN MODE SET
	OUT	UART1C		;
	NOP			;WASTE TIME AT 4MHZ....
	NOP
	MVI	A,40H		;
	OUT	UART1C		;
	NOP			;WASTE TIME AT 4MHZ....
	NOP
	MVI	A,0EEH		;MODE SET:ASYNC,8 DATA & 2 STOP BITS,NO PARITY
	OUT	UART1C		;
	NOP			;WASTE TIME AT 4MHZ....
	NOP
	MVI	A,37H		;COMMAND WORD:ENABLE RXD & TXD, RTS/ & DTR/ 
				;FLAGS SET, ERROR FLAGS RESET...
	OUT	UART1C		;

	;8253 INITIALIZATION:
	MVI	A,0B6H		;SET MODE OF 8253 COUNTER #2 (BAUD CLOCK)
	OUT	RTC		;
	MVI	A,13		;DIVIDE BY 13 OF MASTER 2MHZ. CLOCK
	OUT	TIMER2		;
	XRA	A		;
	OUT 	TIMER2		;
	ENDIF			;END OF CONDITIONAL ASSEMBLY


	IF CENTLIST
	;8255 INITIALIZATION: SETS UP CENTRONICS TYPE PRINTER DRIVER

	MVI	A,0A8H		;DEFINE MODE: PORTA= MODE1 (OUTPUT)
				;PORTC= STATUS A AND MODE0 (INPUT)
			    	;PORTB= DON'T CARE (SET TO MODE0 OUTPUT)
	OUT	COMMAND		;
	MVI	A,0FFH		;TURN OFF DATA STROBE
	OUT	DATAPORT	;
	ENDIF			;STOP CONDITIONAL ASSEMBLY FOR CENTLIST


	IF USERLIST
	;SPACE RESERVED FOR USER DEFINED LIST DRIVER INITIALIZATION

	ENDIF

	JMP	GOCPM		;INITIALIZE AND GO TO CP/M

;--------------------------------
WBOOT:	;SIMPLEST CASE IS TO READ THE DISK UNTIL ALL SECTORS LOADED
;--------------------------------
	LXI	SP,CCP		;SET UP STACK BELOW CP/M
	MVI	C,0		;SELECT DISK 0
	CALL	CSELDSK
	CALL	CHOME		;GO TO TRACK 00

	MVI	B,NSECTS	;B COUNTS # OF SECTORS TO LOAD
	MVI	C,0		;C HAS THE CURRENT TRACK NUMBER
	MVI	D,2		;D HAS THE NEXT SECTOR TO READ

;	NOTE THAT WE BEGIN BY READING TRACK 0, SECTOR 2 SINCE SECTOR 1
;	CONTAINS THE COLD START LOADER, WHICH IS SKIPPED IN A WARM START

	LXI	H,CCP		;BASE OF CP/M (INITIAL LOAD POINT)
LOAD1:	;LOAD ONE MORE SECTOR
	PUSH	B		;SAVE SECTOR COUNT, CURRENT TRACK
	PUSH	D		;SAVE NEXT SECTOR TO READ
	PUSH	H		;SAVE DMA ADDRESS
	MOV	C,D		;GET SECTOR ADDRESS TO REGISTER C
	CALL	CSETSEC		;CONTROLLER SET SECTOR ADDRESS FROM REGISTER C
	POP	B		;RECALL DMA ADDRESS TO B,C
	PUSH	B		;REPLACE ON STACK FOR LATER RECALL
	CALL	CSETDMA		;SET DMA ADDRESS FROM B,C
;
;	DRIVE SET TO 0, TRACK SET, SECTOR SET, DMA ADDRESS SET
	CALL	DISKREAD	;DIRECT DISK READ OF ONE SECTOR
	ORA	A		;ANY ERRORS?
	JNZ	WBOOT		;RETRY THE ENTIRE BOOT IF AN ERROR OCCURS
;
;	NO ERROR, MOVE TO NEXT SECTOR
	POP	H		;RECALL DMA ADDRESS
	LXI	D,128		;DMA=DMA+128
	DAD	D		;NEW DMA ADDRESS IS IN H,L
	POP	D		;RECALL SECTOR ADDRESS
	POP	B		;RECALL NUMBER OF SECTORS REMAINING
				;AND CURRENT TRK
	DCR	B		;SECTORS=SECTORS-1
	JZ	GOCPM		;TRANSFER TO CP/M IF ALL HAVE BEEN LOADED
;
;	MORE SECTORS REMAIN TO LOAD, CHECK FOR TRACK CHANGE
	INR	D
	MOV	A,D		;SECTOR=27?, IF SO, CHANGE TRACKS
	CPI	27
	JC	LOAD1		;CARRY GENERATED IF SECTOR<27
;
;	END OF CURRENT TRACK, GO TO NEXT TRACK

NXTTRK:
	MVI	D,1		;BEGIN WITH FIRST SECTOR OF NEXT TRACK
	INR	C		;TRACK=TRACK+1
;
;	SAVE REGISTER STATE, AND CHANGE TRACKS
	PUSH	B
	PUSH	D
	PUSH	H
	CALL	CSETTRK	;TRACK ADDRESS SET FROM REGISTER C
	POP	H
	POP	D
	POP	B
	JMP	LOAD1		;FOR ANOTHER SECTOR
;
;	*	*	*	*	*	*	*	*

;--------------------------------
GOCPM:	;END OF LOAD OPERATION, SET PARAMETERS AND GO TO CP/M
;--------------------------------
	MVI	A,0C3H		;C3 IS A JMP INSTRUCTION
	STA	0		;FOR JMP TO WBOOT
	LXI	H,BWBOOT	;CBIOS WBOOT ENTRY POINT
	SHLD	1		;SET ADDRESS FIELD FOR JMP AT 0
;
	STA	5		;FOR JMP TO BDOS
	LXI	H,BDOS		;BDOS ENTRY POINT
	SHLD	6		;ADDRESS FIELD OF JUMP AT 5 TO BDOS
;
	LXI	B,80H		;DEFAULT DMA ADDRESS IS 80H
	CALL	CSETDMA
;
;		EI		;ENABLE THE INTERRUPT SYSTEM
	LDA	CPMDRIVE	;CPM BOOT DRIVE
	MOV	C,A		;SEND TO THE CCP
	JMP	CCP		;GO TO CP/M FOR FURTHER PROCESSING
;
;	*	*	*	*	*	*	*	*
;
;	ERROR CHECKING READ AND WRITE ROUTINES FOR
;	MICROMATION CBIOS
;
;		AUGUST 1,1978
;

;--------------------------------
PROTECTED:	;DISK WAS WRITE PROTECTED
;--------------------------------
	LXI	D,PROTMES	;WRITE PROTECT MESAGE
	CALL	PRINT		;PRINT IT

	CALL	CONIN		;WAIT FOR A CHAR & UNLOAD HEAD
	CPI	03		;REBOOT ?
	JZ	WBOOT		;REBOOT IF SO, OTHERWISE

;-------------------------------
WRITE:	;WRITE 1 SECTOR ON DISK
;-------------------------------
	CALL	SETUP		;SELECT DISK, STEP TO CORRECT TRACK
	CALL	WRITEPROTECT	;SETS Z IF DRIVE IS PROTECTED
	JZ	PROTECTED	;IF PROTECTED, PRINT MESSAGE

	MVI	A,DISKWRITE AND 0FFH	;LOW ADDRESS OF WRITE ROUTINE IN PROM
	JMP	READWRITE

;--------------------------------
READ:	;READ 1 SECTOR
;--------------------------------
	CALL	SETUP		;SELECT DRIVE, STEP TO CORRECT TRACK
	MVI	A,DISKREAD AND 0FFH	;LOW ADDRESS OF READ ROUTINE IN PROM

READWRITE:
	STA	RW+1		;STORE ADDRESS IN CALL INSTRUCTION
	XRA	A
	STA	TRY1		;ZERO OUT ERROR COUNTERS
	STA	RETRYCOUNT
RETRY:
	DI
RW:	CALL	DISKREAD	;READ OR WRITE SECTOR
				;SETS Z ON SUCCESSFUL READ
				;SETS C ON TRACK ERROR
	EI
	MVI	A,0
	RZ			;SUCCESSFUL READ. RETURN

				;READ OR WRITE ERROR HANDLERS
	JC	TRACKERROR	;READ AND WRITE SET C ON TRACK ERROR
	LXI	H,RETRYCOUNT
	INR	M		;INCREMENT RETRYCOUNT
	MOV	A,M
	ANI	0FH		;16 TRIES
	JNZ	RETRY		;IF MORE THAN 16 RETRIES, TRY RESEEKING

TRACKERROR:
	LXI	H,TRY1
	INR	M		;INCREMENT NO OF TRACK ERRORS
	MOV	A,M
	CPI	10		;ALLOW ONLY 10 TRACK ERRORS
	MVI	A,1		;CP/M CONVENTION FOR PERMANENT ERROR
	RZ			;IF >10, RETURN A FAILURE

	CALL	CHOME		;ELSE, HOME THE HEAD
	LDA	SEEKTRK
	MOV	C,A
	CALL	CSETTRK		;RESEEK TO CORRECT TRACK
	JMP	RETRY

PROTMES	DB	CR,LF,'PROTECTED$'

*------------------------------------------------------------------
SETUP:	;SELECTS REQUESTED DRIVE IF IT IS NOT ALREADY SELECTED
	;STEPS TO REQUESTED TRACK
	;SETS UP CONTROLLER TO TRANSFER DATA TO/FROM PROPER SIDE OF DISK
*------------------------------------------------------------------
	LDA	NXTDISK		;GET NEXT DISK NO.
	MOV	C,A
	LDA	PRESDSK		;GET PRES DSK.
	CMP	C		;EQUAL?
	CNZ	CSELDSK		;IF NO, SELECT NEXT DISK

	LDA	SEEKTRK		;GET REQUESTED TRACK NUMBER
	MOV	C,A
	LDA	TRACK		;GET TRACK # WE'RE ON
	CMP	C		;ARE WE ON REQUESTED TRACK?
	CNZ	CSETTRK		;IF NO, CALL CONTROLLER SETTRK ROUTINE

	LDA	SIDE		;SIDE = 00 FOR SIDE 0
	RRC			;SHIFT SIDE BIT INTO CARRY
	CMC			;COMPLEMENT CARRY
	LXI	H,CTRBYTE
	MOV	A,M
	RAL			;SHIFT CARRY INTO BIT 0, SET CARRY = BIT 7
	RRC			;ROTATE IT BACK TO NORMAL
	MOV	M,A
	RET

;	*	*	*	*	*	*	*	*

*-----------------------------------------
SELDSK:	;SELECT DISK GIVEN BY REGISTER <C>
*-----------------------------------------
;ON ENTRY, BIT 0 OF REGISTER E CONTAINS THE DRIVE STATUS
;BIT 0 IS 0 IF THE SELECTED DRIVE IS "OFF LINE"
;(NEVER BEEN SELECTED SINCE LAST WARM BOOT)
;WE WANT TO TEST THE DENSITY OF THE DISK IF IT IS OFF LINE
*-----------------------------------------
	MOV	A,C		;Get disk #
	CPI	FDRIVES+HEADS/2	;must be between 0 and 7 (if hard disk is
				;"ON LINE" or 0-3 if it is not
	JNC	BADSEL		;Bad select, return error status, reset DISK

	CPI	FDRIVES		;hard or floppy ?
	JNC	HARDSEL		;if hard disk, go see wether we DO HAVE HARD
				;DISK controller on line, HARD TEST returns
				;to caller with error code <H,L> = 00
				;if NO CONTROLLER IS ON LINE

*- - - - - - - - - - - - - - - -
FLDSKSEL:	;FLOPPY SELECT, disk number
		;is in the proper range
*- - - - - - - - - - - - - - - -
	STA	SEEKDSK		;BIOS SCRATCH (common for both - hard & floppy
	STA	NXTDISK		;DOUBLER SCRATCH LOC. FOR NEXT DISKOP
	XRA	A		;POINT DISK SWITH TO FLOPPY
	STA	HSWITCH		;save disk switch

	MOV	A,E		;GET DRIVE STATUS (bit 0) FOR EVALUATION
	RAR			;GET BIT 0 - DRIVE 0 LOGIN STAT INTO CARRY
	CNC	SETPARM		;FLOPPY DISK TEST, CARRY IS CLEAR IF DRIVE IS
				;JUST BEING SELECTED FOR THE FIRST TIME
				;SELECT DESIRED DRIVE, TEST DENSITY

*---------------------------------------------------
CALCDPE:  ;COMPUTE PROPER DISK PARAMETER HEADER ADDRESS
*---------------------------------------------------
	LDA	NXTDISK		;GET DISK, WHICH BACAME PRESENT AFTER SEL.

*- - - - - - - - - - - - - - - -
HARCON:	;continue from here for
	;both - hard & floppy
*- - - - - - - - - - - - - - - -
	MOV	L,A		;L=DISK NUMBER 0,1,2,3
	MVI	H,0		;HIGH ORDER ZERO
	DAD	H		;*2
	DAD	H		;*4
	DAD	H		;*8
	DAD	H		;*16 (SIZE OF EACH HEADER)
	LXI	D,DPBASE
	DAD	D		;HL=.DPBASE(DISKNO*16)
	RET

*	*	*	*	*	*	*	*	*

*----------------------------------------------------------------
HARDSEL:	;UPDATE DISK SWITCH, SELECT HARD DISK 
		;<C> contains hard disk # selected
*----------------------------------------------------------------
	LDA	HARDVECTOR	;get first location of hard disk EPROM
	CPI	0C3H		;is it a jump instruction ?

	JZ	OKSELECT	;looks like hard disk is out there, lets try

BADSEL:	;Hard disk is NOT READY, ERROR
	XRA	A		;failure, change CP/m drive back to <A>
	STA	CPMDRIVE	;LOC 0004 - CPM CURRENT DISK NO.
	LXI	H,0000H		;error code return from disk select to CP/m
	RET			;return directly to CP/m

*- - - - - - - - - - - - - - - -
OKSELECT:	;HARD DISK is selected
*- - - - - - - - - - - - - - - -
	PUSH	B		;save disk # selected
	LXI	H,HARDVECTOR	;HARD DISK EPROM jump vector table.
	SHLD	HPRVECT		;Hard disk Prom Start address
	LDA	COLDSTAT	;Get COLD BOOT STATUS (=0 if it is a first
				;select after coldboot
	CALL	HARDSELECT	;call hard disk select <C> contains DISK #
				;---> hard disk select returns here
	POP	B
	INR	A		;if was FF then Drive NOT READY, Will try again
	JZ	BADSEL		;HARD DISK IS NOT READY, ERROR

	DCR	A		;If 00 then BAD map was READ OK
	MVI	A,0FFH
	STA	COLDSTAT	;HARD DISK INIT was performed
	JNZ	BADSEL		;BAD MAP read Error

	MOV	A,C		;get ot to <A> for SELECT DISK return
	JMP	HARCON		;calculate proper DPHead, return to CP/m

*	*	*	*	*	*	*	*	*

*--------------------------------------------------------
SETPARM:	;FLOPPY TEST DISK WHICH IS BEING SELECTED
		;FOR THE FIRST TIME AFTER WARMBOOT
		;ON ENTRY, <C> REG CONTAINS DISK NUMBER TO BE SELECTED
*--------------------------------------------------------
	CALL	CSELDSK		;SELECT DISK ROUTINE IN PROM
	CALL	CHOME		;HOME THE HEAD
	MVI	C,2		;STEP TO TRACK 2
	CALL	CSETTRK		;IN PROM, STEPPING FROM TRACK 0 OR 1 TO
				;TRACK 2 TESTS THE DENSITY
				;DENSITY INFO IN DENBYTE IS NOW VALID
	CALL	CALCDPE		;CALCULATE DISK PARAMETER HEADER ADDRESS
	MVI	B,0		;FOR DAD
	MOV	M,B		;ZERO OUT SECTOR TRANSLATE POINTER IN DPE
	INX	H		;(IF DISK IS SINGLE DENSITY, WE'LL REPLACE IT)
	MOV	M,B
	LDA	RDSTAT		;CHECK FOR DOUBLE SIDED DISK
	ANI	40H		;IF BIT 6 IS LOW, DISK IS DOUBLE SIDED
	MVI	C,DPB2-DPB0	;OFFSET IN PARM TABLE FOR DOUBLE SIDED
	JZ	DBLSIDD

	MVI	C,0		;NO OFFSET FOR SINGLE SIDED
DBLSIDD
	LDA	DENBYTE		;NOW FIND DENSITY
				;FOR <C> PROM, DENBYTE = 0 FOR SD, 10H FOR DD
				;FOR <C1> PROM, DENBYTE = 0 FOR SD, 4 FOR DD
	ORA	A		;DENBYTE = 0?
	MVI	A,DPB1-DPB0	;OFFSET IN PARM TABLE FOR DOUBLE DENSITY
	JNZ	DBLDEN

				;SINGLE DENSITY.
	XRA	A		;NO OFFSET FOR SINGLE DENSITY
	DCX	H		;POINT BACK TO BEGINNING OF DP HEADER
	MVI	M,TRANS AND 0FFH ;PUT IN LOW BYTE OF TRANSLATE TABLE POINTER
	INX	H
	MVI	M,TRANS SHR 8	;PUT IN HIGH BYTE OF TRANSLATE TABLE POINTER

DBLDEN	ADD	C		;ADD OFFSET FOR # SIDES
	STA	FDENSIDE	;STORE IN SCRATCH FOR USE BY UTILITIES
	MVI	C,9		;INDEX INTO PARM HEADER TO DPB FIELD
	DAD	B		;HL NOW CONTAINS ADDRESS OF DPB ENTRY OF HEADER
	XCHG			;SAVE IT IN DE

	MOV	C,A		;MOVE DPB OFFSET TO C FOR DAD
	LXI	H,DPB0		;POINT TO BEGINNING OF PARM BLOCKS
	DAD	B		;NOW HL POINT TO CORRECT PARM BLOCK
	XCHG			;NOW DE POINT TO CORRECT PARM BLOCK
				;RESTORE ADDRESS OF DPB ENTRY OF HEADER TO HL
	MOV	M,E		;PUT LOW BYTE OF DPB ADDRESS INTO DP HEADER
	INX	H
	MOV	M,D		;PUT HIGH BYTE OF DPB ADDRESS INTO DP HEADER
	RET

*------------------------------------------------------------------
HOME:	;MOVE TO THE TRACK 00 POSITION OF CURRENT DRIVE
	;TRANSLATE THIS CALL INTO A SETTRK CALL WITH PARAMETER 00
*------------------------------------------------------------------
	MVI	C,0

*---------------------------------------
SETTRK:	;SET TRACK GIVEN BY REGISTER <C>
*---------------------------------------
	MOV	A,C
	STA	SEEKTRK		;JUST STORE TRACK NUMBER
	RET


	*********************************************************
	*	*	*	*	*	*	*	*
	*********************************************************


*------------------------------------------------------------------
SECTRAN:	;SECTOR TRANSLATE ROUTINE
		;THIS ROUTINE HANDLES ONLY SINGLE BYTE SECTOR VALUES
		;AND SINGLE BYTE TRANSLATE TABLES
*-------------------------------------------------------------------
		;ON ENTRY, <B>=0, <C>=LOGICAL SECTOR NUMBER, AND DE POINT TO
		;THE TRANSLATE TABLE
;ON EXIT, <H>=0 AND <L> CONTAINS THE PHYSICAL SECTOR NUMBER

;IF DE=0000H, DO NOT TRANSLATE. JUST PUT MOVE BC INTO HL,
;	INCREMENT (TO REFERENCE TO First Physical SECTOR 1, NOT 0), AND RETURN

;IF <D,E> is NOT 0000, WE ASSUME THE DISK IS SINGLE DENSITY
;NORMALIZE <C> TO THE RANGE OF <0 TO 25> (BY SUBTRACTING 26 IF NECESSARY)
;TRANSLATE WITH THE TABLE POINTED TO BY <D,E> AND, IF 26 WAS SUBTRACTED,
;ADD IT BACK IN
;RESULT IS RETURNED IN <H,L> (IT'S IN THE RANGE <1 TO 52>)
*------------------------------------------------------------------
	MOV	L,C		;MOVE BC (LOG SECT) TO HL (PHYS SECT)
	MOV	H,B		;H IS NOW ZERO (SINCE B WAS)
	INX	H		;INCREMENT FOR PHYSICAL SECTOR NUMBER
	MOV	A,D
	ORA	E		;DE=0000H?
	RZ			;IF YES, RETURN

	DCX	H		;DECR HL BACK TO LOGICAL SECT #
	MOV	A,C
	SUI	26		;SECTOR NUMBER < 26?
	JC	UNDER26

	MVI	B,26		;IF NO, PUT 26 IN B (TO ADD IN LATER)
	MOV	L,A		;PUT (C)-26 IN L REG

UNDER26				;NOW L IS IN RANGE OF 0-25
	DAD	D		;INDEX INTO TRANSLATE TABLE
	MOV	A,M		;GET PHYSICAL SECTOR NUMBER FROM TABLE
	ADD	B		;ADD OFFSET FOR SIDE 1
	MVI	H,0
	MOV	L,A		;PUT BACK IN L REG
	RET


*--------------------------------------------------------------------
SETSEC:		;SET SECTOR ROUTINE
		;DECIDES IF DISK IS SINGLE OR DOUBLE SIDED
		;NORMALIZES THE SECTOR NUMBER (1-26 IN SD, 1-52 IN DD)
		;UPDATES "SIDE
		;JUMPS TO CONTROLLER SET SECTOR ROUTINE
*--------------------------------------------------------------------
	LXI	H,DENMAP	;POINT TO DENSITY TABLE
	LDA	NXTDISK		;GET DISK NUMBER
	ADD	L		;INDEX INTO TABLE
	MOV	L,A
	MOV	A,M		;GET DENSITY BYTE
	LXI	H,SIDE
	MVI	M,0		;INITIALIZE SIDE TO 0
	ORA	A		;SINGLE DENSITY?
	MOV	A,C		;MOVE SECTOR NUMBER TO ACCUMULATOR
	JZ	SDSECT
				;DOUBLE DENSITY
	SUI	26		;IF DOUBLE DENSITY, SECTOR # < 53?

SDSECT	SUI	27		;IF SINGLE DENSITY, SECTOR # < 27?
	JM	SIDE0		;IF YES, SIDE=0, USE SECTOR NUMBER IN C
				;SIDE 1
	INR	M		;SET SIDE=1
	INR	A
	MOV	C,A		;USE SECTOR NUMBER IN ACCUMULATOR

SIDE0	JMP	CSETSEC		;GO TO CONTROLLER SET SECTOR ROUTINE
				;(SECTOR NUMBER IS IN C REG)


	*********************************************************
	*							*
	*    		SIMPLE I/O HANDLERS			*
	*	    HARDWARE UART CONSOLE ROUTINES		*
	*							*
	*********************************************************

CR		EQU	0DH	;ASCII <CR>
LF		EQU	0AH	;<LF>
BELL		EQU	07	;<BELL> at the console

;-----------------------------------
CONSTAT:
CONST:	;CONSOLE STATUS, RETURN 0FFH
	;IF CHARACTER READY, 00H IF NOT
;-----------------------------------
	LDA	UARTSTAT
	ANI	2
	RZ
	MVI	A,0FFH
	RET

*	*	*	*	*	*	*	*	*

;-----------------------------------
CONIN:	;CONSOLE CHARACTER INTO REGISTER A
;-----------------------------------
	CALL	CONSTAT
	JZ	CONIN
	LDA	UARTDATA
	ANI	7FH
	RET

*	*	*	*	*	*	*	*	*

;-----------------------------------
CONOUT: ;CONSOLE CHARACTER OUTPUT FROM REGISTER C
;-----------------------------------
	LDA	UARTSTAT
	ANI	01
	JZ	CONOUT
	MOV	A,C
	STA	UARTDATA
	RET

*	*	*	*	*	*	*	*	*

*===========================================================================
LIST:	;THIS ROUTINE IMPLEMENTS THE I/O BYTE FUNCTION FOR LST: DEVICES
*===========================================================================
*	I/O BYTE FOR LIST DEVICE IS IMPLEMENTED AS FOLLOWS:
*		"TTY" = MULTLIST (MM MULTI I/O BOARD SERIAL PORT#1)
*		"LPT" = CENTLIST (CENTRONICS 703/779 TYPE LIST DEVICE)
* --->N.B.:"CRT" AND "UL1" ARE NOT SUPPORTED IN THIS BIOS DUE TO LACK OF SPACE
*===========================================================================

	IF NOT (USERLIST OR MULTLIST OR CENTLIST)
	RET			;THEN RETURN BECAUSE IT IS NOT SUPPORTED
	ENDIF
 
	IF USERLIST
	;SPACE FOR USER DEFINED LIST ROUTINE
	;--------------------------------------------------
	;MULTLIST AND CENTLIST FLAGS MUST BE SET TO 'FALSE'
	;--------------------------------------------------
	RET
	ENDIF

	IF (MULTLIST OR CENTLIST)
	LDA	IOBYTE		;GET THE CURRENT I/O STATUS
	ANI	0C0H
	JZ	MULTLST		;MM MULTI I/O BRD SERIAL PORT AS LIST

CENTLST
	IF CENTLIST	  	;LIST ROUTINE FOR CENTRONICS 703/779 PRINTER
	XRA	A		;CLEAR CARRY FLAG
	IN	STATUS		;GET STATUS BYTE
	RAL			; 
	RAL			;
	RAL			;CHECK BIT 5:PRINTER BUSY???
	JC	CENTLST		;
AKWAIT	IN	STATUS		;
	ANI	80H		;CHECK BIT 7:/OBF??? (EMPTY=HIGH)
	CPI	80H		;
	JNZ	AKWAIT		;
	MOV	A,C		;GET CHARACTER FROM C REG.
	CPI	0AH		;PRINTER IS AUTO LINEFEED
	RZ
	ORI	80H		;RESET DATA STROBE BIT FIRST...
	OUT	DATAPORT	;OUT TO PRINTER
	OUT	PORTA		;THIS SETS THE /OBF FLAG OF STATUS PORT
	ANI	7FH		;GENERATE DATA STROBE:BIT 7 OF PORT0
	OUT	DATAPORT	;
	ORI	80H		;
	OUT	DATAPORT	;
	ENDIF			;END OF LIST ROUTINE FOR CENTRONICS 779
	RET

MULTLST:
	IF MULTLIST   ;BEGIN CONDITIONAL ASSEMBLY FOR MM I/O BOARD SERIAL OUT

	IN	UART1C		;GET STATUS
	ANI	81H		;CHECK TO SEE IF TRANSMITTER BUFFER IS EMTPY--
	CPI	81H		;AND IF DSR IS ACTIVE
	JNZ	MULTLST		;WAIT TO SEND IT IF NOT...
	MOV	A,C		;GET CHARACTER TO OUTPUT
	OUT	UART1D		;SEND IT TO LIST DEVICE
	ENDIF			;STOP ASSEMBLING FOR THE MM MULTI I/O BOARD
	RET

	ENDIF			;END OF LIST DRIVER BLOCK...(DO NOT REMOVE.)



*	*	*	*	*	*	*	*	*

*------------------------------------
LISTST:	;RETURN LIST STATUS
	;(0 IF NOT READY, 1 IF READY)
*------------------------------------
	XRA	A	;0 IS ALWAYS OK TO RETURN

*---------------------------
PUNCH:	;Not used any longer
READER:
*---------------------------
	RET


*----------------------------------------
PRINT:	;Direct PRINT STRING by <D,E>
	;at the CONSOLE till ($) is found
*----------------------------------------
	LDAX	D		;GET NEXT BYTE TO PRINT
	CPI	'$'		;END?
	RZ

	MOV	C,A
	CALL	CONOUT		;OUTPUT CHARACTER TO CONSOLE
	INX	D		;POINT TO NEXT CHARACTER
	JMP	PRINT

*	*	*	*	*	*	*	*	*	*

	*********************************************************
	*							*
	*  THE REMAINDER OF THE CBIOS IS RESERVED UNINITIALIZED	*
	*  DATA AREA, AND DOES NOT NEED TO BE A PART OF THE	*
	*  SYSTEM MEMORY IMAGE (THE SPACE MUST BE AVAILABLE,	*
	*  HOWEVER, BETWEEN "BEGDAT" AND "ENDDAT").		*
	*							*
	*********************************************************

;------------------------------------
;	SCRATCH RAM AREA FOR BDOS USE
;------------------------------------

BEGDAT		EQU	$	;BEGINING OF DATA AREA

COLDSTAT	DB	0	;COLD BOOT STATUS FOR HARD DISK INITIALIZATION

DIRBUF		DS	128	;DIRECTORY ACCESS BUFFER

ALV0		DS	31	;ALLOCATION VECTOR 0
CSV0		DS	32	;CHECK VECTOR 0

ALV1		DS	31	;ALLOCATION VECTOR 1
CSV1		DS	32	;CHECK VECTOR 1

ALV2		DS	31	;ALLOCATION VECTOR 2
CSV2		DS	32	;CHECK VECTOR 2

ALV3		DS	31	;ALLOCATION VECTOR 3
CSV3		DS	32	;CHECK VECTOR 3

ALV4		DS	41	;HARD DIS ALLOCATION VECTORS
CSV4		DS	0

ALV5		DS	41	;HARD DIS ALLOCATION VECTORS
CSV5		DS	0

ALV6		DS	41	;HARD DIS ALLOCATION VECTORS
CSV6		DS	0

ALV7		DS	41	;HARD DIS ALLOCATION VECTORS
CSV7		DS	0

ENDDAT		EQU	$		;END OF DATA AREA
DATSIZ		EQU	$-BEGDAT	;SIZE OF DATA AREA


*-------------------------------------
	END	;END OF FILE
*-------------------------------------
