
"
    PASCAL PROGRAM TO SETUP INTERLEAVED TEMP1 & TEMP2 FILES


    INVOCATION:

    *INTRLV


    (NOTES: PROGRAM REQUIRES APPROX 9 MINUTES TO EXECUTE.
            THERE MUST BE 875 BLOCKS FREE ON :F1:.
            THIS PROGRAM INSURES TEMP FILE SPACE OF SUFFICIENT SIZE
              TO SELF-COMPILE THE COMPILER.  THEREFORE, IT IT IS NOT
              REQUIRED FOR THE COMPILATION OF RELATIVELY SHORT PROGRAMS.)

"



"###########
#  PREFIX  #
###########"

CONST NL = '(:10:)';   FF = '(:12:)';   CR = '(:13:)';   EM = '(:25:)';

CONST PAGELENGTH = 512;
TYPE PAGE = ARRAY (.1..PAGELENGTH.) OF CHAR;

CONST LINELENGTH = 132;
TYPE LINE = ARRAY (.1..LINELENGTH.) OF CHAR;

CONST IDLENGTH = 16;
TYPE IDENTIFIER = ARRAY (.1..IDLENGTH.) OF CHAR;

TYPE FILE = 1..4;

TYPE ARGTAG =
  (NILTYPE, BOOLTYPE, INTTYPE, IDTYPE, PTRTYPE);

TYPE POINTER = @BOOLEAN;

TYPE ARGTYPE = RECORD
                 CASE TAG: ARGTAG OF
                   NILTYPE, BOOLTYPE: (BOOL: BOOLEAN);
                   INTTYPE: (INT: INTEGER);
                   IDTYPE: (ID: IDENTIFIER);
                   PTRTYPE: (PTR: POINTER)
               END;

CONST MAXARG = 10;
TYPE ARGLIST = ARRAY (.1..MAXARG.) OF ARGTYPE;

TYPE ARGSEQ = (INP, OUT);

TYPE PROGRESULT =
  (TERMINATED, OVERFLOW, POINTERERROR, RANGEERROR, VARIANTERROR,
   HEAPLIMIT, STACKLIMIT, CODELIMIT, TIMELIMIT, CALLERROR);

PROCEDURE READ(VAR C: CHAR);
PROCEDURE WRITE(C: CHAR);
PROCEDURE OPEN(F: FILE; ID: IDENTIFIER; VAR FOUND: BOOLEAN);
PROCEDURE CLOSE(F: FILE);
PROCEDURE GET(F: FILE; P: INTEGER; VAR BLOCK: UNIV PAGE);
PROCEDURE PUT(F: FILE; P: INTEGER; VAR BLOCK: UNIV PAGE);
PROCEDURE NOTUSED1;
PROCEDURE MARK(VAR TOP: INTEGER);
PROCEDURE RELEASE(TOP: INTEGER);
PROCEDURE IDENTIFY(HEADER: LINE);
PROCEDURE ACCEPT(VAR C: CHAR);
PROCEDURE DISPLAY(C: CHAR);
PROCEDURE NOTUSED2;
PROCEDURE NOTUSED3;
PROCEDURE NOTUSED4;
PROCEDURE NOTUSED5;
PROCEDURE READARG(S: ARGSEQ; VAR ARG: ARGTYPE);
PROCEDURE WRITEARG(S: ARGSEQ; ARG: ARGTYPE);
PROCEDURE NOTUSED6;
PROCEDURE NOTUSED7;
PROCEDURE NOTUSED8;
PROCEDURE NOTUSED9;
PROCEDURE RUN(ID: IDENTIFIER; VAR PARAM: ARGLIST;
              VAR LINE: INTEGER; VAR RESULT: PROGRESULT);

PROGRAM INTRLV;

CONST
    TEMP1_SIZE=130;
    TEMP2_SIZE=85;

VAR
    FOUND: BOOLEAN;
    BLOCK: PAGE;
    NXTBLK: INTEGER;

BEGIN

   OPEN(1,':F1:TEMP1       ',FOUND);
   OPEN(2,':F1:TEMP2       ',FOUND);

   FOR NXTBLK := 1 TO TEMP1_SIZE DO
   BEGIN
      PUT(1,NXTBLK,BLOCK);
      IF NXTBLK <= TEMP2_SIZE THEN
         PUT(2,NXTBLK,BLOCK);
   END;

   CLOSE(1);
   CLOSE(2);
END.
