
"
    PASCAL PROGRAM TO COMPARE VIRTUAL MACHINE CODE (SEQCODE) FILES


    INVOCATION:

    *CMPSEQ(PROG1.SEQ,PROG2.SEQ)

"



"###########
#  PREFIX  #
###########"

CONST NL = '(:10:)';   FF = '(:12:)';   CR = '(:13:)';   EM = '(:25:)';

CONST PAGELENGTH = 256;
TYPE PAGE = ARRAY (.1..PAGELENGTH.) OF INTEGER;

CONST LINELENGTH = 132;
TYPE LINE = ARRAY (.1..LINELENGTH.) OF CHAR;

CONST IDLENGTH = 16;
TYPE IDENTIFIER = ARRAY (.1..IDLENGTH.) OF CHAR;

TYPE FILE = 1..4;

TYPE ARGTAG =
  (NILTYPE, BOOLTYPE, INTTYPE, IDTYPE, PTRTYPE);

TYPE POINTER = @BOOLEAN;

TYPE ARGTYPE = RECORD
                 CASE TAG: ARGTAG OF
                   NILTYPE, BOOLTYPE: (BOOL: BOOLEAN);
                   INTTYPE: (INT: INTEGER);
                   IDTYPE: (ID: IDENTIFIER);
                   PTRTYPE: (PTR: POINTER)
               END;

CONST MAXARG = 10;
TYPE ARGLIST = ARRAY (.1..MAXARG.) OF ARGTYPE;

TYPE ARGSEQ = (INP, OUT);

TYPE PROGRESULT =
  (TERMINATED, OVERFLOW, POINTERERROR, RANGEERROR, VARIANTERROR,
   HEAPLIMIT, STACKLIMIT, CODELIMIT, TIMELIMIT, CALLERROR);

PROCEDURE READ(VAR C: CHAR);
PROCEDURE WRITE(C: CHAR);
PROCEDURE OPEN(F: FILE; ID: IDENTIFIER; VAR FOUND: BOOLEAN);
PROCEDURE CLOSE(F: FILE);
PROCEDURE GET(F: FILE; P: INTEGER; VAR BLOCK: UNIV PAGE);
PROCEDURE PUT(F: FILE; P: INTEGER; VAR BLOCK: UNIV PAGE);
PROCEDURE NOTUSED1;
PROCEDURE MARK(VAR TOP: INTEGER);
PROCEDURE RELEASE(TOP: INTEGER);
PROCEDURE IDENTIFY(HEADER: LINE);
PROCEDURE ACCEPT(VAR C: CHAR);
PROCEDURE DISPLAY(C: CHAR);
PROCEDURE NOTUSED2;
PROCEDURE NOTUSED3;
PROCEDURE NOTUSED4;
PROCEDURE NOTUSED5;
PROCEDURE READARG(S: ARGSEQ; VAR ARG: ARGTYPE);
PROCEDURE WRITEARG(S: ARGSEQ; ARG: ARGTYPE);
PROCEDURE NOTUSED6;
PROCEDURE NOTUSED7;
PROCEDURE NOTUSED8;
PROCEDURE NOTUSED9;
PROCEDURE RUN(ID: IDENTIFIER; VAR PARAM: ARGLIST;
              VAR LINE: INTEGER; VAR RESULT: PROGRESULT);


PROGRAM CMPSEQ(VAR PARAM: ARGLIST);

VAR
    FOUND: BOOLEAN;
    BLOCK1: PAGE;
    BLOCK2: PAGE;
    COUNT: INTEGER;
    SIZE: INTEGER;
    NXTBLK: INTEGER;

BEGIN

   WITH PARAM(.2.) DO
      OPEN(1,ID,FOUND);
   WITH PARAM(.3.) DO
      OPEN(2,ID,FOUND);

   GET(1,1,BLOCK1);
   GET(2,1,BLOCK2);

   SIZE:=BLOCK1(.1.) DIV 2;
   COUNT:=1;
   NXTBLK:=2;

   WHILE SIZE <> 0 DO
   BEGIN
      IF COUNT > 256 THEN
      BEGIN
         GET(1,NXTBLK,BLOCK1);
         GET(2,NXTBLK,BLOCK2);
         NXTBLK:=NXTBLK+1;
         COUNT:=1;
      END;
      IF BLOCK1(.COUNT.) <> BLOCK2(.COUNT.) THEN
      BEGIN
         IDENTIFY('NO COMPARE !!!!(:10:)');
         SIZE:=1; "DROP OUT OF WHILE"
      END;
      COUNT:=COUNT+1;
      SIZE:=SIZE-1;
   END;
   CLOSE(1);
   CLOSE(2);
END.
