
/* SYM.C */
/* creates a symbol table file for SID86 from a MWC-86 .CMD file */
/* pgwb  17-Mar-83 */

#include <stdio.h>
#include <ctype.h>

#define LNLINE 80			/* length of input line */
#define LNFS 16				/* length of filespec string */
#define LNNAME 16			/* length of symbol name */
#define LNVALUE 6			/* length of symbol value string */
#define LNTYPE 4			/* length of symbol type string */

typedef struct sym {
    struct sym *next ;			/* points to next symbol in list */
    char name[LNNAME+1] ;		/* symbol name string */
    char value[LNVALUE+1] ;		/* symbol value string */
    char type[LNTYPE+1] ;		/* symbol type string */
} symbol ;

FILE *fpin, *fpout ;

main (argc, argv)
int argc ;
char *argv[] ;
{
    char line[LNLINE+1], c, *cp, *strlower() ;
    char infs[LNFS+1], tmpfs[LNFS+1], outfs[LNFS+1] ;
    symbol tsym, coderoot, dataroot ;
    symbol *pcode, *pdata, *chain() ;
    void output_list(), fail() ;

    fprintf(stderr, "SYM Version 0.3    March 17, 1983\n") ;
    if (argc != 2)
	fail("usage: SYM filename (.CMD extension unnecessary)") ;
    if (argv[1][0] == '@')
	fail("can't start SYM filename with an '@'") ;
    if ((cp = index(argv[1], '.')) != NULL)
	*cp = '\0' ;
    strcat(strncpy(infs, argv[1], LNFS-4), ".CMD") ;
    strcat(strncpy(tmpfs, argv[1], LNFS-4), ".$$$") ;
    strcat(strncpy(outfs, argv[1], LNFS-4), ".SYM") ;
    strlower(strcat(strcat(strcat(strcpy(
	line, "NM >"), tmpfs), " -n "), infs)) ;
    if (system(line) != 0)
	fail("error invoking NM.CMD") ;
    if ((fpin = fopen(tmpfs, "r")) == NULL)
	fail("can't read \"prog.$$$\"") ;
    if ((fpout = fopen(outfs, "w")) == NULL)
	fail("can't write \"prog.SYM\"") ;
    (pcode = &coderoot)->next = NULL ;
    (pdata = &dataroot)->next = NULL ;

    while (fgets(line, LNLINE, fpin) != NULL) {
	if (sscanf(line, "%16s %6s %4s", tsym.name, tsym.value, tsym.type) < 3)
	    continue ;
	if (strlen(tsym.type) < 2)
	    continue ;
	else
	    c = toupper(tsym.type[1]) ;
	if (c == 'C')
	    pcode = chain(pcode, &tsym) ;	/* chain in code symbol */
	else if (c == 'D')
	    pdata = chain(pdata, &tsym) ;	/* chain in data symbol */
    }
    output_list(&coderoot, "LABELS") ;		/* output code symbols */
    output_list(&dataroot, "VARIABLES") ;	/* output data symbols */

    fclose(fpin) ;				/* close prog.$$$ */
    fclose(fpout) ;				/* close prog.SYM */
    unlink(tmpfs) ;				/* delete prog.$$$ */
    return(0) ;					/* return with good status */
}

symbol *
chain (plist, psym)
symbol *plist, *psym ;
{
    symbol *pnew ;
    void fail() ;

    if ((pnew = malloc(sizeof(symbol))) == NULL ) /* allocate new structure */
	fail("memory allocation error") ;
    *pnew = *psym ;			/* copy symbol data */
    (plist->next = pnew)->next = NULL ;	/* link new structure into list */
    return(pnew) ;			/* return pointer to new symbol */
}

void
output_list (plist, heading)
symbol *plist ;
char *heading ;
{
    fprintf(fpout, "\n0000\t%s\n", heading) ;	/* print heading for SID86 */
    while (plist->next != NULL)	{
	if (strcmp(plist->type, (plist->next)->type))
	    fprintf(fpout, "\n") ;
	plist = plist->next ;			/* chase down the list */
	fprintf(fpout, "\t%s\t%s\n", plist->value, plist->name) ;
    }
}

char *
strlower (s)
char *s ;
{
    int i ;

    for ( i = 0 ; s[i] ; i++ )
	if (isupper(s[i]))
	    s[i] = _tolower(s[i]) ;
    return(s) ;
}

void
fail (msg)
char *msg ;
{
    fprintf(stderr, "SYM -- %s\n", msg) ;
    exit(1) ;
}
                  