/*
 *	MWC86 Version 1.0
 *	Copyright (c) 1982, 1983 by Mark Williams Company, Chicago.
 *	All rights reserved. May not be copied or disclosed without permission.
 */

/*
 * This header file contains 
 * typedefs, structures and macros for the
 * CP/M-86 standard I/O package.
 */
#ifndef	STDIO_H
#define	STDIO_H	STDIO_H

#define	NULL	0			/* Null pointer */
#define	EOF	(-1)			/* End of file */
#define	L2BUFSZ	9			/* Log base 2 of buffer size */
#define	BUFSIZ	(1<<L2BUFSZ)		/* # of bytes in a buffer */
#define	_NFILE	20			/* # of FILE structures */
#define	_NNAME	8			/* # of bytes in name */
#define	_NTYPE	3			/* # of bytes in type */

/*
 * All I/O operations are aimed at a
 * FILE structure. The user passes control to
 * the standard I/O routines by doing indirect calls
 * through transfer vectors in the FILE. The open routines
 * set these vectors appropriately for the style of I/O
 * (byte by byte, console edited, raw disc or file) that
 * gets done to the stream.
 */
typedef	struct	FILE	{
	int	_flag;				/* Flags */
	int	_ungetc;			/* Character for `ungetc' */
	int	_count;				/* Byte count */
	unsigned char	*_bufptr;		/* Buffer pointer */
	unsigned char	*_buforg;		/* Buffer origin */
	unsigned int	_size;			/* File size, records */
	int	(*_getfp)();			/* Get function */
	int	(*_putfp)();			/* Put function */
	union	{
		struct	{
			char	_getbf;		/* Get function # */
			char	_putbf;		/* Put function # */
		};
		struct	{
			char	_dev;		/* Device code */
			char	_name[_NNAME];	/* Name */
			char	_type[_NTYPE];	/* Type (extension) */
			char	_ex;		/* Extent */
			char	_forcpm[2];	/* Used by CP/M-86 */
			char	_rc;		/* Record count */
			char	_map[16];	/* Map bytes */
			char	_cr;		/* Current record */
			unsigned char _rec[3];	/* Random index */
		};
	}	_info;				/* Style dependent info */
}	FILE;

/*
 * The random record field of the
 * file control block is an integer on an odd
 * address boundry. Since the 8088
 * doesn't care, we can access it with clever
 * casts and macros.
 */
#define	_gr(fp)		(*(unsigned *)(&(fp)->_info._rec[0]))
#define	_pr(fp, r)	(*(unsigned *)(&(fp)->_info._rec[0])=(r))

/* Flags */
#define	_FSTR	0x01			/* String stream */
#define	_FBIN	0x02			/* Binary */
#define	_FUSER	0x04			/* Buffer is user's */
#define	_FOUT	0x08			/* Output stream */
#define	_FEOF	0x10			/* End of file */
#define	_FERR	0x20			/* Error */
#define	_FFILE	0x40			/* A file */
#define	_FCTLZ	0x100			/* Put out CTLZ on close */
#define	_FBUSY	0x200			/* In use */

/* _ffill */
#define	_FFINC	0x01			/* "++" record */
#define	_FFEOF	0x02			/* Check end of file */

extern	FILE _file[_NFILE];
char	*gets();
char	*fgets();
FILE	*fopen();
FILE	*freopen();
int	fflush();
int	fclose();
long	ftell();
void	puts();
void	fputs();
void	setbuf();
char	*malloc();
char	*realloc();
char	*calloc();

#define	stdin		(&_file[0])
#define	stdout		(&_file[1])
#define	stderr		(&_file[2])
#define	getchar()	getc(stdin)
#define	getc(fp)	(*(fp)->_getfp)((fp))
#define	putchar(c)	putc((c), stdout)
#define	putc(c, fp)	(*(fp)->_putfp)((c), (fp))
#define	feof(fp)	((fp)->_flag&(_FEOF|_FERR))
#define	ferror(fp)	((fp)->_flag&_FERR)
#define	clearerr(fp)	((fp)->_flag &= ~(_FERR|_FEOF))
#define	wdleng()	(16)
#define	cfree(p)	free((p))
#define	fbufcnt(fp)	((fp)->_count)

#endif
                                                        