	title	'cold boot for MORROW discus 1, 10 apr 82'
;
;
; this is the cp/m bootstrap for MORROWs discus 1 system.
;
;
msize		equ	56		;number of kilobytes of memory
cpm		equ	(msize*1024)-1c00h	; base of cpm
bios		equ	cpm+1600h	;base of bios
stack		equ	0e26eh
dmaadr		equ	0e274h
sector		equ	0e00fh
read		equ	0e015h
write		equ	0e018h
seek		equ	0e00ch
home		equ	0e009h
boots		equ	0e000h
;
;
		org	80h
;
;
load:		call	setup
;
rloop:		nop
		push	b
		call	sector
		call	read
		ana	a
		jnz	boots
;
		pop	b
		dcr	b
		jz	bios		;go to boot in bios
		call	nsdma
		jmp	rloop
;
;
save:		lxi	sp,stack
		call	home
		call	setup
;
wloop:		nop
		push	b
		call	sector
		call	write
		ana	a
		jnz	stall
;
		pop	b
		dcr	b
;
stall:		jz	stall
		call	nsdma
;
		jmp	wloop
;
;
intlz:		lxi	sp,stack
		call	home
		lxi	h,80h
		shld	dmaadr
		call	write
		nop
;
done:		jmp	done
;
;
setup:		lxi	b,(51 shl 8) or 06h
		lxi	h,cpm+200h
		shld	dmaadr
		ret
;
;
nsdma:		mvi	a,5
		add	c
		mov	c,a
		sbi	27
		jm	ok
;
		inr	a
		mov	c,a
		lxi	d,0f580h
		cpi	1
		jnz	ok+3
;
		push	b
		call	seek
		pop	b
;
ok:		lxi	d,280h
		lhld	dmaadr
		dad	d
		shld	dmaadr
		mvi	a,(cpm+1c00h)/100h
		sub	h
		jm	nsdma
;
		ret
;
;
		END
