	;PROGRAM TO INITIALIZE IBM
	;COMPATABLE DISKETTES
	;
ORIGIN	EQU	0E000H
STACK	EQU	ORIGIN+240H
DRIVE	EQU	ORIGIN+273H
DREG	EQU	ORIGIN+302H
HOME	EQU	ORIGIN+9
SEEK	EQU	ORIGIN+0CH
SECTOR	EQU	ORIGIN+0FH
DBUFF	EQU	ORIGIN+277H
DWRITE	EQU	ORIGIN+300H
STATUS	EQU	DREG
TRACK	EQU	DBUFF
HLOAD	EQU	ORIGIN+303H
	;
WPROT	EQU	1
INDEX	EQU	10H
CR	EQU	0DH
LF	EQU	0AH
	;
	ORG	100H
	;
	NOP
START	LXI	SP,STACK
	LXI	H,SMESSG	;START-UP MESSAGE
	CALL	SENDM
	CALL	CPIN		;WAIT FOR CR
	CPI	CR
	JNZ	START
	LXI	H,CRLF
	CALL	SENDM
	LXI	H,DMESSG	;SELECT DRIVE #
	CALL	SENDM
	CALL	CPIN
	PUSH	PSW
	MOV	C,A
	CALL	CPOUT
	POP	PSW
	LXI	H,DTABLE
	MVI	B,4
DLOOP	CPI	'A'
	JZ	FOUND
	INX	H
	DCR	A
	DCR	B
	JNZ	DLOOP
	JMP	START		;INVALID DRIVE #
FOUND	MOV	A,M
	STA	DRIVE
	STA	DREG		;INITIALIZE THE DRIVE
	CALL	HOME
	LDA	STATUS		
	MOV	B,A
	RAL
	JC	CKWP
	LXI	H,NMESSG
	CALL	SENDM
	JMP	START
CKWP	MOV	A,B
	RAR
	JNC	MAIN
	LXI	H,WMESSG
	CALL	SENDM
 	JMP	START
MAIN	LXI	D,BUFFER	;LOCAL FORMAT BUFFER
	LXI	B,1A01H		;#OF SECTORS & 1ST ONE
FLOOP	PUSH	B		;SAVE BOTH
	PUSH	D		; POINTERS & COUNT
	CALL	SECTOR		;SET THE SECTOR
	LXI	H,DBUFF		;ID BUFFER POINTER
	MVI	B,6		;ID LENGTH
	POP	D		;GET FORMAT BUFF PTR
SLOOP	MOV	A,M		;GET ID DATA
	STAX	D		;STORE IN FORMAT BUFF
	INX	D
	INX	H
	DCR	B
	JNZ	SLOOP
	POP	B		;GET SECTOR & COUNT
	INR	C
	DCR	B		;TEST FOR END OF TRK
	JNZ	FLOOP
	NOP
	LXI	H,DWRITE
	LXI	D,BUFFER
	MVI	C,40
WINDEX	LDA	STATUS
	ANI	INDEX
	JZ	WINDEX
LDR1	MVI	M,0FFH
	DCR	C
	JNZ	LDR1
	MVI	C,6
LDR2	MVI	M,0
	DCR	C
	JNZ	LDR2
	INX	H
	MVI	M,0FCH
	DCX	H
	MVI	C,26
LDR3	MVI	M,0FFH
	DCR	C
	JNZ	LDR3
	MVI	B,26
TLOOP	MVI	C,6
	MVI	M,0
	DCR	C
	JNZ	TLOOP+2
	INX	H
	MVI	M,0FEH
	DCX	H
	MVI	C,6
TL1	LDAX	D
	MOV	M,A
	INX	D
	DCR	C
	JNZ	TL1
	MVI	C,11
TL2	MVI	M,0FFH
	DCR	C
	JNZ	TL2
	MVI	C,6
TL3	MVI	M,0
	DCR	C
	JNZ	TL3
	INX	H
	MVI	M,0FBH
	DCX	H
	MVI	C,128
TL4	MVI	M,0E5H
	DCR	C
	JNZ	TL4
	MVI	M,5DH
	MVI	M,30H
	MVI	C,27
TL5	MVI	M,0FFH
	DCR	C
	JNZ	TL5
	DCR	B
	JNZ	TLOOP
TL6	MVI	M,0FFH
	LDA	STATUS
	ANI	INDEX
	JZ	TL6
	NOP
	LDA	TRACK
	CPI	76
	JZ	DONE
	INR	A
	MOV	C,A
	CALL	SEEK
	JMP	MAIN
DONE	LXI	H,FMESSG
	CALL	SENDM
	CALL	CPIN
	PUSH	PSW
	MOV	C,A
	CALL	CPOUT
	POP	PSW
	CPI	'I'
	JZ	START
	CPI	'B'
	JZ	ORIGIN
	JMP	DONE
	;
SENDM	MOV	A,M
	ANA	A
	RZ
	MOV	C,A
	PUSH	H
	CALL	CPOUT
	POP	H
	INX	H
	JMP	SENDM
	;
CPIN	LXI	D,6
	JMP	CPOUT+3
CPOUT	LXI	D,9
	LHLD	1
	DAD	D
	PCHL
	;
DTABLE	DB	88H
	DB	09H
	DB	28H
	DB	0AH
	;
SMESSG	DB	CR,LF
	DB	'INSERT'
	DB	' DISKETTE'
	DB	' - THEN'
	DB	' PRESS'
	DB	' RETURN'
	DB	0
CRLF	DB	CR,LF,0
DMESSG	DB	'SELECT'
	DB	' DRIVE'
	DB	' A,B,C,'
	DB	' OR D'
	DB	CR,LF,0
FMESSG	DB	CR,LF
	DB	'FUNCTION'
	DB	' COMPLETE'
	DB	CR,LF
	DB	'ENTER'
	DB	' B FOR'
	DB	' BOOT'
	DB	' OR I '
	DB	'FOR IN'
	DB	'TIALIZE'
	DB	CR,LF,0
WMESSG	DB	CR,LF
	DB	'DISKETTE'
	DB	' IS WRITE'
	DB	' PROTECTED'
	DB	CR,LF,0
NMESSG	DB	CR,LF
	DB	'DRIVE '
	DB	'NOT READY'
	DB	CR,LF,0
BUFFER	DS	160
