	title	'MORROW discus 1 format program,  11 apr 82'
;
;
;	program to initialize IBM compatable diskettes.
;
origin		equ	0e000h
stack		equ	80h
drive		equ	origin+273h
dreg		equ	origin+302h
home		equ	origin+9
seek		equ	origin+0ch
sector		equ	origin+0fh
dbuff		equ	origin+277h
track		equ	origin+277h
dwrite		equ	origin+300h
status		equ	dreg
hload		equ	origin+303h
;
wprot		equ	1
index		equ	10h
cr		equ	0dh
lf		equ	0ah
;
;
		org	100h
;
;
		nop
;
start:		di
		lxi	sp,stack
		lxi	h,smessg	;start-up message
		call	sendm
		call	cpin		;wait for cr
		cpi	cr
		jnz	start
;
		lxi	h,crlf
		call	sendm
		lxi	h,dmessg	;select drive #
		call	sendm
		call	cpin
		ani	43h
		push	psw
		mov	c,a
		call	cpout
		pop	psw
		lxi	h,dtable
		mvi	b,4
;
dloop:		cpi	'A'
		jz	found
;
		inx	h
		dcr	a
		dcr	b
		jnz	dloop
;
		jmp	start		;invalid drive #
;
;
found:		mov	a,m
		sta	drive
		sta	dreg		;initialize the drive
		call	home
		lda	status		
		mov	b,a
		ral
		jc	ckwp
;
		lxi	h,nmessg
		call	sendm
		jmp	start
;
;
ckwp:		mov	a,b
		rar
		jnc	main
;
		lxi	h,wmessg
		call	sendm
		jmp	start
;
;
main:		lxi	d,buffer	;local format buffer
		lxi	b,1a01h		;#of sectors & 1st one
;
floop:		push	b		;save both
		push	d		; pointers & count
		call	sector		;set the sector
		lxi	h,dbuff		;id buffer pointer
		mvi	b,6		;id length
		pop	d		;get format buff ptr
;
sloop:		mov	a,m		;get id data
		stax	d		;store in format buff
		inx	d
		inx	h
		dcr	b
		jnz	sloop
;
		pop	b		;get sector & count
		inr	c
		dcr	b		;test for end of trk
		jnz	floop
;
		nop
		lxi	h,dwrite
		lxi	d,buffer
		mvi	c,40
;
windex:		lda	status
		ani	index
		jz	windex
;
ldr1:		mvi	m,0ffh
		dcr	c
		jnz	ldr1
;
		mvi	c,6
;
ldr2:		mvi	m,0
		dcr	c
		jnz	ldr2
;
		inx	h
		mvi	m,0fch
		dcx	h
		mvi	c,26
;
ldr3:		mvi	m,0ffh
		dcr	c
		jnz	ldr3
;
		mvi	b,26
;
tloop:		mvi	c,6
		mvi	m,0
		dcr	c
		jnz	tloop+2
;
		inx	h
		mvi	m,0feh
		dcx	h
		mvi	c,6
;
tl1:		ldax	d
		mov	m,a
		inx	d
		dcr	c
		jnz	tl1
;
		mvi	c,11
;
tl2:		mvi	m,0ffh
		dcr	c
		jnz	tl2
;
		mvi	c,6
;
tl3:		mvi	m,0
		dcr	c
		jnz	tl3
;
		inx	h
		mvi	m,0fbh
		dcx	h
		mvi	c,128
;
tl4:		mvi	m,0e5h
		dcr	c
		jnz	tl4
;
		mvi	m,5dh
		mvi	m,30h
		mvi	c,27
;
tl5:		mvi	m,0ffh
		dcr	c
		jnz	tl5
;
		dcr	b
		jnz	tloop
;
tl6:		mvi	m,0ffh
		lda	status
		ani	index
		jz	tl6
;
		nop
		lda	track
		cpi	76
		jz	done
;
		inr	a
		mov	c,a
		call	seek
		jmp	main
;
;
done:		lxi	h,fmessg
		call	sendm
		call	cpin
		push	psw
		mov	c,a
		call	cpout
		pop	psw
		cpi	'I'
		jz	start
;
		cpi	'B'
		jz	origin
;
		jmp	done
;
;
sendm:		mov	a,m
		ana	a
		rz
;
		mov	c,a
		push	h
		call	cpout
		pop	h
		inx	h
		jmp	sendm
;
;
cpin:		lxi	d,6
		call	cpout+3
		ani	5fh
		ret
;
;
cpout:		lxi	d,9
		lhld	1
		dad	d
		pchl
;
;
dtable		db	88h
		db	09h
		db	28h
		db	0ah
;
;
smessg		db	cr,lf,'MORROW discus 1 format program.'
		db	cr,lf,lf
		db	'Insert diskette - then press <return>'
		db	0
;
crlf		db	cr,lf,0
;
dmessg		db	'Select drive (A:,B:,C: or D:)  '
		db	cr,lf,0
;
fmessg		db	cr,lf
		db	'FUNCTION COMPLETE.'
		db	cr,lf
		db	'enter <B> for boot or <I> for intialize'
		db	cr,lf,0
;
wmessg		db	cr,lf
		db	'Diskette is write protected'
		db	cr,lf,0
;
nmessg		db	cr,lf
		db	'Drive NOT ready'
		db	cr,lf,0
;
;
buffer		ds	160
;
;
		END
